# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResourceBridgeApplianceResult',
    'AwaitableGetResourceBridgeApplianceResult',
    'get_resource_bridge_appliance',
    'get_resource_bridge_appliance_output',
]

@pulumi.output_type
class GetResourceBridgeApplianceResult:
    """
    A collection of values returned by getResourceBridgeAppliance.
    """
    def __init__(__self__, distro=None, id=None, identities=None, infrastructure_provider=None, location=None, name=None, public_key_base64=None, resource_group_name=None, tags=None):
        if distro and not isinstance(distro, str):
            raise TypeError("Expected argument 'distro' to be a str")
        pulumi.set(__self__, "distro", distro)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if infrastructure_provider and not isinstance(infrastructure_provider, str):
            raise TypeError("Expected argument 'infrastructure_provider' to be a str")
        pulumi.set(__self__, "infrastructure_provider", infrastructure_provider)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key_base64 and not isinstance(public_key_base64, str):
            raise TypeError("Expected argument 'public_key_base64' to be a str")
        pulumi.set(__self__, "public_key_base64", public_key_base64)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def distro(self) -> builtins.str:
        """
        Fabric/Infrastructure for this Arc Resource Bridge Appliance.
        """
        return pulumi.get(self, "distro")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetResourceBridgeApplianceIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="infrastructureProvider")
    def infrastructure_provider(self) -> builtins.str:
        """
        The infrastructure provider about the connected Arc Resource Bridge Appliance.
        """
        return pulumi.get(self, "infrastructure_provider")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Arc Resource Bridge Appliance exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKeyBase64")
    def public_key_base64(self) -> builtins.str:
        """
        RSA public key in PKCS1 format encoded in base64.
        """
        return pulumi.get(self, "public_key_base64")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Arc Resource Bridge Appliance.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceBridgeApplianceResult(GetResourceBridgeApplianceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceBridgeApplianceResult(
            distro=self.distro,
            id=self.id,
            identities=self.identities,
            infrastructure_provider=self.infrastructure_provider,
            location=self.location,
            name=self.name,
            public_key_base64=self.public_key_base64,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_resource_bridge_appliance(name: Optional[builtins.str] = None,
                                  resource_group_name: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceBridgeApplianceResult:
    """
    Use this data source to access information about an existing Arc Resource Bridge Appliance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.arc.get_resource_bridge_appliance(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ResourceConnector`: 2022-10-27


    :param builtins.str name: The name of this Arc Resource Bridge Appliance.
    :param builtins.str resource_group_name: The name of the Resource Group where the Arc Resource Bridge Appliance exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:arc/getResourceBridgeAppliance:getResourceBridgeAppliance', __args__, opts=opts, typ=GetResourceBridgeApplianceResult).value

    return AwaitableGetResourceBridgeApplianceResult(
        distro=pulumi.get(__ret__, 'distro'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        infrastructure_provider=pulumi.get(__ret__, 'infrastructure_provider'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        public_key_base64=pulumi.get(__ret__, 'public_key_base64'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_bridge_appliance_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                         resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceBridgeApplianceResult]:
    """
    Use this data source to access information about an existing Arc Resource Bridge Appliance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.arc.get_resource_bridge_appliance(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ResourceConnector`: 2022-10-27


    :param builtins.str name: The name of this Arc Resource Bridge Appliance.
    :param builtins.str resource_group_name: The name of the Resource Group where the Arc Resource Bridge Appliance exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:arc/getResourceBridgeAppliance:getResourceBridgeAppliance', __args__, opts=opts, typ=GetResourceBridgeApplianceResult)
    return __ret__.apply(lambda __response__: GetResourceBridgeApplianceResult(
        distro=pulumi.get(__response__, 'distro'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        infrastructure_provider=pulumi.get(__response__, 'infrastructure_provider'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        public_key_base64=pulumi.get(__response__, 'public_key_base64'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
