# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProvisionedClusterArgs', 'ProvisionedCluster']

@pulumi.input_type
class ProvisionedClusterArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['ProvisionedClusterIdentityArgs'],
                 resource_group_name: pulumi.Input[builtins.str],
                 arc_agent_auto_upgrade_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 arc_agent_desired_version: Optional[pulumi.Input[builtins.str]] = None,
                 azure_active_directory: Optional[pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ProvisionedCluster resource.
        :param pulumi.Input['ProvisionedClusterIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.bool] arc_agent_auto_upgrade_enabled: Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        :param pulumi.Input[builtins.str] arc_agent_desired_version: The version of the Arc agents to be installed on the cluster.
        :param pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs'] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if arc_agent_auto_upgrade_enabled is not None:
            pulumi.set(__self__, "arc_agent_auto_upgrade_enabled", arc_agent_auto_upgrade_enabled)
        if arc_agent_desired_version is not None:
            pulumi.set(__self__, "arc_agent_desired_version", arc_agent_desired_version)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input['ProvisionedClusterIdentityArgs']:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['ProvisionedClusterIdentityArgs']):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="arcAgentAutoUpgradeEnabled")
    def arc_agent_auto_upgrade_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        """
        return pulumi.get(self, "arc_agent_auto_upgrade_enabled")

    @arc_agent_auto_upgrade_enabled.setter
    def arc_agent_auto_upgrade_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "arc_agent_auto_upgrade_enabled", value)

    @property
    @pulumi.getter(name="arcAgentDesiredVersion")
    def arc_agent_desired_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Arc agents to be installed on the cluster.
        """
        return pulumi.get(self, "arc_agent_desired_version")

    @arc_agent_desired_version.setter
    def arc_agent_desired_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arc_agent_desired_version", value)

    @property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional[pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs']]:
        """
        An `azure_active_directory` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory")

    @azure_active_directory.setter
    def azure_active_directory(self, value: Optional[pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs']]):
        pulumi.set(self, "azure_active_directory", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProvisionedClusterState:
    def __init__(__self__, *,
                 agent_version: Optional[pulumi.Input[builtins.str]] = None,
                 arc_agent_auto_upgrade_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 arc_agent_desired_version: Optional[pulumi.Input[builtins.str]] = None,
                 azure_active_directory: Optional[pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs']] = None,
                 distribution: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ProvisionedClusterIdentityArgs']] = None,
                 infrastructure: Optional[pulumi.Input[builtins.str]] = None,
                 kubernetes_version: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 offering: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 total_core_count: Optional[pulumi.Input[builtins.int]] = None,
                 total_node_count: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ProvisionedCluster resources.
        :param pulumi.Input[builtins.str] agent_version: The version of the agent running on the cluster resource.
        :param pulumi.Input[builtins.bool] arc_agent_auto_upgrade_enabled: Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        :param pulumi.Input[builtins.str] arc_agent_desired_version: The version of the Arc agents to be installed on the cluster.
        :param pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs'] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input[builtins.str] distribution: The distribution running on this Arc Kubernetes Provisioned Cluster.
        :param pulumi.Input['ProvisionedClusterIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] infrastructure: The infrastructure on which the Arc Kubernetes Provisioned Cluster is running on.
        :param pulumi.Input[builtins.str] kubernetes_version: The Kubernetes version of the cluster resource.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] offering: The cluster offering.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        :param pulumi.Input[builtins.int] total_core_count: The number of CPU cores present in the cluster resource.
        :param pulumi.Input[builtins.int] total_node_count: The number of nodes present in the cluster resource.
        """
        if agent_version is not None:
            pulumi.set(__self__, "agent_version", agent_version)
        if arc_agent_auto_upgrade_enabled is not None:
            pulumi.set(__self__, "arc_agent_auto_upgrade_enabled", arc_agent_auto_upgrade_enabled)
        if arc_agent_desired_version is not None:
            pulumi.set(__self__, "arc_agent_desired_version", arc_agent_desired_version)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure is not None:
            pulumi.set(__self__, "infrastructure", infrastructure)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offering is not None:
            pulumi.set(__self__, "offering", offering)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if total_core_count is not None:
            pulumi.set(__self__, "total_core_count", total_core_count)
        if total_node_count is not None:
            pulumi.set(__self__, "total_node_count", total_node_count)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the agent running on the cluster resource.
        """
        return pulumi.get(self, "agent_version")

    @agent_version.setter
    def agent_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "agent_version", value)

    @property
    @pulumi.getter(name="arcAgentAutoUpgradeEnabled")
    def arc_agent_auto_upgrade_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        """
        return pulumi.get(self, "arc_agent_auto_upgrade_enabled")

    @arc_agent_auto_upgrade_enabled.setter
    def arc_agent_auto_upgrade_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "arc_agent_auto_upgrade_enabled", value)

    @property
    @pulumi.getter(name="arcAgentDesiredVersion")
    def arc_agent_desired_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the Arc agents to be installed on the cluster.
        """
        return pulumi.get(self, "arc_agent_desired_version")

    @arc_agent_desired_version.setter
    def arc_agent_desired_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arc_agent_desired_version", value)

    @property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional[pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs']]:
        """
        An `azure_active_directory` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory")

    @azure_active_directory.setter
    def azure_active_directory(self, value: Optional[pulumi.Input['ProvisionedClusterAzureActiveDirectoryArgs']]):
        pulumi.set(self, "azure_active_directory", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The distribution running on this Arc Kubernetes Provisioned Cluster.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ProvisionedClusterIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ProvisionedClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def infrastructure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The infrastructure on which the Arc Kubernetes Provisioned Cluster is running on.
        """
        return pulumi.get(self, "infrastructure")

    @infrastructure.setter
    def infrastructure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "infrastructure", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes version of the cluster resource.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def offering(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cluster offering.
        """
        return pulumi.get(self, "offering")

    @offering.setter
    def offering(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offering", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="totalCoreCount")
    def total_core_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of CPU cores present in the cluster resource.
        """
        return pulumi.get(self, "total_core_count")

    @total_core_count.setter
    def total_core_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_core_count", value)

    @property
    @pulumi.getter(name="totalNodeCount")
    def total_node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes present in the cluster resource.
        """
        return pulumi.get(self, "total_node_count")

    @total_node_count.setter
    def total_node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_node_count", value)


@pulumi.type_token("azure:arckubernetes/provisionedCluster:ProvisionedCluster")
class ProvisionedCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_agent_auto_upgrade_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 arc_agent_desired_version: Optional[pulumi.Input[builtins.str]] = None,
                 azure_active_directory: Optional[pulumi.Input[Union['ProvisionedClusterAzureActiveDirectoryArgs', 'ProvisionedClusterAzureActiveDirectoryArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['ProvisionedClusterIdentityArgs', 'ProvisionedClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Arc Kubernetes Provisioned Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_group = azuread.Group("example",
            display_name="example-adg",
            owners=[current.object_id],
            security_enabled=True)
        example_provisioned_cluster = azure.arckubernetes.ProvisionedCluster("example",
            name="example-akpc",
            resource_group_name=example.name,
            location=example.location,
            azure_active_directory={
                "azure_rbac_enabled": True,
                "admin_group_object_ids": [example_group.id],
                "tenant_id": current.tenant_id,
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kubernetes`: 2024-01-01

        ## Import

        Arc Kubernetes Provisioned Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arckubernetes/provisionedCluster:ProvisionedCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] arc_agent_auto_upgrade_enabled: Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        :param pulumi.Input[builtins.str] arc_agent_desired_version: The version of the Arc agents to be installed on the cluster.
        :param pulumi.Input[Union['ProvisionedClusterAzureActiveDirectoryArgs', 'ProvisionedClusterAzureActiveDirectoryArgsDict']] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input[Union['ProvisionedClusterIdentityArgs', 'ProvisionedClusterIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProvisionedClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Arc Kubernetes Provisioned Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_group = azuread.Group("example",
            display_name="example-adg",
            owners=[current.object_id],
            security_enabled=True)
        example_provisioned_cluster = azure.arckubernetes.ProvisionedCluster("example",
            name="example-akpc",
            resource_group_name=example.name,
            location=example.location,
            azure_active_directory={
                "azure_rbac_enabled": True,
                "admin_group_object_ids": [example_group.id],
                "tenant_id": current.tenant_id,
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kubernetes`: 2024-01-01

        ## Import

        Arc Kubernetes Provisioned Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arckubernetes/provisionedCluster:ProvisionedCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Kubernetes/connectedClusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ProvisionedClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProvisionedClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_agent_auto_upgrade_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 arc_agent_desired_version: Optional[pulumi.Input[builtins.str]] = None,
                 azure_active_directory: Optional[pulumi.Input[Union['ProvisionedClusterAzureActiveDirectoryArgs', 'ProvisionedClusterAzureActiveDirectoryArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['ProvisionedClusterIdentityArgs', 'ProvisionedClusterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProvisionedClusterArgs.__new__(ProvisionedClusterArgs)

            __props__.__dict__["arc_agent_auto_upgrade_enabled"] = arc_agent_auto_upgrade_enabled
            __props__.__dict__["arc_agent_desired_version"] = arc_agent_desired_version
            __props__.__dict__["azure_active_directory"] = azure_active_directory
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["agent_version"] = None
            __props__.__dict__["distribution"] = None
            __props__.__dict__["infrastructure"] = None
            __props__.__dict__["kubernetes_version"] = None
            __props__.__dict__["offering"] = None
            __props__.__dict__["total_core_count"] = None
            __props__.__dict__["total_node_count"] = None
        super(ProvisionedCluster, __self__).__init__(
            'azure:arckubernetes/provisionedCluster:ProvisionedCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_version: Optional[pulumi.Input[builtins.str]] = None,
            arc_agent_auto_upgrade_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            arc_agent_desired_version: Optional[pulumi.Input[builtins.str]] = None,
            azure_active_directory: Optional[pulumi.Input[Union['ProvisionedClusterAzureActiveDirectoryArgs', 'ProvisionedClusterAzureActiveDirectoryArgsDict']]] = None,
            distribution: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ProvisionedClusterIdentityArgs', 'ProvisionedClusterIdentityArgsDict']]] = None,
            infrastructure: Optional[pulumi.Input[builtins.str]] = None,
            kubernetes_version: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            offering: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            total_core_count: Optional[pulumi.Input[builtins.int]] = None,
            total_node_count: Optional[pulumi.Input[builtins.int]] = None) -> 'ProvisionedCluster':
        """
        Get an existing ProvisionedCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] agent_version: The version of the agent running on the cluster resource.
        :param pulumi.Input[builtins.bool] arc_agent_auto_upgrade_enabled: Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        :param pulumi.Input[builtins.str] arc_agent_desired_version: The version of the Arc agents to be installed on the cluster.
        :param pulumi.Input[Union['ProvisionedClusterAzureActiveDirectoryArgs', 'ProvisionedClusterAzureActiveDirectoryArgsDict']] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input[builtins.str] distribution: The distribution running on this Arc Kubernetes Provisioned Cluster.
        :param pulumi.Input[Union['ProvisionedClusterIdentityArgs', 'ProvisionedClusterIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] infrastructure: The infrastructure on which the Arc Kubernetes Provisioned Cluster is running on.
        :param pulumi.Input[builtins.str] kubernetes_version: The Kubernetes version of the cluster resource.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[builtins.str] offering: The cluster offering.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        :param pulumi.Input[builtins.int] total_core_count: The number of CPU cores present in the cluster resource.
        :param pulumi.Input[builtins.int] total_node_count: The number of nodes present in the cluster resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProvisionedClusterState.__new__(_ProvisionedClusterState)

        __props__.__dict__["agent_version"] = agent_version
        __props__.__dict__["arc_agent_auto_upgrade_enabled"] = arc_agent_auto_upgrade_enabled
        __props__.__dict__["arc_agent_desired_version"] = arc_agent_desired_version
        __props__.__dict__["azure_active_directory"] = azure_active_directory
        __props__.__dict__["distribution"] = distribution
        __props__.__dict__["identity"] = identity
        __props__.__dict__["infrastructure"] = infrastructure
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["offering"] = offering
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["total_core_count"] = total_core_count
        __props__.__dict__["total_node_count"] = total_node_count
        return ProvisionedCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentVersion")
    def agent_version(self) -> pulumi.Output[builtins.str]:
        """
        The version of the agent running on the cluster resource.
        """
        return pulumi.get(self, "agent_version")

    @property
    @pulumi.getter(name="arcAgentAutoUpgradeEnabled")
    def arc_agent_auto_upgrade_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the Arc agents will be upgraded automatically to the latest version. Defaults to `true`.
        """
        return pulumi.get(self, "arc_agent_auto_upgrade_enabled")

    @property
    @pulumi.getter(name="arcAgentDesiredVersion")
    def arc_agent_desired_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the Arc agents to be installed on the cluster.
        """
        return pulumi.get(self, "arc_agent_desired_version")

    @property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> pulumi.Output[Optional['outputs.ProvisionedClusterAzureActiveDirectory']]:
        """
        An `azure_active_directory` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory")

    @property
    @pulumi.getter
    def distribution(self) -> pulumi.Output[builtins.str]:
        """
        The distribution running on this Arc Kubernetes Provisioned Cluster.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.ProvisionedClusterIdentity']:
        """
        An `identity` block as defined below. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def infrastructure(self) -> pulumi.Output[builtins.str]:
        """
        The infrastructure on which the Arc Kubernetes Provisioned Cluster is running on.
        """
        return pulumi.get(self, "infrastructure")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[builtins.str]:
        """
        The Kubernetes version of the cluster resource.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Arc Kubernetes Provisioned Cluster. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offering(self) -> pulumi.Output[builtins.str]:
        """
        The cluster offering.
        """
        return pulumi.get(self, "offering")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Arc Kubernetes Provisioned Cluster should exist. Changing this forces a new Arc Kubernetes Provisioned Cluster to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Arc Kubernetes Provisioned Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCoreCount")
    def total_core_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of CPU cores present in the cluster resource.
        """
        return pulumi.get(self, "total_core_count")

    @property
    @pulumi.getter(name="totalNodeCount")
    def total_node_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of nodes present in the cluster resource.
        """
        return pulumi.get(self, "total_node_count")

