# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutomanageConfigurationAssignmentArgs', 'AutomanageConfigurationAssignment']

@pulumi.input_type
class AutomanageConfigurationAssignmentArgs:
    def __init__(__self__, *,
                 arc_machine_id: pulumi.Input[builtins.str],
                 configuration_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a AutomanageConfigurationAssignment resource.
        :param pulumi.Input[builtins.str] arc_machine_id: The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] configuration_id: The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        pulumi.set(__self__, "arc_machine_id", arc_machine_id)
        pulumi.set(__self__, "configuration_id", configuration_id)

    @property
    @pulumi.getter(name="arcMachineId")
    def arc_machine_id(self) -> pulumi.Input[builtins.str]:
        """
        The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_machine_id")

    @arc_machine_id.setter
    def arc_machine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arc_machine_id", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Input[builtins.str]:
        """
        The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "configuration_id", value)


@pulumi.input_type
class _AutomanageConfigurationAssignmentState:
    def __init__(__self__, *,
                 arc_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutomanageConfigurationAssignment resources.
        :param pulumi.Input[builtins.str] arc_machine_id: The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] configuration_id: The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        if arc_machine_id is not None:
            pulumi.set(__self__, "arc_machine_id", arc_machine_id)
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)

    @property
    @pulumi.getter(name="arcMachineId")
    def arc_machine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_machine_id")

    @arc_machine_id.setter
    def arc_machine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arc_machine_id", value)

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration_id", value)


@pulumi.type_token("azure:arcmachine/automanageConfigurationAssignment:AutomanageConfigurationAssignment")
class AutomanageConfigurationAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Arc Machine Automanage Configuration Profile Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        config = pulumi.Config()
        # The name of the Arc Machine.
        arc_machine_name = config.require_object("arcMachineName")
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = example_resource_group.name.apply(lambda name: azure.arcmachine.get_output(name=arc_machine_name,
            resource_group_name=name))
        example_configuration = azure.automanage.Configuration("example",
            name="example-configuration",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_automanage_configuration_assignment = azure.arcmachine.AutomanageConfigurationAssignment("example",
            arc_machine_id=example.id,
            configuration_id=example_configuration.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HybridCompute`: 2022-05-04

        ## Import

        Virtual Machine Automanage Configuration Profile Assignment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arcmachine/automanageConfigurationAssignment:AutomanageConfigurationAssignment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.HybridCompute/machines/machine1/providers/Microsoft.AutoManage/configurationProfileAssignments/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arc_machine_id: The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] configuration_id: The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomanageConfigurationAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Arc Machine Automanage Configuration Profile Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        config = pulumi.Config()
        # The name of the Arc Machine.
        arc_machine_name = config.require_object("arcMachineName")
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = example_resource_group.name.apply(lambda name: azure.arcmachine.get_output(name=arc_machine_name,
            resource_group_name=name))
        example_configuration = azure.automanage.Configuration("example",
            name="example-configuration",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_automanage_configuration_assignment = azure.arcmachine.AutomanageConfigurationAssignment("example",
            arc_machine_id=example.id,
            configuration_id=example_configuration.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HybridCompute`: 2022-05-04

        ## Import

        Virtual Machine Automanage Configuration Profile Assignment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arcmachine/automanageConfigurationAssignment:AutomanageConfigurationAssignment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.HybridCompute/machines/machine1/providers/Microsoft.AutoManage/configurationProfileAssignments/default
        ```

        :param str resource_name: The name of the resource.
        :param AutomanageConfigurationAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomanageConfigurationAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomanageConfigurationAssignmentArgs.__new__(AutomanageConfigurationAssignmentArgs)

            if arc_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'arc_machine_id'")
            __props__.__dict__["arc_machine_id"] = arc_machine_id
            if configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_id'")
            __props__.__dict__["configuration_id"] = configuration_id
        super(AutomanageConfigurationAssignment, __self__).__init__(
            'azure:arcmachine/automanageConfigurationAssignment:AutomanageConfigurationAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arc_machine_id: Optional[pulumi.Input[builtins.str]] = None,
            configuration_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AutomanageConfigurationAssignment':
        """
        Get an existing AutomanageConfigurationAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arc_machine_id: The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] configuration_id: The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.
               
               > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomanageConfigurationAssignmentState.__new__(_AutomanageConfigurationAssignmentState)

        __props__.__dict__["arc_machine_id"] = arc_machine_id
        __props__.__dict__["configuration_id"] = configuration_id
        return AutomanageConfigurationAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="arcMachineId")
    def arc_machine_id(self) -> pulumi.Output[builtins.str]:
        """
        The ARM resource ID of the Arc Machine to assign the Automanage Configuration to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_machine_id")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[builtins.str]:
        """
        The ARM resource ID of the Automanage Configuration to assign to the Virtual Machine. Changing this forces a new resource to be created.

        > **Note:** For a successful creation of this resource, locate "Automanage API Access" app within your Entra ID tenant. Make sure it's granted access to the scope that includes the arc server.
        """
        return pulumi.get(self, "configuration_id")

