# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProviderResult',
    'AwaitableGetProviderResult',
    'get_provider',
    'get_provider_output',
]

@pulumi.output_type
class GetProviderResult:
    """
    A collection of values returned by getProvider.
    """
    def __init__(__self__, attestation_uri=None, id=None, location=None, name=None, resource_group_name=None, tags=None, trust_model=None):
        if attestation_uri and not isinstance(attestation_uri, str):
            raise TypeError("Expected argument 'attestation_uri' to be a str")
        pulumi.set(__self__, "attestation_uri", attestation_uri)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if trust_model and not isinstance(trust_model, str):
            raise TypeError("Expected argument 'trust_model' to be a str")
        pulumi.set(__self__, "trust_model", trust_model)

    @property
    @pulumi.getter(name="attestationUri")
    def attestation_uri(self) -> builtins.str:
        """
        The (Endpoint|URI) of the Attestation Service.
        """
        return pulumi.get(self, "attestation_uri")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The Azure Region where the Attestation Provider exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Attestation Provider.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trustModel")
    def trust_model(self) -> builtins.str:
        """
        Trust model used for the Attestation Service.
        """
        return pulumi.get(self, "trust_model")


class AwaitableGetProviderResult(GetProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProviderResult(
            attestation_uri=self.attestation_uri,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags,
            trust_model=self.trust_model)


def get_provider(name: Optional[builtins.str] = None,
                 resource_group_name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProviderResult:
    """
    Use this data source to access information about an existing Attestation Provider.


    :param builtins.str name: The name of this Attestation Provider.
    :param builtins.str resource_group_name: The name of the Resource Group where the Attestation Provider exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:attestation/getProvider:getProvider', __args__, opts=opts, typ=GetProviderResult).value

    return AwaitableGetProviderResult(
        attestation_uri=pulumi.get(__ret__, 'attestation_uri'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'),
        trust_model=pulumi.get(__ret__, 'trust_model'))
def get_provider_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProviderResult]:
    """
    Use this data source to access information about an existing Attestation Provider.


    :param builtins.str name: The name of this Attestation Provider.
    :param builtins.str resource_group_name: The name of the Resource Group where the Attestation Provider exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:attestation/getProvider:getProvider', __args__, opts=opts, typ=GetProviderResult)
    return __ret__.apply(lambda __response__: GetProviderResult(
        attestation_uri=pulumi.get(__response__, 'attestation_uri'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags'),
        trust_model=pulumi.get(__response__, 'trust_model')))
