# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 antimalware: Optional[pulumi.Input['ConfigurationAntimalwareArgs']] = None,
                 automation_account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_security_baseline: Optional[pulumi.Input['ConfigurationAzureSecurityBaselineArgs']] = None,
                 backup: Optional[pulumi.Input['ConfigurationBackupArgs']] = None,
                 boot_diagnostics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 defender_for_cloud_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 status_change_alert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input['ConfigurationAntimalwareArgs'] antimalware: A `antimalware` block as defined below.
        :param pulumi.Input[builtins.bool] automation_account_enabled: Whether the automation account is enabled. Defaults to `false`.
        :param pulumi.Input['ConfigurationAzureSecurityBaselineArgs'] azure_security_baseline: A `azure_security_baseline` block as defined below.
        :param pulumi.Input['ConfigurationBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] boot_diagnostics_enabled: Whether the boot diagnostics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] defender_for_cloud_enabled: Whether the defender for cloud is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] guest_configuration_enabled: Whether the guest configuration is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] log_analytics_enabled: Whether log analytics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] status_change_alert_enabled: Whether the status change alert is enabled. Defaults to `false`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if antimalware is not None:
            pulumi.set(__self__, "antimalware", antimalware)
        if automation_account_enabled is not None:
            pulumi.set(__self__, "automation_account_enabled", automation_account_enabled)
        if azure_security_baseline is not None:
            pulumi.set(__self__, "azure_security_baseline", azure_security_baseline)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if boot_diagnostics_enabled is not None:
            pulumi.set(__self__, "boot_diagnostics_enabled", boot_diagnostics_enabled)
        if defender_for_cloud_enabled is not None:
            pulumi.set(__self__, "defender_for_cloud_enabled", defender_for_cloud_enabled)
        if guest_configuration_enabled is not None:
            pulumi.set(__self__, "guest_configuration_enabled", guest_configuration_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_analytics_enabled is not None:
            pulumi.set(__self__, "log_analytics_enabled", log_analytics_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status_change_alert_enabled is not None:
            pulumi.set(__self__, "status_change_alert_enabled", status_change_alert_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def antimalware(self) -> Optional[pulumi.Input['ConfigurationAntimalwareArgs']]:
        """
        A `antimalware` block as defined below.
        """
        return pulumi.get(self, "antimalware")

    @antimalware.setter
    def antimalware(self, value: Optional[pulumi.Input['ConfigurationAntimalwareArgs']]):
        pulumi.set(self, "antimalware", value)

    @property
    @pulumi.getter(name="automationAccountEnabled")
    def automation_account_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the automation account is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "automation_account_enabled")

    @automation_account_enabled.setter
    def automation_account_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automation_account_enabled", value)

    @property
    @pulumi.getter(name="azureSecurityBaseline")
    def azure_security_baseline(self) -> Optional[pulumi.Input['ConfigurationAzureSecurityBaselineArgs']]:
        """
        A `azure_security_baseline` block as defined below.
        """
        return pulumi.get(self, "azure_security_baseline")

    @azure_security_baseline.setter
    def azure_security_baseline(self, value: Optional[pulumi.Input['ConfigurationAzureSecurityBaselineArgs']]):
        pulumi.set(self, "azure_security_baseline", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['ConfigurationBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['ConfigurationBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="bootDiagnosticsEnabled")
    def boot_diagnostics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the boot diagnostics are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "boot_diagnostics_enabled")

    @boot_diagnostics_enabled.setter
    def boot_diagnostics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "boot_diagnostics_enabled", value)

    @property
    @pulumi.getter(name="defenderForCloudEnabled")
    def defender_for_cloud_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the defender for cloud is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "defender_for_cloud_enabled")

    @defender_for_cloud_enabled.setter
    def defender_for_cloud_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "defender_for_cloud_enabled", value)

    @property
    @pulumi.getter(name="guestConfigurationEnabled")
    def guest_configuration_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the guest configuration is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "guest_configuration_enabled")

    @guest_configuration_enabled.setter
    def guest_configuration_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "guest_configuration_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logAnalyticsEnabled")
    def log_analytics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether log analytics are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "log_analytics_enabled")

    @log_analytics_enabled.setter
    def log_analytics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_analytics_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="statusChangeAlertEnabled")
    def status_change_alert_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the status change alert is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "status_change_alert_enabled")

    @status_change_alert_enabled.setter
    def status_change_alert_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "status_change_alert_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 antimalware: Optional[pulumi.Input['ConfigurationAntimalwareArgs']] = None,
                 automation_account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_security_baseline: Optional[pulumi.Input['ConfigurationAzureSecurityBaselineArgs']] = None,
                 backup: Optional[pulumi.Input['ConfigurationBackupArgs']] = None,
                 boot_diagnostics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 defender_for_cloud_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 status_change_alert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input['ConfigurationAntimalwareArgs'] antimalware: A `antimalware` block as defined below.
        :param pulumi.Input[builtins.bool] automation_account_enabled: Whether the automation account is enabled. Defaults to `false`.
        :param pulumi.Input['ConfigurationAzureSecurityBaselineArgs'] azure_security_baseline: A `azure_security_baseline` block as defined below.
        :param pulumi.Input['ConfigurationBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] boot_diagnostics_enabled: Whether the boot diagnostics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] defender_for_cloud_enabled: Whether the defender for cloud is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] guest_configuration_enabled: Whether the guest configuration is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] log_analytics_enabled: Whether log analytics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] status_change_alert_enabled: Whether the status change alert is enabled. Defaults to `false`.
        """
        if antimalware is not None:
            pulumi.set(__self__, "antimalware", antimalware)
        if automation_account_enabled is not None:
            pulumi.set(__self__, "automation_account_enabled", automation_account_enabled)
        if azure_security_baseline is not None:
            pulumi.set(__self__, "azure_security_baseline", azure_security_baseline)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if boot_diagnostics_enabled is not None:
            pulumi.set(__self__, "boot_diagnostics_enabled", boot_diagnostics_enabled)
        if defender_for_cloud_enabled is not None:
            pulumi.set(__self__, "defender_for_cloud_enabled", defender_for_cloud_enabled)
        if guest_configuration_enabled is not None:
            pulumi.set(__self__, "guest_configuration_enabled", guest_configuration_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_analytics_enabled is not None:
            pulumi.set(__self__, "log_analytics_enabled", log_analytics_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if status_change_alert_enabled is not None:
            pulumi.set(__self__, "status_change_alert_enabled", status_change_alert_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def antimalware(self) -> Optional[pulumi.Input['ConfigurationAntimalwareArgs']]:
        """
        A `antimalware` block as defined below.
        """
        return pulumi.get(self, "antimalware")

    @antimalware.setter
    def antimalware(self, value: Optional[pulumi.Input['ConfigurationAntimalwareArgs']]):
        pulumi.set(self, "antimalware", value)

    @property
    @pulumi.getter(name="automationAccountEnabled")
    def automation_account_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the automation account is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "automation_account_enabled")

    @automation_account_enabled.setter
    def automation_account_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automation_account_enabled", value)

    @property
    @pulumi.getter(name="azureSecurityBaseline")
    def azure_security_baseline(self) -> Optional[pulumi.Input['ConfigurationAzureSecurityBaselineArgs']]:
        """
        A `azure_security_baseline` block as defined below.
        """
        return pulumi.get(self, "azure_security_baseline")

    @azure_security_baseline.setter
    def azure_security_baseline(self, value: Optional[pulumi.Input['ConfigurationAzureSecurityBaselineArgs']]):
        pulumi.set(self, "azure_security_baseline", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['ConfigurationBackupArgs']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['ConfigurationBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="bootDiagnosticsEnabled")
    def boot_diagnostics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the boot diagnostics are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "boot_diagnostics_enabled")

    @boot_diagnostics_enabled.setter
    def boot_diagnostics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "boot_diagnostics_enabled", value)

    @property
    @pulumi.getter(name="defenderForCloudEnabled")
    def defender_for_cloud_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the defender for cloud is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "defender_for_cloud_enabled")

    @defender_for_cloud_enabled.setter
    def defender_for_cloud_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "defender_for_cloud_enabled", value)

    @property
    @pulumi.getter(name="guestConfigurationEnabled")
    def guest_configuration_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the guest configuration is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "guest_configuration_enabled")

    @guest_configuration_enabled.setter
    def guest_configuration_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "guest_configuration_enabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logAnalyticsEnabled")
    def log_analytics_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether log analytics are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "log_analytics_enabled")

    @log_analytics_enabled.setter
    def log_analytics_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_analytics_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="statusChangeAlertEnabled")
    def status_change_alert_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the status change alert is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "status_change_alert_enabled")

    @status_change_alert_enabled.setter
    def status_change_alert_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "status_change_alert_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:automanage/configuration:Configuration")
class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 antimalware: Optional[pulumi.Input[Union['ConfigurationAntimalwareArgs', 'ConfigurationAntimalwareArgsDict']]] = None,
                 automation_account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_security_baseline: Optional[pulumi.Input[Union['ConfigurationAzureSecurityBaselineArgs', 'ConfigurationAzureSecurityBaselineArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['ConfigurationBackupArgs', 'ConfigurationBackupArgsDict']]] = None,
                 boot_diagnostics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 defender_for_cloud_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 status_change_alert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Automanage Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-automanage",
            location="West Europe")
        example_configuration = azure.automanage.Configuration("example",
            name="example-acmp",
            resource_group_name=example.name,
            location=example.location,
            antimalware={
                "exclusions": {
                    "extensions": "exe;dll",
                    "paths": "C:\\\\Windows\\\\Temp;D:\\\\Temp",
                    "processes": "svchost.exe;notepad.exe",
                },
                "real_time_protection_enabled": True,
                "scheduled_scan_enabled": True,
                "scheduled_scan_type": "Quick",
                "scheduled_scan_day": 1,
                "scheduled_scan_time_in_minutes": 1339,
            },
            azure_security_baseline={
                "assignment_type": "ApplyAndAutoCorrect",
            },
            automation_account_enabled=True,
            backup={
                "policy_name": "acctest-backup-policy-%d",
                "time_zone": "UTC",
                "instant_rp_retention_range_in_days": 2,
                "schedule_policy": {
                    "schedule_run_frequency": "Daily",
                    "schedule_run_days": [
                        "Monday",
                        "Tuesday",
                    ],
                    "schedule_run_times": ["12:00"],
                    "schedule_policy_type": "SimpleSchedulePolicy",
                },
                "retention_policy": {
                    "retention_policy_type": "LongTermRetentionPolicy",
                    "daily_schedule": {
                        "retention_times": ["12:00"],
                        "retention_duration": {
                            "count": 7,
                            "duration_type": "Days",
                        },
                    },
                    "weekly_schedule": {
                        "retention_times": ["14:00"],
                        "retention_duration": {
                            "count": 4,
                            "duration_type": "Weeks",
                        },
                    },
                },
            },
            boot_diagnostics_enabled=True,
            defender_for_cloud_enabled=True,
            guest_configuration_enabled=True,
            log_analytics_enabled=True,
            status_change_alert_enabled=True,
            tags={
                "env": "test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AutoManage`: 2022-05-04

        ## Import

        Automanage Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automanage/configuration:Configuration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AutoManage/configurationProfiles/configurationProfile1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConfigurationAntimalwareArgs', 'ConfigurationAntimalwareArgsDict']] antimalware: A `antimalware` block as defined below.
        :param pulumi.Input[builtins.bool] automation_account_enabled: Whether the automation account is enabled. Defaults to `false`.
        :param pulumi.Input[Union['ConfigurationAzureSecurityBaselineArgs', 'ConfigurationAzureSecurityBaselineArgsDict']] azure_security_baseline: A `azure_security_baseline` block as defined below.
        :param pulumi.Input[Union['ConfigurationBackupArgs', 'ConfigurationBackupArgsDict']] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] boot_diagnostics_enabled: Whether the boot diagnostics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] defender_for_cloud_enabled: Whether the defender for cloud is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] guest_configuration_enabled: Whether the guest configuration is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] log_analytics_enabled: Whether log analytics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] status_change_alert_enabled: Whether the status change alert is enabled. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Automanage Configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-automanage",
            location="West Europe")
        example_configuration = azure.automanage.Configuration("example",
            name="example-acmp",
            resource_group_name=example.name,
            location=example.location,
            antimalware={
                "exclusions": {
                    "extensions": "exe;dll",
                    "paths": "C:\\\\Windows\\\\Temp;D:\\\\Temp",
                    "processes": "svchost.exe;notepad.exe",
                },
                "real_time_protection_enabled": True,
                "scheduled_scan_enabled": True,
                "scheduled_scan_type": "Quick",
                "scheduled_scan_day": 1,
                "scheduled_scan_time_in_minutes": 1339,
            },
            azure_security_baseline={
                "assignment_type": "ApplyAndAutoCorrect",
            },
            automation_account_enabled=True,
            backup={
                "policy_name": "acctest-backup-policy-%d",
                "time_zone": "UTC",
                "instant_rp_retention_range_in_days": 2,
                "schedule_policy": {
                    "schedule_run_frequency": "Daily",
                    "schedule_run_days": [
                        "Monday",
                        "Tuesday",
                    ],
                    "schedule_run_times": ["12:00"],
                    "schedule_policy_type": "SimpleSchedulePolicy",
                },
                "retention_policy": {
                    "retention_policy_type": "LongTermRetentionPolicy",
                    "daily_schedule": {
                        "retention_times": ["12:00"],
                        "retention_duration": {
                            "count": 7,
                            "duration_type": "Days",
                        },
                    },
                    "weekly_schedule": {
                        "retention_times": ["14:00"],
                        "retention_duration": {
                            "count": 4,
                            "duration_type": "Weeks",
                        },
                    },
                },
            },
            boot_diagnostics_enabled=True,
            defender_for_cloud_enabled=True,
            guest_configuration_enabled=True,
            log_analytics_enabled=True,
            status_change_alert_enabled=True,
            tags={
                "env": "test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AutoManage`: 2022-05-04

        ## Import

        Automanage Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automanage/configuration:Configuration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AutoManage/configurationProfiles/configurationProfile1
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 antimalware: Optional[pulumi.Input[Union['ConfigurationAntimalwareArgs', 'ConfigurationAntimalwareArgsDict']]] = None,
                 automation_account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 azure_security_baseline: Optional[pulumi.Input[Union['ConfigurationAzureSecurityBaselineArgs', 'ConfigurationAzureSecurityBaselineArgsDict']]] = None,
                 backup: Optional[pulumi.Input[Union['ConfigurationBackupArgs', 'ConfigurationBackupArgsDict']]] = None,
                 boot_diagnostics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 defender_for_cloud_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_analytics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 status_change_alert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            __props__.__dict__["antimalware"] = antimalware
            __props__.__dict__["automation_account_enabled"] = automation_account_enabled
            __props__.__dict__["azure_security_baseline"] = azure_security_baseline
            __props__.__dict__["backup"] = backup
            __props__.__dict__["boot_diagnostics_enabled"] = boot_diagnostics_enabled
            __props__.__dict__["defender_for_cloud_enabled"] = defender_for_cloud_enabled
            __props__.__dict__["guest_configuration_enabled"] = guest_configuration_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["log_analytics_enabled"] = log_analytics_enabled
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["status_change_alert_enabled"] = status_change_alert_enabled
            __props__.__dict__["tags"] = tags
        super(Configuration, __self__).__init__(
            'azure:automanage/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            antimalware: Optional[pulumi.Input[Union['ConfigurationAntimalwareArgs', 'ConfigurationAntimalwareArgsDict']]] = None,
            automation_account_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            azure_security_baseline: Optional[pulumi.Input[Union['ConfigurationAzureSecurityBaselineArgs', 'ConfigurationAzureSecurityBaselineArgsDict']]] = None,
            backup: Optional[pulumi.Input[Union['ConfigurationBackupArgs', 'ConfigurationBackupArgsDict']]] = None,
            boot_diagnostics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            defender_for_cloud_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            guest_configuration_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            log_analytics_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            status_change_alert_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConfigurationAntimalwareArgs', 'ConfigurationAntimalwareArgsDict']] antimalware: A `antimalware` block as defined below.
        :param pulumi.Input[builtins.bool] automation_account_enabled: Whether the automation account is enabled. Defaults to `false`.
        :param pulumi.Input[Union['ConfigurationAzureSecurityBaselineArgs', 'ConfigurationAzureSecurityBaselineArgsDict']] azure_security_baseline: A `azure_security_baseline` block as defined below.
        :param pulumi.Input[Union['ConfigurationBackupArgs', 'ConfigurationBackupArgsDict']] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.bool] boot_diagnostics_enabled: Whether the boot diagnostics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] defender_for_cloud_enabled: Whether the defender for cloud is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.bool] guest_configuration_enabled: Whether the guest configuration is enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] log_analytics_enabled: Whether log analytics are enabled. Defaults to `false`.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        :param pulumi.Input[builtins.bool] status_change_alert_enabled: Whether the status change alert is enabled. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["antimalware"] = antimalware
        __props__.__dict__["automation_account_enabled"] = automation_account_enabled
        __props__.__dict__["azure_security_baseline"] = azure_security_baseline
        __props__.__dict__["backup"] = backup
        __props__.__dict__["boot_diagnostics_enabled"] = boot_diagnostics_enabled
        __props__.__dict__["defender_for_cloud_enabled"] = defender_for_cloud_enabled
        __props__.__dict__["guest_configuration_enabled"] = guest_configuration_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["log_analytics_enabled"] = log_analytics_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["status_change_alert_enabled"] = status_change_alert_enabled
        __props__.__dict__["tags"] = tags
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def antimalware(self) -> pulumi.Output[Optional['outputs.ConfigurationAntimalware']]:
        """
        A `antimalware` block as defined below.
        """
        return pulumi.get(self, "antimalware")

    @property
    @pulumi.getter(name="automationAccountEnabled")
    def automation_account_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the automation account is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "automation_account_enabled")

    @property
    @pulumi.getter(name="azureSecurityBaseline")
    def azure_security_baseline(self) -> pulumi.Output[Optional['outputs.ConfigurationAzureSecurityBaseline']]:
        """
        A `azure_security_baseline` block as defined below.
        """
        return pulumi.get(self, "azure_security_baseline")

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional['outputs.ConfigurationBackup']]:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="bootDiagnosticsEnabled")
    def boot_diagnostics_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the boot diagnostics are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "boot_diagnostics_enabled")

    @property
    @pulumi.getter(name="defenderForCloudEnabled")
    def defender_for_cloud_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the defender for cloud is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "defender_for_cloud_enabled")

    @property
    @pulumi.getter(name="guestConfigurationEnabled")
    def guest_configuration_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the guest configuration is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "guest_configuration_enabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logAnalyticsEnabled")
    def log_analytics_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether log analytics are enabled. Defaults to `false`.
        """
        return pulumi.get(self, "log_analytics_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Automanage Configuration. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Automanage Configuration should exist. Changing this forces a new Automanage Configuration to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="statusChangeAlertEnabled")
    def status_change_alert_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the status change alert is enabled. Defaults to `false`.
        """
        return pulumi.get(self, "status_change_alert_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        return pulumi.get(self, "tags")

