# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['JobScheduleArgs', 'JobSchedule']

@pulumi.input_type
class JobScheduleArgs:
    def __init__(__self__, *,
                 automation_account_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 runbook_name: pulumi.Input[builtins.str],
                 schedule_name: pulumi.Input[builtins.str],
                 job_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_on: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a JobSchedule resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_name: The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] schedule_name: The name of the Schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] job_schedule_id: The UUID identifying the Automation Job Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.
               
               > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        :param pulumi.Input[builtins.str] run_on: Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "runbook_name", runbook_name)
        pulumi.set(__self__, "schedule_name", schedule_name)
        if job_schedule_id is not None:
            pulumi.set(__self__, "job_schedule_id", job_schedule_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if run_on is not None:
            pulumi.set(__self__, "run_on", run_on)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "runbook_name")

    @runbook_name.setter
    def runbook_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runbook_name", value)

    @property
    @pulumi.getter(name="scheduleName")
    def schedule_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "schedule_name")

    @schedule_name.setter
    def schedule_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schedule_name", value)

    @property
    @pulumi.getter(name="jobScheduleId")
    def job_schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID identifying the Automation Job Schedule.
        """
        return pulumi.get(self, "job_schedule_id")

    @job_schedule_id.setter
    def job_schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_schedule_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.

        > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "run_on")

    @run_on.setter
    def run_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "run_on", value)


@pulumi.input_type
class _JobScheduleState:
    def __init__(__self__, *,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 run_on: Optional[pulumi.Input[builtins.str]] = None,
                 runbook_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering JobSchedule resources.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] job_schedule_id: The UUID identifying the Automation Job Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.
               
               > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_manager_id: The Resource Manager ID of the Automation Job Schedule.
        :param pulumi.Input[builtins.str] run_on: Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_name: The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] schedule_name: The name of the Schedule. Changing this forces a new resource to be created.
        """
        if automation_account_name is not None:
            pulumi.set(__self__, "automation_account_name", automation_account_name)
        if job_schedule_id is not None:
            pulumi.set(__self__, "job_schedule_id", job_schedule_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if resource_manager_id is not None:
            pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if run_on is not None:
            pulumi.set(__self__, "run_on", run_on)
        if runbook_name is not None:
            pulumi.set(__self__, "runbook_name", runbook_name)
        if schedule_name is not None:
            pulumi.set(__self__, "schedule_name", schedule_name)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="jobScheduleId")
    def job_schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID identifying the Automation Job Schedule.
        """
        return pulumi.get(self, "job_schedule_id")

    @job_schedule_id.setter
    def job_schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job_schedule_id", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.

        > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Resource Manager ID of the Automation Job Schedule.
        """
        return pulumi.get(self, "resource_manager_id")

    @resource_manager_id.setter
    def resource_manager_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_manager_id", value)

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "run_on")

    @run_on.setter
    def run_on(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "run_on", value)

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "runbook_name")

    @runbook_name.setter
    def runbook_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runbook_name", value)

    @property
    @pulumi.getter(name="scheduleName")
    def schedule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "schedule_name")

    @schedule_name.setter
    def schedule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_name", value)


@pulumi.type_token("azure:automation/jobSchedule:JobSchedule")
class JobSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 run_on: Optional[pulumi.Input[builtins.str]] = None,
                 runbook_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Links an Automation Runbook and Schedule.

        > **Note:** AzureRM provides this stand-alone automation.JobSchedule and an inlined `job_schedule` property in azurerm_runbook to manage the job schedules. You can only make use of one of these methods to manage a job schedule.

        ## Example Usage

        This is an example of just the Job Schedule.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.automation.JobSchedule("example",
            resource_group_name="tf-rgr-automation",
            automation_account_name="tf-automation-account",
            schedule_name="hour",
            runbook_name="Get-VirtualMachine",
            parameters={
                "resourcegroup": "tf-rgr-vm",
                "vmname": "TF-VM-01",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation`: 2023-11-01

        ## Import

        Automation Job Schedules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/jobSchedule:JobSchedule example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/schedules/schedule1|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/runbooks/runbook1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] job_schedule_id: The UUID identifying the Automation Job Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.
               
               > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] run_on: Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_name: The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] schedule_name: The name of the Schedule. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Links an Automation Runbook and Schedule.

        > **Note:** AzureRM provides this stand-alone automation.JobSchedule and an inlined `job_schedule` property in azurerm_runbook to manage the job schedules. You can only make use of one of these methods to manage a job schedule.

        ## Example Usage

        This is an example of just the Job Schedule.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.automation.JobSchedule("example",
            resource_group_name="tf-rgr-automation",
            automation_account_name="tf-automation-account",
            schedule_name="hour",
            runbook_name="Get-VirtualMachine",
            parameters={
                "resourcegroup": "tf-rgr-vm",
                "vmname": "TF-VM-01",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation`: 2023-11-01

        ## Import

        Automation Job Schedules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/jobSchedule:JobSchedule example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/schedules/schedule1|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/runbooks/runbook1"
        ```

        :param str resource_name: The name of the resource.
        :param JobScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 job_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 run_on: Optional[pulumi.Input[builtins.str]] = None,
                 runbook_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobScheduleArgs.__new__(JobScheduleArgs)

            if automation_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_name'")
            __props__.__dict__["automation_account_name"] = automation_account_name
            __props__.__dict__["job_schedule_id"] = job_schedule_id
            __props__.__dict__["parameters"] = parameters
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["run_on"] = run_on
            if runbook_name is None and not opts.urn:
                raise TypeError("Missing required property 'runbook_name'")
            __props__.__dict__["runbook_name"] = runbook_name
            if schedule_name is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_name'")
            __props__.__dict__["schedule_name"] = schedule_name
            __props__.__dict__["resource_manager_id"] = None
        super(JobSchedule, __self__).__init__(
            'azure:automation/jobSchedule:JobSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
            job_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_manager_id: Optional[pulumi.Input[builtins.str]] = None,
            run_on: Optional[pulumi.Input[builtins.str]] = None,
            runbook_name: Optional[pulumi.Input[builtins.str]] = None,
            schedule_name: Optional[pulumi.Input[builtins.str]] = None) -> 'JobSchedule':
        """
        Get an existing JobSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] job_schedule_id: The UUID identifying the Automation Job Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] parameters: A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.
               
               > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_manager_id: The Resource Manager ID of the Automation Job Schedule.
        :param pulumi.Input[builtins.str] run_on: Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_name: The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] schedule_name: The name of the Schedule. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobScheduleState.__new__(_JobScheduleState)

        __props__.__dict__["automation_account_name"] = automation_account_name
        __props__.__dict__["job_schedule_id"] = job_schedule_id
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["resource_manager_id"] = resource_manager_id
        __props__.__dict__["run_on"] = run_on
        __props__.__dict__["runbook_name"] = runbook_name
        __props__.__dict__["schedule_name"] = schedule_name
        return JobSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Automation Account in which the Job Schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @property
    @pulumi.getter(name="jobScheduleId")
    def job_schedule_id(self) -> pulumi.Output[builtins.str]:
        """
        The UUID identifying the Automation Job Schedule.
        """
        return pulumi.get(self, "job_schedule_id")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of key/value pairs corresponding to the arguments that can be passed to the Runbook. Changing this forces a new resource to be created.

        > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which the Job Schedule is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> pulumi.Output[builtins.str]:
        """
        The Resource Manager ID of the Automation Job Schedule.
        """
        return pulumi.get(self, "resource_manager_id")

    @property
    @pulumi.getter(name="runOn")
    def run_on(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Name of a Hybrid Worker Group the Runbook will be executed on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "run_on")

    @property
    @pulumi.getter(name="runbookName")
    def runbook_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of a Runbook to link to a Schedule. It needs to be in the same Automation Account as the Schedule and Job Schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "runbook_name")

    @property
    @pulumi.getter(name="scheduleName")
    def schedule_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Schedule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "schedule_name")

