# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Python3PackageArgs', 'Python3Package']

@pulumi.input_type
class Python3PackageArgs:
    def __init__(__self__, *,
                 automation_account_name: pulumi.Input[builtins.str],
                 content_uri: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 content_version: Optional[pulumi.Input[builtins.str]] = None,
                 hash_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 hash_value: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Python3Package resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_uri: The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_version: Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_algorithm: Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_value: Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        pulumi.set(__self__, "content_uri", content_uri)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if content_version is not None:
            pulumi.set(__self__, "content_version", content_version)
        if hash_algorithm is not None:
            pulumi.set(__self__, "hash_algorithm", hash_algorithm)
        if hash_value is not None:
            pulumi.set(__self__, "hash_value", hash_value)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="contentUri")
    def content_uri(self) -> pulumi.Input[builtins.str]:
        """
        The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "content_uri")

    @content_uri.setter
    def content_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "content_uri", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="contentVersion")
    def content_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "content_version")

    @content_version.setter
    def content_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_version", value)

    @property
    @pulumi.getter(name="hashAlgorithm")
    def hash_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "hash_algorithm")

    @hash_algorithm.setter
    def hash_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_algorithm", value)

    @property
    @pulumi.getter(name="hashValue")
    def hash_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "hash_value")

    @hash_value.setter
    def hash_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _Python3PackageState:
    def __init__(__self__, *,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 content_uri: Optional[pulumi.Input[builtins.str]] = None,
                 content_version: Optional[pulumi.Input[builtins.str]] = None,
                 hash_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 hash_value: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Python3Package resources.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_uri: The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] content_version: Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_algorithm: Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_value: Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        if automation_account_name is not None:
            pulumi.set(__self__, "automation_account_name", automation_account_name)
        if content_uri is not None:
            pulumi.set(__self__, "content_uri", content_uri)
        if content_version is not None:
            pulumi.set(__self__, "content_version", content_version)
        if hash_algorithm is not None:
            pulumi.set(__self__, "hash_algorithm", hash_algorithm)
        if hash_value is not None:
            pulumi.set(__self__, "hash_value", hash_value)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="contentUri")
    def content_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "content_uri")

    @content_uri.setter
    def content_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_uri", value)

    @property
    @pulumi.getter(name="contentVersion")
    def content_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "content_version")

    @content_version.setter
    def content_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content_version", value)

    @property
    @pulumi.getter(name="hashAlgorithm")
    def hash_algorithm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "hash_algorithm")

    @hash_algorithm.setter
    def hash_algorithm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_algorithm", value)

    @property
    @pulumi.getter(name="hashValue")
    def hash_value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "hash_value")

    @hash_value.setter
    def hash_value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hash_value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:automation/python3Package:Python3Package")
class Python3Package(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 content_uri: Optional[pulumi.Input[builtins.str]] = None,
                 content_version: Optional[pulumi.Input[builtins.str]] = None,
                 hash_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 hash_value: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Automation Python3 Package.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="%[2]s")
        example_account = azure.automation.Account("example",
            name="accexample",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_python3_package = azure.automation.Python3Package("example",
            name="example",
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            content_uri="https://pypi.org/packages/source/r/requests/requests-2.31.0.tar.gz",
            content_version="2.31.0",
            hash_algorithm="sha256",
            hash_value="942c5a758f98d790eaed1a29cb6eefc7ffb0d1cf7af05c3d2791656dbd6ad1e1",
            tags={
                "key": "foo",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation`: 2023-11-01

        ## Import

        Automation Python3 Packages can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/python3Package:Python3Package example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/python3Packages/pkg
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_uri: The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] content_version: Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_algorithm: Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_value: Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Python3PackageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Automation Python3 Package.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="%[2]s")
        example_account = azure.automation.Account("example",
            name="accexample",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_python3_package = azure.automation.Python3Package("example",
            name="example",
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            content_uri="https://pypi.org/packages/source/r/requests/requests-2.31.0.tar.gz",
            content_version="2.31.0",
            hash_algorithm="sha256",
            hash_value="942c5a758f98d790eaed1a29cb6eefc7ffb0d1cf7af05c3d2791656dbd6ad1e1",
            tags={
                "key": "foo",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation`: 2023-11-01

        ## Import

        Automation Python3 Packages can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/python3Package:Python3Package example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/python3Packages/pkg
        ```

        :param str resource_name: The name of the resource.
        :param Python3PackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Python3PackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 content_uri: Optional[pulumi.Input[builtins.str]] = None,
                 content_version: Optional[pulumi.Input[builtins.str]] = None,
                 hash_algorithm: Optional[pulumi.Input[builtins.str]] = None,
                 hash_value: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Python3PackageArgs.__new__(Python3PackageArgs)

            if automation_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_name'")
            __props__.__dict__["automation_account_name"] = automation_account_name
            if content_uri is None and not opts.urn:
                raise TypeError("Missing required property 'content_uri'")
            __props__.__dict__["content_uri"] = content_uri
            __props__.__dict__["content_version"] = content_version
            __props__.__dict__["hash_algorithm"] = hash_algorithm
            __props__.__dict__["hash_value"] = hash_value
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
        super(Python3Package, __self__).__init__(
            'azure:automation/python3Package:Python3Package',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
            content_uri: Optional[pulumi.Input[builtins.str]] = None,
            content_version: Optional[pulumi.Input[builtins.str]] = None,
            hash_algorithm: Optional[pulumi.Input[builtins.str]] = None,
            hash_value: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Python3Package':
        """
        Get an existing Python3Package resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content_uri: The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] content_version: Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_algorithm: Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] hash_value: Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Python3PackageState.__new__(_Python3PackageState)

        __props__.__dict__["automation_account_name"] = automation_account_name
        __props__.__dict__["content_uri"] = content_uri
        __props__.__dict__["content_version"] = content_version
        __props__.__dict__["hash_algorithm"] = hash_algorithm
        __props__.__dict__["hash_value"] = hash_value
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return Python3Package(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the automation account in which the Python3 Package is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @property
    @pulumi.getter(name="contentUri")
    def content_uri(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the python package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "content_uri")

    @property
    @pulumi.getter(name="contentVersion")
    def content_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify the version of the python3 package. The value should meet the system.version class format like `1.1.1`. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "content_version")

    @property
    @pulumi.getter(name="hashAlgorithm")
    def hash_algorithm(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specify the hash algorithm used to hash the content of the python3 package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "hash_algorithm")

    @property
    @pulumi.getter(name="hashValue")
    def hash_value(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specity the hash value of the content. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "hash_value")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Automation Python3 Package. Changing this forces a new Automation Python3 Package to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which the Python3 Package is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Automation Python3 Package.
        """
        return pulumi.get(self, "tags")

