# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RunBookArgs', 'RunBook']

@pulumi.input_type
class RunBookArgs:
    def __init__(__self__, *,
                 automation_account_name: pulumi.Input[builtins.str],
                 log_progress: pulumi.Input[builtins.bool],
                 log_verbose: pulumi.Input[builtins.bool],
                 resource_group_name: pulumi.Input[builtins.str],
                 runbook_type: pulumi.Input[builtins.str],
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 draft: Optional[pulumi.Input['RunBookDraftArgs']] = None,
                 job_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_activity_trace_level: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 publish_content_link: Optional[pulumi.Input['RunBookPublishContentLinkArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a RunBook resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] log_progress: Progress log option.
        :param pulumi.Input[builtins.bool] log_verbose: Verbose log option.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_type: The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content: The desired content of the runbook.
               
               > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        :param pulumi.Input[builtins.str] description: A description for the runbook.
        :param pulumi.Input['RunBookDraftArgs'] draft: A `draft` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]] job_schedules: One or more `job_schedule` block as defined below.
               
               > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] log_activity_trace_level: Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Runbook. Changing this forces a new resource to be created.
        :param pulumi.Input['RunBookPublishContentLinkArgs'] publish_content_link: One `publish_content_link` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "automation_account_name", automation_account_name)
        pulumi.set(__self__, "log_progress", log_progress)
        pulumi.set(__self__, "log_verbose", log_verbose)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "runbook_type", runbook_type)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if draft is not None:
            pulumi.set(__self__, "draft", draft)
        if job_schedules is not None:
            pulumi.set(__self__, "job_schedules", job_schedules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_activity_trace_level is not None:
            pulumi.set(__self__, "log_activity_trace_level", log_activity_trace_level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish_content_link is not None:
            pulumi.set(__self__, "publish_content_link", publish_content_link)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter(name="logProgress")
    def log_progress(self) -> pulumi.Input[builtins.bool]:
        """
        Progress log option.
        """
        return pulumi.get(self, "log_progress")

    @log_progress.setter
    def log_progress(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "log_progress", value)

    @property
    @pulumi.getter(name="logVerbose")
    def log_verbose(self) -> pulumi.Input[builtins.bool]:
        """
        Verbose log option.
        """
        return pulumi.get(self, "log_verbose")

    @log_verbose.setter
    def log_verbose(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "log_verbose", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="runbookType")
    def runbook_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "runbook_type")

    @runbook_type.setter
    def runbook_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runbook_type", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired content of the runbook.

        > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the runbook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def draft(self) -> Optional[pulumi.Input['RunBookDraftArgs']]:
        """
        A `draft` block as defined below.
        """
        return pulumi.get(self, "draft")

    @draft.setter
    def draft(self, value: Optional[pulumi.Input['RunBookDraftArgs']]):
        pulumi.set(self, "draft", value)

    @property
    @pulumi.getter(name="jobSchedules")
    def job_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]]]:
        """
        One or more `job_schedule` block as defined below.

        > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        """
        return pulumi.get(self, "job_schedules")

    @job_schedules.setter
    def job_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]]]):
        pulumi.set(self, "job_schedules", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logActivityTraceLevel")
    def log_activity_trace_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        """
        return pulumi.get(self, "log_activity_trace_level")

    @log_activity_trace_level.setter
    def log_activity_trace_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "log_activity_trace_level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Runbook. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publishContentLink")
    def publish_content_link(self) -> Optional[pulumi.Input['RunBookPublishContentLinkArgs']]:
        """
        One `publish_content_link` block as defined below.
        """
        return pulumi.get(self, "publish_content_link")

    @publish_content_link.setter
    def publish_content_link(self, value: Optional[pulumi.Input['RunBookPublishContentLinkArgs']]):
        pulumi.set(self, "publish_content_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RunBookState:
    def __init__(__self__, *,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 draft: Optional[pulumi.Input['RunBookDraftArgs']] = None,
                 job_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_activity_trace_level: Optional[pulumi.Input[builtins.int]] = None,
                 log_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 log_verbose: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 publish_content_link: Optional[pulumi.Input['RunBookPublishContentLinkArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 runbook_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RunBook resources.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content: The desired content of the runbook.
               
               > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        :param pulumi.Input[builtins.str] description: A description for the runbook.
        :param pulumi.Input['RunBookDraftArgs'] draft: A `draft` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]] job_schedules: One or more `job_schedule` block as defined below.
               
               > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] log_activity_trace_level: Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        :param pulumi.Input[builtins.bool] log_progress: Progress log option.
        :param pulumi.Input[builtins.bool] log_verbose: Verbose log option.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Runbook. Changing this forces a new resource to be created.
        :param pulumi.Input['RunBookPublishContentLinkArgs'] publish_content_link: One `publish_content_link` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_type: The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if automation_account_name is not None:
            pulumi.set(__self__, "automation_account_name", automation_account_name)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if draft is not None:
            pulumi.set(__self__, "draft", draft)
        if job_schedules is not None:
            pulumi.set(__self__, "job_schedules", job_schedules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if log_activity_trace_level is not None:
            pulumi.set(__self__, "log_activity_trace_level", log_activity_trace_level)
        if log_progress is not None:
            pulumi.set(__self__, "log_progress", log_progress)
        if log_verbose is not None:
            pulumi.set(__self__, "log_verbose", log_verbose)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if publish_content_link is not None:
            pulumi.set(__self__, "publish_content_link", publish_content_link)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if runbook_type is not None:
            pulumi.set(__self__, "runbook_type", runbook_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @automation_account_name.setter
    def automation_account_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automation_account_name", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The desired content of the runbook.

        > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the runbook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def draft(self) -> Optional[pulumi.Input['RunBookDraftArgs']]:
        """
        A `draft` block as defined below.
        """
        return pulumi.get(self, "draft")

    @draft.setter
    def draft(self, value: Optional[pulumi.Input['RunBookDraftArgs']]):
        pulumi.set(self, "draft", value)

    @property
    @pulumi.getter(name="jobSchedules")
    def job_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]]]:
        """
        One or more `job_schedule` block as defined below.

        > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        """
        return pulumi.get(self, "job_schedules")

    @job_schedules.setter
    def job_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunBookJobScheduleArgs']]]]):
        pulumi.set(self, "job_schedules", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="logActivityTraceLevel")
    def log_activity_trace_level(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        """
        return pulumi.get(self, "log_activity_trace_level")

    @log_activity_trace_level.setter
    def log_activity_trace_level(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "log_activity_trace_level", value)

    @property
    @pulumi.getter(name="logProgress")
    def log_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Progress log option.
        """
        return pulumi.get(self, "log_progress")

    @log_progress.setter
    def log_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_progress", value)

    @property
    @pulumi.getter(name="logVerbose")
    def log_verbose(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Verbose log option.
        """
        return pulumi.get(self, "log_verbose")

    @log_verbose.setter
    def log_verbose(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "log_verbose", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Runbook. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publishContentLink")
    def publish_content_link(self) -> Optional[pulumi.Input['RunBookPublishContentLinkArgs']]:
        """
        One `publish_content_link` block as defined below.
        """
        return pulumi.get(self, "publish_content_link")

    @publish_content_link.setter
    def publish_content_link(self, value: Optional[pulumi.Input['RunBookPublishContentLinkArgs']]):
        pulumi.set(self, "publish_content_link", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="runbookType")
    def runbook_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "runbook_type")

    @runbook_type.setter
    def runbook_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runbook_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:automation/runBook:RunBook")
class RunBook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 draft: Optional[pulumi.Input[Union['RunBookDraftArgs', 'RunBookDraftArgsDict']]] = None,
                 job_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunBookJobScheduleArgs', 'RunBookJobScheduleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_activity_trace_level: Optional[pulumi.Input[builtins.int]] = None,
                 log_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 log_verbose: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 publish_content_link: Optional[pulumi.Input[Union['RunBookPublishContentLinkArgs', 'RunBookPublishContentLinkArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 runbook_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Automation Runbook.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="account1",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_run_book = azure.automation.RunBook("example",
            name="Get-AzureVMTutorial",
            location=example.location,
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            log_verbose=True,
            log_progress=True,
            description="This is an example runbook",
            runbook_type="PowerShellWorkflow",
            publish_content_link={
                "uri": "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/c4935ffb69246a6058eb24f54640f53f69d3ac9f/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1",
            })
        ```

        ## Import

        Automation Runbooks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/runBook:RunBook Get-AzureVMTutorial /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/runbooks/Get-AzureVMTutorial
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content: The desired content of the runbook.
               
               > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        :param pulumi.Input[builtins.str] description: A description for the runbook.
        :param pulumi.Input[Union['RunBookDraftArgs', 'RunBookDraftArgsDict']] draft: A `draft` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunBookJobScheduleArgs', 'RunBookJobScheduleArgsDict']]]] job_schedules: One or more `job_schedule` block as defined below.
               
               > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] log_activity_trace_level: Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        :param pulumi.Input[builtins.bool] log_progress: Progress log option.
        :param pulumi.Input[builtins.bool] log_verbose: Verbose log option.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Runbook. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['RunBookPublishContentLinkArgs', 'RunBookPublishContentLinkArgsDict']] publish_content_link: One `publish_content_link` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_type: The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RunBookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Automation Runbook.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="account1",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_run_book = azure.automation.RunBook("example",
            name="Get-AzureVMTutorial",
            location=example.location,
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            log_verbose=True,
            log_progress=True,
            description="This is an example runbook",
            runbook_type="PowerShellWorkflow",
            publish_content_link={
                "uri": "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/c4935ffb69246a6058eb24f54640f53f69d3ac9f/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1",
            })
        ```

        ## Import

        Automation Runbooks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/runBook:RunBook Get-AzureVMTutorial /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/runbooks/Get-AzureVMTutorial
        ```

        :param str resource_name: The name of the resource.
        :param RunBookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RunBookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
                 content: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 draft: Optional[pulumi.Input[Union['RunBookDraftArgs', 'RunBookDraftArgsDict']]] = None,
                 job_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunBookJobScheduleArgs', 'RunBookJobScheduleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 log_activity_trace_level: Optional[pulumi.Input[builtins.int]] = None,
                 log_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 log_verbose: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 publish_content_link: Optional[pulumi.Input[Union['RunBookPublishContentLinkArgs', 'RunBookPublishContentLinkArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 runbook_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RunBookArgs.__new__(RunBookArgs)

            if automation_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_name'")
            __props__.__dict__["automation_account_name"] = automation_account_name
            __props__.__dict__["content"] = content
            __props__.__dict__["description"] = description
            __props__.__dict__["draft"] = draft
            __props__.__dict__["job_schedules"] = job_schedules
            __props__.__dict__["location"] = location
            __props__.__dict__["log_activity_trace_level"] = log_activity_trace_level
            if log_progress is None and not opts.urn:
                raise TypeError("Missing required property 'log_progress'")
            __props__.__dict__["log_progress"] = log_progress
            if log_verbose is None and not opts.urn:
                raise TypeError("Missing required property 'log_verbose'")
            __props__.__dict__["log_verbose"] = log_verbose
            __props__.__dict__["name"] = name
            __props__.__dict__["publish_content_link"] = publish_content_link
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if runbook_type is None and not opts.urn:
                raise TypeError("Missing required property 'runbook_type'")
            __props__.__dict__["runbook_type"] = runbook_type
            __props__.__dict__["tags"] = tags
        super(RunBook, __self__).__init__(
            'azure:automation/runBook:RunBook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automation_account_name: Optional[pulumi.Input[builtins.str]] = None,
            content: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            draft: Optional[pulumi.Input[Union['RunBookDraftArgs', 'RunBookDraftArgsDict']]] = None,
            job_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RunBookJobScheduleArgs', 'RunBookJobScheduleArgsDict']]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            log_activity_trace_level: Optional[pulumi.Input[builtins.int]] = None,
            log_progress: Optional[pulumi.Input[builtins.bool]] = None,
            log_verbose: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            publish_content_link: Optional[pulumi.Input[Union['RunBookPublishContentLinkArgs', 'RunBookPublishContentLinkArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            runbook_type: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'RunBook':
        """
        Get an existing RunBook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] automation_account_name: The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] content: The desired content of the runbook.
               
               > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        :param pulumi.Input[builtins.str] description: A description for the runbook.
        :param pulumi.Input[Union['RunBookDraftArgs', 'RunBookDraftArgsDict']] draft: A `draft` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RunBookJobScheduleArgs', 'RunBookJobScheduleArgsDict']]]] job_schedules: One or more `job_schedule` block as defined below.
               
               > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] log_activity_trace_level: Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        :param pulumi.Input[builtins.bool] log_progress: Progress log option.
        :param pulumi.Input[builtins.bool] log_verbose: Verbose log option.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Runbook. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['RunBookPublishContentLinkArgs', 'RunBookPublishContentLinkArgsDict']] publish_content_link: One `publish_content_link` block as defined below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] runbook_type: The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RunBookState.__new__(_RunBookState)

        __props__.__dict__["automation_account_name"] = automation_account_name
        __props__.__dict__["content"] = content
        __props__.__dict__["description"] = description
        __props__.__dict__["draft"] = draft
        __props__.__dict__["job_schedules"] = job_schedules
        __props__.__dict__["location"] = location
        __props__.__dict__["log_activity_trace_level"] = log_activity_trace_level
        __props__.__dict__["log_progress"] = log_progress
        __props__.__dict__["log_verbose"] = log_verbose
        __props__.__dict__["name"] = name
        __props__.__dict__["publish_content_link"] = publish_content_link
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["runbook_type"] = runbook_type
        __props__.__dict__["tags"] = tags
        return RunBook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="automationAccountName")
    def automation_account_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the automation account in which the Runbook is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "automation_account_name")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[builtins.str]:
        """
        The desired content of the runbook.

        > **Note:** The Azure API requires a `publish_content_link` to be supplied even when specifying your own `content`.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description for the runbook.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def draft(self) -> pulumi.Output[Optional['outputs.RunBookDraft']]:
        """
        A `draft` block as defined below.
        """
        return pulumi.get(self, "draft")

    @property
    @pulumi.getter(name="jobSchedules")
    def job_schedules(self) -> pulumi.Output[Sequence['outputs.RunBookJobSchedule']]:
        """
        One or more `job_schedule` block as defined below.

        > **Note:** AzureRM provides a stand-alone automation.JobSchedule and this inlined `job_schedule` property to manage the job schedules. At this time you should choose one of them to manage the job schedule resources.
        """
        return pulumi.get(self, "job_schedules")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="logActivityTraceLevel")
    def log_activity_trace_level(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the activity-level tracing options of the runbook, available only for Graphical runbooks. Possible values are `0` for None, `9` for Basic, and `15` for Detailed. Must turn on Verbose logging in order to see the tracing.
        """
        return pulumi.get(self, "log_activity_trace_level")

    @property
    @pulumi.getter(name="logProgress")
    def log_progress(self) -> pulumi.Output[builtins.bool]:
        """
        Progress log option.
        """
        return pulumi.get(self, "log_progress")

    @property
    @pulumi.getter(name="logVerbose")
    def log_verbose(self) -> pulumi.Output[builtins.bool]:
        """
        Verbose log option.
        """
        return pulumi.get(self, "log_verbose")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Runbook. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publishContentLink")
    def publish_content_link(self) -> pulumi.Output[Optional['outputs.RunBookPublishContentLink']]:
        """
        One `publish_content_link` block as defined below.
        """
        return pulumi.get(self, "publish_content_link")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which the Runbook is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="runbookType")
    def runbook_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the runbook - can be either `Graph`, `GraphPowerShell`, `GraphPowerShellWorkflow`, `PowerShellWorkflow`, `PowerShell`, `PowerShell72`, `Python3`, `Python2` or `Script`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "runbook_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

