# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PolicyFileShareBackupArgs',
    'PolicyFileShareBackupArgsDict',
    'PolicyFileShareBackupHourlyArgs',
    'PolicyFileShareBackupHourlyArgsDict',
    'PolicyFileShareRetentionDailyArgs',
    'PolicyFileShareRetentionDailyArgsDict',
    'PolicyFileShareRetentionMonthlyArgs',
    'PolicyFileShareRetentionMonthlyArgsDict',
    'PolicyFileShareRetentionWeeklyArgs',
    'PolicyFileShareRetentionWeeklyArgsDict',
    'PolicyFileShareRetentionYearlyArgs',
    'PolicyFileShareRetentionYearlyArgsDict',
    'PolicyVMBackupArgs',
    'PolicyVMBackupArgsDict',
    'PolicyVMInstantRestoreResourceGroupArgs',
    'PolicyVMInstantRestoreResourceGroupArgsDict',
    'PolicyVMRetentionDailyArgs',
    'PolicyVMRetentionDailyArgsDict',
    'PolicyVMRetentionMonthlyArgs',
    'PolicyVMRetentionMonthlyArgsDict',
    'PolicyVMRetentionWeeklyArgs',
    'PolicyVMRetentionWeeklyArgsDict',
    'PolicyVMRetentionYearlyArgs',
    'PolicyVMRetentionYearlyArgsDict',
    'PolicyVMTieringPolicyArgs',
    'PolicyVMTieringPolicyArgsDict',
    'PolicyVMTieringPolicyArchivedRestorePointArgs',
    'PolicyVMTieringPolicyArchivedRestorePointArgsDict',
    'PolicyVMWorkloadProtectionPolicyArgs',
    'PolicyVMWorkloadProtectionPolicyArgsDict',
    'PolicyVMWorkloadProtectionPolicyBackupArgs',
    'PolicyVMWorkloadProtectionPolicyBackupArgsDict',
    'PolicyVMWorkloadProtectionPolicyRetentionDailyArgs',
    'PolicyVMWorkloadProtectionPolicyRetentionDailyArgsDict',
    'PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs',
    'PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgsDict',
    'PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs',
    'PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgsDict',
    'PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs',
    'PolicyVMWorkloadProtectionPolicyRetentionYearlyArgsDict',
    'PolicyVMWorkloadProtectionPolicySimpleRetentionArgs',
    'PolicyVMWorkloadProtectionPolicySimpleRetentionArgsDict',
    'PolicyVMWorkloadSettingsArgs',
    'PolicyVMWorkloadSettingsArgsDict',
]

MYPY = False

if not MYPY:
    class PolicyFileShareBackupArgsDict(TypedDict):
        frequency: pulumi.Input[builtins.str]
        """
        Sets the backup frequency. Possible values are `Daily` and `Hourly`. 

        > **Note:** This argument is made available for consistency with VM backup policies and to allow for potential future support of weekly backups
        """
        hourly: NotRequired[pulumi.Input['PolicyFileShareBackupHourlyArgsDict']]
        """
        A `hourly` block defined as below. This is required when `frequency` is set to `Hourly`.
        """
        time: NotRequired[pulumi.Input[builtins.str]]
        """
        The time of day to perform the backup in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.)

        > **Note:** `time` is required when `frequency` is set to `Daily`.
        """
elif False:
    PolicyFileShareBackupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyFileShareBackupArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[builtins.str],
                 hourly: Optional[pulumi.Input['PolicyFileShareBackupHourlyArgs']] = None,
                 time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] frequency: Sets the backup frequency. Possible values are `Daily` and `Hourly`. 
               
               > **Note:** This argument is made available for consistency with VM backup policies and to allow for potential future support of weekly backups
        :param pulumi.Input['PolicyFileShareBackupHourlyArgs'] hourly: A `hourly` block defined as below. This is required when `frequency` is set to `Hourly`.
        :param pulumi.Input[builtins.str] time: The time of day to perform the backup in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.)
               
               > **Note:** `time` is required when `frequency` is set to `Daily`.
        """
        pulumi.set(__self__, "frequency", frequency)
        if hourly is not None:
            pulumi.set(__self__, "hourly", hourly)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[builtins.str]:
        """
        Sets the backup frequency. Possible values are `Daily` and `Hourly`. 

        > **Note:** This argument is made available for consistency with VM backup policies and to allow for potential future support of weekly backups
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def hourly(self) -> Optional[pulumi.Input['PolicyFileShareBackupHourlyArgs']]:
        """
        A `hourly` block defined as below. This is required when `frequency` is set to `Hourly`.
        """
        return pulumi.get(self, "hourly")

    @hourly.setter
    def hourly(self, value: Optional[pulumi.Input['PolicyFileShareBackupHourlyArgs']]):
        pulumi.set(self, "hourly", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time of day to perform the backup in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.)

        > **Note:** `time` is required when `frequency` is set to `Daily`.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time", value)


if not MYPY:
    class PolicyFileShareBackupHourlyArgsDict(TypedDict):
        interval: pulumi.Input[builtins.int]
        """
        Specifies the interval at which backup needs to be triggered. Possible values are `4`, `6`, `8` and `12`.
        """
        start_time: pulumi.Input[builtins.str]
        """
        Specifies the start time of the hourly backup. The time format should be in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.).
        """
        window_duration: pulumi.Input[builtins.int]
        """
        Species the duration of the backup window in hours. Details could be found [here](https://learn.microsoft.com/en-us/azure/backup/backup-azure-files-faq#what-does-the-duration-attribute-in-azure-files-backup-policy-signify-).
        """
elif False:
    PolicyFileShareBackupHourlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyFileShareBackupHourlyArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[builtins.int],
                 start_time: pulumi.Input[builtins.str],
                 window_duration: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] interval: Specifies the interval at which backup needs to be triggered. Possible values are `4`, `6`, `8` and `12`.
        :param pulumi.Input[builtins.str] start_time: Specifies the start time of the hourly backup. The time format should be in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.).
        :param pulumi.Input[builtins.int] window_duration: Species the duration of the backup window in hours. Details could be found [here](https://learn.microsoft.com/en-us/azure/backup/backup-azure-files-faq#what-does-the-duration-attribute-in-azure-files-backup-policy-signify-).
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "window_duration", window_duration)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[builtins.int]:
        """
        Specifies the interval at which backup needs to be triggered. Possible values are `4`, `6`, `8` and `12`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the start time of the hourly backup. The time format should be in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.).
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="windowDuration")
    def window_duration(self) -> pulumi.Input[builtins.int]:
        """
        Species the duration of the backup window in hours. Details could be found [here](https://learn.microsoft.com/en-us/azure/backup/backup-azure-files-faq#what-does-the-duration-attribute-in-azure-files-backup-policy-signify-).
        """
        return pulumi.get(self, "window_duration")

    @window_duration.setter
    def window_duration(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "window_duration", value)


if not MYPY:
    class PolicyFileShareRetentionDailyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
elif False:
    PolicyFileShareRetentionDailyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyFileShareRetentionDailyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] count: The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)


if not MYPY:
    class PolicyFileShareRetentionMonthlyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of monthly backups to keep. Must be between `1` and `120`
        """
        days: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        include_last_days: NotRequired[pulumi.Input[builtins.bool]]
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
elif False:
    PolicyFileShareRetentionMonthlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyFileShareRetentionMonthlyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 include_last_days: Optional[pulumi.Input[builtins.bool]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 weeks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] count: The number of monthly backups to keep. Must be between `1` and `120`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param pulumi.Input[builtins.bool] include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of monthly backups to keep. Must be between `1` and `120`
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @include_last_days.setter
    def include_last_days(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_last_days", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")

    @weeks.setter
    def weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weeks", value)


if not MYPY:
    class PolicyFileShareRetentionWeeklyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        weekdays: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
elif False:
    PolicyFileShareRetentionWeeklyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyFileShareRetentionWeeklyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 weekdays: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.int] count: The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def weekdays(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "weekdays", value)


if not MYPY:
    class PolicyFileShareRetentionYearlyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of yearly backups to keep. Must be between `1` and `10`
        """
        months: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `Augest`, `September`, `October`, `November` and `December`.
        """
        days: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        include_last_days: NotRequired[pulumi.Input[builtins.bool]]
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
elif False:
    PolicyFileShareRetentionYearlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyFileShareRetentionYearlyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 months: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 include_last_days: Optional[pulumi.Input[builtins.bool]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 weeks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] count: The number of yearly backups to keep. Must be between `1` and `10`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] months: The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `Augest`, `September`, `October`, `November` and `December`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param pulumi.Input[builtins.bool] include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "months", months)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of yearly backups to keep. Must be between `1` and `10`
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def months(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `Augest`, `September`, `October`, `November` and `December`.
        """
        return pulumi.get(self, "months")

    @months.setter
    def months(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "months", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @include_last_days.setter
    def include_last_days(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_last_days", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")

    @weeks.setter
    def weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weeks", value)


if not MYPY:
    class PolicyVMBackupArgsDict(TypedDict):
        frequency: pulumi.Input[builtins.str]
        """
        Sets the backup frequency. Possible values are `Hourly`, `Daily` and `Weekly`.
        """
        time: pulumi.Input[builtins.str]
        """
        The time of day to perform the backup in 24hour format.
        """
        hour_duration: NotRequired[pulumi.Input[builtins.int]]
        """
        Duration of the backup window in hours. Possible values are between `4` and `24` This is used when `frequency` is `Hourly`.

        > **Note:** `hour_duration` must be multiplier of `hour_interval`
        """
        hour_interval: NotRequired[pulumi.Input[builtins.int]]
        """
        Interval in hour at which backup is triggered. Possible values are `4`, `6`, `8` and `12`. This is used when `frequency` is `Hourly`.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The days of the week to perform backups on. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
elif False:
    PolicyVMBackupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMBackupArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[builtins.str],
                 time: pulumi.Input[builtins.str],
                 hour_duration: Optional[pulumi.Input[builtins.int]] = None,
                 hour_interval: Optional[pulumi.Input[builtins.int]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] frequency: Sets the backup frequency. Possible values are `Hourly`, `Daily` and `Weekly`.
        :param pulumi.Input[builtins.str] time: The time of day to perform the backup in 24hour format.
        :param pulumi.Input[builtins.int] hour_duration: Duration of the backup window in hours. Possible values are between `4` and `24` This is used when `frequency` is `Hourly`.
               
               > **Note:** `hour_duration` must be multiplier of `hour_interval`
        :param pulumi.Input[builtins.int] hour_interval: Interval in hour at which backup is triggered. Possible values are `4`, `6`, `8` and `12`. This is used when `frequency` is `Hourly`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The days of the week to perform backups on. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "time", time)
        if hour_duration is not None:
            pulumi.set(__self__, "hour_duration", hour_duration)
        if hour_interval is not None:
            pulumi.set(__self__, "hour_interval", hour_interval)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[builtins.str]:
        """
        Sets the backup frequency. Possible values are `Hourly`, `Daily` and `Weekly`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[builtins.str]:
        """
        The time of day to perform the backup in 24hour format.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time", value)

    @property
    @pulumi.getter(name="hourDuration")
    def hour_duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Duration of the backup window in hours. Possible values are between `4` and `24` This is used when `frequency` is `Hourly`.

        > **Note:** `hour_duration` must be multiplier of `hour_interval`
        """
        return pulumi.get(self, "hour_duration")

    @hour_duration.setter
    def hour_duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hour_duration", value)

    @property
    @pulumi.getter(name="hourInterval")
    def hour_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interval in hour at which backup is triggered. Possible values are `4`, `6`, `8` and `12`. This is used when `frequency` is `Hourly`.
        """
        return pulumi.get(self, "hour_interval")

    @hour_interval.setter
    def hour_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "hour_interval", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The days of the week to perform backups on. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)


if not MYPY:
    class PolicyVMInstantRestoreResourceGroupArgsDict(TypedDict):
        prefix: pulumi.Input[builtins.str]
        """
        The prefix for the `instant_restore_resource_group` name.
        """
        suffix: NotRequired[pulumi.Input[builtins.str]]
        """
        The suffix for the `instant_restore_resource_group` name.
        """
elif False:
    PolicyVMInstantRestoreResourceGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMInstantRestoreResourceGroupArgs:
    def __init__(__self__, *,
                 prefix: pulumi.Input[builtins.str],
                 suffix: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] prefix: The prefix for the `instant_restore_resource_group` name.
        :param pulumi.Input[builtins.str] suffix: The suffix for the `instant_restore_resource_group` name.
        """
        pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[builtins.str]:
        """
        The prefix for the `instant_restore_resource_group` name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def suffix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The suffix for the `instant_restore_resource_group` name.
        """
        return pulumi.get(self, "suffix")

    @suffix.setter
    def suffix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "suffix", value)


if not MYPY:
    class PolicyVMRetentionDailyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of daily backups to keep. Must be between `7` and `9999`.

        > **Note:** Azure previously allows this field to be set to a minimum of 1 (day) - but for new resources/to update this value on existing Backup Policies - this value must now be at least 7 (days).
        """
elif False:
    PolicyVMRetentionDailyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMRetentionDailyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] count: The number of daily backups to keep. Must be between `7` and `9999`.
               
               > **Note:** Azure previously allows this field to be set to a minimum of 1 (day) - but for new resources/to update this value on existing Backup Policies - this value must now be at least 7 (days).
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of daily backups to keep. Must be between `7` and `9999`.

        > **Note:** Azure previously allows this field to be set to a minimum of 1 (day) - but for new resources/to update this value on existing Backup Policies - this value must now be at least 7 (days).
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)


if not MYPY:
    class PolicyVMRetentionMonthlyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of monthly backups to keep. Must be between `1` and `9999`
        """
        days: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        include_last_days: NotRequired[pulumi.Input[builtins.bool]]
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
elif False:
    PolicyVMRetentionMonthlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMRetentionMonthlyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 include_last_days: Optional[pulumi.Input[builtins.bool]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 weeks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] count: The number of monthly backups to keep. Must be between `1` and `9999`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param pulumi.Input[builtins.bool] include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of monthly backups to keep. Must be between `1` and `9999`
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @include_last_days.setter
    def include_last_days(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_last_days", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")

    @weeks.setter
    def weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weeks", value)


if not MYPY:
    class PolicyVMRetentionWeeklyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of weekly backups to keep. Must be between `1` and `9999`
        """
        weekdays: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
elif False:
    PolicyVMRetentionWeeklyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMRetentionWeeklyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 weekdays: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.int] count: The number of weekly backups to keep. Must be between `1` and `9999`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of weekly backups to keep. Must be between `1` and `9999`
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def weekdays(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "weekdays", value)


if not MYPY:
    class PolicyVMRetentionYearlyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of yearly backups to keep. Must be between `1` and `9999`
        """
        months: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        """
        days: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        include_last_days: NotRequired[pulumi.Input[builtins.bool]]
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
elif False:
    PolicyVMRetentionYearlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMRetentionYearlyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 months: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 days: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 include_last_days: Optional[pulumi.Input[builtins.bool]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 weeks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] count: The number of yearly backups to keep. Must be between `1` and `9999`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] months: The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param pulumi.Input[builtins.bool] include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "months", months)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of yearly backups to keep. Must be between `1` and `9999`
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def months(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        """
        return pulumi.get(self, "months")

    @months.setter
    def months(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "months", value)

    @property
    @pulumi.getter
    def days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @days.setter
    def days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "days", value)

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @include_last_days.setter
    def include_last_days(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_last_days", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")

    @weeks.setter
    def weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weeks", value)


if not MYPY:
    class PolicyVMTieringPolicyArgsDict(TypedDict):
        archived_restore_point: pulumi.Input['PolicyVMTieringPolicyArchivedRestorePointArgsDict']
        """
        An `archived_restore_point` block as defined below.
        """
elif False:
    PolicyVMTieringPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMTieringPolicyArgs:
    def __init__(__self__, *,
                 archived_restore_point: pulumi.Input['PolicyVMTieringPolicyArchivedRestorePointArgs']):
        """
        :param pulumi.Input['PolicyVMTieringPolicyArchivedRestorePointArgs'] archived_restore_point: An `archived_restore_point` block as defined below.
        """
        pulumi.set(__self__, "archived_restore_point", archived_restore_point)

    @property
    @pulumi.getter(name="archivedRestorePoint")
    def archived_restore_point(self) -> pulumi.Input['PolicyVMTieringPolicyArchivedRestorePointArgs']:
        """
        An `archived_restore_point` block as defined below.
        """
        return pulumi.get(self, "archived_restore_point")

    @archived_restore_point.setter
    def archived_restore_point(self, value: pulumi.Input['PolicyVMTieringPolicyArchivedRestorePointArgs']):
        pulumi.set(self, "archived_restore_point", value)


if not MYPY:
    class PolicyVMTieringPolicyArchivedRestorePointArgsDict(TypedDict):
        mode: pulumi.Input[builtins.str]
        """
        The tiering mode to control automatic tiering of recovery points. Possible values are `TierAfter` and `TierRecommended`.
        """
        duration: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days/weeks/months/years to retain backups in current tier before tiering.
        """
        duration_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The retention duration type. Possible values are `Days`, `Weeks`, `Months` and `Years`.
        """
elif False:
    PolicyVMTieringPolicyArchivedRestorePointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMTieringPolicyArchivedRestorePointArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[builtins.str],
                 duration: Optional[pulumi.Input[builtins.int]] = None,
                 duration_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mode: The tiering mode to control automatic tiering of recovery points. Possible values are `TierAfter` and `TierRecommended`.
        :param pulumi.Input[builtins.int] duration: The number of days/weeks/months/years to retain backups in current tier before tiering.
        :param pulumi.Input[builtins.str] duration_type: The retention duration type. Possible values are `Days`, `Weeks`, `Months` and `Years`.
        """
        pulumi.set(__self__, "mode", mode)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        The tiering mode to control automatic tiering of recovery points. Possible values are `TierAfter` and `TierRecommended`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days/weeks/months/years to retain backups in current tier before tiering.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The retention duration type. Possible values are `Days`, `Weeks`, `Months` and `Years`.
        """
        return pulumi.get(self, "duration_type")

    @duration_type.setter
    def duration_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "duration_type", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicyArgsDict(TypedDict):
        backup: pulumi.Input['PolicyVMWorkloadProtectionPolicyBackupArgsDict']
        """
        A `backup` block as defined below.
        """
        policy_type: pulumi.Input[builtins.str]
        """
        The type of the VM Workload Backup Policy. Possible values are `Differential`, `Full`, `Incremental` and `Log`.
        """
        retention_daily: NotRequired[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionDailyArgsDict']]
        """
        A `retention_daily` block as defined below.
        """
        retention_monthly: NotRequired[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgsDict']]
        """
        A `retention_monthly` block as defined below.
        """
        retention_weekly: NotRequired[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgsDict']]
        """
        A `retention_weekly` block as defined below.
        """
        retention_yearly: NotRequired[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionYearlyArgsDict']]
        """
        A `retention_yearly` block as defined below.
        """
        simple_retention: NotRequired[pulumi.Input['PolicyVMWorkloadProtectionPolicySimpleRetentionArgsDict']]
        """
        A `simple_retention` block as defined below.
        """
elif False:
    PolicyVMWorkloadProtectionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicyArgs:
    def __init__(__self__, *,
                 backup: pulumi.Input['PolicyVMWorkloadProtectionPolicyBackupArgs'],
                 policy_type: pulumi.Input[builtins.str],
                 retention_daily: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionDailyArgs']] = None,
                 retention_monthly: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs']] = None,
                 retention_weekly: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs']] = None,
                 retention_yearly: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs']] = None,
                 simple_retention: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicySimpleRetentionArgs']] = None):
        """
        :param pulumi.Input['PolicyVMWorkloadProtectionPolicyBackupArgs'] backup: A `backup` block as defined below.
        :param pulumi.Input[builtins.str] policy_type: The type of the VM Workload Backup Policy. Possible values are `Differential`, `Full`, `Incremental` and `Log`.
        :param pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionDailyArgs'] retention_daily: A `retention_daily` block as defined below.
        :param pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs'] retention_monthly: A `retention_monthly` block as defined below.
        :param pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs'] retention_weekly: A `retention_weekly` block as defined below.
        :param pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs'] retention_yearly: A `retention_yearly` block as defined below.
        :param pulumi.Input['PolicyVMWorkloadProtectionPolicySimpleRetentionArgs'] simple_retention: A `simple_retention` block as defined below.
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "policy_type", policy_type)
        if retention_daily is not None:
            pulumi.set(__self__, "retention_daily", retention_daily)
        if retention_monthly is not None:
            pulumi.set(__self__, "retention_monthly", retention_monthly)
        if retention_weekly is not None:
            pulumi.set(__self__, "retention_weekly", retention_weekly)
        if retention_yearly is not None:
            pulumi.set(__self__, "retention_yearly", retention_yearly)
        if simple_retention is not None:
            pulumi.set(__self__, "simple_retention", simple_retention)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Input['PolicyVMWorkloadProtectionPolicyBackupArgs']:
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: pulumi.Input['PolicyVMWorkloadProtectionPolicyBackupArgs']):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the VM Workload Backup Policy. Possible values are `Differential`, `Full`, `Incremental` and `Log`.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionDailyArgs']]:
        """
        A `retention_daily` block as defined below.
        """
        return pulumi.get(self, "retention_daily")

    @retention_daily.setter
    def retention_daily(self, value: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionDailyArgs']]):
        pulumi.set(self, "retention_daily", value)

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs']]:
        """
        A `retention_monthly` block as defined below.
        """
        return pulumi.get(self, "retention_monthly")

    @retention_monthly.setter
    def retention_monthly(self, value: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs']]):
        pulumi.set(self, "retention_monthly", value)

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs']]:
        """
        A `retention_weekly` block as defined below.
        """
        return pulumi.get(self, "retention_weekly")

    @retention_weekly.setter
    def retention_weekly(self, value: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs']]):
        pulumi.set(self, "retention_weekly", value)

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs']]:
        """
        A `retention_yearly` block as defined below.
        """
        return pulumi.get(self, "retention_yearly")

    @retention_yearly.setter
    def retention_yearly(self, value: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs']]):
        pulumi.set(self, "retention_yearly", value)

    @property
    @pulumi.getter(name="simpleRetention")
    def simple_retention(self) -> Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicySimpleRetentionArgs']]:
        """
        A `simple_retention` block as defined below.
        """
        return pulumi.get(self, "simple_retention")

    @simple_retention.setter
    def simple_retention(self, value: Optional[pulumi.Input['PolicyVMWorkloadProtectionPolicySimpleRetentionArgs']]):
        pulumi.set(self, "simple_retention", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicyBackupArgsDict(TypedDict):
        frequency: NotRequired[pulumi.Input[builtins.str]]
        """
        The backup frequency for the VM Workload Backup Policy. Possible values are `Daily` and `Weekly`.
        """
        frequency_in_minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        The backup frequency in minutes for the VM Workload Backup Policy. Possible values are `15`, `30`, `60`, `120`, `240`, `480`, `720` and `1440`.
        """
        time: NotRequired[pulumi.Input[builtins.str]]
        """
        The time of day to perform the backup in 24hour format.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The days of the week to perform backups on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
elif False:
    PolicyVMWorkloadProtectionPolicyBackupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicyBackupArgs:
    def __init__(__self__, *,
                 frequency: Optional[pulumi.Input[builtins.str]] = None,
                 frequency_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 time: Optional[pulumi.Input[builtins.str]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] frequency: The backup frequency for the VM Workload Backup Policy. Possible values are `Daily` and `Weekly`.
        :param pulumi.Input[builtins.int] frequency_in_minutes: The backup frequency in minutes for the VM Workload Backup Policy. Possible values are `15`, `30`, `60`, `120`, `240`, `480`, `720` and `1440`.
        :param pulumi.Input[builtins.str] time: The time of day to perform the backup in 24hour format.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The days of the week to perform backups on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if frequency_in_minutes is not None:
            pulumi.set(__self__, "frequency_in_minutes", frequency_in_minutes)
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The backup frequency for the VM Workload Backup Policy. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="frequencyInMinutes")
    def frequency_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The backup frequency in minutes for the VM Workload Backup Policy. Possible values are `15`, `30`, `60`, `120`, `240`, `480`, `720` and `1440`.
        """
        return pulumi.get(self, "frequency_in_minutes")

    @frequency_in_minutes.setter
    def frequency_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frequency_in_minutes", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time of day to perform the backup in 24hour format.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The days of the week to perform backups on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicyRetentionDailyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of daily backups to keep. Possible values are between `7` and `9999`.
        """
elif False:
    PolicyVMWorkloadProtectionPolicyRetentionDailyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicyRetentionDailyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] count: The number of daily backups to keep. Possible values are between `7` and `9999`.
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of daily backups to keep. Possible values are between `7` and `9999`.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of monthly backups to keep. Must be between `1` and `1188`.
        """
        format_type: pulumi.Input[builtins.str]
        """
        The retention schedule format type for monthly retention policy. Possible values are `Daily` and `Weekly`.
        """
        monthdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        The monthday backups to retain. Possible values are between `0` and `28`.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`.
        """
elif False:
    PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 format_type: pulumi.Input[builtins.str],
                 monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 weeks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] count: The number of monthly backups to keep. Must be between `1` and `1188`.
        :param pulumi.Input[builtins.str] format_type: The retention schedule format type for monthly retention policy. Possible values are `Daily` and `Weekly`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] monthdays: The monthday backups to retain. Possible values are between `0` and `28`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weeks: The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "format_type", format_type)
        if monthdays is not None:
            pulumi.set(__self__, "monthdays", monthdays)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of monthly backups to keep. Must be between `1` and `1188`.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Input[builtins.str]:
        """
        The retention schedule format type for monthly retention policy. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "format_type", value)

    @property
    @pulumi.getter
    def monthdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        The monthday backups to retain. Possible values are between `0` and `28`.
        """
        return pulumi.get(self, "monthdays")

    @monthdays.setter
    def monthdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "monthdays", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`.
        """
        return pulumi.get(self, "weeks")

    @weeks.setter
    def weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weeks", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of weekly backups to keep. Possible values are between `1` and `5163`.
        """
        weekdays: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
elif False:
    PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 weekdays: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.int] count: The number of weekly backups to keep. Possible values are between `1` and `5163`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of weekly backups to keep. Possible values are between `1` and `5163`.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter
    def weekdays(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "weekdays", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicyRetentionYearlyArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The number of yearly backups to keep. Possible values are between `1` and `99`
        """
        format_type: pulumi.Input[builtins.str]
        """
        The retention schedule format type for yearly retention policy. Possible values are `Daily` and `Weekly`.
        """
        months: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The months of the year to retain backups of. Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        """
        monthdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        The monthday backups to retain. Possible values are between `0` and `28`.
        """
        weekdays: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        weeks: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
elif False:
    PolicyVMWorkloadProtectionPolicyRetentionYearlyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int],
                 format_type: pulumi.Input[builtins.str],
                 months: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 monthdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 weekdays: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 weeks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.int] count: The number of yearly backups to keep. Possible values are between `1` and `99`
        :param pulumi.Input[builtins.str] format_type: The retention schedule format type for yearly retention policy. Possible values are `Daily` and `Weekly`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] months: The months of the year to retain backups of. Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] monthdays: The monthday backups to retain. Possible values are between `0` and `28`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weekdays: The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] weeks: The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "format_type", format_type)
        pulumi.set(__self__, "months", months)
        if monthdays is not None:
            pulumi.set(__self__, "monthdays", monthdays)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The number of yearly backups to keep. Possible values are between `1` and `99`
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> pulumi.Input[builtins.str]:
        """
        The retention schedule format type for yearly retention policy. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "format_type")

    @format_type.setter
    def format_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "format_type", value)

    @property
    @pulumi.getter
    def months(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The months of the year to retain backups of. Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        """
        return pulumi.get(self, "months")

    @months.setter
    def months(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "months", value)

    @property
    @pulumi.getter
    def monthdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        The monthday backups to retain. Possible values are between `0` and `28`.
        """
        return pulumi.get(self, "monthdays")

    @monthdays.setter
    def monthdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "monthdays", value)

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @weekdays.setter
    def weekdays(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weekdays", value)

    @property
    @pulumi.getter
    def weeks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")

    @weeks.setter
    def weeks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "weeks", value)


if not MYPY:
    class PolicyVMWorkloadProtectionPolicySimpleRetentionArgsDict(TypedDict):
        count: pulumi.Input[builtins.int]
        """
        The count that is used to count retention duration with duration type `Days`. Possible values are between `7` and `35`.
        """
elif False:
    PolicyVMWorkloadProtectionPolicySimpleRetentionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadProtectionPolicySimpleRetentionArgs:
    def __init__(__self__, *,
                 count: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] count: The count that is used to count retention duration with duration type `Days`. Possible values are between `7` and `35`.
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> pulumi.Input[builtins.int]:
        """
        The count that is used to count retention duration with duration type `Days`. Possible values are between `7` and `35`.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "count", value)


if not MYPY:
    class PolicyVMWorkloadSettingsArgsDict(TypedDict):
        time_zone: pulumi.Input[builtins.str]
        """
        The timezone for the VM Workload Backup Policy. [The possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        compression_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        The compression setting for the VM Workload Backup Policy. Defaults to `false`.
        """
elif False:
    PolicyVMWorkloadSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyVMWorkloadSettingsArgs:
    def __init__(__self__, *,
                 time_zone: pulumi.Input[builtins.str],
                 compression_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] time_zone: The timezone for the VM Workload Backup Policy. [The possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param pulumi.Input[builtins.bool] compression_enabled: The compression setting for the VM Workload Backup Policy. Defaults to `false`.
        """
        pulumi.set(__self__, "time_zone", time_zone)
        if compression_enabled is not None:
            pulumi.set(__self__, "compression_enabled", compression_enabled)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Input[builtins.str]:
        """
        The timezone for the VM Workload Backup Policy. [The possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="compressionEnabled")
    def compression_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The compression setting for the VM Workload Backup Policy. Defaults to `false`.
        """
        return pulumi.get(self, "compression_enabled")

    @compression_enabled.setter
    def compression_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compression_enabled", value)


