# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ContainerStorageAccountArgs', 'ContainerStorageAccount']

@pulumi.input_type
class ContainerStorageAccountArgs:
    def __init__(__self__, *,
                 recovery_vault_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 storage_account_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ContainerStorageAccount resource.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account to be registered Changing this forces a new resource to be created.
               
               > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Storage Account to be registered Changing this forces a new resource to be created.

        > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.input_type
class _ContainerStorageAccountState:
    def __init__(__self__, *,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ContainerStorageAccount resources.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account to be registered Changing this forces a new resource to be created.
               
               > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Storage Account to be registered Changing this forces a new resource to be created.

        > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_id", value)


@pulumi.type_token("azure:backup/containerStorageAccount:ContainerStorageAccount")
class ContainerStorageAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages registration of a storage account with Azure Backup. Storage accounts must be registered with an Azure Recovery Vault in order to backup file shares within the storage account. Registering a storage account with a vault creates what is known as a protection container within Azure Recovery Services. Once the container is created, Azure file shares within the storage account can be backed up using the `backup.ProtectedFileShare` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-network-mapping-primary",
            location="West Europe")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        sa = azure.storage.Account("sa",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        container = azure.backup.ContainerStorageAccount("container",
            resource_group_name=example.name,
            recovery_vault_name=vault.name,
            storage_account_id=sa.id)
        ```

        ## Import

        Backup Storage Account Containers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/containerStorageAccount:ContainerStorageAccount mycontainer "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/backupFabrics/Azure/protectionContainers/StorageContainer;storage;storage-rg-name;storage-account"
        ```

        Note the ID requires quoting as there are semicolons

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account to be registered Changing this forces a new resource to be created.
               
               > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContainerStorageAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages registration of a storage account with Azure Backup. Storage accounts must be registered with an Azure Recovery Vault in order to backup file shares within the storage account. Registering a storage account with a vault creates what is known as a protection container within Azure Recovery Services. Once the container is created, Azure file shares within the storage account can be backed up using the `backup.ProtectedFileShare` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-network-mapping-primary",
            location="West Europe")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        sa = azure.storage.Account("sa",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        container = azure.backup.ContainerStorageAccount("container",
            resource_group_name=example.name,
            recovery_vault_name=vault.name,
            storage_account_id=sa.id)
        ```

        ## Import

        Backup Storage Account Containers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/containerStorageAccount:ContainerStorageAccount mycontainer "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/backupFabrics/Azure/protectionContainers/StorageContainer;storage;storage-rg-name;storage-account"
        ```

        Note the ID requires quoting as there are semicolons

        :param str resource_name: The name of the resource.
        :param ContainerStorageAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerStorageAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerStorageAccountArgs.__new__(ContainerStorageAccountArgs)

            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
        super(ContainerStorageAccount, __self__).__init__(
            'azure:backup/containerStorageAccount:ContainerStorageAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ContainerStorageAccount':
        """
        Get an existing ContainerStorageAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] storage_account_id: The ID of the Storage Account to be registered Changing this forces a new resource to be created.
               
               > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerStorageAccountState.__new__(_ContainerStorageAccountState)

        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_account_id"] = storage_account_id
        return ContainerStorageAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the vault where the storage account will be registered. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource group where the vault is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Storage Account to be registered Changing this forces a new resource to be created.

        > **Note:** Azure Backup places a Resource Lock on the storage account that will cause deletion to fail until the account is unregistered from Azure Backup
        """
        return pulumi.get(self, "storage_account_id")

