# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'PolicyFileShareBackup',
    'PolicyFileShareBackupHourly',
    'PolicyFileShareRetentionDaily',
    'PolicyFileShareRetentionMonthly',
    'PolicyFileShareRetentionWeekly',
    'PolicyFileShareRetentionYearly',
    'PolicyVMBackup',
    'PolicyVMInstantRestoreResourceGroup',
    'PolicyVMRetentionDaily',
    'PolicyVMRetentionMonthly',
    'PolicyVMRetentionWeekly',
    'PolicyVMRetentionYearly',
    'PolicyVMTieringPolicy',
    'PolicyVMTieringPolicyArchivedRestorePoint',
    'PolicyVMWorkloadProtectionPolicy',
    'PolicyVMWorkloadProtectionPolicyBackup',
    'PolicyVMWorkloadProtectionPolicyRetentionDaily',
    'PolicyVMWorkloadProtectionPolicyRetentionMonthly',
    'PolicyVMWorkloadProtectionPolicyRetentionWeekly',
    'PolicyVMWorkloadProtectionPolicyRetentionYearly',
    'PolicyVMWorkloadProtectionPolicySimpleRetention',
    'PolicyVMWorkloadSettings',
]

@pulumi.output_type
class PolicyFileShareBackup(dict):
    def __init__(__self__, *,
                 frequency: builtins.str,
                 hourly: Optional['outputs.PolicyFileShareBackupHourly'] = None,
                 time: Optional[builtins.str] = None):
        """
        :param builtins.str frequency: Sets the backup frequency. Possible values are `Daily` and `Hourly`. 
               
               > **Note:** This argument is made available for consistency with VM backup policies and to allow for potential future support of weekly backups
        :param 'PolicyFileShareBackupHourlyArgs' hourly: A `hourly` block defined as below. This is required when `frequency` is set to `Hourly`.
        :param builtins.str time: The time of day to perform the backup in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.)
               
               > **Note:** `time` is required when `frequency` is set to `Daily`.
        """
        pulumi.set(__self__, "frequency", frequency)
        if hourly is not None:
            pulumi.set(__self__, "hourly", hourly)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def frequency(self) -> builtins.str:
        """
        Sets the backup frequency. Possible values are `Daily` and `Hourly`. 

        > **Note:** This argument is made available for consistency with VM backup policies and to allow for potential future support of weekly backups
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def hourly(self) -> Optional['outputs.PolicyFileShareBackupHourly']:
        """
        A `hourly` block defined as below. This is required when `frequency` is set to `Hourly`.
        """
        return pulumi.get(self, "hourly")

    @property
    @pulumi.getter
    def time(self) -> Optional[builtins.str]:
        """
        The time of day to perform the backup in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.)

        > **Note:** `time` is required when `frequency` is set to `Daily`.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class PolicyFileShareBackupHourly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "windowDuration":
            suggest = "window_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyFileShareBackupHourly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyFileShareBackupHourly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyFileShareBackupHourly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 interval: builtins.int,
                 start_time: builtins.str,
                 window_duration: builtins.int):
        """
        :param builtins.int interval: Specifies the interval at which backup needs to be triggered. Possible values are `4`, `6`, `8` and `12`.
        :param builtins.str start_time: Specifies the start time of the hourly backup. The time format should be in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.).
        :param builtins.int window_duration: Species the duration of the backup window in hours. Details could be found [here](https://learn.microsoft.com/en-us/azure/backup/backup-azure-files-faq#what-does-the-duration-attribute-in-azure-files-backup-policy-signify-).
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "window_duration", window_duration)

    @property
    @pulumi.getter
    def interval(self) -> builtins.int:
        """
        Specifies the interval at which backup needs to be triggered. Possible values are `4`, `6`, `8` and `12`.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> builtins.str:
        """
        Specifies the start time of the hourly backup. The time format should be in 24-hour format. Times must be either on the hour or half hour (e.g. 12:00, 12:30, 13:00, etc.).
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="windowDuration")
    def window_duration(self) -> builtins.int:
        """
        Species the duration of the backup window in hours. Details could be found [here](https://learn.microsoft.com/en-us/azure/backup/backup-azure-files-faq#what-does-the-duration-attribute-in-azure-files-backup-policy-signify-).
        """
        return pulumi.get(self, "window_duration")


@pulumi.output_type
class PolicyFileShareRetentionDaily(dict):
    def __init__(__self__, *,
                 count: builtins.int):
        """
        :param builtins.int count: The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class PolicyFileShareRetentionMonthly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeLastDays":
            suggest = "include_last_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyFileShareRetentionMonthly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyFileShareRetentionMonthly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyFileShareRetentionMonthly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: builtins.int,
                 days: Optional[Sequence[builtins.int]] = None,
                 include_last_days: Optional[builtins.bool] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int count: The number of monthly backups to keep. Must be between `1` and `120`
        :param Sequence[builtins.int] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param builtins.bool include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param Sequence[builtins.str] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of monthly backups to keep. Must be between `1` and `120`
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def days(self) -> Optional[Sequence[builtins.int]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[builtins.bool]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")


@pulumi.output_type
class PolicyFileShareRetentionWeekly(dict):
    def __init__(__self__, *,
                 count: builtins.int,
                 weekdays: Sequence[builtins.str]):
        """
        :param builtins.int count: The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        :param Sequence[builtins.str] weekdays: The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of daily backups to keep. Must be between `1` and `200` (inclusive)
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def weekdays(self) -> Sequence[builtins.str]:
        """
        The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class PolicyFileShareRetentionYearly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeLastDays":
            suggest = "include_last_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyFileShareRetentionYearly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyFileShareRetentionYearly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyFileShareRetentionYearly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: builtins.int,
                 months: Sequence[builtins.str],
                 days: Optional[Sequence[builtins.int]] = None,
                 include_last_days: Optional[builtins.bool] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int count: The number of yearly backups to keep. Must be between `1` and `10`
        :param Sequence[builtins.str] months: The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `Augest`, `September`, `October`, `November` and `December`.
        :param Sequence[builtins.int] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param builtins.bool include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param Sequence[builtins.str] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "months", months)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of yearly backups to keep. Must be between `1` and `10`
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def months(self) -> Sequence[builtins.str]:
        """
        The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `Augest`, `September`, `October`, `November` and `December`.
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter
    def days(self) -> Optional[Sequence[builtins.int]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[builtins.bool]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")


@pulumi.output_type
class PolicyVMBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hourDuration":
            suggest = "hour_duration"
        elif key == "hourInterval":
            suggest = "hour_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: builtins.str,
                 time: builtins.str,
                 hour_duration: Optional[builtins.int] = None,
                 hour_interval: Optional[builtins.int] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str frequency: Sets the backup frequency. Possible values are `Hourly`, `Daily` and `Weekly`.
        :param builtins.str time: The time of day to perform the backup in 24hour format.
        :param builtins.int hour_duration: Duration of the backup window in hours. Possible values are between `4` and `24` This is used when `frequency` is `Hourly`.
               
               > **Note:** `hour_duration` must be multiplier of `hour_interval`
        :param builtins.int hour_interval: Interval in hour at which backup is triggered. Possible values are `4`, `6`, `8` and `12`. This is used when `frequency` is `Hourly`.
        :param Sequence[builtins.str] weekdays: The days of the week to perform backups on. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "time", time)
        if hour_duration is not None:
            pulumi.set(__self__, "hour_duration", hour_duration)
        if hour_interval is not None:
            pulumi.set(__self__, "hour_interval", hour_interval)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def frequency(self) -> builtins.str:
        """
        Sets the backup frequency. Possible values are `Hourly`, `Daily` and `Weekly`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def time(self) -> builtins.str:
        """
        The time of day to perform the backup in 24hour format.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter(name="hourDuration")
    def hour_duration(self) -> Optional[builtins.int]:
        """
        Duration of the backup window in hours. Possible values are between `4` and `24` This is used when `frequency` is `Hourly`.

        > **Note:** `hour_duration` must be multiplier of `hour_interval`
        """
        return pulumi.get(self, "hour_duration")

    @property
    @pulumi.getter(name="hourInterval")
    def hour_interval(self) -> Optional[builtins.int]:
        """
        Interval in hour at which backup is triggered. Possible values are `4`, `6`, `8` and `12`. This is used when `frequency` is `Hourly`.
        """
        return pulumi.get(self, "hour_interval")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The days of the week to perform backups on. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class PolicyVMInstantRestoreResourceGroup(dict):
    def __init__(__self__, *,
                 prefix: builtins.str,
                 suffix: Optional[builtins.str] = None):
        """
        :param builtins.str prefix: The prefix for the `instant_restore_resource_group` name.
        :param builtins.str suffix: The suffix for the `instant_restore_resource_group` name.
        """
        pulumi.set(__self__, "prefix", prefix)
        if suffix is not None:
            pulumi.set(__self__, "suffix", suffix)

    @property
    @pulumi.getter
    def prefix(self) -> builtins.str:
        """
        The prefix for the `instant_restore_resource_group` name.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def suffix(self) -> Optional[builtins.str]:
        """
        The suffix for the `instant_restore_resource_group` name.
        """
        return pulumi.get(self, "suffix")


@pulumi.output_type
class PolicyVMRetentionDaily(dict):
    def __init__(__self__, *,
                 count: builtins.int):
        """
        :param builtins.int count: The number of daily backups to keep. Must be between `7` and `9999`.
               
               > **Note:** Azure previously allows this field to be set to a minimum of 1 (day) - but for new resources/to update this value on existing Backup Policies - this value must now be at least 7 (days).
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of daily backups to keep. Must be between `7` and `9999`.

        > **Note:** Azure previously allows this field to be set to a minimum of 1 (day) - but for new resources/to update this value on existing Backup Policies - this value must now be at least 7 (days).
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class PolicyVMRetentionMonthly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeLastDays":
            suggest = "include_last_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMRetentionMonthly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMRetentionMonthly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMRetentionMonthly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: builtins.int,
                 days: Optional[Sequence[builtins.int]] = None,
                 include_last_days: Optional[builtins.bool] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int count: The number of monthly backups to keep. Must be between `1` and `9999`
        :param Sequence[builtins.int] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param builtins.bool include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param Sequence[builtins.str] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of monthly backups to keep. Must be between `1` and `9999`
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def days(self) -> Optional[Sequence[builtins.int]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[builtins.bool]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")


@pulumi.output_type
class PolicyVMRetentionWeekly(dict):
    def __init__(__self__, *,
                 count: builtins.int,
                 weekdays: Sequence[builtins.str]):
        """
        :param builtins.int count: The number of weekly backups to keep. Must be between `1` and `9999`
        :param Sequence[builtins.str] weekdays: The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of weekly backups to keep. Must be between `1` and `9999`
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def weekdays(self) -> Sequence[builtins.str]:
        """
        The weekday backups to retain. Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class PolicyVMRetentionYearly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeLastDays":
            suggest = "include_last_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMRetentionYearly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMRetentionYearly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMRetentionYearly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: builtins.int,
                 months: Sequence[builtins.str],
                 days: Optional[Sequence[builtins.int]] = None,
                 include_last_days: Optional[builtins.bool] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int count: The number of yearly backups to keep. Must be between `1` and `9999`
        :param Sequence[builtins.str] months: The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        :param Sequence[builtins.int] days: The days of the month to retain backups of. Must be between `1` and `31`.
        :param builtins.bool include_last_days: Including the last day of the month, default to `false`.
               
               > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param Sequence[builtins.str] weeks: The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "months", months)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if include_last_days is not None:
            pulumi.set(__self__, "include_last_days", include_last_days)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of yearly backups to keep. Must be between `1` and `9999`
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def months(self) -> Sequence[builtins.str]:
        """
        The months of the year to retain backups of. Must be one of `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter
    def days(self) -> Optional[Sequence[builtins.int]]:
        """
        The days of the month to retain backups of. Must be between `1` and `31`.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="includeLastDays")
    def include_last_days(self) -> Optional[builtins.bool]:
        """
        Including the last day of the month, default to `false`.

        > **Note:** Either `weekdays` and `weeks` or `days` and `include_last_days` must be specified.
        """
        return pulumi.get(self, "include_last_days")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The weekday backups to retain . Must be one of `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        The weeks of the month to retain backups of. Must be one of `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")


@pulumi.output_type
class PolicyVMTieringPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archivedRestorePoint":
            suggest = "archived_restore_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMTieringPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMTieringPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMTieringPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archived_restore_point: 'outputs.PolicyVMTieringPolicyArchivedRestorePoint'):
        """
        :param 'PolicyVMTieringPolicyArchivedRestorePointArgs' archived_restore_point: An `archived_restore_point` block as defined below.
        """
        pulumi.set(__self__, "archived_restore_point", archived_restore_point)

    @property
    @pulumi.getter(name="archivedRestorePoint")
    def archived_restore_point(self) -> 'outputs.PolicyVMTieringPolicyArchivedRestorePoint':
        """
        An `archived_restore_point` block as defined below.
        """
        return pulumi.get(self, "archived_restore_point")


@pulumi.output_type
class PolicyVMTieringPolicyArchivedRestorePoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationType":
            suggest = "duration_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMTieringPolicyArchivedRestorePoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMTieringPolicyArchivedRestorePoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMTieringPolicyArchivedRestorePoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: builtins.str,
                 duration: Optional[builtins.int] = None,
                 duration_type: Optional[builtins.str] = None):
        """
        :param builtins.str mode: The tiering mode to control automatic tiering of recovery points. Possible values are `TierAfter` and `TierRecommended`.
        :param builtins.int duration: The number of days/weeks/months/years to retain backups in current tier before tiering.
        :param builtins.str duration_type: The retention duration type. Possible values are `Days`, `Weeks`, `Months` and `Years`.
        """
        pulumi.set(__self__, "mode", mode)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if duration_type is not None:
            pulumi.set(__self__, "duration_type", duration_type)

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        The tiering mode to control automatic tiering of recovery points. Possible values are `TierAfter` and `TierRecommended`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.int]:
        """
        The number of days/weeks/months/years to retain backups in current tier before tiering.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="durationType")
    def duration_type(self) -> Optional[builtins.str]:
        """
        The retention duration type. Possible values are `Days`, `Weeks`, `Months` and `Years`.
        """
        return pulumi.get(self, "duration_type")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyType":
            suggest = "policy_type"
        elif key == "retentionDaily":
            suggest = "retention_daily"
        elif key == "retentionMonthly":
            suggest = "retention_monthly"
        elif key == "retentionWeekly":
            suggest = "retention_weekly"
        elif key == "retentionYearly":
            suggest = "retention_yearly"
        elif key == "simpleRetention":
            suggest = "simple_retention"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMWorkloadProtectionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMWorkloadProtectionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMWorkloadProtectionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup: 'outputs.PolicyVMWorkloadProtectionPolicyBackup',
                 policy_type: builtins.str,
                 retention_daily: Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionDaily'] = None,
                 retention_monthly: Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionMonthly'] = None,
                 retention_weekly: Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionWeekly'] = None,
                 retention_yearly: Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionYearly'] = None,
                 simple_retention: Optional['outputs.PolicyVMWorkloadProtectionPolicySimpleRetention'] = None):
        """
        :param 'PolicyVMWorkloadProtectionPolicyBackupArgs' backup: A `backup` block as defined below.
        :param builtins.str policy_type: The type of the VM Workload Backup Policy. Possible values are `Differential`, `Full`, `Incremental` and `Log`.
        :param 'PolicyVMWorkloadProtectionPolicyRetentionDailyArgs' retention_daily: A `retention_daily` block as defined below.
        :param 'PolicyVMWorkloadProtectionPolicyRetentionMonthlyArgs' retention_monthly: A `retention_monthly` block as defined below.
        :param 'PolicyVMWorkloadProtectionPolicyRetentionWeeklyArgs' retention_weekly: A `retention_weekly` block as defined below.
        :param 'PolicyVMWorkloadProtectionPolicyRetentionYearlyArgs' retention_yearly: A `retention_yearly` block as defined below.
        :param 'PolicyVMWorkloadProtectionPolicySimpleRetentionArgs' simple_retention: A `simple_retention` block as defined below.
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "policy_type", policy_type)
        if retention_daily is not None:
            pulumi.set(__self__, "retention_daily", retention_daily)
        if retention_monthly is not None:
            pulumi.set(__self__, "retention_monthly", retention_monthly)
        if retention_weekly is not None:
            pulumi.set(__self__, "retention_weekly", retention_weekly)
        if retention_yearly is not None:
            pulumi.set(__self__, "retention_yearly", retention_yearly)
        if simple_retention is not None:
            pulumi.set(__self__, "simple_retention", simple_retention)

    @property
    @pulumi.getter
    def backup(self) -> 'outputs.PolicyVMWorkloadProtectionPolicyBackup':
        """
        A `backup` block as defined below.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> builtins.str:
        """
        The type of the VM Workload Backup Policy. Possible values are `Differential`, `Full`, `Incremental` and `Log`.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionDaily']:
        """
        A `retention_daily` block as defined below.
        """
        return pulumi.get(self, "retention_daily")

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionMonthly']:
        """
        A `retention_monthly` block as defined below.
        """
        return pulumi.get(self, "retention_monthly")

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionWeekly']:
        """
        A `retention_weekly` block as defined below.
        """
        return pulumi.get(self, "retention_weekly")

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> Optional['outputs.PolicyVMWorkloadProtectionPolicyRetentionYearly']:
        """
        A `retention_yearly` block as defined below.
        """
        return pulumi.get(self, "retention_yearly")

    @property
    @pulumi.getter(name="simpleRetention")
    def simple_retention(self) -> Optional['outputs.PolicyVMWorkloadProtectionPolicySimpleRetention']:
        """
        A `simple_retention` block as defined below.
        """
        return pulumi.get(self, "simple_retention")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicyBackup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "frequencyInMinutes":
            suggest = "frequency_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMWorkloadProtectionPolicyBackup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMWorkloadProtectionPolicyBackup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMWorkloadProtectionPolicyBackup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: Optional[builtins.str] = None,
                 frequency_in_minutes: Optional[builtins.int] = None,
                 time: Optional[builtins.str] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str frequency: The backup frequency for the VM Workload Backup Policy. Possible values are `Daily` and `Weekly`.
        :param builtins.int frequency_in_minutes: The backup frequency in minutes for the VM Workload Backup Policy. Possible values are `15`, `30`, `60`, `120`, `240`, `480`, `720` and `1440`.
        :param builtins.str time: The time of day to perform the backup in 24hour format.
        :param Sequence[builtins.str] weekdays: The days of the week to perform backups on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if frequency_in_minutes is not None:
            pulumi.set(__self__, "frequency_in_minutes", frequency_in_minutes)
        if time is not None:
            pulumi.set(__self__, "time", time)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[builtins.str]:
        """
        The backup frequency for the VM Workload Backup Policy. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="frequencyInMinutes")
    def frequency_in_minutes(self) -> Optional[builtins.int]:
        """
        The backup frequency in minutes for the VM Workload Backup Policy. Possible values are `15`, `30`, `60`, `120`, `240`, `480`, `720` and `1440`.
        """
        return pulumi.get(self, "frequency_in_minutes")

    @property
    @pulumi.getter
    def time(self) -> Optional[builtins.str]:
        """
        The time of day to perform the backup in 24hour format.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The days of the week to perform backups on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`. This is used when `frequency` is `Weekly`.
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicyRetentionDaily(dict):
    def __init__(__self__, *,
                 count: builtins.int):
        """
        :param builtins.int count: The number of daily backups to keep. Possible values are between `7` and `9999`.
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of daily backups to keep. Possible values are between `7` and `9999`.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicyRetentionMonthly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatType":
            suggest = "format_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMWorkloadProtectionPolicyRetentionMonthly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMWorkloadProtectionPolicyRetentionMonthly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMWorkloadProtectionPolicyRetentionMonthly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: builtins.int,
                 format_type: builtins.str,
                 monthdays: Optional[Sequence[builtins.int]] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int count: The number of monthly backups to keep. Must be between `1` and `1188`.
        :param builtins.str format_type: The retention schedule format type for monthly retention policy. Possible values are `Daily` and `Weekly`.
        :param Sequence[builtins.int] monthdays: The monthday backups to retain. Possible values are between `0` and `28`.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param Sequence[builtins.str] weeks: The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "format_type", format_type)
        if monthdays is not None:
            pulumi.set(__self__, "monthdays", monthdays)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of monthly backups to keep. Must be between `1` and `1188`.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> builtins.str:
        """
        The retention schedule format type for monthly retention policy. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "format_type")

    @property
    @pulumi.getter
    def monthdays(self) -> Optional[Sequence[builtins.int]]:
        """
        The monthday backups to retain. Possible values are between `0` and `28`.
        """
        return pulumi.get(self, "monthdays")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth` and `Last`.
        """
        return pulumi.get(self, "weeks")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicyRetentionWeekly(dict):
    def __init__(__self__, *,
                 count: builtins.int,
                 weekdays: Sequence[builtins.str]):
        """
        :param builtins.int count: The number of weekly backups to keep. Possible values are between `1` and `5163`.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "weekdays", weekdays)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of weekly backups to keep. Possible values are between `1` and `5163`.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def weekdays(self) -> Sequence[builtins.str]:
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicyRetentionYearly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "formatType":
            suggest = "format_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMWorkloadProtectionPolicyRetentionYearly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMWorkloadProtectionPolicyRetentionYearly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMWorkloadProtectionPolicyRetentionYearly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 count: builtins.int,
                 format_type: builtins.str,
                 months: Sequence[builtins.str],
                 monthdays: Optional[Sequence[builtins.int]] = None,
                 weekdays: Optional[Sequence[builtins.str]] = None,
                 weeks: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.int count: The number of yearly backups to keep. Possible values are between `1` and `99`
        :param builtins.str format_type: The retention schedule format type for yearly retention policy. Possible values are `Daily` and `Weekly`.
        :param Sequence[builtins.str] months: The months of the year to retain backups of. Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        :param Sequence[builtins.int] monthdays: The monthday backups to retain. Possible values are between `0` and `28`.
        :param Sequence[builtins.str] weekdays: The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        :param Sequence[builtins.str] weeks: The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "format_type", format_type)
        pulumi.set(__self__, "months", months)
        if monthdays is not None:
            pulumi.set(__self__, "monthdays", monthdays)
        if weekdays is not None:
            pulumi.set(__self__, "weekdays", weekdays)
        if weeks is not None:
            pulumi.set(__self__, "weeks", weeks)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The number of yearly backups to keep. Possible values are between `1` and `99`
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="formatType")
    def format_type(self) -> builtins.str:
        """
        The retention schedule format type for yearly retention policy. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "format_type")

    @property
    @pulumi.getter
    def months(self) -> Sequence[builtins.str]:
        """
        The months of the year to retain backups of. Possible values are `January`, `February`, `March`, `April`, `May`, `June`, `July`, `August`, `September`, `October`, `November` and `December`.
        """
        return pulumi.get(self, "months")

    @property
    @pulumi.getter
    def monthdays(self) -> Optional[Sequence[builtins.int]]:
        """
        The monthday backups to retain. Possible values are between `0` and `28`.
        """
        return pulumi.get(self, "monthdays")

    @property
    @pulumi.getter
    def weekdays(self) -> Optional[Sequence[builtins.str]]:
        """
        The weekday backups to retain. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` or `Saturday`.
        """
        return pulumi.get(self, "weekdays")

    @property
    @pulumi.getter
    def weeks(self) -> Optional[Sequence[builtins.str]]:
        """
        The weeks of the month to retain backups of. Possible values are `First`, `Second`, `Third`, `Fourth`, `Last`.
        """
        return pulumi.get(self, "weeks")


@pulumi.output_type
class PolicyVMWorkloadProtectionPolicySimpleRetention(dict):
    def __init__(__self__, *,
                 count: builtins.int):
        """
        :param builtins.int count: The count that is used to count retention duration with duration type `Days`. Possible values are between `7` and `35`.
        """
        pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def count(self) -> builtins.int:
        """
        The count that is used to count retention duration with duration type `Days`. Possible values are between `7` and `35`.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class PolicyVMWorkloadSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"
        elif key == "compressionEnabled":
            suggest = "compression_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyVMWorkloadSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyVMWorkloadSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyVMWorkloadSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 time_zone: builtins.str,
                 compression_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str time_zone: The timezone for the VM Workload Backup Policy. [The possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param builtins.bool compression_enabled: The compression setting for the VM Workload Backup Policy. Defaults to `false`.
        """
        pulumi.set(__self__, "time_zone", time_zone)
        if compression_enabled is not None:
            pulumi.set(__self__, "compression_enabled", compression_enabled)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> builtins.str:
        """
        The timezone for the VM Workload Backup Policy. [The possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="compressionEnabled")
    def compression_enabled(self) -> Optional[builtins.bool]:
        """
        The compression setting for the VM Workload Backup Policy. Defaults to `false`.
        """
        return pulumi.get(self, "compression_enabled")


