# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyVMArgs', 'PolicyVM']

@pulumi.input_type
class PolicyVMArgs:
    def __init__(__self__, *,
                 backup: pulumi.Input['PolicyVMBackupArgs'],
                 recovery_vault_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 instant_restore_resource_group: Optional[pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs']] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 retention_daily: Optional[pulumi.Input['PolicyVMRetentionDailyArgs']] = None,
                 retention_monthly: Optional[pulumi.Input['PolicyVMRetentionMonthlyArgs']] = None,
                 retention_weekly: Optional[pulumi.Input['PolicyVMRetentionWeeklyArgs']] = None,
                 retention_yearly: Optional[pulumi.Input['PolicyVMRetentionYearlyArgs']] = None,
                 tiering_policy: Optional[pulumi.Input['PolicyVMTieringPolicyArgs']] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyVM resource.
        :param pulumi.Input['PolicyVMBackupArgs'] backup: Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        :param pulumi.Input[builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        :param pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs'] instant_restore_resource_group: Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        :param pulumi.Input[builtins.int] instant_restore_retention_days: Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.
               
               > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] policy_type: Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input['PolicyVMRetentionDailyArgs'] retention_daily: Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        :param pulumi.Input['PolicyVMRetentionMonthlyArgs'] retention_monthly: Configures the policy monthly retention as documented in the `retention_monthly` block below.
        :param pulumi.Input['PolicyVMRetentionWeeklyArgs'] retention_weekly: Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        :param pulumi.Input['PolicyVMRetentionYearlyArgs'] retention_yearly: Configures the policy yearly retention as documented in the `retention_yearly` block below.
        :param pulumi.Input['PolicyVMTieringPolicyArgs'] tiering_policy: A `tiering_policy` block as defined below.
        :param pulumi.Input[builtins.str] timezone: Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if instant_restore_resource_group is not None:
            pulumi.set(__self__, "instant_restore_resource_group", instant_restore_resource_group)
        if instant_restore_retention_days is not None:
            pulumi.set(__self__, "instant_restore_retention_days", instant_restore_retention_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if retention_daily is not None:
            pulumi.set(__self__, "retention_daily", retention_daily)
        if retention_monthly is not None:
            pulumi.set(__self__, "retention_monthly", retention_monthly)
        if retention_weekly is not None:
            pulumi.set(__self__, "retention_weekly", retention_weekly)
        if retention_yearly is not None:
            pulumi.set(__self__, "retention_yearly", retention_yearly)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Input['PolicyVMBackupArgs']:
        """
        Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: pulumi.Input['PolicyVMBackupArgs']):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="instantRestoreResourceGroup")
    def instant_restore_resource_group(self) -> Optional[pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs']]:
        """
        Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        """
        return pulumi.get(self, "instant_restore_resource_group")

    @instant_restore_resource_group.setter
    def instant_restore_resource_group(self, value: Optional[pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs']]):
        pulumi.set(self, "instant_restore_resource_group", value)

    @property
    @pulumi.getter(name="instantRestoreRetentionDays")
    def instant_restore_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.

        > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        """
        return pulumi.get(self, "instant_restore_retention_days")

    @instant_restore_retention_days.setter
    def instant_restore_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instant_restore_retention_days", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> Optional[pulumi.Input['PolicyVMRetentionDailyArgs']]:
        """
        Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        """
        return pulumi.get(self, "retention_daily")

    @retention_daily.setter
    def retention_daily(self, value: Optional[pulumi.Input['PolicyVMRetentionDailyArgs']]):
        pulumi.set(self, "retention_daily", value)

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> Optional[pulumi.Input['PolicyVMRetentionMonthlyArgs']]:
        """
        Configures the policy monthly retention as documented in the `retention_monthly` block below.
        """
        return pulumi.get(self, "retention_monthly")

    @retention_monthly.setter
    def retention_monthly(self, value: Optional[pulumi.Input['PolicyVMRetentionMonthlyArgs']]):
        pulumi.set(self, "retention_monthly", value)

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> Optional[pulumi.Input['PolicyVMRetentionWeeklyArgs']]:
        """
        Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        """
        return pulumi.get(self, "retention_weekly")

    @retention_weekly.setter
    def retention_weekly(self, value: Optional[pulumi.Input['PolicyVMRetentionWeeklyArgs']]):
        pulumi.set(self, "retention_weekly", value)

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> Optional[pulumi.Input['PolicyVMRetentionYearlyArgs']]:
        """
        Configures the policy yearly retention as documented in the `retention_yearly` block below.
        """
        return pulumi.get(self, "retention_yearly")

    @retention_yearly.setter
    def retention_yearly(self, value: Optional[pulumi.Input['PolicyVMRetentionYearlyArgs']]):
        pulumi.set(self, "retention_yearly", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['PolicyVMTieringPolicyArgs']]:
        """
        A `tiering_policy` block as defined below.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['PolicyVMTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _PolicyVMState:
    def __init__(__self__, *,
                 backup: Optional[pulumi.Input['PolicyVMBackupArgs']] = None,
                 instant_restore_resource_group: Optional[pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs']] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_daily: Optional[pulumi.Input['PolicyVMRetentionDailyArgs']] = None,
                 retention_monthly: Optional[pulumi.Input['PolicyVMRetentionMonthlyArgs']] = None,
                 retention_weekly: Optional[pulumi.Input['PolicyVMRetentionWeeklyArgs']] = None,
                 retention_yearly: Optional[pulumi.Input['PolicyVMRetentionYearlyArgs']] = None,
                 tiering_policy: Optional[pulumi.Input['PolicyVMTieringPolicyArgs']] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyVM resources.
        :param pulumi.Input['PolicyVMBackupArgs'] backup: Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        :param pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs'] instant_restore_resource_group: Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        :param pulumi.Input[builtins.int] instant_restore_retention_days: Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.
               
               > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] policy_type: Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        :param pulumi.Input['PolicyVMRetentionDailyArgs'] retention_daily: Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        :param pulumi.Input['PolicyVMRetentionMonthlyArgs'] retention_monthly: Configures the policy monthly retention as documented in the `retention_monthly` block below.
        :param pulumi.Input['PolicyVMRetentionWeeklyArgs'] retention_weekly: Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        :param pulumi.Input['PolicyVMRetentionYearlyArgs'] retention_yearly: Configures the policy yearly retention as documented in the `retention_yearly` block below.
        :param pulumi.Input['PolicyVMTieringPolicyArgs'] tiering_policy: A `tiering_policy` block as defined below.
        :param pulumi.Input[builtins.str] timezone: Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if instant_restore_resource_group is not None:
            pulumi.set(__self__, "instant_restore_resource_group", instant_restore_resource_group)
        if instant_restore_retention_days is not None:
            pulumi.set(__self__, "instant_restore_retention_days", instant_restore_retention_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_daily is not None:
            pulumi.set(__self__, "retention_daily", retention_daily)
        if retention_monthly is not None:
            pulumi.set(__self__, "retention_monthly", retention_monthly)
        if retention_weekly is not None:
            pulumi.set(__self__, "retention_weekly", retention_weekly)
        if retention_yearly is not None:
            pulumi.set(__self__, "retention_yearly", retention_yearly)
        if tiering_policy is not None:
            pulumi.set(__self__, "tiering_policy", tiering_policy)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['PolicyVMBackupArgs']]:
        """
        Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['PolicyVMBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="instantRestoreResourceGroup")
    def instant_restore_resource_group(self) -> Optional[pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs']]:
        """
        Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        """
        return pulumi.get(self, "instant_restore_resource_group")

    @instant_restore_resource_group.setter
    def instant_restore_resource_group(self, value: Optional[pulumi.Input['PolicyVMInstantRestoreResourceGroupArgs']]):
        pulumi.set(self, "instant_restore_resource_group", value)

    @property
    @pulumi.getter(name="instantRestoreRetentionDays")
    def instant_restore_retention_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.

        > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        """
        return pulumi.get(self, "instant_restore_retention_days")

    @instant_restore_retention_days.setter
    def instant_restore_retention_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "instant_restore_retention_days", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> Optional[pulumi.Input['PolicyVMRetentionDailyArgs']]:
        """
        Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        """
        return pulumi.get(self, "retention_daily")

    @retention_daily.setter
    def retention_daily(self, value: Optional[pulumi.Input['PolicyVMRetentionDailyArgs']]):
        pulumi.set(self, "retention_daily", value)

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> Optional[pulumi.Input['PolicyVMRetentionMonthlyArgs']]:
        """
        Configures the policy monthly retention as documented in the `retention_monthly` block below.
        """
        return pulumi.get(self, "retention_monthly")

    @retention_monthly.setter
    def retention_monthly(self, value: Optional[pulumi.Input['PolicyVMRetentionMonthlyArgs']]):
        pulumi.set(self, "retention_monthly", value)

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> Optional[pulumi.Input['PolicyVMRetentionWeeklyArgs']]:
        """
        Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        """
        return pulumi.get(self, "retention_weekly")

    @retention_weekly.setter
    def retention_weekly(self, value: Optional[pulumi.Input['PolicyVMRetentionWeeklyArgs']]):
        pulumi.set(self, "retention_weekly", value)

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> Optional[pulumi.Input['PolicyVMRetentionYearlyArgs']]:
        """
        Configures the policy yearly retention as documented in the `retention_yearly` block below.
        """
        return pulumi.get(self, "retention_yearly")

    @retention_yearly.setter
    def retention_yearly(self, value: Optional[pulumi.Input['PolicyVMRetentionYearlyArgs']]):
        pulumi.set(self, "retention_yearly", value)

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> Optional[pulumi.Input['PolicyVMTieringPolicyArgs']]:
        """
        A `tiering_policy` block as defined below.
        """
        return pulumi.get(self, "tiering_policy")

    @tiering_policy.setter
    def tiering_policy(self, value: Optional[pulumi.Input['PolicyVMTieringPolicyArgs']]):
        pulumi.set(self, "tiering_policy", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timezone", value)


@pulumi.type_token("azure:backup/policyVM:PolicyVM")
class PolicyVM(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[Union['PolicyVMBackupArgs', 'PolicyVMBackupArgsDict']]] = None,
                 instant_restore_resource_group: Optional[pulumi.Input[Union['PolicyVMInstantRestoreResourceGroupArgs', 'PolicyVMInstantRestoreResourceGroupArgsDict']]] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_daily: Optional[pulumi.Input[Union['PolicyVMRetentionDailyArgs', 'PolicyVMRetentionDailyArgsDict']]] = None,
                 retention_monthly: Optional[pulumi.Input[Union['PolicyVMRetentionMonthlyArgs', 'PolicyVMRetentionMonthlyArgsDict']]] = None,
                 retention_weekly: Optional[pulumi.Input[Union['PolicyVMRetentionWeeklyArgs', 'PolicyVMRetentionWeeklyArgsDict']]] = None,
                 retention_yearly: Optional[pulumi.Input[Union['PolicyVMRetentionYearlyArgs', 'PolicyVMRetentionYearlyArgsDict']]] = None,
                 tiering_policy: Optional[pulumi.Input[Union['PolicyVMTieringPolicyArgs', 'PolicyVMTieringPolicyArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Backup VM Backup Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-recovery_vault",
            location="West Europe")
        example_vault = azure.recoveryservices.Vault("example",
            name="tfex-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_policy_vm = azure.backup.PolicyVM("example",
            name="tfex-recovery-vault-policy",
            resource_group_name=example.name,
            recovery_vault_name=example_vault.name,
            timezone="UTC",
            backup={
                "frequency": "Daily",
                "time": "23:00",
            },
            retention_daily={
                "count": 10,
            },
            retention_weekly={
                "count": 42,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                    "Friday",
                    "Saturday",
                ],
            },
            retention_monthly={
                "count": 7,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                ],
                "weeks": [
                    "First",
                    "Last",
                ],
            },
            retention_yearly={
                "count": 77,
                "weekdays": ["Sunday"],
                "weeks": ["Last"],
                "months": ["January"],
            })
        ```

        ## Import

        VM Backup Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/policyVM:PolicyVM policy1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/example-recovery-vault/backupPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyVMBackupArgs', 'PolicyVMBackupArgsDict']] backup: Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        :param pulumi.Input[Union['PolicyVMInstantRestoreResourceGroupArgs', 'PolicyVMInstantRestoreResourceGroupArgsDict']] instant_restore_resource_group: Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        :param pulumi.Input[builtins.int] instant_restore_retention_days: Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.
               
               > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] policy_type: Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PolicyVMRetentionDailyArgs', 'PolicyVMRetentionDailyArgsDict']] retention_daily: Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        :param pulumi.Input[Union['PolicyVMRetentionMonthlyArgs', 'PolicyVMRetentionMonthlyArgsDict']] retention_monthly: Configures the policy monthly retention as documented in the `retention_monthly` block below.
        :param pulumi.Input[Union['PolicyVMRetentionWeeklyArgs', 'PolicyVMRetentionWeeklyArgsDict']] retention_weekly: Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        :param pulumi.Input[Union['PolicyVMRetentionYearlyArgs', 'PolicyVMRetentionYearlyArgsDict']] retention_yearly: Configures the policy yearly retention as documented in the `retention_yearly` block below.
        :param pulumi.Input[Union['PolicyVMTieringPolicyArgs', 'PolicyVMTieringPolicyArgsDict']] tiering_policy: A `tiering_policy` block as defined below.
        :param pulumi.Input[builtins.str] timezone: Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyVMArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Backup VM Backup Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-recovery_vault",
            location="West Europe")
        example_vault = azure.recoveryservices.Vault("example",
            name="tfex-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_policy_vm = azure.backup.PolicyVM("example",
            name="tfex-recovery-vault-policy",
            resource_group_name=example.name,
            recovery_vault_name=example_vault.name,
            timezone="UTC",
            backup={
                "frequency": "Daily",
                "time": "23:00",
            },
            retention_daily={
                "count": 10,
            },
            retention_weekly={
                "count": 42,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                    "Friday",
                    "Saturday",
                ],
            },
            retention_monthly={
                "count": 7,
                "weekdays": [
                    "Sunday",
                    "Wednesday",
                ],
                "weeks": [
                    "First",
                    "Last",
                ],
            },
            retention_yearly={
                "count": 77,
                "weekdays": ["Sunday"],
                "weeks": ["Last"],
                "months": ["January"],
            })
        ```

        ## Import

        VM Backup Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/policyVM:PolicyVM policy1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/example-recovery-vault/backupPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param PolicyVMArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyVMArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup: Optional[pulumi.Input[Union['PolicyVMBackupArgs', 'PolicyVMBackupArgsDict']]] = None,
                 instant_restore_resource_group: Optional[pulumi.Input[Union['PolicyVMInstantRestoreResourceGroupArgs', 'PolicyVMInstantRestoreResourceGroupArgsDict']]] = None,
                 instant_restore_retention_days: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_daily: Optional[pulumi.Input[Union['PolicyVMRetentionDailyArgs', 'PolicyVMRetentionDailyArgsDict']]] = None,
                 retention_monthly: Optional[pulumi.Input[Union['PolicyVMRetentionMonthlyArgs', 'PolicyVMRetentionMonthlyArgsDict']]] = None,
                 retention_weekly: Optional[pulumi.Input[Union['PolicyVMRetentionWeeklyArgs', 'PolicyVMRetentionWeeklyArgsDict']]] = None,
                 retention_yearly: Optional[pulumi.Input[Union['PolicyVMRetentionYearlyArgs', 'PolicyVMRetentionYearlyArgsDict']]] = None,
                 tiering_policy: Optional[pulumi.Input[Union['PolicyVMTieringPolicyArgs', 'PolicyVMTieringPolicyArgsDict']]] = None,
                 timezone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyVMArgs.__new__(PolicyVMArgs)

            if backup is None and not opts.urn:
                raise TypeError("Missing required property 'backup'")
            __props__.__dict__["backup"] = backup
            __props__.__dict__["instant_restore_resource_group"] = instant_restore_resource_group
            __props__.__dict__["instant_restore_retention_days"] = instant_restore_retention_days
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_type"] = policy_type
            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_daily"] = retention_daily
            __props__.__dict__["retention_monthly"] = retention_monthly
            __props__.__dict__["retention_weekly"] = retention_weekly
            __props__.__dict__["retention_yearly"] = retention_yearly
            __props__.__dict__["tiering_policy"] = tiering_policy
            __props__.__dict__["timezone"] = timezone
        super(PolicyVM, __self__).__init__(
            'azure:backup/policyVM:PolicyVM',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup: Optional[pulumi.Input[Union['PolicyVMBackupArgs', 'PolicyVMBackupArgsDict']]] = None,
            instant_restore_resource_group: Optional[pulumi.Input[Union['PolicyVMInstantRestoreResourceGroupArgs', 'PolicyVMInstantRestoreResourceGroupArgsDict']]] = None,
            instant_restore_retention_days: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            policy_type: Optional[pulumi.Input[builtins.str]] = None,
            recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            retention_daily: Optional[pulumi.Input[Union['PolicyVMRetentionDailyArgs', 'PolicyVMRetentionDailyArgsDict']]] = None,
            retention_monthly: Optional[pulumi.Input[Union['PolicyVMRetentionMonthlyArgs', 'PolicyVMRetentionMonthlyArgsDict']]] = None,
            retention_weekly: Optional[pulumi.Input[Union['PolicyVMRetentionWeeklyArgs', 'PolicyVMRetentionWeeklyArgsDict']]] = None,
            retention_yearly: Optional[pulumi.Input[Union['PolicyVMRetentionYearlyArgs', 'PolicyVMRetentionYearlyArgsDict']]] = None,
            tiering_policy: Optional[pulumi.Input[Union['PolicyVMTieringPolicyArgs', 'PolicyVMTieringPolicyArgsDict']]] = None,
            timezone: Optional[pulumi.Input[builtins.str]] = None) -> 'PolicyVM':
        """
        Get an existing PolicyVM resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyVMBackupArgs', 'PolicyVMBackupArgsDict']] backup: Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        :param pulumi.Input[Union['PolicyVMInstantRestoreResourceGroupArgs', 'PolicyVMInstantRestoreResourceGroupArgsDict']] instant_restore_resource_group: Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        :param pulumi.Input[builtins.int] instant_restore_retention_days: Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.
               
               > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] policy_type: Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recovery_vault_name: Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PolicyVMRetentionDailyArgs', 'PolicyVMRetentionDailyArgsDict']] retention_daily: Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        :param pulumi.Input[Union['PolicyVMRetentionMonthlyArgs', 'PolicyVMRetentionMonthlyArgsDict']] retention_monthly: Configures the policy monthly retention as documented in the `retention_monthly` block below.
        :param pulumi.Input[Union['PolicyVMRetentionWeeklyArgs', 'PolicyVMRetentionWeeklyArgsDict']] retention_weekly: Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        :param pulumi.Input[Union['PolicyVMRetentionYearlyArgs', 'PolicyVMRetentionYearlyArgsDict']] retention_yearly: Configures the policy yearly retention as documented in the `retention_yearly` block below.
        :param pulumi.Input[Union['PolicyVMTieringPolicyArgs', 'PolicyVMTieringPolicyArgsDict']] tiering_policy: A `tiering_policy` block as defined below.
        :param pulumi.Input[builtins.str] timezone: Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyVMState.__new__(_PolicyVMState)

        __props__.__dict__["backup"] = backup
        __props__.__dict__["instant_restore_resource_group"] = instant_restore_resource_group
        __props__.__dict__["instant_restore_retention_days"] = instant_restore_retention_days
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_daily"] = retention_daily
        __props__.__dict__["retention_monthly"] = retention_monthly
        __props__.__dict__["retention_weekly"] = retention_weekly
        __props__.__dict__["retention_yearly"] = retention_yearly
        __props__.__dict__["tiering_policy"] = tiering_policy
        __props__.__dict__["timezone"] = timezone
        return PolicyVM(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output['outputs.PolicyVMBackup']:
        """
        Configures the Policy backup frequency, times & days as documented in the `backup` block below.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="instantRestoreResourceGroup")
    def instant_restore_resource_group(self) -> pulumi.Output[Optional['outputs.PolicyVMInstantRestoreResourceGroup']]:
        """
        Specifies the instant restore resource group name as documented in the `instant_restore_resource_group` block below.
        """
        return pulumi.get(self, "instant_restore_resource_group")

    @property
    @pulumi.getter(name="instantRestoreRetentionDays")
    def instant_restore_retention_days(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the instant restore retention range in days. Possible values are between `1` and `5` when `policy_type` is `V1`, and `1` to `30` when `policy_type` is `V2`.

        > **Note:** `instant_restore_retention_days` **must** be set to `5` if the backup frequency is set to `Weekly`.
        """
        return pulumi.get(self, "instant_restore_retention_days")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Type of the Backup Policy. Possible values are `V1` and `V2` where `V2` stands for the Enhanced Policy. Defaults to `V1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "policy_type")

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="retentionDaily")
    def retention_daily(self) -> pulumi.Output[Optional['outputs.PolicyVMRetentionDaily']]:
        """
        Configures the policy daily retention as documented in the `retention_daily` block below. Required when backup frequency is `Daily`.
        """
        return pulumi.get(self, "retention_daily")

    @property
    @pulumi.getter(name="retentionMonthly")
    def retention_monthly(self) -> pulumi.Output[Optional['outputs.PolicyVMRetentionMonthly']]:
        """
        Configures the policy monthly retention as documented in the `retention_monthly` block below.
        """
        return pulumi.get(self, "retention_monthly")

    @property
    @pulumi.getter(name="retentionWeekly")
    def retention_weekly(self) -> pulumi.Output[Optional['outputs.PolicyVMRetentionWeekly']]:
        """
        Configures the policy weekly retention as documented in the `retention_weekly` block below. Required when backup frequency is `Weekly`.
        """
        return pulumi.get(self, "retention_weekly")

    @property
    @pulumi.getter(name="retentionYearly")
    def retention_yearly(self) -> pulumi.Output[Optional['outputs.PolicyVMRetentionYearly']]:
        """
        Configures the policy yearly retention as documented in the `retention_yearly` block below.
        """
        return pulumi.get(self, "retention_yearly")

    @property
    @pulumi.getter(name="tieringPolicy")
    def tiering_policy(self) -> pulumi.Output[Optional['outputs.PolicyVMTieringPolicy']]:
        """
        A `tiering_policy` block as defined below.
        """
        return pulumi.get(self, "tiering_policy")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the timezone. [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Defaults to `UTC`
        """
        return pulumi.get(self, "timezone")

