# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyVMWorkloadArgs', 'PolicyVMWorkload']

@pulumi.input_type
class PolicyVMWorkloadArgs:
    def __init__(__self__, *,
                 protection_policies: pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]],
                 recovery_vault_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 settings: pulumi.Input['PolicyVMWorkloadSettingsArgs'],
                 workload_type: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PolicyVMWorkload resource.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]] protection_policies: One or more `protection_policy` blocks as defined below.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input['PolicyVMWorkloadSettingsArgs'] settings: A `settings` block as defined below.
        :param pulumi.Input[builtins.str] workload_type: The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "protection_policies", protection_policies)
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "workload_type", workload_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="protectionPolicies")
    def protection_policies(self) -> pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]]:
        """
        One or more `protection_policy` blocks as defined below.
        """
        return pulumi.get(self, "protection_policies")

    @protection_policies.setter
    def protection_policies(self, value: pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]]):
        pulumi.set(self, "protection_policies", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Input['PolicyVMWorkloadSettingsArgs']:
        """
        A `settings` block as defined below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: pulumi.Input['PolicyVMWorkloadSettingsArgs']):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> pulumi.Input[builtins.str]:
        """
        The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workload_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PolicyVMWorkloadState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_policies: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input['PolicyVMWorkloadSettingsArgs']] = None,
                 workload_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyVMWorkload resources.
        :param pulumi.Input[builtins.str] name: The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]] protection_policies: One or more `protection_policy` blocks as defined below.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input['PolicyVMWorkloadSettingsArgs'] settings: A `settings` block as defined below.
        :param pulumi.Input[builtins.str] workload_type: The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protection_policies is not None:
            pulumi.set(__self__, "protection_policies", protection_policies)
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protectionPolicies")
    def protection_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]]]:
        """
        One or more `protection_policy` blocks as defined below.
        """
        return pulumi.get(self, "protection_policies")

    @protection_policies.setter
    def protection_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyVMWorkloadProtectionPolicyArgs']]]]):
        pulumi.set(self, "protection_policies", value)

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['PolicyVMWorkloadSettingsArgs']]:
        """
        A `settings` block as defined below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['PolicyVMWorkloadSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_type", value)


@pulumi.type_token("azure:backup/policyVMWorkload:PolicyVMWorkload")
class PolicyVMWorkload(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyVMWorkloadProtectionPolicyArgs', 'PolicyVMWorkloadProtectionPolicyArgsDict']]]]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['PolicyVMWorkloadSettingsArgs', 'PolicyVMWorkloadSettingsArgsDict']]] = None,
                 workload_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure VM Workload Backup Policy within a Recovery Services vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-bpvmw",
            location="West Europe")
        example_vault = azure.recoveryservices.Vault("example",
            name="example-rsv",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            soft_delete_enabled=False)
        example_policy_vm_workload = azure.backup.PolicyVMWorkload("example",
            name="example-bpvmw",
            resource_group_name=example.name,
            recovery_vault_name=example_vault.name,
            workload_type="SQLDataBase",
            settings={
                "time_zone": "UTC",
                "compression_enabled": False,
            },
            protection_policies=[
                {
                    "policy_type": "Full",
                    "backup": {
                        "frequency": "Daily",
                        "time": "15:00",
                    },
                    "retention_daily": {
                        "count": 8,
                    },
                },
                {
                    "policy_type": "Log",
                    "backup": {
                        "frequency_in_minutes": 15,
                    },
                    "simple_retention": {
                        "count": 8,
                    },
                },
            ])
        ```

        ## Import

        Azure VM Workload Backup Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/policyVMWorkload:PolicyVMWorkload policy1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/vault1/backupPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyVMWorkloadProtectionPolicyArgs', 'PolicyVMWorkloadProtectionPolicyArgsDict']]]] protection_policies: One or more `protection_policy` blocks as defined below.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PolicyVMWorkloadSettingsArgs', 'PolicyVMWorkloadSettingsArgsDict']] settings: A `settings` block as defined below.
        :param pulumi.Input[builtins.str] workload_type: The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyVMWorkloadArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure VM Workload Backup Policy within a Recovery Services vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-bpvmw",
            location="West Europe")
        example_vault = azure.recoveryservices.Vault("example",
            name="example-rsv",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            soft_delete_enabled=False)
        example_policy_vm_workload = azure.backup.PolicyVMWorkload("example",
            name="example-bpvmw",
            resource_group_name=example.name,
            recovery_vault_name=example_vault.name,
            workload_type="SQLDataBase",
            settings={
                "time_zone": "UTC",
                "compression_enabled": False,
            },
            protection_policies=[
                {
                    "policy_type": "Full",
                    "backup": {
                        "frequency": "Daily",
                        "time": "15:00",
                    },
                    "retention_daily": {
                        "count": 8,
                    },
                },
                {
                    "policy_type": "Log",
                    "backup": {
                        "frequency_in_minutes": 15,
                    },
                    "simple_retention": {
                        "count": 8,
                    },
                },
            ])
        ```

        ## Import

        Azure VM Workload Backup Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:backup/policyVMWorkload:PolicyVMWorkload policy1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/vault1/backupPolicies/policy1
        ```

        :param str resource_name: The name of the resource.
        :param PolicyVMWorkloadArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyVMWorkloadArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 protection_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyVMWorkloadProtectionPolicyArgs', 'PolicyVMWorkloadProtectionPolicyArgsDict']]]]] = None,
                 recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input[Union['PolicyVMWorkloadSettingsArgs', 'PolicyVMWorkloadSettingsArgsDict']]] = None,
                 workload_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyVMWorkloadArgs.__new__(PolicyVMWorkloadArgs)

            __props__.__dict__["name"] = name
            if protection_policies is None and not opts.urn:
                raise TypeError("Missing required property 'protection_policies'")
            __props__.__dict__["protection_policies"] = protection_policies
            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if settings is None and not opts.urn:
                raise TypeError("Missing required property 'settings'")
            __props__.__dict__["settings"] = settings
            if workload_type is None and not opts.urn:
                raise TypeError("Missing required property 'workload_type'")
            __props__.__dict__["workload_type"] = workload_type
        super(PolicyVMWorkload, __self__).__init__(
            'azure:backup/policyVMWorkload:PolicyVMWorkload',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            protection_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyVMWorkloadProtectionPolicyArgs', 'PolicyVMWorkloadProtectionPolicyArgsDict']]]]] = None,
            recovery_vault_name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            settings: Optional[pulumi.Input[Union['PolicyVMWorkloadSettingsArgs', 'PolicyVMWorkloadSettingsArgsDict']]] = None,
            workload_type: Optional[pulumi.Input[builtins.str]] = None) -> 'PolicyVMWorkload':
        """
        Get an existing PolicyVMWorkload resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyVMWorkloadProtectionPolicyArgs', 'PolicyVMWorkloadProtectionPolicyArgsDict']]]] protection_policies: One or more `protection_policy` blocks as defined below.
        :param pulumi.Input[builtins.str] recovery_vault_name: The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PolicyVMWorkloadSettingsArgs', 'PolicyVMWorkloadSettingsArgsDict']] settings: A `settings` block as defined below.
        :param pulumi.Input[builtins.str] workload_type: The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyVMWorkloadState.__new__(_PolicyVMWorkloadState)

        __props__.__dict__["name"] = name
        __props__.__dict__["protection_policies"] = protection_policies
        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["settings"] = settings
        __props__.__dict__["workload_type"] = workload_type
        return PolicyVMWorkload(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectionPolicies")
    def protection_policies(self) -> pulumi.Output[Sequence['outputs.PolicyVMWorkloadProtectionPolicy']]:
        """
        One or more `protection_policy` blocks as defined below.
        """
        return pulumi.get(self, "protection_policies")

    @property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Recovery Services Vault to use. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the VM Workload Backup Policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.PolicyVMWorkloadSettings']:
        """
        A `settings` block as defined below.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> pulumi.Output[builtins.str]:
        """
        The VM Workload type for the Backup Policy. Possible values are `SQLDataBase` and `SAPHanaDatabase`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workload_type")

