# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountEncryptionArgs',
    'AccountEncryptionArgsDict',
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'AccountKeyVaultReferenceArgs',
    'AccountKeyVaultReferenceArgsDict',
    'AccountNetworkProfileArgs',
    'AccountNetworkProfileArgsDict',
    'AccountNetworkProfileAccountAccessArgs',
    'AccountNetworkProfileAccountAccessArgsDict',
    'AccountNetworkProfileAccountAccessIpRuleArgs',
    'AccountNetworkProfileAccountAccessIpRuleArgsDict',
    'AccountNetworkProfileNodeManagementAccessArgs',
    'AccountNetworkProfileNodeManagementAccessArgsDict',
    'AccountNetworkProfileNodeManagementAccessIpRuleArgs',
    'AccountNetworkProfileNodeManagementAccessIpRuleArgsDict',
    'PoolAutoScaleArgs',
    'PoolAutoScaleArgsDict',
    'PoolCertificateArgs',
    'PoolCertificateArgsDict',
    'PoolContainerConfigurationArgs',
    'PoolContainerConfigurationArgsDict',
    'PoolContainerConfigurationContainerRegistryArgs',
    'PoolContainerConfigurationContainerRegistryArgsDict',
    'PoolDataDiskArgs',
    'PoolDataDiskArgsDict',
    'PoolDiskEncryptionArgs',
    'PoolDiskEncryptionArgsDict',
    'PoolExtensionArgs',
    'PoolExtensionArgsDict',
    'PoolFixedScaleArgs',
    'PoolFixedScaleArgsDict',
    'PoolIdentityArgs',
    'PoolIdentityArgsDict',
    'PoolMountArgs',
    'PoolMountArgsDict',
    'PoolMountAzureBlobFileSystemArgs',
    'PoolMountAzureBlobFileSystemArgsDict',
    'PoolMountAzureFileShareArgs',
    'PoolMountAzureFileShareArgsDict',
    'PoolMountCifsMountArgs',
    'PoolMountCifsMountArgsDict',
    'PoolMountNfsMountArgs',
    'PoolMountNfsMountArgsDict',
    'PoolNetworkConfigurationArgs',
    'PoolNetworkConfigurationArgsDict',
    'PoolNetworkConfigurationEndpointConfigurationArgs',
    'PoolNetworkConfigurationEndpointConfigurationArgsDict',
    'PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs',
    'PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgsDict',
    'PoolNodePlacementArgs',
    'PoolNodePlacementArgsDict',
    'PoolSecurityProfileArgs',
    'PoolSecurityProfileArgsDict',
    'PoolStartTaskArgs',
    'PoolStartTaskArgsDict',
    'PoolStartTaskContainerArgs',
    'PoolStartTaskContainerArgsDict',
    'PoolStartTaskContainerRegistryArgs',
    'PoolStartTaskContainerRegistryArgsDict',
    'PoolStartTaskResourceFileArgs',
    'PoolStartTaskResourceFileArgsDict',
    'PoolStartTaskUserIdentityArgs',
    'PoolStartTaskUserIdentityArgsDict',
    'PoolStartTaskUserIdentityAutoUserArgs',
    'PoolStartTaskUserIdentityAutoUserArgsDict',
    'PoolStorageImageReferenceArgs',
    'PoolStorageImageReferenceArgsDict',
    'PoolTaskSchedulingPolicyArgs',
    'PoolTaskSchedulingPolicyArgsDict',
    'PoolUserAccountArgs',
    'PoolUserAccountArgsDict',
    'PoolUserAccountLinuxUserConfigurationArgs',
    'PoolUserAccountLinuxUserConfigurationArgsDict',
    'PoolUserAccountWindowsUserConfigurationArgs',
    'PoolUserAccountWindowsUserConfigurationArgsDict',
    'PoolWindowArgs',
    'PoolWindowArgsDict',
]

MYPY = False

if not MYPY:
    class AccountEncryptionArgsDict(TypedDict):
        key_vault_key_id: pulumi.Input[builtins.str]
        """
        The full URL path to the Azure key vault key id that should be used to encrypt data, as documented [here](https://docs.microsoft.com/azure/batch/batch-customer-managed-key). Both versioned and versionless keys are supported.
        """
elif False:
    AccountEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] key_vault_key_id: The full URL path to the Azure key vault key id that should be used to encrypt data, as documented [here](https://docs.microsoft.com/azure/batch/batch-customer-managed-key). Both versioned and versionless keys are supported.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[builtins.str]:
        """
        The full URL path to the Azure key vault key id that should be used to encrypt data, as documented [here](https://docs.microsoft.com/azure/batch/batch-customer-managed-key). Both versioned and versionless keys are supported.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)


if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Batch Account. Possible values are `SystemAssigned` or `UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Batch Account.

        > **NOTE:** This is required when `type` is set to `UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Batch Account. Possible values are `SystemAssigned` or `UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned`.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Batch Account. Possible values are `SystemAssigned` or `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Batch Account.

        > **NOTE:** This is required when `type` is set to `UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AccountKeyVaultReferenceArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The Azure identifier of the Azure KeyVault to use.
        """
        url: pulumi.Input[builtins.str]
        """
        The HTTPS URL of the Azure KeyVault to use.
        """
elif False:
    AccountKeyVaultReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountKeyVaultReferenceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 url: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] id: The Azure identifier of the Azure KeyVault to use.
        :param pulumi.Input[builtins.str] url: The HTTPS URL of the Azure KeyVault to use.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The Azure identifier of the Azure KeyVault to use.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        The HTTPS URL of the Azure KeyVault to use.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)


if not MYPY:
    class AccountNetworkProfileArgsDict(TypedDict):
        account_access: NotRequired[pulumi.Input['AccountNetworkProfileAccountAccessArgsDict']]
        """
        An `account_access` block as defined below.
        """
        node_management_access: NotRequired[pulumi.Input['AccountNetworkProfileNodeManagementAccessArgsDict']]
        """
        A `node_management_access` block as defined below.

        > **NOTE:** At least one of `account_access` or `node_management_access` must be specified.
        """
elif False:
    AccountNetworkProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkProfileArgs:
    def __init__(__self__, *,
                 account_access: Optional[pulumi.Input['AccountNetworkProfileAccountAccessArgs']] = None,
                 node_management_access: Optional[pulumi.Input['AccountNetworkProfileNodeManagementAccessArgs']] = None):
        """
        :param pulumi.Input['AccountNetworkProfileAccountAccessArgs'] account_access: An `account_access` block as defined below.
        :param pulumi.Input['AccountNetworkProfileNodeManagementAccessArgs'] node_management_access: A `node_management_access` block as defined below.
               
               > **NOTE:** At least one of `account_access` or `node_management_access` must be specified.
        """
        if account_access is not None:
            pulumi.set(__self__, "account_access", account_access)
        if node_management_access is not None:
            pulumi.set(__self__, "node_management_access", node_management_access)

    @property
    @pulumi.getter(name="accountAccess")
    def account_access(self) -> Optional[pulumi.Input['AccountNetworkProfileAccountAccessArgs']]:
        """
        An `account_access` block as defined below.
        """
        return pulumi.get(self, "account_access")

    @account_access.setter
    def account_access(self, value: Optional[pulumi.Input['AccountNetworkProfileAccountAccessArgs']]):
        pulumi.set(self, "account_access", value)

    @property
    @pulumi.getter(name="nodeManagementAccess")
    def node_management_access(self) -> Optional[pulumi.Input['AccountNetworkProfileNodeManagementAccessArgs']]:
        """
        A `node_management_access` block as defined below.

        > **NOTE:** At least one of `account_access` or `node_management_access` must be specified.
        """
        return pulumi.get(self, "node_management_access")

    @node_management_access.setter
    def node_management_access(self, value: Optional[pulumi.Input['AccountNetworkProfileNodeManagementAccessArgs']]):
        pulumi.set(self, "node_management_access", value)


if not MYPY:
    class AccountNetworkProfileAccountAccessArgsDict(TypedDict):
        default_action: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the default action for the account access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        ip_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileAccountAccessIpRuleArgsDict']]]]
        """
        One or more `ip_rule` blocks as defined below.
        """
elif False:
    AccountNetworkProfileAccountAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkProfileAccountAccessArgs:
    def __init__(__self__, *,
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileAccountAccessIpRuleArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] default_action: Specifies the default action for the account access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileAccountAccessIpRuleArgs']]] ip_rules: One or more `ip_rule` blocks as defined below.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the default action for the account access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileAccountAccessIpRuleArgs']]]]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileAccountAccessIpRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)


if not MYPY:
    class AccountNetworkProfileAccountAccessIpRuleArgsDict(TypedDict):
        ip_range: pulumi.Input[builtins.str]
        """
        The CIDR block from which requests will match the rule.
        """
        action: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
elif False:
    AccountNetworkProfileAccountAccessIpRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkProfileAccountAccessIpRuleArgs:
    def __init__(__self__, *,
                 ip_range: pulumi.Input[builtins.str],
                 action: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ip_range: The CIDR block from which requests will match the rule.
        :param pulumi.Input[builtins.str] action: Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[builtins.str]:
        """
        The CIDR block from which requests will match the rule.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)


if not MYPY:
    class AccountNetworkProfileNodeManagementAccessArgsDict(TypedDict):
        default_action: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the default action for the node management access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        ip_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileNodeManagementAccessIpRuleArgsDict']]]]
        """
        One or more `ip_rule` blocks as defined below.
        """
elif False:
    AccountNetworkProfileNodeManagementAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkProfileNodeManagementAccessArgs:
    def __init__(__self__, *,
                 default_action: Optional[pulumi.Input[builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileNodeManagementAccessIpRuleArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] default_action: Specifies the default action for the node management access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        :param pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileNodeManagementAccessIpRuleArgs']]] ip_rules: One or more `ip_rule` blocks as defined below.
        """
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the default action for the node management access. Possible values are `Allow` and `Deny`. Defaults to `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileNodeManagementAccessIpRuleArgs']]]]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkProfileNodeManagementAccessIpRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)


if not MYPY:
    class AccountNetworkProfileNodeManagementAccessIpRuleArgsDict(TypedDict):
        ip_range: pulumi.Input[builtins.str]
        """
        The CIDR block from which requests will match the rule.
        """
        action: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
elif False:
    AccountNetworkProfileNodeManagementAccessIpRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkProfileNodeManagementAccessIpRuleArgs:
    def __init__(__self__, *,
                 ip_range: pulumi.Input[builtins.str],
                 action: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ip_range: The CIDR block from which requests will match the rule.
        :param pulumi.Input[builtins.str] action: Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[builtins.str]:
        """
        The CIDR block from which requests will match the rule.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the action of the ip rule. The only possible value is `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)


if not MYPY:
    class PoolAutoScaleArgsDict(TypedDict):
        formula: pulumi.Input[builtins.str]
        """
        The autoscale formula that needs to be used for scaling the Batch pool.
        """
        evaluation_interval: NotRequired[pulumi.Input[builtins.str]]
        """
        The interval to wait before evaluating if the pool needs to be scaled. Defaults to `PT15M`.
        """
elif False:
    PoolAutoScaleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolAutoScaleArgs:
    def __init__(__self__, *,
                 formula: pulumi.Input[builtins.str],
                 evaluation_interval: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] formula: The autoscale formula that needs to be used for scaling the Batch pool.
        :param pulumi.Input[builtins.str] evaluation_interval: The interval to wait before evaluating if the pool needs to be scaled. Defaults to `PT15M`.
        """
        pulumi.set(__self__, "formula", formula)
        if evaluation_interval is not None:
            pulumi.set(__self__, "evaluation_interval", evaluation_interval)

    @property
    @pulumi.getter
    def formula(self) -> pulumi.Input[builtins.str]:
        """
        The autoscale formula that needs to be used for scaling the Batch pool.
        """
        return pulumi.get(self, "formula")

    @formula.setter
    def formula(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "formula", value)

    @property
    @pulumi.getter(name="evaluationInterval")
    def evaluation_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The interval to wait before evaluating if the pool needs to be scaled. Defaults to `PT15M`.
        """
        return pulumi.get(self, "evaluation_interval")

    @evaluation_interval.setter
    def evaluation_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "evaluation_interval", value)


if not MYPY:
    class PoolCertificateArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The ID of the Batch Certificate to install on the Batch Pool, which must be inside the same Batch Account.
        """
        store_location: pulumi.Input[builtins.str]
        """
        The location of the certificate store on the compute node into which to install the certificate. Possible values are `CurrentUser` or `LocalMachine`.

        > **Note:** This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a 'certs' directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
        """
        store_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the certificate store on the compute node into which to install the certificate. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: `My`, `Root`, `CA`, `Trust`, `Disallowed`, `TrustedPeople`, `TrustedPublisher`, `AuthRoot`, `AddressBook`, but any custom store name can also be used.
        """
        visibilities: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Which user accounts on the compute node should have access to the private data of the certificate. Possible values are `StartTask`, `Task` and `RemoteUser`.
        """
elif False:
    PoolCertificateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolCertificateArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 store_location: pulumi.Input[builtins.str],
                 store_name: Optional[pulumi.Input[builtins.str]] = None,
                 visibilities: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] id: The ID of the Batch Certificate to install on the Batch Pool, which must be inside the same Batch Account.
        :param pulumi.Input[builtins.str] store_location: The location of the certificate store on the compute node into which to install the certificate. Possible values are `CurrentUser` or `LocalMachine`.
               
               > **Note:** This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a 'certs' directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
        :param pulumi.Input[builtins.str] store_name: The name of the certificate store on the compute node into which to install the certificate. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: `My`, `Root`, `CA`, `Trust`, `Disallowed`, `TrustedPeople`, `TrustedPublisher`, `AuthRoot`, `AddressBook`, but any custom store name can also be used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] visibilities: Which user accounts on the compute node should have access to the private data of the certificate. Possible values are `StartTask`, `Task` and `RemoteUser`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "store_location", store_location)
        if store_name is not None:
            pulumi.set(__self__, "store_name", store_name)
        if visibilities is not None:
            pulumi.set(__self__, "visibilities", visibilities)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Batch Certificate to install on the Batch Pool, which must be inside the same Batch Account.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="storeLocation")
    def store_location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the certificate store on the compute node into which to install the certificate. Possible values are `CurrentUser` or `LocalMachine`.

        > **Note:** This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). For Linux compute nodes, the certificates are stored in a directory inside the task working directory and an environment variable `AZ_BATCH_CERTIFICATES_DIR` is supplied to the task to query for this location. For certificates with visibility of `remoteUser`, a 'certs' directory is created in the user's home directory (e.g., `/home/{user-name}/certs`) and certificates are placed in that directory.
        """
        return pulumi.get(self, "store_location")

    @store_location.setter
    def store_location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "store_location", value)

    @property
    @pulumi.getter(name="storeName")
    def store_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the certificate store on the compute node into which to install the certificate. This property is applicable only for pools configured with Windows nodes (that is, created with cloudServiceConfiguration, or with virtualMachineConfiguration using a Windows image reference). Common store names include: `My`, `Root`, `CA`, `Trust`, `Disallowed`, `TrustedPeople`, `TrustedPublisher`, `AuthRoot`, `AddressBook`, but any custom store name can also be used.
        """
        return pulumi.get(self, "store_name")

    @store_name.setter
    def store_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "store_name", value)

    @property
    @pulumi.getter
    def visibilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Which user accounts on the compute node should have access to the private data of the certificate. Possible values are `StartTask`, `Task` and `RemoteUser`.
        """
        return pulumi.get(self, "visibilities")

    @visibilities.setter
    def visibilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "visibilities", value)


if not MYPY:
    class PoolContainerConfigurationArgsDict(TypedDict):
        container_image_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of container image names to use, as would be specified by `docker pull`. Changing this forces a new resource to be created.
        """
        container_registries: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolContainerConfigurationContainerRegistryArgsDict']]]]
        """
        One or more `container_registries` blocks as defined below. Additional container registries from which container images can be pulled by the pool's VMs. Changing this forces a new resource to be created.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of container configuration. Possible value is `DockerCompatible`.
        """
elif False:
    PoolContainerConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolContainerConfigurationArgs:
    def __init__(__self__, *,
                 container_image_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 container_registries: Optional[pulumi.Input[Sequence[pulumi.Input['PoolContainerConfigurationContainerRegistryArgs']]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] container_image_names: A list of container image names to use, as would be specified by `docker pull`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolContainerConfigurationContainerRegistryArgs']]] container_registries: One or more `container_registries` blocks as defined below. Additional container registries from which container images can be pulled by the pool's VMs. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] type: The type of container configuration. Possible value is `DockerCompatible`.
        """
        if container_image_names is not None:
            pulumi.set(__self__, "container_image_names", container_image_names)
        if container_registries is not None:
            pulumi.set(__self__, "container_registries", container_registries)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="containerImageNames")
    def container_image_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of container image names to use, as would be specified by `docker pull`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_image_names")

    @container_image_names.setter
    def container_image_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "container_image_names", value)

    @property
    @pulumi.getter(name="containerRegistries")
    def container_registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolContainerConfigurationContainerRegistryArgs']]]]:
        """
        One or more `container_registries` blocks as defined below. Additional container registries from which container images can be pulled by the pool's VMs. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registries")

    @container_registries.setter
    def container_registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolContainerConfigurationContainerRegistryArgs']]]]):
        pulumi.set(self, "container_registries", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of container configuration. Possible value is `DockerCompatible`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class PoolContainerConfigurationContainerRegistryArgsDict(TypedDict):
        registry_server: pulumi.Input[builtins.str]
        """
        The container registry URL. Changing this forces a new resource to be created.
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        The password to log into the registry server. Changing this forces a new resource to be created.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password. Changing this forces a new resource to be created.
        """
        user_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The user name to log into the registry server. Changing this forces a new resource to be created.
        """
elif False:
    PoolContainerConfigurationContainerRegistryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolContainerConfigurationContainerRegistryArgs:
    def __init__(__self__, *,
                 registry_server: pulumi.Input[builtins.str],
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] registry_server: The container registry URL. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] password: The password to log into the registry server. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_name: The user name to log into the registry server. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "registry_server", registry_server)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> pulumi.Input[builtins.str]:
        """
        The container registry URL. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "registry_server")

    @registry_server.setter
    def registry_server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "registry_server", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password to log into the registry server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reference to the user assigned identity to use to access an Azure Container Registry instead of username and password. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user name to log into the registry server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


if not MYPY:
    class PoolDataDiskArgsDict(TypedDict):
        disk_size_gb: pulumi.Input[builtins.int]
        """
        The initial disk size in GB when creating new data disk.
        """
        lun: pulumi.Input[builtins.int]
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        """
        caching: NotRequired[pulumi.Input[builtins.str]]
        """
        Values are: "none" - The caching mode for the disk is not enabled. "readOnly" - The caching mode for the disk is read only. "readWrite" - The caching mode for the disk is read and write. For information about the caching options see: <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>. Possible values are `None`, `ReadOnly` and `ReadWrite`. Defaults to `ReadOnly`.
        """
        storage_account_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The storage account type to be used for the data disk. Values are: Possible values are `Standard_LRS` - The data disk should use standard locally redundant storage. `Premium_LRS` - The data disk should use premium locally redundant storage. Defaults to `Standard_LRS`.
        """
elif False:
    PoolDataDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolDataDiskArgs:
    def __init__(__self__, *,
                 disk_size_gb: pulumi.Input[builtins.int],
                 lun: pulumi.Input[builtins.int],
                 caching: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] disk_size_gb: The initial disk size in GB when creating new data disk.
        :param pulumi.Input[builtins.int] lun: The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        :param pulumi.Input[builtins.str] caching: Values are: "none" - The caching mode for the disk is not enabled. "readOnly" - The caching mode for the disk is read only. "readWrite" - The caching mode for the disk is read and write. For information about the caching options see: <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>. Possible values are `None`, `ReadOnly` and `ReadWrite`. Defaults to `ReadOnly`.
        :param pulumi.Input[builtins.str] storage_account_type: The storage account type to be used for the data disk. Values are: Possible values are `Standard_LRS` - The data disk should use standard locally redundant storage. `Premium_LRS` - The data disk should use premium locally redundant storage. Defaults to `Standard_LRS`.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Input[builtins.int]:
        """
        The initial disk size in GB when creating new data disk.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[builtins.int]:
        """
        The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun. The value must be between 0 and 63, inclusive.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Values are: "none" - The caching mode for the disk is not enabled. "readOnly" - The caching mode for the disk is read only. "readWrite" - The caching mode for the disk is read and write. For information about the caching options see: <https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/>. Possible values are `None`, `ReadOnly` and `ReadWrite`. Defaults to `ReadOnly`.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage account type to be used for the data disk. Values are: Possible values are `Standard_LRS` - The data disk should use standard locally redundant storage. `Premium_LRS` - The data disk should use premium locally redundant storage. Defaults to `Standard_LRS`.
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_type", value)


if not MYPY:
    class PoolDiskEncryptionArgsDict(TypedDict):
        disk_encryption_target: pulumi.Input[builtins.str]
        """
        On Linux pool, only \\"TemporaryDisk\\" is supported; on Windows pool, \\"OsDisk\\" and \\"TemporaryDisk\\" must be specified.
        """
elif False:
    PoolDiskEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolDiskEncryptionArgs:
    def __init__(__self__, *,
                 disk_encryption_target: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] disk_encryption_target: On Linux pool, only \\"TemporaryDisk\\" is supported; on Windows pool, \\"OsDisk\\" and \\"TemporaryDisk\\" must be specified.
        """
        pulumi.set(__self__, "disk_encryption_target", disk_encryption_target)

    @property
    @pulumi.getter(name="diskEncryptionTarget")
    def disk_encryption_target(self) -> pulumi.Input[builtins.str]:
        """
        On Linux pool, only \\"TemporaryDisk\\" is supported; on Windows pool, \\"OsDisk\\" and \\"TemporaryDisk\\" must be specified.
        """
        return pulumi.get(self, "disk_encryption_target")

    @disk_encryption_target.setter
    def disk_encryption_target(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "disk_encryption_target", value)


if not MYPY:
    class PoolExtensionArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the virtual machine extension.
        """
        publisher: pulumi.Input[builtins.str]
        """
        The name of the extension handler publisher.The name of the extension handler publisher.
        """
        type: pulumi.Input[builtins.str]
        """
        The type of the extensions.
        """
        auto_upgrade_minor_version: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        automatic_upgrade_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available. Supported values are `true` and `false`.

        > **Note:** When `automatic_upgrade_enabled` is set to `true`, the `type_handler_version` is automatically updated by the Azure platform when a new version is available and any change in `type_handler_version` should be manually ignored by user.
        """
        protected_settings: NotRequired[pulumi.Input[builtins.str]]
        """
        JSON formatted protected settings for the extension, the value should be encoded with `jsonencode` function. The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        """
        provision_after_extensions: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        """
        settings_json: NotRequired[pulumi.Input[builtins.str]]
        """
        JSON formatted public settings for the extension, the value should be encoded with `jsonencode` function.
        """
        type_handler_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The version of script handler.
        """
elif False:
    PoolExtensionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolExtensionArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 publisher: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 auto_upgrade_minor_version: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_upgrade_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 protected_settings: Optional[pulumi.Input[builtins.str]] = None,
                 provision_after_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 settings_json: Optional[pulumi.Input[builtins.str]] = None,
                 type_handler_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the virtual machine extension.
        :param pulumi.Input[builtins.str] publisher: The name of the extension handler publisher.The name of the extension handler publisher.
        :param pulumi.Input[builtins.str] type: The type of the extensions.
        :param pulumi.Input[builtins.bool] auto_upgrade_minor_version: Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        :param pulumi.Input[builtins.bool] automatic_upgrade_enabled: Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available. Supported values are `true` and `false`.
               
               > **Note:** When `automatic_upgrade_enabled` is set to `true`, the `type_handler_version` is automatically updated by the Azure platform when a new version is available and any change in `type_handler_version` should be manually ignored by user.
        :param pulumi.Input[builtins.str] protected_settings: JSON formatted protected settings for the extension, the value should be encoded with `jsonencode` function. The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] provision_after_extensions: The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        :param pulumi.Input[builtins.str] settings_json: JSON formatted public settings for the extension, the value should be encoded with `jsonencode` function.
        :param pulumi.Input[builtins.str] type_handler_version: The version of script handler.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings_json is not None:
            pulumi.set(__self__, "settings_json", settings_json)
        if type_handler_version is not None:
            pulumi.set(__self__, "type_handler_version", type_handler_version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the virtual machine extension.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Input[builtins.str]:
        """
        The name of the extension handler publisher.The name of the extension handler publisher.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the extensions.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @auto_upgrade_minor_version.setter
    def auto_upgrade_minor_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_upgrade_minor_version", value)

    @property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available. Supported values are `true` and `false`.

        > **Note:** When `automatic_upgrade_enabled` is set to `true`, the `type_handler_version` is automatically updated by the Azure platform when a new version is available and any change in `type_handler_version` should be manually ignored by user.
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @automatic_upgrade_enabled.setter
    def automatic_upgrade_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automatic_upgrade_enabled", value)

    @property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON formatted protected settings for the extension, the value should be encoded with `jsonencode` function. The extension can contain either `protected_settings` or `provision_after_extensions` or no protected settings at all.
        """
        return pulumi.get(self, "protected_settings")

    @protected_settings.setter
    def protected_settings(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protected_settings", value)

    @property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The collection of extension names. Collection of extension names after which this extension needs to be provisioned.
        """
        return pulumi.get(self, "provision_after_extensions")

    @provision_after_extensions.setter
    def provision_after_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "provision_after_extensions", value)

    @property
    @pulumi.getter(name="settingsJson")
    def settings_json(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        JSON formatted public settings for the extension, the value should be encoded with `jsonencode` function.
        """
        return pulumi.get(self, "settings_json")

    @settings_json.setter
    def settings_json(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "settings_json", value)

    @property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of script handler.
        """
        return pulumi.get(self, "type_handler_version")

    @type_handler_version.setter
    def type_handler_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type_handler_version", value)


if not MYPY:
    class PoolFixedScaleArgsDict(TypedDict):
        node_deallocation_method: NotRequired[pulumi.Input[builtins.str]]
        """
        It determines what to do with a node and its running task(s) if the pool size is decreasing. Values are `Requeue`, `RetainedData`, `TaskCompletion` and `Terminate`.
        """
        resize_timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        The timeout for resize operations. Defaults to `PT15M`.
        """
        target_dedicated_nodes: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of nodes in the Batch pool. Defaults to `1`.
        """
        target_low_priority_nodes: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of low priority nodes in the Batch pool. Defaults to `0`.
        """
elif False:
    PoolFixedScaleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolFixedScaleArgs:
    def __init__(__self__, *,
                 node_deallocation_method: Optional[pulumi.Input[builtins.str]] = None,
                 resize_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 target_dedicated_nodes: Optional[pulumi.Input[builtins.int]] = None,
                 target_low_priority_nodes: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] node_deallocation_method: It determines what to do with a node and its running task(s) if the pool size is decreasing. Values are `Requeue`, `RetainedData`, `TaskCompletion` and `Terminate`.
        :param pulumi.Input[builtins.str] resize_timeout: The timeout for resize operations. Defaults to `PT15M`.
        :param pulumi.Input[builtins.int] target_dedicated_nodes: The number of nodes in the Batch pool. Defaults to `1`.
        :param pulumi.Input[builtins.int] target_low_priority_nodes: The number of low priority nodes in the Batch pool. Defaults to `0`.
        """
        if node_deallocation_method is not None:
            pulumi.set(__self__, "node_deallocation_method", node_deallocation_method)
        if resize_timeout is not None:
            pulumi.set(__self__, "resize_timeout", resize_timeout)
        if target_dedicated_nodes is not None:
            pulumi.set(__self__, "target_dedicated_nodes", target_dedicated_nodes)
        if target_low_priority_nodes is not None:
            pulumi.set(__self__, "target_low_priority_nodes", target_low_priority_nodes)

    @property
    @pulumi.getter(name="nodeDeallocationMethod")
    def node_deallocation_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        It determines what to do with a node and its running task(s) if the pool size is decreasing. Values are `Requeue`, `RetainedData`, `TaskCompletion` and `Terminate`.
        """
        return pulumi.get(self, "node_deallocation_method")

    @node_deallocation_method.setter
    def node_deallocation_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_deallocation_method", value)

    @property
    @pulumi.getter(name="resizeTimeout")
    def resize_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The timeout for resize operations. Defaults to `PT15M`.
        """
        return pulumi.get(self, "resize_timeout")

    @resize_timeout.setter
    def resize_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resize_timeout", value)

    @property
    @pulumi.getter(name="targetDedicatedNodes")
    def target_dedicated_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes in the Batch pool. Defaults to `1`.
        """
        return pulumi.get(self, "target_dedicated_nodes")

    @target_dedicated_nodes.setter
    def target_dedicated_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "target_dedicated_nodes", value)

    @property
    @pulumi.getter(name="targetLowPriorityNodes")
    def target_low_priority_nodes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of low priority nodes in the Batch pool. Defaults to `0`.
        """
        return pulumi.get(self, "target_low_priority_nodes")

    @target_low_priority_nodes.setter
    def target_low_priority_nodes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "target_low_priority_nodes", value)


if not MYPY:
    class PoolIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
        """
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Batch Account. Only possible value is `UserAssigned`.
        """
elif False:
    PoolIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Batch Account. Only possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Batch Account.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Batch Account. Only possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class PoolMountArgsDict(TypedDict):
        azure_blob_file_system: NotRequired[pulumi.Input['PoolMountAzureBlobFileSystemArgsDict']]
        """
        A `azure_blob_file_system` block defined as below.
        """
        azure_file_shares: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolMountAzureFileShareArgsDict']]]]
        """
        A `azure_file_share` block defined as below.
        """
        cifs_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolMountCifsMountArgsDict']]]]
        """
        A `cifs_mount` block defined as below.
        """
        nfs_mounts: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolMountNfsMountArgsDict']]]]
        """
        A `nfs_mount` block defined as below.
        """
elif False:
    PoolMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolMountArgs:
    def __init__(__self__, *,
                 azure_blob_file_system: Optional[pulumi.Input['PoolMountAzureBlobFileSystemArgs']] = None,
                 azure_file_shares: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountAzureFileShareArgs']]]] = None,
                 cifs_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountCifsMountArgs']]]] = None,
                 nfs_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountNfsMountArgs']]]] = None):
        """
        :param pulumi.Input['PoolMountAzureBlobFileSystemArgs'] azure_blob_file_system: A `azure_blob_file_system` block defined as below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolMountAzureFileShareArgs']]] azure_file_shares: A `azure_file_share` block defined as below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolMountCifsMountArgs']]] cifs_mounts: A `cifs_mount` block defined as below.
        :param pulumi.Input[Sequence[pulumi.Input['PoolMountNfsMountArgs']]] nfs_mounts: A `nfs_mount` block defined as below.
        """
        if azure_blob_file_system is not None:
            pulumi.set(__self__, "azure_blob_file_system", azure_blob_file_system)
        if azure_file_shares is not None:
            pulumi.set(__self__, "azure_file_shares", azure_file_shares)
        if cifs_mounts is not None:
            pulumi.set(__self__, "cifs_mounts", cifs_mounts)
        if nfs_mounts is not None:
            pulumi.set(__self__, "nfs_mounts", nfs_mounts)

    @property
    @pulumi.getter(name="azureBlobFileSystem")
    def azure_blob_file_system(self) -> Optional[pulumi.Input['PoolMountAzureBlobFileSystemArgs']]:
        """
        A `azure_blob_file_system` block defined as below.
        """
        return pulumi.get(self, "azure_blob_file_system")

    @azure_blob_file_system.setter
    def azure_blob_file_system(self, value: Optional[pulumi.Input['PoolMountAzureBlobFileSystemArgs']]):
        pulumi.set(self, "azure_blob_file_system", value)

    @property
    @pulumi.getter(name="azureFileShares")
    def azure_file_shares(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountAzureFileShareArgs']]]]:
        """
        A `azure_file_share` block defined as below.
        """
        return pulumi.get(self, "azure_file_shares")

    @azure_file_shares.setter
    def azure_file_shares(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountAzureFileShareArgs']]]]):
        pulumi.set(self, "azure_file_shares", value)

    @property
    @pulumi.getter(name="cifsMounts")
    def cifs_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountCifsMountArgs']]]]:
        """
        A `cifs_mount` block defined as below.
        """
        return pulumi.get(self, "cifs_mounts")

    @cifs_mounts.setter
    def cifs_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountCifsMountArgs']]]]):
        pulumi.set(self, "cifs_mounts", value)

    @property
    @pulumi.getter(name="nfsMounts")
    def nfs_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountNfsMountArgs']]]]:
        """
        A `nfs_mount` block defined as below.
        """
        return pulumi.get(self, "nfs_mounts")

    @nfs_mounts.setter
    def nfs_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolMountNfsMountArgs']]]]):
        pulumi.set(self, "nfs_mounts", value)


if not MYPY:
    class PoolMountAzureBlobFileSystemArgsDict(TypedDict):
        account_name: pulumi.Input[builtins.str]
        """
        The Azure Storage Account name.
        """
        container_name: pulumi.Input[builtins.str]
        """
        The Azure Blob Storage Container name.
        """
        relative_mount_path: pulumi.Input[builtins.str]
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        account_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The Azure Storage Account key. This property is mutually exclusive with both `sas_key` and `identity_id`; exactly one must be specified.
        """
        blobfuse_options: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        """
        sas_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
elif False:
    PoolMountAzureBlobFileSystemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolMountAzureBlobFileSystemArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[builtins.str],
                 container_name: pulumi.Input[builtins.str],
                 relative_mount_path: pulumi.Input[builtins.str],
                 account_key: Optional[pulumi.Input[builtins.str]] = None,
                 blobfuse_options: Optional[pulumi.Input[builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 sas_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] account_name: The Azure Storage Account name.
        :param pulumi.Input[builtins.str] container_name: The Azure Blob Storage Container name.
        :param pulumi.Input[builtins.str] relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param pulumi.Input[builtins.str] account_key: The Azure Storage Account key. This property is mutually exclusive with both `sas_key` and `identity_id`; exactly one must be specified.
        :param pulumi.Input[builtins.str] blobfuse_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        :param pulumi.Input[builtins.str] identity_id: The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        :param pulumi.Input[builtins.str] sas_key: The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if account_key is not None:
            pulumi.set(__self__, "account_key", account_key)
        if blobfuse_options is not None:
            pulumi.set(__self__, "blobfuse_options", blobfuse_options)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if sas_key is not None:
            pulumi.set(__self__, "sas_key", sas_key)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Storage Account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Blob Storage Container name.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_name", value)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[builtins.str]:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Storage Account key. This property is mutually exclusive with both `sas_key` and `identity_id`; exactly one must be specified.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="blobfuseOptions")
    def blobfuse_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "blobfuse_options")

    @blobfuse_options.setter
    def blobfuse_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blobfuse_options", value)

    @property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM resource id of the user assigned identity. This property is mutually exclusive with both `account_key` and `sas_key`; exactly one must be specified.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @property
    @pulumi.getter(name="sasKey")
    def sas_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Storage SAS token. This property is mutually exclusive with both `account_key` and `identity_id`; exactly one must be specified.
        """
        return pulumi.get(self, "sas_key")

    @sas_key.setter
    def sas_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sas_key", value)


if not MYPY:
    class PoolMountAzureFileShareArgsDict(TypedDict):
        account_key: pulumi.Input[builtins.str]
        """
        The Azure Storage Account key.
        """
        account_name: pulumi.Input[builtins.str]
        """
        The Azure Storage Account name.
        """
        azure_file_url: pulumi.Input[builtins.str]
        """
        The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        """
        relative_mount_path: pulumi.Input[builtins.str]
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        mount_options: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
elif False:
    PoolMountAzureFileShareArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolMountAzureFileShareArgs:
    def __init__(__self__, *,
                 account_key: pulumi.Input[builtins.str],
                 account_name: pulumi.Input[builtins.str],
                 azure_file_url: pulumi.Input[builtins.str],
                 relative_mount_path: pulumi.Input[builtins.str],
                 mount_options: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] account_key: The Azure Storage Account key.
        :param pulumi.Input[builtins.str] account_name: The Azure Storage Account name.
        :param pulumi.Input[builtins.str] azure_file_url: The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        :param pulumi.Input[builtins.str] relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param pulumi.Input[builtins.str] mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "account_key", account_key)
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "azure_file_url", azure_file_url)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="accountKey")
    def account_key(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Storage Account key.
        """
        return pulumi.get(self, "account_key")

    @account_key.setter
    def account_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_key", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Storage Account name.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="azureFileUrl")
    def azure_file_url(self) -> pulumi.Input[builtins.str]:
        """
        The Azure Files URL. This is of the form 'https://{account}.file.core.windows.net/'.
        """
        return pulumi.get(self, "azure_file_url")

    @azure_file_url.setter
    def azure_file_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "azure_file_url", value)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[builtins.str]:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class PoolMountCifsMountArgsDict(TypedDict):
        password: pulumi.Input[builtins.str]
        """
        The password to use for authentication against the CIFS file system.
        """
        relative_mount_path: pulumi.Input[builtins.str]
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        source: pulumi.Input[builtins.str]
        """
        The URI of the file system to mount.
        """
        user_name: pulumi.Input[builtins.str]
        """
        The user to use for authentication against the CIFS file system.
        """
        mount_options: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
elif False:
    PoolMountCifsMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolMountCifsMountArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[builtins.str],
                 relative_mount_path: pulumi.Input[builtins.str],
                 source: pulumi.Input[builtins.str],
                 user_name: pulumi.Input[builtins.str],
                 mount_options: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] password: The password to use for authentication against the CIFS file system.
        :param pulumi.Input[builtins.str] relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param pulumi.Input[builtins.str] source: The URI of the file system to mount.
        :param pulumi.Input[builtins.str] user_name: The user to use for authentication against the CIFS file system.
        :param pulumi.Input[builtins.str] mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "user_name", user_name)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[builtins.str]:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the file system to mount.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[builtins.str]:
        """
        The user to use for authentication against the CIFS file system.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class PoolMountNfsMountArgsDict(TypedDict):
        relative_mount_path: pulumi.Input[builtins.str]
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        source: pulumi.Input[builtins.str]
        """
        The URI of the file system to mount.
        """
        mount_options: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
elif False:
    PoolMountNfsMountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolMountNfsMountArgs:
    def __init__(__self__, *,
                 relative_mount_path: pulumi.Input[builtins.str],
                 source: pulumi.Input[builtins.str],
                 mount_options: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] relative_mount_path: The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        :param pulumi.Input[builtins.str] source: The URI of the file system to mount.
        :param pulumi.Input[builtins.str] mount_options: Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        pulumi.set(__self__, "relative_mount_path", relative_mount_path)
        pulumi.set(__self__, "source", source)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="relativeMountPath")
    def relative_mount_path(self) -> pulumi.Input[builtins.str]:
        """
        The relative path on compute node where the file system will be mounted All file systems are mounted relative to the Batch mounts directory, accessible via the `AZ_BATCH_NODE_MOUNTS_DIR` environment variable.
        """
        return pulumi.get(self, "relative_mount_path")

    @relative_mount_path.setter
    def relative_mount_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "relative_mount_path", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the file system to mount.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional command line options to pass to the mount command. These are 'net use' options in Windows and 'mount' options in Linux.
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mount_options", value)


if not MYPY:
    class PoolNetworkConfigurationArgsDict(TypedDict):
        accelerated_networking_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable accelerated networking. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        dynamic_vnet_assignment_scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The scope of dynamic vnet assignment. Allowed values: `none`, `job`. Changing this forces a new resource to be created. Defaults to `none`.
        """
        endpoint_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationArgsDict']]]]
        """
        A list of `endpoint_configuration` blocks that can be used to address specific ports on an individual compute node externally as defined below. Set as documented in the inbound_nat_pools block below. Changing this forces a new resource to be created.
        """
        public_address_provisioning_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Type of public IP address provisioning. Supported values are `BatchManaged`, `UserManaged` and `NoPublicIPAddresses`.
        """
        public_ips: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of public IP ids that will be allocated to nodes. Changing this forces a new resource to be created.
        """
        subnet_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARM resource identifier of the virtual network subnet which the compute nodes of the pool will join. Changing this forces a new resource to be created.
        """
elif False:
    PoolNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolNetworkConfigurationArgs:
    def __init__(__self__, *,
                 accelerated_networking_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 dynamic_vnet_assignment_scope: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationArgs']]]] = None,
                 public_address_provisioning_type: Optional[pulumi.Input[builtins.str]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.bool] accelerated_networking_enabled: Whether to enable accelerated networking. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] dynamic_vnet_assignment_scope: The scope of dynamic vnet assignment. Allowed values: `none`, `job`. Changing this forces a new resource to be created. Defaults to `none`.
        :param pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationArgs']]] endpoint_configurations: A list of `endpoint_configuration` blocks that can be used to address specific ports on an individual compute node externally as defined below. Set as documented in the inbound_nat_pools block below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] public_address_provisioning_type: Type of public IP address provisioning. Supported values are `BatchManaged`, `UserManaged` and `NoPublicIPAddresses`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] public_ips: A list of public IP ids that will be allocated to nodes. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_id: The ARM resource identifier of the virtual network subnet which the compute nodes of the pool will join. Changing this forces a new resource to be created.
        """
        if accelerated_networking_enabled is not None:
            pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        if dynamic_vnet_assignment_scope is not None:
            pulumi.set(__self__, "dynamic_vnet_assignment_scope", dynamic_vnet_assignment_scope)
        if endpoint_configurations is not None:
            pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        if public_address_provisioning_type is not None:
            pulumi.set(__self__, "public_address_provisioning_type", public_address_provisioning_type)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable accelerated networking. Possible values are `true` and `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @accelerated_networking_enabled.setter
    def accelerated_networking_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accelerated_networking_enabled", value)

    @property
    @pulumi.getter(name="dynamicVnetAssignmentScope")
    def dynamic_vnet_assignment_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of dynamic vnet assignment. Allowed values: `none`, `job`. Changing this forces a new resource to be created. Defaults to `none`.
        """
        return pulumi.get(self, "dynamic_vnet_assignment_scope")

    @dynamic_vnet_assignment_scope.setter
    def dynamic_vnet_assignment_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dynamic_vnet_assignment_scope", value)

    @property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationArgs']]]]:
        """
        A list of `endpoint_configuration` blocks that can be used to address specific ports on an individual compute node externally as defined below. Set as documented in the inbound_nat_pools block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "endpoint_configurations")

    @endpoint_configurations.setter
    def endpoint_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationArgs']]]]):
        pulumi.set(self, "endpoint_configurations", value)

    @property
    @pulumi.getter(name="publicAddressProvisioningType")
    def public_address_provisioning_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of public IP address provisioning. Supported values are `BatchManaged`, `UserManaged` and `NoPublicIPAddresses`.
        """
        return pulumi.get(self, "public_address_provisioning_type")

    @public_address_provisioning_type.setter
    def public_address_provisioning_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_address_provisioning_type", value)

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of public IP ids that will be allocated to nodes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM resource identifier of the virtual network subnet which the compute nodes of the pool will join. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class PoolNetworkConfigurationEndpointConfigurationArgsDict(TypedDict):
        backend_port: pulumi.Input[builtins.int]
        """
        The port number on the compute node. Acceptable values are between `1` and `65535` except for `29876`, `29877` as these are reserved. Changing this forces a new resource to be created.
        """
        frontend_port_range: pulumi.Input[builtins.str]
        """
        The range of external ports that will be used to provide inbound access to the backendPort on individual compute nodes in the format of `1000-1100`. Acceptable values range between `1` and `65534` except ports from `50000` to `55000` which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. Values must be a range of at least `100` nodes. Changing this forces a new resource to be created.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the endpoint. The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters. Changing this forces a new resource to be created.
        """
        protocol: pulumi.Input[builtins.str]
        """
        The protocol of the endpoint. Acceptable values are `TCP` and `UDP`. Changing this forces a new resource to be created.
        """
        network_security_group_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgsDict']]]]
        """
        A list of `network_security_group_rules` blocks as defined below that will be applied to the endpoint. The maximum number of rules that can be specified across all the endpoints on a Batch pool is `25`. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. Set as documented in the network_security_group_rules block below. Changing this forces a new resource to be created.
        """
elif False:
    PoolNetworkConfigurationEndpointConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolNetworkConfigurationEndpointConfigurationArgs:
    def __init__(__self__, *,
                 backend_port: pulumi.Input[builtins.int],
                 frontend_port_range: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 network_security_group_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs']]]] = None):
        """
        :param pulumi.Input[builtins.int] backend_port: The port number on the compute node. Acceptable values are between `1` and `65535` except for `29876`, `29877` as these are reserved. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] frontend_port_range: The range of external ports that will be used to provide inbound access to the backendPort on individual compute nodes in the format of `1000-1100`. Acceptable values range between `1` and `65534` except ports from `50000` to `55000` which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. Values must be a range of at least `100` nodes. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the endpoint. The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] protocol: The protocol of the endpoint. Acceptable values are `TCP` and `UDP`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs']]] network_security_group_rules: A list of `network_security_group_rules` blocks as defined below that will be applied to the endpoint. The maximum number of rules that can be specified across all the endpoints on a Batch pool is `25`. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. Set as documented in the network_security_group_rules block below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "frontend_port_range", frontend_port_range)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        if network_security_group_rules is not None:
            pulumi.set(__self__, "network_security_group_rules", network_security_group_rules)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> pulumi.Input[builtins.int]:
        """
        The port number on the compute node. Acceptable values are between `1` and `65535` except for `29876`, `29877` as these are reserved. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backend_port")

    @backend_port.setter
    def backend_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "backend_port", value)

    @property
    @pulumi.getter(name="frontendPortRange")
    def frontend_port_range(self) -> pulumi.Input[builtins.str]:
        """
        The range of external ports that will be used to provide inbound access to the backendPort on individual compute nodes in the format of `1000-1100`. Acceptable values range between `1` and `65534` except ports from `50000` to `55000` which are reserved by the Batch service. All ranges within a pool must be distinct and cannot overlap. Values must be a range of at least `100` nodes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "frontend_port_range")

    @frontend_port_range.setter
    def frontend_port_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "frontend_port_range", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the endpoint. The name must be unique within a Batch pool, can contain letters, numbers, underscores, periods, and hyphens. Names must start with a letter or number, must end with a letter, number, or underscore, and cannot exceed 77 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The protocol of the endpoint. Acceptable values are `TCP` and `UDP`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="networkSecurityGroupRules")
    def network_security_group_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs']]]]:
        """
        A list of `network_security_group_rules` blocks as defined below that will be applied to the endpoint. The maximum number of rules that can be specified across all the endpoints on a Batch pool is `25`. If no network security group rules are specified, a default rule will be created to allow inbound access to the specified backendPort. Set as documented in the network_security_group_rules block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_security_group_rules")

    @network_security_group_rules.setter
    def network_security_group_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs']]]]):
        pulumi.set(self, "network_security_group_rules", value)


if not MYPY:
    class PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgsDict(TypedDict):
        access: pulumi.Input[builtins.str]
        """
        The action that should be taken for a specified IP address, subnet range or tag. Acceptable values are `Allow` and `Deny`. Changing this forces a new resource to be created.
        """
        priority: pulumi.Input[builtins.int]
        """
        The priority for this rule. The value must be at least `150`. Changing this forces a new resource to be created.
        """
        source_address_prefix: pulumi.Input[builtins.str]
        """
        The source address prefix or tag to match for the rule. Changing this forces a new resource to be created.
        """
        source_port_ranges: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The source port ranges to match for the rule. Valid values are `*` (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. `100-200`). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be `*`. Changing this forces a new resource to be created.
        """
elif False:
    PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolNetworkConfigurationEndpointConfigurationNetworkSecurityGroupRuleArgs:
    def __init__(__self__, *,
                 access: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int],
                 source_address_prefix: pulumi.Input[builtins.str],
                 source_port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] access: The action that should be taken for a specified IP address, subnet range or tag. Acceptable values are `Allow` and `Deny`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] priority: The priority for this rule. The value must be at least `150`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_address_prefix: The source address prefix or tag to match for the rule. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_port_ranges: The source port ranges to match for the rule. Valid values are `*` (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. `100-200`). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be `*`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "access", access)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_address_prefix", source_address_prefix)
        if source_port_ranges is not None:
            pulumi.set(__self__, "source_port_ranges", source_port_ranges)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Input[builtins.str]:
        """
        The action that should be taken for a specified IP address, subnet range or tag. Acceptable values are `Allow` and `Deny`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        The priority for this rule. The value must be at least `150`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceAddressPrefix")
    def source_address_prefix(self) -> pulumi.Input[builtins.str]:
        """
        The source address prefix or tag to match for the rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_address_prefix")

    @source_address_prefix.setter
    def source_address_prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_address_prefix", value)

    @property
    @pulumi.getter(name="sourcePortRanges")
    def source_port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The source port ranges to match for the rule. Valid values are `*` (for all ports 0 - 65535) or arrays of ports or port ranges (i.e. `100-200`). The ports should in the range of 0 to 65535 and the port ranges or ports can't overlap. If any other values are provided the request fails with HTTP status code 400. Default value will be `*`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_port_ranges")

    @source_port_ranges.setter
    def source_port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_port_ranges", value)


if not MYPY:
    class PoolNodePlacementArgsDict(TypedDict):
        policy: NotRequired[pulumi.Input[builtins.str]]
        """
        The placement policy for allocating nodes in the pool. Values are: "Regional": All nodes in the pool will be allocated in the same region; "Zonal": Nodes in the pool will be spread across different zones with the best effort balancing. Defaults to `Regional`.
        """
elif False:
    PoolNodePlacementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolNodePlacementArgs:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] policy: The placement policy for allocating nodes in the pool. Values are: "Regional": All nodes in the pool will be allocated in the same region; "Zonal": Nodes in the pool will be spread across different zones with the best effort balancing. Defaults to `Regional`.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The placement policy for allocating nodes in the pool. Values are: "Regional": All nodes in the pool will be allocated in the same region; "Zonal": Nodes in the pool will be spread across different zones with the best effort balancing. Defaults to `Regional`.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy", value)


if not MYPY:
    class PoolSecurityProfileArgsDict(TypedDict):
        host_encryption_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable host encryption for the Virtual Machine or Virtual Machine Scale Set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        """
        secure_boot_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable secure boot for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        """
        security_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The security type of the Virtual Machine. Possible values are `confidentialVM` and `trustedLaunch`. Changing this forces a new resource to be created.
        """
        vtpm_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to enable virtual trusted platform module (vTPM) for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.

        > **Note:** `security_profile` block can only be specified during creation and does not support updates.

        > **Note:** `security_type` must be specified to set UEFI related properties including `secure_boot_enabled` and `vtpm_enabled`.
        """
elif False:
    PoolSecurityProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolSecurityProfileArgs:
    def __init__(__self__, *,
                 host_encryption_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 secure_boot_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 security_type: Optional[pulumi.Input[builtins.str]] = None,
                 vtpm_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] host_encryption_enabled: Whether to enable host encryption for the Virtual Machine or Virtual Machine Scale Set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] secure_boot_enabled: Whether to enable secure boot for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] security_type: The security type of the Virtual Machine. Possible values are `confidentialVM` and `trustedLaunch`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] vtpm_enabled: Whether to enable virtual trusted platform module (vTPM) for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
               
               > **Note:** `security_profile` block can only be specified during creation and does not support updates.
               
               > **Note:** `security_type` must be specified to set UEFI related properties including `secure_boot_enabled` and `vtpm_enabled`.
        """
        if host_encryption_enabled is not None:
            pulumi.set(__self__, "host_encryption_enabled", host_encryption_enabled)
        if secure_boot_enabled is not None:
            pulumi.set(__self__, "secure_boot_enabled", secure_boot_enabled)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if vtpm_enabled is not None:
            pulumi.set(__self__, "vtpm_enabled", vtpm_enabled)

    @property
    @pulumi.getter(name="hostEncryptionEnabled")
    def host_encryption_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable host encryption for the Virtual Machine or Virtual Machine Scale Set. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host_encryption_enabled")

    @host_encryption_enabled.setter
    def host_encryption_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "host_encryption_enabled", value)

    @property
    @pulumi.getter(name="secureBootEnabled")
    def secure_boot_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable secure boot for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secure_boot_enabled")

    @secure_boot_enabled.setter
    def secure_boot_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "secure_boot_enabled", value)

    @property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The security type of the Virtual Machine. Possible values are `confidentialVM` and `trustedLaunch`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_type", value)

    @property
    @pulumi.getter(name="vtpmEnabled")
    def vtpm_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable virtual trusted platform module (vTPM) for the Virtual Machine or Virtual Machine Scale Set. Possible values are `true` and `false`. Changing this forces a new resource to be created.

        > **Note:** `security_profile` block can only be specified during creation and does not support updates.

        > **Note:** `security_type` must be specified to set UEFI related properties including `secure_boot_enabled` and `vtpm_enabled`.
        """
        return pulumi.get(self, "vtpm_enabled")

    @vtpm_enabled.setter
    def vtpm_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "vtpm_enabled", value)


if not MYPY:
    class PoolStartTaskArgsDict(TypedDict):
        command_line: pulumi.Input[builtins.str]
        """
        The command line executed by the start task.
        """
        user_identity: pulumi.Input['PoolStartTaskUserIdentityArgsDict']
        """
        A `user_identity` block that describes the user identity under which the start task runs as defined below.
        """
        common_environment_properties: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A map of strings (key,value) that represents the environment variables to set in the start task.
        """
        containers: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerArgsDict']]]]
        """
        A `container` block is the settings for the container under which the start task runs as defined below. When this is specified, all directories recursively below the `AZ_BATCH_NODE_ROOT_DIR` (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        """
        resource_files: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskResourceFileArgsDict']]]]
        """
        One or more `resource_file` blocks that describe the files to be downloaded to a compute node as defined below.
        """
        task_retry_maximum: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of retry count.
        """
        wait_for_success: NotRequired[pulumi.Input[builtins.bool]]
        """
        A flag that indicates if the Batch pool should wait for the start task to be completed. Default to `false`.
        """
elif False:
    PoolStartTaskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStartTaskArgs:
    def __init__(__self__, *,
                 command_line: pulumi.Input[builtins.str],
                 user_identity: pulumi.Input['PoolStartTaskUserIdentityArgs'],
                 common_environment_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerArgs']]]] = None,
                 resource_files: Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskResourceFileArgs']]]] = None,
                 task_retry_maximum: Optional[pulumi.Input[builtins.int]] = None,
                 wait_for_success: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] command_line: The command line executed by the start task.
        :param pulumi.Input['PoolStartTaskUserIdentityArgs'] user_identity: A `user_identity` block that describes the user identity under which the start task runs as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] common_environment_properties: A map of strings (key,value) that represents the environment variables to set in the start task.
        :param pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerArgs']]] containers: A `container` block is the settings for the container under which the start task runs as defined below. When this is specified, all directories recursively below the `AZ_BATCH_NODE_ROOT_DIR` (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        :param pulumi.Input[Sequence[pulumi.Input['PoolStartTaskResourceFileArgs']]] resource_files: One or more `resource_file` blocks that describe the files to be downloaded to a compute node as defined below.
        :param pulumi.Input[builtins.int] task_retry_maximum: The number of retry count.
        :param pulumi.Input[builtins.bool] wait_for_success: A flag that indicates if the Batch pool should wait for the start task to be completed. Default to `false`.
        """
        pulumi.set(__self__, "command_line", command_line)
        pulumi.set(__self__, "user_identity", user_identity)
        if common_environment_properties is not None:
            pulumi.set(__self__, "common_environment_properties", common_environment_properties)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if resource_files is not None:
            pulumi.set(__self__, "resource_files", resource_files)
        if task_retry_maximum is not None:
            pulumi.set(__self__, "task_retry_maximum", task_retry_maximum)
        if wait_for_success is not None:
            pulumi.set(__self__, "wait_for_success", wait_for_success)

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> pulumi.Input[builtins.str]:
        """
        The command line executed by the start task.
        """
        return pulumi.get(self, "command_line")

    @command_line.setter
    def command_line(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "command_line", value)

    @property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> pulumi.Input['PoolStartTaskUserIdentityArgs']:
        """
        A `user_identity` block that describes the user identity under which the start task runs as defined below.
        """
        return pulumi.get(self, "user_identity")

    @user_identity.setter
    def user_identity(self, value: pulumi.Input['PoolStartTaskUserIdentityArgs']):
        pulumi.set(self, "user_identity", value)

    @property
    @pulumi.getter(name="commonEnvironmentProperties")
    def common_environment_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of strings (key,value) that represents the environment variables to set in the start task.
        """
        return pulumi.get(self, "common_environment_properties")

    @common_environment_properties.setter
    def common_environment_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "common_environment_properties", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerArgs']]]]:
        """
        A `container` block is the settings for the container under which the start task runs as defined below. When this is specified, all directories recursively below the `AZ_BATCH_NODE_ROOT_DIR` (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="resourceFiles")
    def resource_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskResourceFileArgs']]]]:
        """
        One or more `resource_file` blocks that describe the files to be downloaded to a compute node as defined below.
        """
        return pulumi.get(self, "resource_files")

    @resource_files.setter
    def resource_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskResourceFileArgs']]]]):
        pulumi.set(self, "resource_files", value)

    @property
    @pulumi.getter(name="taskRetryMaximum")
    def task_retry_maximum(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of retry count.
        """
        return pulumi.get(self, "task_retry_maximum")

    @task_retry_maximum.setter
    def task_retry_maximum(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "task_retry_maximum", value)

    @property
    @pulumi.getter(name="waitForSuccess")
    def wait_for_success(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A flag that indicates if the Batch pool should wait for the start task to be completed. Default to `false`.
        """
        return pulumi.get(self, "wait_for_success")

    @wait_for_success.setter
    def wait_for_success(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wait_for_success", value)


if not MYPY:
    class PoolStartTaskContainerArgsDict(TypedDict):
        image_name: pulumi.Input[builtins.str]
        """
        The image to use to create the container in which the task will run. This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        """
        registries: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerRegistryArgsDict']]]]
        """
        The `container_registries` block defined as below.
        """
        run_options: NotRequired[pulumi.Input[builtins.str]]
        """
        Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        """
        working_directory: NotRequired[pulumi.Input[builtins.str]]
        """
        A flag to indicate where the container task working directory is. Possible values are `TaskWorkingDirectory` and `ContainerImageDefault`.
        """
elif False:
    PoolStartTaskContainerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStartTaskContainerArgs:
    def __init__(__self__, *,
                 image_name: pulumi.Input[builtins.str],
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerRegistryArgs']]]] = None,
                 run_options: Optional[pulumi.Input[builtins.str]] = None,
                 working_directory: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] image_name: The image to use to create the container in which the task will run. This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        :param pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerRegistryArgs']]] registries: The `container_registries` block defined as below.
        :param pulumi.Input[builtins.str] run_options: Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        :param pulumi.Input[builtins.str] working_directory: A flag to indicate where the container task working directory is. Possible values are `TaskWorkingDirectory` and `ContainerImageDefault`.
        """
        pulumi.set(__self__, "image_name", image_name)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if run_options is not None:
            pulumi.set(__self__, "run_options", run_options)
        if working_directory is not None:
            pulumi.set(__self__, "working_directory", working_directory)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Input[builtins.str]:
        """
        The image to use to create the container in which the task will run. This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter
    def registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerRegistryArgs']]]]:
        """
        The `container_registries` block defined as below.
        """
        return pulumi.get(self, "registries")

    @registries.setter
    def registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolStartTaskContainerRegistryArgs']]]]):
        pulumi.set(self, "registries", value)

    @property
    @pulumi.getter(name="runOptions")
    def run_options(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
        """
        return pulumi.get(self, "run_options")

    @run_options.setter
    def run_options(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "run_options", value)

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A flag to indicate where the container task working directory is. Possible values are `TaskWorkingDirectory` and `ContainerImageDefault`.
        """
        return pulumi.get(self, "working_directory")

    @working_directory.setter
    def working_directory(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "working_directory", value)


if not MYPY:
    class PoolStartTaskContainerRegistryArgsDict(TypedDict):
        registry_server: pulumi.Input[builtins.str]
        """
        The container registry URL. Changing this forces a new resource to be created.
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        user_assigned_identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The User Assigned Identity to use for Container Registry access.
        """
        user_name: NotRequired[pulumi.Input[builtins.str]]
elif False:
    PoolStartTaskContainerRegistryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStartTaskContainerRegistryArgs:
    def __init__(__self__, *,
                 registry_server: pulumi.Input[builtins.str],
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] registry_server: The container registry URL. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: The User Assigned Identity to use for Container Registry access.
        """
        pulumi.set(__self__, "registry_server", registry_server)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="registryServer")
    def registry_server(self) -> pulumi.Input[builtins.str]:
        """
        The container registry URL. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "registry_server")

    @registry_server.setter
    def registry_server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "registry_server", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The User Assigned Identity to use for Container Registry access.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


if not MYPY:
    class PoolStartTaskResourceFileArgsDict(TypedDict):
        auto_storage_container_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The storage container name in the auto storage account.
        """
        blob_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs whose names begin with the specified prefix will be downloaded. The property is valid only when `auto_storage_container_name` or `storage_container_url` is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        """
        file_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        The file permission mode represented as a string in octal format (e.g. `"0644"`). This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a `resource_file` which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        """
        file_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified, `file_path` is optional and is the directory to download the files to. In the case where `file_path` is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        """
        http_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        storage_container_url: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL of the blob container within Azure Blob Storage. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        user_assigned_identity_id: NotRequired[pulumi.Input[builtins.str]]
        """
        An identity reference from pool's user assigned managed identity list.

        > **Note:** Exactly one of `auto_storage_container_name`, `storage_container_url` and `auto_user` must be specified.
        """
elif False:
    PoolStartTaskResourceFileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStartTaskResourceFileArgs:
    def __init__(__self__, *,
                 auto_storage_container_name: Optional[pulumi.Input[builtins.str]] = None,
                 blob_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 file_mode: Optional[pulumi.Input[builtins.str]] = None,
                 file_path: Optional[pulumi.Input[builtins.str]] = None,
                 http_url: Optional[pulumi.Input[builtins.str]] = None,
                 storage_container_url: Optional[pulumi.Input[builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] auto_storage_container_name: The storage container name in the auto storage account.
        :param pulumi.Input[builtins.str] blob_prefix: The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs whose names begin with the specified prefix will be downloaded. The property is valid only when `auto_storage_container_name` or `storage_container_url` is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        :param pulumi.Input[builtins.str] file_mode: The file permission mode represented as a string in octal format (e.g. `"0644"`). This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a `resource_file` which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        :param pulumi.Input[builtins.str] file_path: The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified, `file_path` is optional and is the directory to download the files to. In the case where `file_path` is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        :param pulumi.Input[builtins.str] http_url: The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param pulumi.Input[builtins.str] storage_container_url: The URL of the blob container within Azure Blob Storage. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        :param pulumi.Input[builtins.str] user_assigned_identity_id: An identity reference from pool's user assigned managed identity list.
               
               > **Note:** Exactly one of `auto_storage_container_name`, `storage_container_url` and `auto_user` must be specified.
        """
        if auto_storage_container_name is not None:
            pulumi.set(__self__, "auto_storage_container_name", auto_storage_container_name)
        if blob_prefix is not None:
            pulumi.set(__self__, "blob_prefix", blob_prefix)
        if file_mode is not None:
            pulumi.set(__self__, "file_mode", file_mode)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if http_url is not None:
            pulumi.set(__self__, "http_url", http_url)
        if storage_container_url is not None:
            pulumi.set(__self__, "storage_container_url", storage_container_url)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @property
    @pulumi.getter(name="autoStorageContainerName")
    def auto_storage_container_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage container name in the auto storage account.
        """
        return pulumi.get(self, "auto_storage_container_name")

    @auto_storage_container_name.setter
    def auto_storage_container_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_storage_container_name", value)

    @property
    @pulumi.getter(name="blobPrefix")
    def blob_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The blob prefix to use when downloading blobs from an Azure Storage container. Only the blobs whose names begin with the specified prefix will be downloaded. The property is valid only when `auto_storage_container_name` or `storage_container_url` is used. This prefix can be a partial filename or a subdirectory. If a prefix is not specified, all the files in the container will be downloaded.
        """
        return pulumi.get(self, "blob_prefix")

    @blob_prefix.setter
    def blob_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blob_prefix", value)

    @property
    @pulumi.getter(name="fileMode")
    def file_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The file permission mode represented as a string in octal format (e.g. `"0644"`). This property applies only to files being downloaded to Linux compute nodes. It will be ignored if it is specified for a `resource_file` which will be downloaded to a Windows node. If this property is not specified for a Linux node, then a default value of 0770 is applied to the file.
        """
        return pulumi.get(self, "file_mode")

    @file_mode.setter
    def file_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_mode", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location on the compute node to which to download the file, relative to the task's working directory. If the `http_url` property is specified, the `file_path` is required and describes the path which the file will be downloaded to, including the filename. Otherwise, if the `auto_storage_container_name` or `storage_container_url` property is specified, `file_path` is optional and is the directory to download the files to. In the case where `file_path` is used as a directory, any directory structure already associated with the input data will be retained in full and appended to the specified filePath directory. The specified relative path cannot break out of the task's working directory (for example by using '..').
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter(name="httpUrl")
    def http_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the file to download. If the URL is Azure Blob Storage, it must be readable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "http_url")

    @http_url.setter
    def http_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_url", value)

    @property
    @pulumi.getter(name="storageContainerUrl")
    def storage_container_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the blob container within Azure Blob Storage. This URL must be readable and listable using anonymous access; that is, the Batch service does not present any credentials when downloading the blob. There are two ways to get such a URL for a blob in Azure storage: include a Shared Access Signature (SAS) granting read and list permissions on the blob, or set the ACL for the blob or its container to allow public access.
        """
        return pulumi.get(self, "storage_container_url")

    @storage_container_url.setter
    def storage_container_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_container_url", value)

    @property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An identity reference from pool's user assigned managed identity list.

        > **Note:** Exactly one of `auto_storage_container_name`, `storage_container_url` and `auto_user` must be specified.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


if not MYPY:
    class PoolStartTaskUserIdentityArgsDict(TypedDict):
        auto_user: NotRequired[pulumi.Input['PoolStartTaskUserIdentityAutoUserArgsDict']]
        """
        A `auto_user` block that describes the user identity under which the start task runs as defined below.

        > **Note:** `user_name` and `auto_user` blocks cannot be used both at the same time, but you need to define one or the other.
        """
        user_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The username to be used by the Batch pool start task.
        """
elif False:
    PoolStartTaskUserIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStartTaskUserIdentityArgs:
    def __init__(__self__, *,
                 auto_user: Optional[pulumi.Input['PoolStartTaskUserIdentityAutoUserArgs']] = None,
                 user_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['PoolStartTaskUserIdentityAutoUserArgs'] auto_user: A `auto_user` block that describes the user identity under which the start task runs as defined below.
               
               > **Note:** `user_name` and `auto_user` blocks cannot be used both at the same time, but you need to define one or the other.
        :param pulumi.Input[builtins.str] user_name: The username to be used by the Batch pool start task.
        """
        if auto_user is not None:
            pulumi.set(__self__, "auto_user", auto_user)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="autoUser")
    def auto_user(self) -> Optional[pulumi.Input['PoolStartTaskUserIdentityAutoUserArgs']]:
        """
        A `auto_user` block that describes the user identity under which the start task runs as defined below.

        > **Note:** `user_name` and `auto_user` blocks cannot be used both at the same time, but you need to define one or the other.
        """
        return pulumi.get(self, "auto_user")

    @auto_user.setter
    def auto_user(self, value: Optional[pulumi.Input['PoolStartTaskUserIdentityAutoUserArgs']]):
        pulumi.set(self, "auto_user", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username to be used by the Batch pool start task.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_name", value)


if not MYPY:
    class PoolStartTaskUserIdentityAutoUserArgsDict(TypedDict):
        elevation_level: NotRequired[pulumi.Input[builtins.str]]
        """
        The elevation level of the user identity under which the start task runs. Possible values are `Admin` or `NonAdmin`. Defaults to `NonAdmin`.
        """
        scope: NotRequired[pulumi.Input[builtins.str]]
        """
        The scope of the user identity under which the start task runs. Possible values are `Task` or `Pool`. Defaults to `Task`.
        """
elif False:
    PoolStartTaskUserIdentityAutoUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStartTaskUserIdentityAutoUserArgs:
    def __init__(__self__, *,
                 elevation_level: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] elevation_level: The elevation level of the user identity under which the start task runs. Possible values are `Admin` or `NonAdmin`. Defaults to `NonAdmin`.
        :param pulumi.Input[builtins.str] scope: The scope of the user identity under which the start task runs. Possible values are `Task` or `Pool`. Defaults to `Task`.
        """
        if elevation_level is not None:
            pulumi.set(__self__, "elevation_level", elevation_level)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The elevation level of the user identity under which the start task runs. Possible values are `Admin` or `NonAdmin`. Defaults to `NonAdmin`.
        """
        return pulumi.get(self, "elevation_level")

    @elevation_level.setter
    def elevation_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "elevation_level", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scope of the user identity under which the start task runs. Possible values are `Task` or `Pool`. Defaults to `Task`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


if not MYPY:
    class PoolStorageImageReferenceArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the ID of the Custom Image which the virtual machines should be created from. Changing this forces a new resource to be created. See [official documentation](https://docs.microsoft.com/azure/batch/batch-custom-images) for more details.
        """
        offer: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        publisher: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        sku: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.

        To provision a Custom Image, the following fields are applicable:
        """
elif False:
    PoolStorageImageReferenceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolStorageImageReferenceArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 offer: Optional[pulumi.Input[builtins.str]] = None,
                 publisher: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: Specifies the ID of the Custom Image which the virtual machines should be created from. Changing this forces a new resource to be created. See [official documentation](https://docs.microsoft.com/azure/batch/batch-custom-images) for more details.
        :param pulumi.Input[builtins.str] offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] version: Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.
               
               To provision a Custom Image, the following fields are applicable:
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the ID of the Custom Image which the virtual machines should be created from. Changing this forces a new resource to be created. See [official documentation](https://docs.microsoft.com/azure/batch/batch-custom-images) for more details.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.

        To provision a Custom Image, the following fields are applicable:
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class PoolTaskSchedulingPolicyArgsDict(TypedDict):
        node_fill_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Supported values are "Pack" and "Spread". "Pack" means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. "Spread" means that tasks should be assigned evenly across all nodes in the pool.
        """
elif False:
    PoolTaskSchedulingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolTaskSchedulingPolicyArgs:
    def __init__(__self__, *,
                 node_fill_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] node_fill_type: Supported values are "Pack" and "Spread". "Pack" means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. "Spread" means that tasks should be assigned evenly across all nodes in the pool.
        """
        if node_fill_type is not None:
            pulumi.set(__self__, "node_fill_type", node_fill_type)

    @property
    @pulumi.getter(name="nodeFillType")
    def node_fill_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Supported values are "Pack" and "Spread". "Pack" means as many tasks as possible (taskSlotsPerNode) should be assigned to each node in the pool before any tasks are assigned to the next node in the pool. "Spread" means that tasks should be assigned evenly across all nodes in the pool.
        """
        return pulumi.get(self, "node_fill_type")

    @node_fill_type.setter
    def node_fill_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "node_fill_type", value)


if not MYPY:
    class PoolUserAccountArgsDict(TypedDict):
        elevation_level: pulumi.Input[builtins.str]
        """
        The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        name: pulumi.Input[builtins.str]
        """
        The name of the user account.
        """
        password: pulumi.Input[builtins.str]
        """
        The password for the user account.
        """
        linux_user_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountLinuxUserConfigurationArgsDict']]]]
        """
        The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        windows_user_configurations: NotRequired[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountWindowsUserConfigurationArgsDict']]]]
        """
        The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
elif False:
    PoolUserAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolUserAccountArgs:
    def __init__(__self__, *,
                 elevation_level: pulumi.Input[builtins.str],
                 name: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 linux_user_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountLinuxUserConfigurationArgs']]]] = None,
                 windows_user_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountWindowsUserConfigurationArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] elevation_level: The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        :param pulumi.Input[builtins.str] name: The name of the user account.
        :param pulumi.Input[builtins.str] password: The password for the user account.
        :param pulumi.Input[Sequence[pulumi.Input['PoolUserAccountLinuxUserConfigurationArgs']]] linux_user_configurations: The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        :param pulumi.Input[Sequence[pulumi.Input['PoolUserAccountWindowsUserConfigurationArgs']]] windows_user_configurations: The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        pulumi.set(__self__, "elevation_level", elevation_level)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        if linux_user_configurations is not None:
            pulumi.set(__self__, "linux_user_configurations", linux_user_configurations)
        if windows_user_configurations is not None:
            pulumi.set(__self__, "windows_user_configurations", windows_user_configurations)

    @property
    @pulumi.getter(name="elevationLevel")
    def elevation_level(self) -> pulumi.Input[builtins.str]:
        """
        The elevation level of the user account. "NonAdmin" - The auto user is a standard user without elevated access. "Admin" - The auto user is a user with elevated access and operates with full Administrator permissions. The default value is nonAdmin.
        """
        return pulumi.get(self, "elevation_level")

    @elevation_level.setter
    def elevation_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "elevation_level", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the user account.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The password for the user account.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="linuxUserConfigurations")
    def linux_user_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountLinuxUserConfigurationArgs']]]]:
        """
        The `linux_user_configuration` block defined below is a linux-specific user configuration for the user account. This property is ignored if specified on a Windows pool. If not specified, the user is created with the default options.
        """
        return pulumi.get(self, "linux_user_configurations")

    @linux_user_configurations.setter
    def linux_user_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountLinuxUserConfigurationArgs']]]]):
        pulumi.set(self, "linux_user_configurations", value)

    @property
    @pulumi.getter(name="windowsUserConfigurations")
    def windows_user_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountWindowsUserConfigurationArgs']]]]:
        """
        The `windows_user_configuration` block defined below is a windows-specific user configuration for the user account. This property can only be specified if the user is on a Windows pool. If not specified and on a Windows pool, the user is created with the default options.
        """
        return pulumi.get(self, "windows_user_configurations")

    @windows_user_configurations.setter
    def windows_user_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PoolUserAccountWindowsUserConfigurationArgs']]]]):
        pulumi.set(self, "windows_user_configurations", value)


if not MYPY:
    class PoolUserAccountLinuxUserConfigurationArgsDict(TypedDict):
        gid: NotRequired[pulumi.Input[builtins.int]]
        """
        The user ID of the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        ssh_private_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The SSH private key for the user account. The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        """
        uid: NotRequired[pulumi.Input[builtins.int]]
        """
        The group ID for the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
elif False:
    PoolUserAccountLinuxUserConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolUserAccountLinuxUserConfigurationArgs:
    def __init__(__self__, *,
                 gid: Optional[pulumi.Input[builtins.int]] = None,
                 ssh_private_key: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] gid: The user ID of the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        :param pulumi.Input[builtins.str] ssh_private_key: The SSH private key for the user account. The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        :param pulumi.Input[builtins.int] uid: The group ID for the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if ssh_private_key is not None:
            pulumi.set(__self__, "ssh_private_key", ssh_private_key)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def gid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The user ID of the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the uid.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter(name="sshPrivateKey")
    def ssh_private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SSH private key for the user account. The private key must not be password protected. The private key is used to automatically configure asymmetric-key based authentication for SSH between nodes in a Linux pool when the pool's enableInterNodeCommunication property is true (it is ignored if enableInterNodeCommunication is false). It does this by placing the key pair into the user's .ssh directory. If not specified, password-less SSH is not configured between nodes (no modification of the user's .ssh directory is done).
        """
        return pulumi.get(self, "ssh_private_key")

    @ssh_private_key.setter
    def ssh_private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_private_key", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The group ID for the user account. The `uid` and `gid` properties must be specified together or not at all. If not specified the underlying operating system picks the gid.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "uid", value)


if not MYPY:
    class PoolUserAccountWindowsUserConfigurationArgsDict(TypedDict):
        login_mode: pulumi.Input[builtins.str]
        """
        Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode. Values supported are "Batch" and "Interactive".
        """
elif False:
    PoolUserAccountWindowsUserConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolUserAccountWindowsUserConfigurationArgs:
    def __init__(__self__, *,
                 login_mode: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] login_mode: Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode. Values supported are "Batch" and "Interactive".
        """
        pulumi.set(__self__, "login_mode", login_mode)

    @property
    @pulumi.getter(name="loginMode")
    def login_mode(self) -> pulumi.Input[builtins.str]:
        """
        Specifies login mode for the user. The default value for VirtualMachineConfiguration pools is interactive mode and for CloudServiceConfiguration pools is batch mode. Values supported are "Batch" and "Interactive".
        """
        return pulumi.get(self, "login_mode")

    @login_mode.setter
    def login_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login_mode", value)


if not MYPY:
    class PoolWindowArgsDict(TypedDict):
        enable_automatic_updates: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether automatic updates are enabled on the virtual machine. Defaults to `true`.
        """
elif False:
    PoolWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PoolWindowArgs:
    def __init__(__self__, *,
                 enable_automatic_updates: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] enable_automatic_updates: Whether automatic updates are enabled on the virtual machine. Defaults to `true`.
        """
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)

    @property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether automatic updates are enabled on the virtual machine. Defaults to `true`.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @enable_automatic_updates.setter
    def enable_automatic_updates(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_automatic_updates", value)


