# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 allowed_authentication_modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 encryption: Optional[pulumi.Input['AccountEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 key_vault_reference: Optional[pulumi.Input['AccountKeyVaultReferenceArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['AccountNetworkProfileArgs']] = None,
                 pool_allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_account_authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_node_identity: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.
               
               > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_authentication_modes: Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        :param pulumi.Input['AccountEncryptionArgs'] encryption: Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['AccountKeyVaultReferenceArgs'] key_vault_reference: A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountNetworkProfileArgs'] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[builtins.str] pool_allocation_mode: Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
               
               > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.
               
               > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        :param pulumi.Input[builtins.str] storage_account_authentication_mode: Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.
               
               > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.
               
               > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        :param pulumi.Input[builtins.str] storage_account_node_identity: Specifies the user assigned identity for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if allowed_authentication_modes is not None:
            pulumi.set(__self__, "allowed_authentication_modes", allowed_authentication_modes)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference is not None:
            pulumi.set(__self__, "key_vault_reference", key_vault_reference)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if pool_allocation_mode is not None:
            pulumi.set(__self__, "pool_allocation_mode", pool_allocation_mode)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if storage_account_authentication_mode is not None:
            pulumi.set(__self__, "storage_account_authentication_mode", storage_account_authentication_mode)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_account_node_identity is not None:
            pulumi.set(__self__, "storage_account_node_identity", storage_account_node_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.

        > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="allowedAuthenticationModes")
    def allowed_authentication_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        """
        return pulumi.get(self, "allowed_authentication_modes")

    @allowed_authentication_modes.setter
    def allowed_authentication_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_authentication_modes", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['AccountEncryptionArgs']]:
        """
        Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['AccountEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultReference")
    def key_vault_reference(self) -> Optional[pulumi.Input['AccountKeyVaultReferenceArgs']]:
        """
        A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        """
        return pulumi.get(self, "key_vault_reference")

    @key_vault_reference.setter
    def key_vault_reference(self, value: Optional[pulumi.Input['AccountKeyVaultReferenceArgs']]):
        pulumi.set(self, "key_vault_reference", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['AccountNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['AccountNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="poolAllocationMode")
    def pool_allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        """
        return pulumi.get(self, "pool_allocation_mode")

    @pool_allocation_mode.setter
    def pool_allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool_allocation_mode", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether public network access is allowed for this server. Defaults to `true`.

        > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.

        > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="storageAccountAuthenticationMode")
    def storage_account_authentication_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.

        > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        """
        return pulumi.get(self, "storage_account_authentication_mode")

    @storage_account_authentication_mode.setter
    def storage_account_authentication_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_authentication_mode", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.

        > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="storageAccountNodeIdentity")
    def storage_account_node_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the user assigned identity for the storage account.
        """
        return pulumi.get(self, "storage_account_node_identity")

    @storage_account_node_identity.setter
    def storage_account_node_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_node_identity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 account_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 allowed_authentication_modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 encryption: Optional[pulumi.Input['AccountEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 key_vault_reference: Optional[pulumi.Input['AccountKeyVaultReferenceArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile: Optional[pulumi.Input['AccountNetworkProfileArgs']] = None,
                 pool_allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_node_identity: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[builtins.str] account_endpoint: The account endpoint used to interact with the Batch service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_authentication_modes: Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        :param pulumi.Input['AccountEncryptionArgs'] encryption: Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input['AccountKeyVaultReferenceArgs'] key_vault_reference: A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountNetworkProfileArgs'] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[builtins.str] pool_allocation_mode: Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        :param pulumi.Input[builtins.str] primary_access_key: The Batch account primary access key.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
               
               > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.
               
               > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.
               
               > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        :param pulumi.Input[builtins.str] secondary_access_key: The Batch account secondary access key.
        :param pulumi.Input[builtins.str] storage_account_authentication_mode: Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.
               
               > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.
               
               > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        :param pulumi.Input[builtins.str] storage_account_node_identity: Specifies the user assigned identity for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if account_endpoint is not None:
            pulumi.set(__self__, "account_endpoint", account_endpoint)
        if allowed_authentication_modes is not None:
            pulumi.set(__self__, "allowed_authentication_modes", allowed_authentication_modes)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if key_vault_reference is not None:
            pulumi.set(__self__, "key_vault_reference", key_vault_reference)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if pool_allocation_mode is not None:
            pulumi.set(__self__, "pool_allocation_mode", pool_allocation_mode)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if storage_account_authentication_mode is not None:
            pulumi.set(__self__, "storage_account_authentication_mode", storage_account_authentication_mode)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_account_node_identity is not None:
            pulumi.set(__self__, "storage_account_node_identity", storage_account_node_identity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountEndpoint")
    def account_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The account endpoint used to interact with the Batch service.
        """
        return pulumi.get(self, "account_endpoint")

    @account_endpoint.setter
    def account_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "account_endpoint", value)

    @property
    @pulumi.getter(name="allowedAuthenticationModes")
    def allowed_authentication_modes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        """
        return pulumi.get(self, "allowed_authentication_modes")

    @allowed_authentication_modes.setter
    def allowed_authentication_modes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_authentication_modes", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['AccountEncryptionArgs']]:
        """
        Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['AccountEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="keyVaultReference")
    def key_vault_reference(self) -> Optional[pulumi.Input['AccountKeyVaultReferenceArgs']]:
        """
        A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        """
        return pulumi.get(self, "key_vault_reference")

    @key_vault_reference.setter
    def key_vault_reference(self, value: Optional[pulumi.Input['AccountKeyVaultReferenceArgs']]):
        pulumi.set(self, "key_vault_reference", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input['AccountNetworkProfileArgs']]:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input['AccountNetworkProfileArgs']]):
        pulumi.set(self, "network_profile", value)

    @property
    @pulumi.getter(name="poolAllocationMode")
    def pool_allocation_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        """
        return pulumi.get(self, "pool_allocation_mode")

    @pool_allocation_mode.setter
    def pool_allocation_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pool_allocation_mode", value)

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Batch account primary access key.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether public network access is allowed for this server. Defaults to `true`.

        > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.

        > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.

        > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Batch account secondary access key.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @property
    @pulumi.getter(name="storageAccountAuthenticationMode")
    def storage_account_authentication_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.

        > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        """
        return pulumi.get(self, "storage_account_authentication_mode")

    @storage_account_authentication_mode.setter
    def storage_account_authentication_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_authentication_mode", value)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.

        > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @property
    @pulumi.getter(name="storageAccountNodeIdentity")
    def storage_account_node_identity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the user assigned identity for the storage account.
        """
        return pulumi.get(self, "storage_account_node_identity")

    @storage_account_node_identity.setter
    def storage_account_node_identity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_account_node_identity", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:batch/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_authentication_modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 encryption: Optional[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 key_vault_reference: Optional[pulumi.Input[Union['AccountKeyVaultReferenceArgs', 'AccountKeyVaultReferenceArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['AccountNetworkProfileArgs', 'AccountNetworkProfileArgsDict']]] = None,
                 pool_allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_node_identity: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Batch account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="testbatch",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="teststorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_account2 = azure.batch.Account("example",
            name="testbatchaccount",
            resource_group_name=example.name,
            location=example.location,
            pool_allocation_mode="BatchService",
            storage_account_id=example_account.id,
            storage_account_authentication_mode="StorageKeys",
            tags={
                "env": "test",
            })
        ```

        ## Import

        Batch Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:batch/account:Account example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Batch/batchAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_authentication_modes: Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        :param pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']] encryption: Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['AccountKeyVaultReferenceArgs', 'AccountKeyVaultReferenceArgsDict']] key_vault_reference: A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountNetworkProfileArgs', 'AccountNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[builtins.str] pool_allocation_mode: Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
               
               > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.
               
               > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.
               
               > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        :param pulumi.Input[builtins.str] storage_account_authentication_mode: Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.
               
               > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.
               
               > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        :param pulumi.Input[builtins.str] storage_account_node_identity: Specifies the user assigned identity for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Batch account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="testbatch",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="teststorage",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_account2 = azure.batch.Account("example",
            name="testbatchaccount",
            resource_group_name=example.name,
            location=example.location,
            pool_allocation_mode="BatchService",
            storage_account_id=example_account.id,
            storage_account_authentication_mode="StorageKeys",
            tags={
                "env": "test",
            })
        ```

        ## Import

        Batch Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:batch/account:Account example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Batch/batchAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_authentication_modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 encryption: Optional[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 key_vault_reference: Optional[pulumi.Input[Union['AccountKeyVaultReferenceArgs', 'AccountKeyVaultReferenceArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[Union['AccountNetworkProfileArgs', 'AccountNetworkProfileArgsDict']]] = None,
                 pool_allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account_node_identity: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["allowed_authentication_modes"] = allowed_authentication_modes
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["identity"] = identity
            __props__.__dict__["key_vault_reference"] = key_vault_reference
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_profile"] = network_profile
            __props__.__dict__["pool_allocation_mode"] = pool_allocation_mode
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["storage_account_authentication_mode"] = storage_account_authentication_mode
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["storage_account_node_identity"] = storage_account_node_identity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["account_endpoint"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["secondary_access_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "secondaryAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'azure:batch/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            allowed_authentication_modes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            encryption: Optional[pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
            key_vault_reference: Optional[pulumi.Input[Union['AccountKeyVaultReferenceArgs', 'AccountKeyVaultReferenceArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_profile: Optional[pulumi.Input[Union['AccountNetworkProfileArgs', 'AccountNetworkProfileArgsDict']]] = None,
            pool_allocation_mode: Optional[pulumi.Input[builtins.str]] = None,
            primary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_authentication_mode: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[builtins.str]] = None,
            storage_account_node_identity: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] account_endpoint: The account endpoint used to interact with the Batch service.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_authentication_modes: Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        :param pulumi.Input[Union['AccountEncryptionArgs', 'AccountEncryptionArgsDict']] encryption: Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Union['AccountKeyVaultReferenceArgs', 'AccountKeyVaultReferenceArgsDict']] key_vault_reference: A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountNetworkProfileArgs', 'AccountNetworkProfileArgsDict']] network_profile: A `network_profile` block as defined below.
        :param pulumi.Input[builtins.str] pool_allocation_mode: Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        :param pulumi.Input[builtins.str] primary_access_key: The Batch account primary access key.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Whether public network access is allowed for this server. Defaults to `true`.
               
               > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.
               
               > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.
               
               > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        :param pulumi.Input[builtins.str] secondary_access_key: The Batch account secondary access key.
        :param pulumi.Input[builtins.str] storage_account_authentication_mode: Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.
               
               > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        :param pulumi.Input[builtins.str] storage_account_id: Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.
               
               > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        :param pulumi.Input[builtins.str] storage_account_node_identity: Specifies the user assigned identity for the storage account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["account_endpoint"] = account_endpoint
        __props__.__dict__["allowed_authentication_modes"] = allowed_authentication_modes
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["identity"] = identity
        __props__.__dict__["key_vault_reference"] = key_vault_reference
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile"] = network_profile
        __props__.__dict__["pool_allocation_mode"] = pool_allocation_mode
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["storage_account_authentication_mode"] = storage_account_authentication_mode
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["storage_account_node_identity"] = storage_account_node_identity
        __props__.__dict__["tags"] = tags
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountEndpoint")
    def account_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The account endpoint used to interact with the Batch service.
        """
        return pulumi.get(self, "account_endpoint")

    @property
    @pulumi.getter(name="allowedAuthenticationModes")
    def allowed_authentication_modes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Specifies the allowed authentication mode for the Batch account. Possible values include `AAD`, `SharedKey` or `TaskAuthenticationToken`.
        """
        return pulumi.get(self, "allowed_authentication_modes")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.AccountEncryption']]:
        """
        Specifies if customer managed key encryption should be used to encrypt batch account data. One `encryption` block as defined below.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AccountIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="keyVaultReference")
    def key_vault_reference(self) -> pulumi.Output[Optional['outputs.AccountKeyVaultReference']]:
        """
        A `key_vault_reference` block, as defined below, that describes the Azure KeyVault reference to use when deploying the Azure Batch account using the `UserSubscription` pool allocation mode.
        """
        return pulumi.get(self, "key_vault_reference")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Batch account. Only lowercase Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output[Optional['outputs.AccountNetworkProfile']]:
        """
        A `network_profile` block as defined below.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="poolAllocationMode")
    def pool_allocation_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the mode to use for pool allocation. Possible values are `BatchService` or `UserSubscription`. Defaults to `BatchService`.
        """
        return pulumi.get(self, "pool_allocation_mode")

    @property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The Batch account primary access key.
        """
        return pulumi.get(self, "primary_access_key")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether public network access is allowed for this server. Defaults to `true`.

        > **NOTE:** When using `UserSubscription` mode, an Azure KeyVault reference has to be specified. See `key_vault_reference` below.

        > **NOTE:** When using `UserSubscription` mode, the `Microsoft Azure Batch` service principal has to have `Contributor` role on your subscription scope, as documented [here](https://docs.microsoft.com/azure/batch/batch-account-create-portal#additional-configuration-for-user-subscription-mode).
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Batch account. Changing this forces a new resource to be created.

        > **NOTE:** To work around [a bug in the Azure API](https://github.com/Azure/azure-rest-api-specs/issues/5574) this property is currently treated as case-insensitive. A future version of this provider will require that the casing is correct.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[builtins.str]:
        """
        The Batch account secondary access key.
        """
        return pulumi.get(self, "secondary_access_key")

    @property
    @pulumi.getter(name="storageAccountAuthenticationMode")
    def storage_account_authentication_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the storage account authentication mode. Possible values include `StorageKeys`, `BatchAccountManagedIdentity`.

        > **NOTE:** When using `BatchAccountManagedIdentity` mod, the `identity.type` must set to `UserAssigned` or `SystemAssigned`.
        """
        return pulumi.get(self, "storage_account_authentication_mode")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the storage account to use for the Batch account. If not specified, Azure Batch will manage the storage.

        > **NOTE:** When using `storage_account_id`, the `storage_account_authentication_mode` must be specified as well.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="storageAccountNodeIdentity")
    def storage_account_node_identity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the user assigned identity for the storage account.
        """
        return pulumi.get(self, "storage_account_node_identity")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

