# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountCostManagementExportArgs', 'AccountCostManagementExport']

@pulumi.input_type
class AccountCostManagementExportArgs:
    def __init__(__self__, *,
                 billing_account_id: pulumi.Input[builtins.str],
                 export_data_options: pulumi.Input['AccountCostManagementExportExportDataOptionsArgs'],
                 export_data_storage_location: pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs'],
                 recurrence_period_end_date: pulumi.Input[builtins.str],
                 recurrence_period_start_date: pulumi.Input[builtins.str],
                 recurrence_type: pulumi.Input[builtins.str],
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AccountCostManagementExport resource.
        :param pulumi.Input[builtins.str] billing_account_id: The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountCostManagementExportExportDataOptionsArgs'] export_data_options: A `export_data_options` block as defined below.
        :param pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs'] export_data_storage_location: A `export_data_storage_location` block as defined below.
        :param pulumi.Input[builtins.str] recurrence_period_end_date: The date the export will stop capturing information.
        :param pulumi.Input[builtins.str] recurrence_period_start_date: The date the export will start capturing information.
        :param pulumi.Input[builtins.str] recurrence_type: How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        :param pulumi.Input[builtins.bool] active: Is the cost management export active? Default is `true`.
               
               * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "billing_account_id", billing_account_id)
        pulumi.set(__self__, "export_data_options", export_data_options)
        pulumi.set(__self__, "export_data_storage_location", export_data_storage_location)
        pulumi.set(__self__, "recurrence_period_end_date", recurrence_period_end_date)
        pulumi.set(__self__, "recurrence_period_start_date", recurrence_period_start_date)
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "billing_account_id", value)

    @property
    @pulumi.getter(name="exportDataOptions")
    def export_data_options(self) -> pulumi.Input['AccountCostManagementExportExportDataOptionsArgs']:
        """
        A `export_data_options` block as defined below.
        """
        return pulumi.get(self, "export_data_options")

    @export_data_options.setter
    def export_data_options(self, value: pulumi.Input['AccountCostManagementExportExportDataOptionsArgs']):
        pulumi.set(self, "export_data_options", value)

    @property
    @pulumi.getter(name="exportDataStorageLocation")
    def export_data_storage_location(self) -> pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs']:
        """
        A `export_data_storage_location` block as defined below.
        """
        return pulumi.get(self, "export_data_storage_location")

    @export_data_storage_location.setter
    def export_data_storage_location(self, value: pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs']):
        pulumi.set(self, "export_data_storage_location", value)

    @property
    @pulumi.getter(name="recurrencePeriodEndDate")
    def recurrence_period_end_date(self) -> pulumi.Input[builtins.str]:
        """
        The date the export will stop capturing information.
        """
        return pulumi.get(self, "recurrence_period_end_date")

    @recurrence_period_end_date.setter
    def recurrence_period_end_date(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recurrence_period_end_date", value)

    @property
    @pulumi.getter(name="recurrencePeriodStartDate")
    def recurrence_period_start_date(self) -> pulumi.Input[builtins.str]:
        """
        The date the export will start capturing information.
        """
        return pulumi.get(self, "recurrence_period_start_date")

    @recurrence_period_start_date.setter
    def recurrence_period_start_date(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recurrence_period_start_date", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> pulumi.Input[builtins.str]:
        """
        How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the cost management export active? Default is `true`.

        * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AccountCostManagementExportState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_data_options: Optional[pulumi.Input['AccountCostManagementExportExportDataOptionsArgs']] = None,
                 export_data_storage_location: Optional[pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs']] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_period_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_period_start_date: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountCostManagementExport resources.
        :param pulumi.Input[builtins.bool] active: Is the cost management export active? Default is `true`.
               
               * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        :param pulumi.Input[builtins.str] billing_account_id: The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountCostManagementExportExportDataOptionsArgs'] export_data_options: A `export_data_options` block as defined below.
        :param pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs'] export_data_storage_location: A `export_data_storage_location` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recurrence_period_end_date: The date the export will stop capturing information.
        :param pulumi.Input[builtins.str] recurrence_period_start_date: The date the export will start capturing information.
        :param pulumi.Input[builtins.str] recurrence_type: How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if billing_account_id is not None:
            pulumi.set(__self__, "billing_account_id", billing_account_id)
        if export_data_options is not None:
            pulumi.set(__self__, "export_data_options", export_data_options)
        if export_data_storage_location is not None:
            pulumi.set(__self__, "export_data_storage_location", export_data_storage_location)
        if file_format is not None:
            pulumi.set(__self__, "file_format", file_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recurrence_period_end_date is not None:
            pulumi.set(__self__, "recurrence_period_end_date", recurrence_period_end_date)
        if recurrence_period_start_date is not None:
            pulumi.set(__self__, "recurrence_period_start_date", recurrence_period_start_date)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the cost management export active? Default is `true`.

        * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "billing_account_id")

    @billing_account_id.setter
    def billing_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_account_id", value)

    @property
    @pulumi.getter(name="exportDataOptions")
    def export_data_options(self) -> Optional[pulumi.Input['AccountCostManagementExportExportDataOptionsArgs']]:
        """
        A `export_data_options` block as defined below.
        """
        return pulumi.get(self, "export_data_options")

    @export_data_options.setter
    def export_data_options(self, value: Optional[pulumi.Input['AccountCostManagementExportExportDataOptionsArgs']]):
        pulumi.set(self, "export_data_options", value)

    @property
    @pulumi.getter(name="exportDataStorageLocation")
    def export_data_storage_location(self) -> Optional[pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs']]:
        """
        A `export_data_storage_location` block as defined below.
        """
        return pulumi.get(self, "export_data_storage_location")

    @export_data_storage_location.setter
    def export_data_storage_location(self, value: Optional[pulumi.Input['AccountCostManagementExportExportDataStorageLocationArgs']]):
        pulumi.set(self, "export_data_storage_location", value)

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "file_format")

    @file_format.setter
    def file_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_format", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="recurrencePeriodEndDate")
    def recurrence_period_end_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the export will stop capturing information.
        """
        return pulumi.get(self, "recurrence_period_end_date")

    @recurrence_period_end_date.setter
    def recurrence_period_end_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recurrence_period_end_date", value)

    @property
    @pulumi.getter(name="recurrencePeriodStartDate")
    def recurrence_period_start_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date the export will start capturing information.
        """
        return pulumi.get(self, "recurrence_period_start_date")

    @recurrence_period_start_date.setter
    def recurrence_period_start_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recurrence_period_start_date", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recurrence_type", value)


@pulumi.type_token("azure:billing/accountCostManagementExport:AccountCostManagementExport")
class AccountCostManagementExport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_data_options: Optional[pulumi.Input[Union['AccountCostManagementExportExportDataOptionsArgs', 'AccountCostManagementExportExportDataOptionsArgsDict']]] = None,
                 export_data_storage_location: Optional[pulumi.Input[Union['AccountCostManagementExportExportDataStorageLocationArgs', 'AccountCostManagementExportExportDataStorageLocationArgsDict']]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_period_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_period_start_date: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cost Management Export for a Billing Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="examplecontainer",
            storage_account_name=example_account.name)
        example_account_cost_management_export = azure.billing.AccountCostManagementExport("example",
            name="example",
            billing_account_id="example",
            recurrence_type="Monthly",
            recurrence_period_start_date="2020-08-18T00:00:00Z",
            recurrence_period_end_date="2020-09-18T00:00:00Z",
            file_format="Csv",
            export_data_storage_location={
                "container_id": example_container.resource_manager_id,
                "root_folder_path": "/root/updated",
            },
            export_data_options={
                "type": "Usage",
                "time_frame": "WeekToDate",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement`: 2023-08-01

        ## Import

        Billing Account Cost Management Exports can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:billing/accountCostManagementExport:AccountCostManagementExport example /providers/Microsoft.Billing/billingAccounts/12345678/providers/Microsoft.CostManagement/exports/export1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Is the cost management export active? Default is `true`.
               
               * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        :param pulumi.Input[builtins.str] billing_account_id: The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountCostManagementExportExportDataOptionsArgs', 'AccountCostManagementExportExportDataOptionsArgsDict']] export_data_options: A `export_data_options` block as defined below.
        :param pulumi.Input[Union['AccountCostManagementExportExportDataStorageLocationArgs', 'AccountCostManagementExportExportDataStorageLocationArgsDict']] export_data_storage_location: A `export_data_storage_location` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recurrence_period_end_date: The date the export will stop capturing information.
        :param pulumi.Input[builtins.str] recurrence_period_start_date: The date the export will start capturing information.
        :param pulumi.Input[builtins.str] recurrence_type: How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountCostManagementExportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cost Management Export for a Billing Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="examplecontainer",
            storage_account_name=example_account.name)
        example_account_cost_management_export = azure.billing.AccountCostManagementExport("example",
            name="example",
            billing_account_id="example",
            recurrence_type="Monthly",
            recurrence_period_start_date="2020-08-18T00:00:00Z",
            recurrence_period_end_date="2020-09-18T00:00:00Z",
            file_format="Csv",
            export_data_storage_location={
                "container_id": example_container.resource_manager_id,
                "root_folder_path": "/root/updated",
            },
            export_data_options={
                "type": "Usage",
                "time_frame": "WeekToDate",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CostManagement`: 2023-08-01

        ## Import

        Billing Account Cost Management Exports can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:billing/accountCostManagementExport:AccountCostManagementExport example /providers/Microsoft.Billing/billingAccounts/12345678/providers/Microsoft.CostManagement/exports/export1
        ```

        :param str resource_name: The name of the resource.
        :param AccountCostManagementExportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountCostManagementExportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 billing_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 export_data_options: Optional[pulumi.Input[Union['AccountCostManagementExportExportDataOptionsArgs', 'AccountCostManagementExportExportDataOptionsArgsDict']]] = None,
                 export_data_storage_location: Optional[pulumi.Input[Union['AccountCostManagementExportExportDataStorageLocationArgs', 'AccountCostManagementExportExportDataStorageLocationArgsDict']]] = None,
                 file_format: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_period_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_period_start_date: Optional[pulumi.Input[builtins.str]] = None,
                 recurrence_type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountCostManagementExportArgs.__new__(AccountCostManagementExportArgs)

            __props__.__dict__["active"] = active
            if billing_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'billing_account_id'")
            __props__.__dict__["billing_account_id"] = billing_account_id
            if export_data_options is None and not opts.urn:
                raise TypeError("Missing required property 'export_data_options'")
            __props__.__dict__["export_data_options"] = export_data_options
            if export_data_storage_location is None and not opts.urn:
                raise TypeError("Missing required property 'export_data_storage_location'")
            __props__.__dict__["export_data_storage_location"] = export_data_storage_location
            __props__.__dict__["file_format"] = file_format
            __props__.__dict__["name"] = name
            if recurrence_period_end_date is None and not opts.urn:
                raise TypeError("Missing required property 'recurrence_period_end_date'")
            __props__.__dict__["recurrence_period_end_date"] = recurrence_period_end_date
            if recurrence_period_start_date is None and not opts.urn:
                raise TypeError("Missing required property 'recurrence_period_start_date'")
            __props__.__dict__["recurrence_period_start_date"] = recurrence_period_start_date
            if recurrence_type is None and not opts.urn:
                raise TypeError("Missing required property 'recurrence_type'")
            __props__.__dict__["recurrence_type"] = recurrence_type
        super(AccountCostManagementExport, __self__).__init__(
            'azure:billing/accountCostManagementExport:AccountCostManagementExport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            billing_account_id: Optional[pulumi.Input[builtins.str]] = None,
            export_data_options: Optional[pulumi.Input[Union['AccountCostManagementExportExportDataOptionsArgs', 'AccountCostManagementExportExportDataOptionsArgsDict']]] = None,
            export_data_storage_location: Optional[pulumi.Input[Union['AccountCostManagementExportExportDataStorageLocationArgs', 'AccountCostManagementExportExportDataStorageLocationArgsDict']]] = None,
            file_format: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            recurrence_period_end_date: Optional[pulumi.Input[builtins.str]] = None,
            recurrence_period_start_date: Optional[pulumi.Input[builtins.str]] = None,
            recurrence_type: Optional[pulumi.Input[builtins.str]] = None) -> 'AccountCostManagementExport':
        """
        Get an existing AccountCostManagementExport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Is the cost management export active? Default is `true`.
               
               * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        :param pulumi.Input[builtins.str] billing_account_id: The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AccountCostManagementExportExportDataOptionsArgs', 'AccountCostManagementExportExportDataOptionsArgsDict']] export_data_options: A `export_data_options` block as defined below.
        :param pulumi.Input[Union['AccountCostManagementExportExportDataStorageLocationArgs', 'AccountCostManagementExportExportDataStorageLocationArgsDict']] export_data_storage_location: A `export_data_storage_location` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] recurrence_period_end_date: The date the export will stop capturing information.
        :param pulumi.Input[builtins.str] recurrence_period_start_date: The date the export will start capturing information.
        :param pulumi.Input[builtins.str] recurrence_type: How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountCostManagementExportState.__new__(_AccountCostManagementExportState)

        __props__.__dict__["active"] = active
        __props__.__dict__["billing_account_id"] = billing_account_id
        __props__.__dict__["export_data_options"] = export_data_options
        __props__.__dict__["export_data_storage_location"] = export_data_storage_location
        __props__.__dict__["file_format"] = file_format
        __props__.__dict__["name"] = name
        __props__.__dict__["recurrence_period_end_date"] = recurrence_period_end_date
        __props__.__dict__["recurrence_period_start_date"] = recurrence_period_start_date
        __props__.__dict__["recurrence_type"] = recurrence_type
        return AccountCostManagementExport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the cost management export active? Default is `true`.

        * * `file_format` - (Optional) Format for export. Valid values are `Csv` only. Default is `Csv`.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the billing account on which to create an export. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "billing_account_id")

    @property
    @pulumi.getter(name="exportDataOptions")
    def export_data_options(self) -> pulumi.Output['outputs.AccountCostManagementExportExportDataOptions']:
        """
        A `export_data_options` block as defined below.
        """
        return pulumi.get(self, "export_data_options")

    @property
    @pulumi.getter(name="exportDataStorageLocation")
    def export_data_storage_location(self) -> pulumi.Output['outputs.AccountCostManagementExportExportDataStorageLocation']:
        """
        A `export_data_storage_location` block as defined below.
        """
        return pulumi.get(self, "export_data_storage_location")

    @property
    @pulumi.getter(name="fileFormat")
    def file_format(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "file_format")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Cost Management Export. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recurrencePeriodEndDate")
    def recurrence_period_end_date(self) -> pulumi.Output[builtins.str]:
        """
        The date the export will stop capturing information.
        """
        return pulumi.get(self, "recurrence_period_end_date")

    @property
    @pulumi.getter(name="recurrencePeriodStartDate")
    def recurrence_period_start_date(self) -> pulumi.Output[builtins.str]:
        """
        The date the export will start capturing information.
        """
        return pulumi.get(self, "recurrence_period_start_date")

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> pulumi.Output[builtins.str]:
        """
        How often the requested information will be exported. Valid values include `Annually`, `Daily`, `Monthly`, `Weekly`.
        """
        return pulumi.get(self, "recurrence_type")

