# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AssignmentArgs', 'Assignment']

@pulumi.input_type
class AssignmentArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['AssignmentIdentityArgs'],
                 target_subscription_id: pulumi.Input[builtins.str],
                 version_id: pulumi.Input[builtins.str],
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 lock_exclude_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_exclude_principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[builtins.str]] = None,
                 resource_groups: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Assignment resource.
        :param pulumi.Input['AssignmentIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] target_subscription_id: The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] version_id: The ID of the Published Version of the blueprint to be assigned.
        :param pulumi.Input[builtins.str] location: The Azure location of the Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_actions: a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_principals: a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[builtins.str] lock_mode: The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        :param pulumi.Input[builtins.str] name: The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parameter_values: a JSON string to supply Blueprint Assignment parameter values.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] resource_groups: a JSON string to supply the Blueprint Resource Group information.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "target_subscription_id", target_subscription_id)
        pulumi.set(__self__, "version_id", version_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if lock_exclude_actions is not None:
            pulumi.set(__self__, "lock_exclude_actions", lock_exclude_actions)
        if lock_exclude_principals is not None:
            pulumi.set(__self__, "lock_exclude_principals", lock_exclude_principals)
        if lock_mode is not None:
            pulumi.set(__self__, "lock_mode", lock_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if resource_groups is not None:
            pulumi.set(__self__, "resource_groups", resource_groups)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input['AssignmentIdentityArgs']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['AssignmentIdentityArgs']):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> pulumi.Input[builtins.str]:
        """
        The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_subscription_id")

    @target_subscription_id.setter
    def target_subscription_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_subscription_id", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Published Version of the blueprint to be assigned.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure location of the Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="lockExcludeActions")
    def lock_exclude_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        """
        return pulumi.get(self, "lock_exclude_actions")

    @lock_exclude_actions.setter
    def lock_exclude_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lock_exclude_actions", value)

    @property
    @pulumi.getter(name="lockExcludePrincipals")
    def lock_exclude_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        """
        return pulumi.get(self, "lock_exclude_principals")

    @lock_exclude_principals.setter
    def lock_exclude_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lock_exclude_principals", value)

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        """
        return pulumi.get(self, "lock_mode")

    @lock_mode.setter
    def lock_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lock_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        a JSON string to supply Blueprint Assignment parameter values.

        > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameter_values", value)

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        a JSON string to supply the Blueprint Resource Group information.

        > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        return pulumi.get(self, "resource_groups")

    @resource_groups.setter
    def resource_groups(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_groups", value)


@pulumi.input_type
class _AssignmentState:
    def __init__(__self__, *,
                 blueprint_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['AssignmentIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 lock_exclude_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_exclude_principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[builtins.str]] = None,
                 resource_groups: Optional[pulumi.Input[builtins.str]] = None,
                 target_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Assignment resources.
        :param pulumi.Input[builtins.str] blueprint_name: The name of the blueprint assigned
        :param pulumi.Input[builtins.str] description: The Description on the Blueprint
        :param pulumi.Input[builtins.str] display_name: The display name of the blueprint
        :param pulumi.Input['AssignmentIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure location of the Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_actions: a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_principals: a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[builtins.str] lock_mode: The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        :param pulumi.Input[builtins.str] name: The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parameter_values: a JSON string to supply Blueprint Assignment parameter values.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] resource_groups: a JSON string to supply the Blueprint Resource Group information.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] target_subscription_id: The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] version_id: The ID of the Published Version of the blueprint to be assigned.
        """
        if blueprint_name is not None:
            pulumi.set(__self__, "blueprint_name", blueprint_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if lock_exclude_actions is not None:
            pulumi.set(__self__, "lock_exclude_actions", lock_exclude_actions)
        if lock_exclude_principals is not None:
            pulumi.set(__self__, "lock_exclude_principals", lock_exclude_principals)
        if lock_mode is not None:
            pulumi.set(__self__, "lock_mode", lock_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if resource_groups is not None:
            pulumi.set(__self__, "resource_groups", resource_groups)
        if target_subscription_id is not None:
            pulumi.set(__self__, "target_subscription_id", target_subscription_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the blueprint assigned
        """
        return pulumi.get(self, "blueprint_name")

    @blueprint_name.setter
    def blueprint_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "blueprint_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Description on the Blueprint
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the blueprint
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AssignmentIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AssignmentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure location of the Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="lockExcludeActions")
    def lock_exclude_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        """
        return pulumi.get(self, "lock_exclude_actions")

    @lock_exclude_actions.setter
    def lock_exclude_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lock_exclude_actions", value)

    @property
    @pulumi.getter(name="lockExcludePrincipals")
    def lock_exclude_principals(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        """
        return pulumi.get(self, "lock_exclude_principals")

    @lock_exclude_principals.setter
    def lock_exclude_principals(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lock_exclude_principals", value)

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        """
        return pulumi.get(self, "lock_mode")

    @lock_mode.setter
    def lock_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lock_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        a JSON string to supply Blueprint Assignment parameter values.

        > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parameter_values", value)

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        a JSON string to supply the Blueprint Resource Group information.

        > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        return pulumi.get(self, "resource_groups")

    @resource_groups.setter
    def resource_groups(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_groups", value)

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_subscription_id")

    @target_subscription_id.setter
    def target_subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_subscription_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Published Version of the blueprint to be assigned.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("azure:blueprint/assignment:Assignment")
class Assignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['AssignmentIdentityArgs', 'AssignmentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 lock_exclude_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_exclude_principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[builtins.str]] = None,
                 resource_groups: Optional[pulumi.Input[builtins.str]] = None,
                 target_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Blueprint Assignment resource

        > **NOTE:** Azure Blueprints are in Preview and potentially subject to breaking change without notice.

        > **NOTE:** Azure Blueprint Assignments can only be applied to Subscriptions.  Assignments to Management Groups is not currently supported by the service or by this provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.get_subscription()
        example_get_definition = azure.blueprint.get_definition(name="exampleBlueprint",
            scope_id=example.id)
        example_get_published_version = azure.blueprint.get_published_version(scope_id=example_get_definition.scope_id,
            blueprint_name=example_get_definition.name,
            version="v1.0.0")
        example_resource_group = azure.core.ResourceGroup("example",
            name="exampleRG-bp",
            location="West Europe",
            tags={
                "Environment": "example",
            })
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            name="bp-user-example")
        operator = azure.authorization.Assignment("operator",
            scope=example.id,
            role_definition_name="Blueprint Operator",
            principal_id=example_user_assigned_identity.principal_id)
        owner = azure.authorization.Assignment("owner",
            scope=example.id,
            role_definition_name="Owner",
            principal_id=example_user_assigned_identity.principal_id)
        example_assignment = azure.blueprint.Assignment("example",
            name="testAccBPAssignment",
            target_subscription_id=example.id,
            version_id=example_get_published_version.id,
            location=example_resource_group.location,
            lock_mode="AllResourcesDoNotDelete",
            lock_exclude_principals=[current.object_id],
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            resource_groups=\"\"\"    {
              "ResourceGroup": {
                "name": "exampleRG-bp"
              }
            }
        \"\"\",
            parameter_values=\"\"\"    {
              "allowedlocationsforresourcegroups_listOfAllowedLocations": {
                "value": ["westus", "westus2", "eastus", "centralus", "centraluseuap", "southcentralus", "northcentralus", "westcentralus", "eastus2", "eastus2euap", "brazilsouth", "brazilus", "northeurope", "westeurope", "eastasia", "southeastasia", "japanwest", "japaneast", "koreacentral", "koreasouth", "indiasouth", "indiawest", "indiacentral", "australiaeast", "australiasoutheast", "canadacentral", "canadaeast", "uknorth", "uksouth2", "uksouth", "ukwest", "francecentral", "francesouth", "australiacentral", "australiacentral2", "uaecentral", "uaenorth", "southafricanorth", "southafricawest", "switzerlandnorth", "switzerlandwest", "germanynorth", "germanywestcentral", "norwayeast", "norwaywest"]
              }
            }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[
                    operator,
                    owner,
                ]))
        ```

        ## Import

        Azure Blueprint Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:blueprint/assignment:Assignment example "/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Blueprint/blueprintAssignments/assignSimpleBlueprint"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AssignmentIdentityArgs', 'AssignmentIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure location of the Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_actions: a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_principals: a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[builtins.str] lock_mode: The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        :param pulumi.Input[builtins.str] name: The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parameter_values: a JSON string to supply Blueprint Assignment parameter values.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] resource_groups: a JSON string to supply the Blueprint Resource Group information.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] target_subscription_id: The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] version_id: The ID of the Published Version of the blueprint to be assigned.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Blueprint Assignment resource

        > **NOTE:** Azure Blueprints are in Preview and potentially subject to breaking change without notice.

        > **NOTE:** Azure Blueprint Assignments can only be applied to Subscriptions.  Assignments to Management Groups is not currently supported by the service or by this provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.get_subscription()
        example_get_definition = azure.blueprint.get_definition(name="exampleBlueprint",
            scope_id=example.id)
        example_get_published_version = azure.blueprint.get_published_version(scope_id=example_get_definition.scope_id,
            blueprint_name=example_get_definition.name,
            version="v1.0.0")
        example_resource_group = azure.core.ResourceGroup("example",
            name="exampleRG-bp",
            location="West Europe",
            tags={
                "Environment": "example",
            })
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            name="bp-user-example")
        operator = azure.authorization.Assignment("operator",
            scope=example.id,
            role_definition_name="Blueprint Operator",
            principal_id=example_user_assigned_identity.principal_id)
        owner = azure.authorization.Assignment("owner",
            scope=example.id,
            role_definition_name="Owner",
            principal_id=example_user_assigned_identity.principal_id)
        example_assignment = azure.blueprint.Assignment("example",
            name="testAccBPAssignment",
            target_subscription_id=example.id,
            version_id=example_get_published_version.id,
            location=example_resource_group.location,
            lock_mode="AllResourcesDoNotDelete",
            lock_exclude_principals=[current.object_id],
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            resource_groups=\"\"\"    {
              "ResourceGroup": {
                "name": "exampleRG-bp"
              }
            }
        \"\"\",
            parameter_values=\"\"\"    {
              "allowedlocationsforresourcegroups_listOfAllowedLocations": {
                "value": ["westus", "westus2", "eastus", "centralus", "centraluseuap", "southcentralus", "northcentralus", "westcentralus", "eastus2", "eastus2euap", "brazilsouth", "brazilus", "northeurope", "westeurope", "eastasia", "southeastasia", "japanwest", "japaneast", "koreacentral", "koreasouth", "indiasouth", "indiawest", "indiacentral", "australiaeast", "australiasoutheast", "canadacentral", "canadaeast", "uknorth", "uksouth2", "uksouth", "ukwest", "francecentral", "francesouth", "australiacentral", "australiacentral2", "uaecentral", "uaenorth", "southafricanorth", "southafricawest", "switzerlandnorth", "switzerlandwest", "germanynorth", "germanywestcentral", "norwayeast", "norwaywest"]
              }
            }
        \"\"\",
            opts = pulumi.ResourceOptions(depends_on=[
                    operator,
                    owner,
                ]))
        ```

        ## Import

        Azure Blueprint Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:blueprint/assignment:Assignment example "/subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.Blueprint/blueprintAssignments/assignSimpleBlueprint"
        ```

        :param str resource_name: The name of the resource.
        :param AssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['AssignmentIdentityArgs', 'AssignmentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 lock_exclude_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_exclude_principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 lock_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[builtins.str]] = None,
                 resource_groups: Optional[pulumi.Input[builtins.str]] = None,
                 target_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 version_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssignmentArgs.__new__(AssignmentArgs)

            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["lock_exclude_actions"] = lock_exclude_actions
            __props__.__dict__["lock_exclude_principals"] = lock_exclude_principals
            __props__.__dict__["lock_mode"] = lock_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["parameter_values"] = parameter_values
            __props__.__dict__["resource_groups"] = resource_groups
            if target_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_subscription_id'")
            __props__.__dict__["target_subscription_id"] = target_subscription_id
            if version_id is None and not opts.urn:
                raise TypeError("Missing required property 'version_id'")
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["blueprint_name"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["type"] = None
        super(Assignment, __self__).__init__(
            'azure:blueprint/assignment:Assignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blueprint_name: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['AssignmentIdentityArgs', 'AssignmentIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            lock_exclude_actions: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            lock_exclude_principals: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            lock_mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parameter_values: Optional[pulumi.Input[builtins.str]] = None,
            resource_groups: Optional[pulumi.Input[builtins.str]] = None,
            target_subscription_id: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            version_id: Optional[pulumi.Input[builtins.str]] = None) -> 'Assignment':
        """
        Get an existing Assignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] blueprint_name: The name of the blueprint assigned
        :param pulumi.Input[builtins.str] description: The Description on the Blueprint
        :param pulumi.Input[builtins.str] display_name: The display name of the blueprint
        :param pulumi.Input[Union['AssignmentIdentityArgs', 'AssignmentIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure location of the Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_actions: a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lock_exclude_principals: a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        :param pulumi.Input[builtins.str] lock_mode: The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        :param pulumi.Input[builtins.str] name: The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] parameter_values: a JSON string to supply Blueprint Assignment parameter values.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] resource_groups: a JSON string to supply the Blueprint Resource Group information.
               
               > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        :param pulumi.Input[builtins.str] target_subscription_id: The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] version_id: The ID of the Published Version of the blueprint to be assigned.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AssignmentState.__new__(_AssignmentState)

        __props__.__dict__["blueprint_name"] = blueprint_name
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["lock_exclude_actions"] = lock_exclude_actions
        __props__.__dict__["lock_exclude_principals"] = lock_exclude_principals
        __props__.__dict__["lock_mode"] = lock_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["parameter_values"] = parameter_values
        __props__.__dict__["resource_groups"] = resource_groups
        __props__.__dict__["target_subscription_id"] = target_subscription_id
        __props__.__dict__["type"] = type
        __props__.__dict__["version_id"] = version_id
        return Assignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blueprintName")
    def blueprint_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the blueprint assigned
        """
        return pulumi.get(self, "blueprint_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The Description on the Blueprint
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the blueprint
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.AssignmentIdentity']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure location of the Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="lockExcludeActions")
    def lock_exclude_actions(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        a list of up to 200 actions that are permitted to bypass the locks applied by the Blueprint.
        """
        return pulumi.get(self, "lock_exclude_actions")

    @property
    @pulumi.getter(name="lockExcludePrincipals")
    def lock_exclude_principals(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        a list of up to 5 Principal IDs that are permitted to bypass the locks applied by the Blueprint.
        """
        return pulumi.get(self, "lock_exclude_principals")

    @property
    @pulumi.getter(name="lockMode")
    def lock_mode(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The locking mode of the Blueprint Assignment. One of `None` (Default), `AllResourcesReadOnly`, or `AllResourcesDoNotDelete`. Defaults to `None`.
        """
        return pulumi.get(self, "lock_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Blueprint Assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        a JSON string to supply Blueprint Assignment parameter values.

        > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        return pulumi.get(self, "parameter_values")

    @property
    @pulumi.getter(name="resourceGroups")
    def resource_groups(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        a JSON string to supply the Blueprint Resource Group information.

        > **NOTE:** Improperly formatted JSON, or missing values required by a Blueprint will cause the assignment to fail.
        """
        return pulumi.get(self, "resource_groups")

    @property
    @pulumi.getter(name="targetSubscriptionId")
    def target_subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The Subscription ID the Blueprint Published Version is to be applied to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_subscription_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Published Version of the blueprint to be assigned.
        """
        return pulumi.get(self, "version_id")

