# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ChannelsRegistrationArgs', 'ChannelsRegistration']

@pulumi.input_type
class ChannelsRegistrationArgs:
    def __init__(__self__, *,
                 microsoft_app_id: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 sku: pulumi.Input[builtins.str],
                 cmk_key_vault_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ChannelsRegistration resource.
        :param pulumi.Input[builtins.str] microsoft_app_id: The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] cmk_key_vault_url: The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.
               
               > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.
               
               > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        :param pulumi.Input[builtins.str] description: The description of the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_application_id: The Application Insights Application ID to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_key: The Application Insights Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] display_name: The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        :param pulumi.Input[builtins.str] endpoint: The Bot Channels Registration endpoint.
        :param pulumi.Input[builtins.str] icon_url: The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the Bot Channels Registration in an isolated network?
        :param pulumi.Input[builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "microsoft_app_id", microsoft_app_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if cmk_key_vault_url is not None:
            pulumi.set(__self__, "cmk_key_vault_url", cmk_key_vault_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if developer_app_insights_key is not None:
            pulumi.set(__self__, "developer_app_insights_key", developer_app_insights_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if streaming_endpoint_enabled is not None:
            pulumi.set(__self__, "streaming_endpoint_enabled", streaming_endpoint_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="microsoftAppId")
    def microsoft_app_id(self) -> pulumi.Input[builtins.str]:
        """
        The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_id")

    @microsoft_app_id.setter
    def microsoft_app_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "microsoft_app_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Input[builtins.str]:
        """
        The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="cmkKeyVaultUrl")
    def cmk_key_vault_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.

        > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.

        > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        """
        return pulumi.get(self, "cmk_key_vault_url")

    @cmk_key_vault_url.setter
    def cmk_key_vault_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cmk_key_vault_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Bot Channels Registration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application Insights API Key to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @developer_app_insights_api_key.setter
    def developer_app_insights_api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "developer_app_insights_api_key", value)

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application Insights Application ID to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @developer_app_insights_application_id.setter
    def developer_app_insights_application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "developer_app_insights_application_id", value)

    @property
    @pulumi.getter(name="developerAppInsightsKey")
    def developer_app_insights_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application Insights Key to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_key")

    @developer_app_insights_key.setter
    def developer_app_insights_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "developer_app_insights_key", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Bot Channels Registration endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Bot Channels Registration in an isolated network?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="streamingEndpointEnabled")
    def streaming_endpoint_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        """
        return pulumi.get(self, "streaming_endpoint_enabled")

    @streaming_endpoint_enabled.setter
    def streaming_endpoint_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "streaming_endpoint_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ChannelsRegistrationState:
    def __init__(__self__, *,
                 cmk_key_vault_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 microsoft_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ChannelsRegistration resources.
        :param pulumi.Input[builtins.str] cmk_key_vault_url: The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.
               
               > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.
               
               > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        :param pulumi.Input[builtins.str] description: The description of the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_application_id: The Application Insights Application ID to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_key: The Application Insights Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] display_name: The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        :param pulumi.Input[builtins.str] endpoint: The Bot Channels Registration endpoint.
        :param pulumi.Input[builtins.str] icon_url: The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] microsoft_app_id: The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the Bot Channels Registration in an isolated network?
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if cmk_key_vault_url is not None:
            pulumi.set(__self__, "cmk_key_vault_url", cmk_key_vault_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if developer_app_insights_api_key is not None:
            pulumi.set(__self__, "developer_app_insights_api_key", developer_app_insights_api_key)
        if developer_app_insights_application_id is not None:
            pulumi.set(__self__, "developer_app_insights_application_id", developer_app_insights_application_id)
        if developer_app_insights_key is not None:
            pulumi.set(__self__, "developer_app_insights_key", developer_app_insights_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if microsoft_app_id is not None:
            pulumi.set(__self__, "microsoft_app_id", microsoft_app_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if streaming_endpoint_enabled is not None:
            pulumi.set(__self__, "streaming_endpoint_enabled", streaming_endpoint_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cmkKeyVaultUrl")
    def cmk_key_vault_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.

        > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.

        > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        """
        return pulumi.get(self, "cmk_key_vault_url")

    @cmk_key_vault_url.setter
    def cmk_key_vault_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cmk_key_vault_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Bot Channels Registration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application Insights API Key to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @developer_app_insights_api_key.setter
    def developer_app_insights_api_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "developer_app_insights_api_key", value)

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application Insights Application ID to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @developer_app_insights_application_id.setter
    def developer_app_insights_application_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "developer_app_insights_application_id", value)

    @property
    @pulumi.getter(name="developerAppInsightsKey")
    def developer_app_insights_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Application Insights Key to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_key")

    @developer_app_insights_key.setter
    def developer_app_insights_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "developer_app_insights_key", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Bot Channels Registration endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="microsoftAppId")
    def microsoft_app_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_id")

    @microsoft_app_id.setter
    def microsoft_app_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "microsoft_app_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Bot Channels Registration in an isolated network?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="streamingEndpointEnabled")
    def streaming_endpoint_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        """
        return pulumi.get(self, "streaming_endpoint_enabled")

    @streaming_endpoint_enabled.setter
    def streaming_endpoint_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "streaming_endpoint_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:bot/channelsRegistration:ChannelsRegistration")
class ChannelsRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmk_key_vault_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 microsoft_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Bot Channels Registration.

        > **Note:** Bot Channels Registration has been [deprecated by Azure](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-resources-faq-azure?view=azure-bot-service-4.0#why-are-web-app-bot-and-bot-channel-registration-being-deprecated). New implementations should use the `bot.ServiceAzureBot` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_channels_registration = azure.bot.ChannelsRegistration("example",
            name="example",
            location="global",
            resource_group_name=example.name,
            sku="F0",
            microsoft_app_id=current.client_id)
        ```

        ## Import

        Bot Channels Registration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/channelsRegistration:ChannelsRegistration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.BotService/botServices/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cmk_key_vault_url: The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.
               
               > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.
               
               > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        :param pulumi.Input[builtins.str] description: The description of the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_application_id: The Application Insights Application ID to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_key: The Application Insights Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] display_name: The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        :param pulumi.Input[builtins.str] endpoint: The Bot Channels Registration endpoint.
        :param pulumi.Input[builtins.str] icon_url: The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] microsoft_app_id: The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the Bot Channels Registration in an isolated network?
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ChannelsRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Bot Channels Registration.

        > **Note:** Bot Channels Registration has been [deprecated by Azure](https://learn.microsoft.com/en-us/azure/bot-service/bot-service-resources-faq-azure?view=azure-bot-service-4.0#why-are-web-app-bot-and-bot-channel-registration-being-deprecated). New implementations should use the `bot.ServiceAzureBot` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_channels_registration = azure.bot.ChannelsRegistration("example",
            name="example",
            location="global",
            resource_group_name=example.name,
            sku="F0",
            microsoft_app_id=current.client_id)
        ```

        ## Import

        Bot Channels Registration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:bot/channelsRegistration:ChannelsRegistration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.BotService/botServices/example
        ```

        :param str resource_name: The name of the resource.
        :param ChannelsRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ChannelsRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmk_key_vault_url: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_api_key: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_application_id: Optional[pulumi.Input[builtins.str]] = None,
                 developer_app_insights_key: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 icon_url: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 microsoft_app_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 streaming_endpoint_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ChannelsRegistrationArgs.__new__(ChannelsRegistrationArgs)

            __props__.__dict__["cmk_key_vault_url"] = cmk_key_vault_url
            __props__.__dict__["description"] = description
            __props__.__dict__["developer_app_insights_api_key"] = None if developer_app_insights_api_key is None else pulumi.Output.secret(developer_app_insights_api_key)
            __props__.__dict__["developer_app_insights_application_id"] = developer_app_insights_application_id
            __props__.__dict__["developer_app_insights_key"] = developer_app_insights_key
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["icon_url"] = icon_url
            __props__.__dict__["location"] = location
            if microsoft_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'microsoft_app_id'")
            __props__.__dict__["microsoft_app_id"] = microsoft_app_id
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["streaming_endpoint_enabled"] = streaming_endpoint_enabled
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["developerAppInsightsApiKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ChannelsRegistration, __self__).__init__(
            'azure:bot/channelsRegistration:ChannelsRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cmk_key_vault_url: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            developer_app_insights_api_key: Optional[pulumi.Input[builtins.str]] = None,
            developer_app_insights_application_id: Optional[pulumi.Input[builtins.str]] = None,
            developer_app_insights_key: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            icon_url: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            microsoft_app_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[builtins.str]] = None,
            streaming_endpoint_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'ChannelsRegistration':
        """
        Get an existing ChannelsRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cmk_key_vault_url: The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.
               
               > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.
               
               > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        :param pulumi.Input[builtins.str] description: The description of the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_api_key: The Application Insights API Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_application_id: The Application Insights Application ID to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] developer_app_insights_key: The Application Insights Key to associate with the Bot Channels Registration.
        :param pulumi.Input[builtins.str] display_name: The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        :param pulumi.Input[builtins.str] endpoint: The Bot Channels Registration endpoint.
        :param pulumi.Input[builtins.str] icon_url: The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        :param pulumi.Input[builtins.str] location: The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] microsoft_app_id: The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        :param pulumi.Input[builtins.bool] public_network_access_enabled: Is the Bot Channels Registration in an isolated network?
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] streaming_endpoint_enabled: Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ChannelsRegistrationState.__new__(_ChannelsRegistrationState)

        __props__.__dict__["cmk_key_vault_url"] = cmk_key_vault_url
        __props__.__dict__["description"] = description
        __props__.__dict__["developer_app_insights_api_key"] = developer_app_insights_api_key
        __props__.__dict__["developer_app_insights_application_id"] = developer_app_insights_application_id
        __props__.__dict__["developer_app_insights_key"] = developer_app_insights_key
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["icon_url"] = icon_url
        __props__.__dict__["location"] = location
        __props__.__dict__["microsoft_app_id"] = microsoft_app_id
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["streaming_endpoint_enabled"] = streaming_endpoint_enabled
        __props__.__dict__["tags"] = tags
        return ChannelsRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cmkKeyVaultUrl")
    def cmk_key_vault_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The CMK Key Vault Key URL to encrypt the Bot Channels Registration with the Customer Managed Encryption Key.

        > **Note:** It has to add the Key Vault Access Policy for the `Bot Service CMEK Prod` Service Principal and the `soft_delete_enabled` and the `purge_protection_enabled` is enabled on the `keyvault.KeyVault` resource while using `cmk_key_vault_url`.

        > **Note:** It has to turn off the CMK feature before revoking Key Vault Access Policy. For more information, please refer to [Revoke access to customer-managed keys](https://docs.microsoft.com/azure/bot-service/bot-service-encryption?view=azure-bot-service-4.0&WT.mc_id=Portal-Microsoft_Azure_BotService#revoke-access-to-customer-managed-keys).
        """
        return pulumi.get(self, "cmk_key_vault_url")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Bot Channels Registration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="developerAppInsightsApiKey")
    def developer_app_insights_api_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Application Insights API Key to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_api_key")

    @property
    @pulumi.getter(name="developerAppInsightsApplicationId")
    def developer_app_insights_application_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Application Insights Application ID to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_application_id")

    @property
    @pulumi.getter(name="developerAppInsightsKey")
    def developer_app_insights_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Application Insights Key to associate with the Bot Channels Registration.
        """
        return pulumi.get(self, "developer_app_insights_key")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Bot Channels Registration will be displayed as. This defaults to `name` if not specified.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Bot Channels Registration endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The icon URL to visually identify the Bot Channels Registration. Defaults to `https://docs.botframework.com/static/devportal/client/images/bot-framework-default.png`.
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="microsoftAppId")
    def microsoft_app_id(self) -> pulumi.Output[builtins.str]:
        """
        The Microsoft Application ID for the Bot Channels Registration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "microsoft_app_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Bot Channels Registration. Changing this forces a new resource to be created. Must be globally unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the Bot Channels Registration in an isolated network?
        """
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Bot Channels Registration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[builtins.str]:
        """
        The SKU of the Bot Channels Registration. Valid values include `F0` or `S1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="streamingEndpointEnabled")
    def streaming_endpoint_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the streaming endpoint enabled for the Bot Channels Registration. Defaults to `false`.
        """
        return pulumi.get(self, "streaming_endpoint_enabled")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

