# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ChannelDirectLineSite',
    'ChannelFacebookPage',
    'ChannelLineLineChannel',
    'ChannelWebChatSite',
]

@pulumi.output_type
class ChannelDirectLineSite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointParametersEnabled":
            suggest = "endpoint_parameters_enabled"
        elif key == "enhancedAuthenticationEnabled":
            suggest = "enhanced_authentication_enabled"
        elif key == "storageEnabled":
            suggest = "storage_enabled"
        elif key == "trustedOrigins":
            suggest = "trusted_origins"
        elif key == "userUploadEnabled":
            suggest = "user_upload_enabled"
        elif key == "v1Allowed":
            suggest = "v1_allowed"
        elif key == "v3Allowed":
            suggest = "v3_allowed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelDirectLineSite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelDirectLineSite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelDirectLineSite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 enabled: Optional[builtins.bool] = None,
                 endpoint_parameters_enabled: Optional[builtins.bool] = None,
                 enhanced_authentication_enabled: Optional[builtins.bool] = None,
                 id: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None,
                 key2: Optional[builtins.str] = None,
                 storage_enabled: Optional[builtins.bool] = None,
                 trusted_origins: Optional[Sequence[builtins.str]] = None,
                 user_upload_enabled: Optional[builtins.bool] = None,
                 v1_allowed: Optional[builtins.bool] = None,
                 v3_allowed: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the site
        :param builtins.bool enabled: Enables/Disables this site. Defaults to `true`.
        :param builtins.bool endpoint_parameters_enabled: Is the endpoint parameters enabled for this site?
        :param builtins.bool enhanced_authentication_enabled: Enables additional security measures for this site, see [Enhanced Directline Authentication Features](https://blog.botframework.com/2018/09/25/enhanced-direct-line-authentication-features). Disabled by default.
        :param builtins.str id: Id for the site
        :param builtins.str key: Primary key for accessing this site
        :param builtins.str key2: Secondary key for accessing this site
        :param builtins.bool storage_enabled: Is the storage site enabled for detailed logging? Defaults to `true`.
        :param Sequence[builtins.str] trusted_origins: This field is required when `is_secure_site_enabled` is enabled. Determines which origins can establish a Directline conversation for this site.
        :param builtins.bool user_upload_enabled: Is the user upload enabled for this site? Defaults to `true`.
        :param builtins.bool v1_allowed: Enables v1 of the Directline protocol for this site. Defaults to `true`.
        :param builtins.bool v3_allowed: Enables v3 of the Directline protocol for this site. Defaults to `true`.
        """
        pulumi.set(__self__, "name", name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "endpoint_parameters_enabled", endpoint_parameters_enabled)
        if enhanced_authentication_enabled is not None:
            pulumi.set(__self__, "enhanced_authentication_enabled", enhanced_authentication_enabled)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if key2 is not None:
            pulumi.set(__self__, "key2", key2)
        if storage_enabled is not None:
            pulumi.set(__self__, "storage_enabled", storage_enabled)
        if trusted_origins is not None:
            pulumi.set(__self__, "trusted_origins", trusted_origins)
        if user_upload_enabled is not None:
            pulumi.set(__self__, "user_upload_enabled", user_upload_enabled)
        if v1_allowed is not None:
            pulumi.set(__self__, "v1_allowed", v1_allowed)
        if v3_allowed is not None:
            pulumi.set(__self__, "v3_allowed", v3_allowed)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the site
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Enables/Disables this site. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="endpointParametersEnabled")
    def endpoint_parameters_enabled(self) -> Optional[builtins.bool]:
        """
        Is the endpoint parameters enabled for this site?
        """
        return pulumi.get(self, "endpoint_parameters_enabled")

    @property
    @pulumi.getter(name="enhancedAuthenticationEnabled")
    def enhanced_authentication_enabled(self) -> Optional[builtins.bool]:
        """
        Enables additional security measures for this site, see [Enhanced Directline Authentication Features](https://blog.botframework.com/2018/09/25/enhanced-direct-line-authentication-features). Disabled by default.
        """
        return pulumi.get(self, "enhanced_authentication_enabled")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Id for the site
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        Primary key for accessing this site
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def key2(self) -> Optional[builtins.str]:
        """
        Secondary key for accessing this site
        """
        return pulumi.get(self, "key2")

    @property
    @pulumi.getter(name="storageEnabled")
    def storage_enabled(self) -> Optional[builtins.bool]:
        """
        Is the storage site enabled for detailed logging? Defaults to `true`.
        """
        return pulumi.get(self, "storage_enabled")

    @property
    @pulumi.getter(name="trustedOrigins")
    def trusted_origins(self) -> Optional[Sequence[builtins.str]]:
        """
        This field is required when `is_secure_site_enabled` is enabled. Determines which origins can establish a Directline conversation for this site.
        """
        return pulumi.get(self, "trusted_origins")

    @property
    @pulumi.getter(name="userUploadEnabled")
    def user_upload_enabled(self) -> Optional[builtins.bool]:
        """
        Is the user upload enabled for this site? Defaults to `true`.
        """
        return pulumi.get(self, "user_upload_enabled")

    @property
    @pulumi.getter(name="v1Allowed")
    def v1_allowed(self) -> Optional[builtins.bool]:
        """
        Enables v1 of the Directline protocol for this site. Defaults to `true`.
        """
        return pulumi.get(self, "v1_allowed")

    @property
    @pulumi.getter(name="v3Allowed")
    def v3_allowed(self) -> Optional[builtins.bool]:
        """
        Enables v3 of the Directline protocol for this site. Defaults to `true`.
        """
        return pulumi.get(self, "v3_allowed")


@pulumi.output_type
class ChannelFacebookPage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelFacebookPage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelFacebookPage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelFacebookPage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: builtins.str,
                 id: builtins.str):
        """
        :param builtins.str access_token: The Facebook Page Access Token for the Facebook Channel.
        :param builtins.str id: The Facebook Page ID for the Facebook Channel.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> builtins.str:
        """
        The Facebook Page Access Token for the Facebook Channel.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The Facebook Page ID for the Facebook Channel.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ChannelLineLineChannel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessToken":
            suggest = "access_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelLineLineChannel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelLineLineChannel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelLineLineChannel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_token: builtins.str,
                 secret: builtins.str):
        """
        :param builtins.str access_token: The access token which is used to call the Line Channel API.
        :param builtins.str secret: The secret which is used to access the Line Channel.
        """
        pulumi.set(__self__, "access_token", access_token)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="accessToken")
    def access_token(self) -> builtins.str:
        """
        The access token which is used to call the Line Channel API.
        """
        return pulumi.get(self, "access_token")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        The secret which is used to access the Line Channel.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ChannelWebChatSite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointParametersEnabled":
            suggest = "endpoint_parameters_enabled"
        elif key == "storageEnabled":
            suggest = "storage_enabled"
        elif key == "userUploadEnabled":
            suggest = "user_upload_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelWebChatSite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelWebChatSite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelWebChatSite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 endpoint_parameters_enabled: Optional[builtins.bool] = None,
                 storage_enabled: Optional[builtins.bool] = None,
                 user_upload_enabled: Optional[builtins.bool] = None):
        """
        :param builtins.str name: The name of the site.
        :param builtins.bool endpoint_parameters_enabled: Is the endpoint parameters enabled for this site?
        :param builtins.bool storage_enabled: Is the storage site enabled for detailed logging? Defaults to `true`.
        :param builtins.bool user_upload_enabled: Is the user upload enabled for this site? Defaults to `true`.
        """
        pulumi.set(__self__, "name", name)
        if endpoint_parameters_enabled is not None:
            pulumi.set(__self__, "endpoint_parameters_enabled", endpoint_parameters_enabled)
        if storage_enabled is not None:
            pulumi.set(__self__, "storage_enabled", storage_enabled)
        if user_upload_enabled is not None:
            pulumi.set(__self__, "user_upload_enabled", user_upload_enabled)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the site.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="endpointParametersEnabled")
    def endpoint_parameters_enabled(self) -> Optional[builtins.bool]:
        """
        Is the endpoint parameters enabled for this site?
        """
        return pulumi.get(self, "endpoint_parameters_enabled")

    @property
    @pulumi.getter(name="storageEnabled")
    def storage_enabled(self) -> Optional[builtins.bool]:
        """
        Is the storage site enabled for detailed logging? Defaults to `true`.
        """
        return pulumi.get(self, "storage_enabled")

    @property
    @pulumi.getter(name="userUploadEnabled")
    def user_upload_enabled(self) -> Optional[builtins.bool]:
        """
        Is the user upload enabled for this site? Defaults to `true`.
        """
        return pulumi.get(self, "user_upload_enabled")


