# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointArgs', 'Endpoint']

@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 origins: pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]],
                 profile_name: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 content_types_to_compresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delivery_rules: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]]] = None,
                 geo_filters: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]]] = None,
                 global_delivery_rule: Optional[pulumi.Input['EndpointGlobalDeliveryRuleArgs']] = None,
                 is_compression_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_http_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 is_https_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimization_type: Optional[pulumi.Input[builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[builtins.str]] = None,
                 origin_path: Optional[pulumi.Input[builtins.str]] = None,
                 probe_path: Optional[pulumi.Input[builtins.str]] = None,
                 querystring_caching_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Endpoint resource.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]] origins: The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] profile_name: The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_types_to_compresses: An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]] delivery_rules: Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]] geo_filters: A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        :param pulumi.Input['EndpointGlobalDeliveryRuleArgs'] global_delivery_rule: Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        :param pulumi.Input[builtins.bool] is_compression_enabled: Indicates whether compression is to be enabled.
        :param pulumi.Input[builtins.bool] is_http_allowed: Specifies if http allowed. Defaults to `true`.
        :param pulumi.Input[builtins.bool] is_https_allowed: Specifies if https allowed. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] optimization_type: What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        :param pulumi.Input[builtins.str] origin_host_header: The host header CDN provider will send along with content requests to origins.
        :param pulumi.Input[builtins.str] origin_path: The path used at for origin requests.
        :param pulumi.Input[builtins.str] probe_path: the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.
               
               > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        :param pulumi.Input[builtins.str] querystring_caching_behaviour: Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "origins", origins)
        pulumi.set(__self__, "profile_name", profile_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if content_types_to_compresses is not None:
            pulumi.set(__self__, "content_types_to_compresses", content_types_to_compresses)
        if delivery_rules is not None:
            pulumi.set(__self__, "delivery_rules", delivery_rules)
        if geo_filters is not None:
            pulumi.set(__self__, "geo_filters", geo_filters)
        if global_delivery_rule is not None:
            pulumi.set(__self__, "global_delivery_rule", global_delivery_rule)
        if is_compression_enabled is not None:
            pulumi.set(__self__, "is_compression_enabled", is_compression_enabled)
        if is_http_allowed is not None:
            pulumi.set(__self__, "is_http_allowed", is_http_allowed)
        if is_https_allowed is not None:
            pulumi.set(__self__, "is_https_allowed", is_https_allowed)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimization_type is not None:
            pulumi.set(__self__, "optimization_type", optimization_type)
        if origin_host_header is not None:
            pulumi.set(__self__, "origin_host_header", origin_host_header)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if probe_path is not None:
            pulumi.set(__self__, "probe_path", probe_path)
        if querystring_caching_behaviour is not None:
            pulumi.set(__self__, "querystring_caching_behaviour", querystring_caching_behaviour)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def origins(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]]:
        """
        The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Input[builtins.str]:
        """
        The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="contentTypesToCompresses")
    def content_types_to_compresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        """
        return pulumi.get(self, "content_types_to_compresses")

    @content_types_to_compresses.setter
    def content_types_to_compresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "content_types_to_compresses", value)

    @property
    @pulumi.getter(name="deliveryRules")
    def delivery_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]]]:
        """
        Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        """
        return pulumi.get(self, "delivery_rules")

    @delivery_rules.setter
    def delivery_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]]]):
        pulumi.set(self, "delivery_rules", value)

    @property
    @pulumi.getter(name="geoFilters")
    def geo_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]]]:
        """
        A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        """
        return pulumi.get(self, "geo_filters")

    @geo_filters.setter
    def geo_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]]]):
        pulumi.set(self, "geo_filters", value)

    @property
    @pulumi.getter(name="globalDeliveryRule")
    def global_delivery_rule(self) -> Optional[pulumi.Input['EndpointGlobalDeliveryRuleArgs']]:
        """
        Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        """
        return pulumi.get(self, "global_delivery_rule")

    @global_delivery_rule.setter
    def global_delivery_rule(self, value: Optional[pulumi.Input['EndpointGlobalDeliveryRuleArgs']]):
        pulumi.set(self, "global_delivery_rule", value)

    @property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether compression is to be enabled.
        """
        return pulumi.get(self, "is_compression_enabled")

    @is_compression_enabled.setter
    def is_compression_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_compression_enabled", value)

    @property
    @pulumi.getter(name="isHttpAllowed")
    def is_http_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if http allowed. Defaults to `true`.
        """
        return pulumi.get(self, "is_http_allowed")

    @is_http_allowed.setter
    def is_http_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_http_allowed", value)

    @property
    @pulumi.getter(name="isHttpsAllowed")
    def is_https_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if https allowed. Defaults to `true`.
        """
        return pulumi.get(self, "is_https_allowed")

    @is_https_allowed.setter
    def is_https_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_https_allowed", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optimizationType")
    def optimization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        """
        return pulumi.get(self, "optimization_type")

    @optimization_type.setter
    def optimization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "optimization_type", value)

    @property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host header CDN provider will send along with content requests to origins.
        """
        return pulumi.get(self, "origin_host_header")

    @origin_host_header.setter
    def origin_host_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_host_header", value)

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path used at for origin requests.
        """
        return pulumi.get(self, "origin_path")

    @origin_path.setter
    def origin_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_path", value)

    @property
    @pulumi.getter(name="probePath")
    def probe_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.

        > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        """
        return pulumi.get(self, "probe_path")

    @probe_path.setter
    def probe_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_path", value)

    @property
    @pulumi.getter(name="querystringCachingBehaviour")
    def querystring_caching_behaviour(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        """
        return pulumi.get(self, "querystring_caching_behaviour")

    @querystring_caching_behaviour.setter
    def querystring_caching_behaviour(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "querystring_caching_behaviour", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EndpointState:
    def __init__(__self__, *,
                 content_types_to_compresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delivery_rules: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 geo_filters: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]]] = None,
                 global_delivery_rule: Optional[pulumi.Input['EndpointGlobalDeliveryRuleArgs']] = None,
                 is_compression_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_http_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 is_https_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimization_type: Optional[pulumi.Input[builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[builtins.str]] = None,
                 origin_path: Optional[pulumi.Input[builtins.str]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]]] = None,
                 probe_path: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 querystring_caching_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Endpoint resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_types_to_compresses: An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]] delivery_rules: Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] fqdn: The Fully Qualified Domain Name of the CDN Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]] geo_filters: A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        :param pulumi.Input['EndpointGlobalDeliveryRuleArgs'] global_delivery_rule: Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        :param pulumi.Input[builtins.bool] is_compression_enabled: Indicates whether compression is to be enabled.
        :param pulumi.Input[builtins.bool] is_http_allowed: Specifies if http allowed. Defaults to `true`.
        :param pulumi.Input[builtins.bool] is_https_allowed: Specifies if https allowed. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] optimization_type: What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        :param pulumi.Input[builtins.str] origin_host_header: The host header CDN provider will send along with content requests to origins.
        :param pulumi.Input[builtins.str] origin_path: The path used at for origin requests.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]] origins: The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_path: the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.
               
               > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        :param pulumi.Input[builtins.str] profile_name: The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] querystring_caching_behaviour: Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if content_types_to_compresses is not None:
            pulumi.set(__self__, "content_types_to_compresses", content_types_to_compresses)
        if delivery_rules is not None:
            pulumi.set(__self__, "delivery_rules", delivery_rules)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if geo_filters is not None:
            pulumi.set(__self__, "geo_filters", geo_filters)
        if global_delivery_rule is not None:
            pulumi.set(__self__, "global_delivery_rule", global_delivery_rule)
        if is_compression_enabled is not None:
            pulumi.set(__self__, "is_compression_enabled", is_compression_enabled)
        if is_http_allowed is not None:
            pulumi.set(__self__, "is_http_allowed", is_http_allowed)
        if is_https_allowed is not None:
            pulumi.set(__self__, "is_https_allowed", is_https_allowed)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimization_type is not None:
            pulumi.set(__self__, "optimization_type", optimization_type)
        if origin_host_header is not None:
            pulumi.set(__self__, "origin_host_header", origin_host_header)
        if origin_path is not None:
            pulumi.set(__self__, "origin_path", origin_path)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if probe_path is not None:
            pulumi.set(__self__, "probe_path", probe_path)
        if profile_name is not None:
            pulumi.set(__self__, "profile_name", profile_name)
        if querystring_caching_behaviour is not None:
            pulumi.set(__self__, "querystring_caching_behaviour", querystring_caching_behaviour)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="contentTypesToCompresses")
    def content_types_to_compresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        """
        return pulumi.get(self, "content_types_to_compresses")

    @content_types_to_compresses.setter
    def content_types_to_compresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "content_types_to_compresses", value)

    @property
    @pulumi.getter(name="deliveryRules")
    def delivery_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]]]:
        """
        Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        """
        return pulumi.get(self, "delivery_rules")

    @delivery_rules.setter
    def delivery_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointDeliveryRuleArgs']]]]):
        pulumi.set(self, "delivery_rules", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Fully Qualified Domain Name of the CDN Endpoint.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter(name="geoFilters")
    def geo_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]]]:
        """
        A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        """
        return pulumi.get(self, "geo_filters")

    @geo_filters.setter
    def geo_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGeoFilterArgs']]]]):
        pulumi.set(self, "geo_filters", value)

    @property
    @pulumi.getter(name="globalDeliveryRule")
    def global_delivery_rule(self) -> Optional[pulumi.Input['EndpointGlobalDeliveryRuleArgs']]:
        """
        Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        """
        return pulumi.get(self, "global_delivery_rule")

    @global_delivery_rule.setter
    def global_delivery_rule(self, value: Optional[pulumi.Input['EndpointGlobalDeliveryRuleArgs']]):
        pulumi.set(self, "global_delivery_rule", value)

    @property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether compression is to be enabled.
        """
        return pulumi.get(self, "is_compression_enabled")

    @is_compression_enabled.setter
    def is_compression_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_compression_enabled", value)

    @property
    @pulumi.getter(name="isHttpAllowed")
    def is_http_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if http allowed. Defaults to `true`.
        """
        return pulumi.get(self, "is_http_allowed")

    @is_http_allowed.setter
    def is_http_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_http_allowed", value)

    @property
    @pulumi.getter(name="isHttpsAllowed")
    def is_https_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if https allowed. Defaults to `true`.
        """
        return pulumi.get(self, "is_https_allowed")

    @is_https_allowed.setter
    def is_https_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_https_allowed", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optimizationType")
    def optimization_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        """
        return pulumi.get(self, "optimization_type")

    @optimization_type.setter
    def optimization_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "optimization_type", value)

    @property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host header CDN provider will send along with content requests to origins.
        """
        return pulumi.get(self, "origin_host_header")

    @origin_host_header.setter
    def origin_host_header(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_host_header", value)

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path used at for origin requests.
        """
        return pulumi.get(self, "origin_path")

    @origin_path.setter
    def origin_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "origin_path", value)

    @property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]]]:
        """
        The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointOriginArgs']]]]):
        pulumi.set(self, "origins", value)

    @property
    @pulumi.getter(name="probePath")
    def probe_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.

        > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        """
        return pulumi.get(self, "probe_path")

    @probe_path.setter
    def probe_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "probe_path", value)

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_name")

    @profile_name.setter
    def profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "profile_name", value)

    @property
    @pulumi.getter(name="querystringCachingBehaviour")
    def querystring_caching_behaviour(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        """
        return pulumi.get(self, "querystring_caching_behaviour")

    @querystring_caching_behaviour.setter
    def querystring_caching_behaviour(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "querystring_caching_behaviour", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:cdn/endpoint:Endpoint")
class Endpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_types_to_compresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delivery_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointDeliveryRuleArgs', 'EndpointDeliveryRuleArgsDict']]]]] = None,
                 geo_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointGeoFilterArgs', 'EndpointGeoFilterArgsDict']]]]] = None,
                 global_delivery_rule: Optional[pulumi.Input[Union['EndpointGlobalDeliveryRuleArgs', 'EndpointGlobalDeliveryRuleArgsDict']]] = None,
                 is_compression_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_http_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 is_https_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimization_type: Optional[pulumi.Input[builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[builtins.str]] = None,
                 origin_path: Optional[pulumi.Input[builtins.str]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointOriginArgs', 'EndpointOriginArgsDict']]]]] = None,
                 probe_path: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 querystring_caching_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        A CDN Endpoint is the entity within a CDN Profile containing configuration information regarding caching behaviours and origins. The CDN Endpoint is exposed using the URL format `<endpointname>.azureedge.net`.

        !> **Note:** Azure rolled out a breaking change on Friday 9th April 2021 which may cause issues with the CDN/FrontDoor resources. More information is available in this GitHub issue - unfortunately this may necessitate a breaking change to the CDN and FrontDoor resources, more information will be posted in the GitHub issue as the necessary changes are identified.

        !> **Note:** The CDN services from Edgio(formerly Verizon) was shut down on 15 January 2025 and is no longer available.

        !> **Note:** Support for CDN services from Akamai was removed on 31 October 2023.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_profile = azure.cdn.Profile("example",
            name="example-cdn",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_Microsoft")
        example_endpoint = azure.cdn.Endpoint("example",
            name="example",
            profile_name=example_profile.name,
            location=example.location,
            resource_group_name=example.name,
            origins=[{
                "name": "example",
                "host_name": "www.contoso.com",
            }])
        ```

        ## Import

        CDN Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/endpoint:Endpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Cdn/profiles/myprofile1/endpoints/myendpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_types_to_compresses: An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointDeliveryRuleArgs', 'EndpointDeliveryRuleArgsDict']]]] delivery_rules: Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointGeoFilterArgs', 'EndpointGeoFilterArgsDict']]]] geo_filters: A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        :param pulumi.Input[Union['EndpointGlobalDeliveryRuleArgs', 'EndpointGlobalDeliveryRuleArgsDict']] global_delivery_rule: Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        :param pulumi.Input[builtins.bool] is_compression_enabled: Indicates whether compression is to be enabled.
        :param pulumi.Input[builtins.bool] is_http_allowed: Specifies if http allowed. Defaults to `true`.
        :param pulumi.Input[builtins.bool] is_https_allowed: Specifies if https allowed. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] optimization_type: What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        :param pulumi.Input[builtins.str] origin_host_header: The host header CDN provider will send along with content requests to origins.
        :param pulumi.Input[builtins.str] origin_path: The path used at for origin requests.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointOriginArgs', 'EndpointOriginArgsDict']]]] origins: The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_path: the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.
               
               > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        :param pulumi.Input[builtins.str] profile_name: The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] querystring_caching_behaviour: Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A CDN Endpoint is the entity within a CDN Profile containing configuration information regarding caching behaviours and origins. The CDN Endpoint is exposed using the URL format `<endpointname>.azureedge.net`.

        !> **Note:** Azure rolled out a breaking change on Friday 9th April 2021 which may cause issues with the CDN/FrontDoor resources. More information is available in this GitHub issue - unfortunately this may necessitate a breaking change to the CDN and FrontDoor resources, more information will be posted in the GitHub issue as the necessary changes are identified.

        !> **Note:** The CDN services from Edgio(formerly Verizon) was shut down on 15 January 2025 and is no longer available.

        !> **Note:** Support for CDN services from Akamai was removed on 31 October 2023.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_profile = azure.cdn.Profile("example",
            name="example-cdn",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard_Microsoft")
        example_endpoint = azure.cdn.Endpoint("example",
            name="example",
            profile_name=example_profile.name,
            location=example.location,
            resource_group_name=example.name,
            origins=[{
                "name": "example",
                "host_name": "www.contoso.com",
            }])
        ```

        ## Import

        CDN Endpoints can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/endpoint:Endpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Cdn/profiles/myprofile1/endpoints/myendpoint1
        ```

        :param str resource_name: The name of the resource.
        :param EndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_types_to_compresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 delivery_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointDeliveryRuleArgs', 'EndpointDeliveryRuleArgsDict']]]]] = None,
                 geo_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointGeoFilterArgs', 'EndpointGeoFilterArgsDict']]]]] = None,
                 global_delivery_rule: Optional[pulumi.Input[Union['EndpointGlobalDeliveryRuleArgs', 'EndpointGlobalDeliveryRuleArgsDict']]] = None,
                 is_compression_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_http_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 is_https_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 optimization_type: Optional[pulumi.Input[builtins.str]] = None,
                 origin_host_header: Optional[pulumi.Input[builtins.str]] = None,
                 origin_path: Optional[pulumi.Input[builtins.str]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointOriginArgs', 'EndpointOriginArgsDict']]]]] = None,
                 probe_path: Optional[pulumi.Input[builtins.str]] = None,
                 profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 querystring_caching_behaviour: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointArgs.__new__(EndpointArgs)

            __props__.__dict__["content_types_to_compresses"] = content_types_to_compresses
            __props__.__dict__["delivery_rules"] = delivery_rules
            __props__.__dict__["geo_filters"] = geo_filters
            __props__.__dict__["global_delivery_rule"] = global_delivery_rule
            __props__.__dict__["is_compression_enabled"] = is_compression_enabled
            __props__.__dict__["is_http_allowed"] = is_http_allowed
            __props__.__dict__["is_https_allowed"] = is_https_allowed
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["optimization_type"] = optimization_type
            __props__.__dict__["origin_host_header"] = origin_host_header
            __props__.__dict__["origin_path"] = origin_path
            if origins is None and not opts.urn:
                raise TypeError("Missing required property 'origins'")
            __props__.__dict__["origins"] = origins
            __props__.__dict__["probe_path"] = probe_path
            if profile_name is None and not opts.urn:
                raise TypeError("Missing required property 'profile_name'")
            __props__.__dict__["profile_name"] = profile_name
            __props__.__dict__["querystring_caching_behaviour"] = querystring_caching_behaviour
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["fqdn"] = None
        super(Endpoint, __self__).__init__(
            'azure:cdn/endpoint:Endpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_types_to_compresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            delivery_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointDeliveryRuleArgs', 'EndpointDeliveryRuleArgsDict']]]]] = None,
            fqdn: Optional[pulumi.Input[builtins.str]] = None,
            geo_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointGeoFilterArgs', 'EndpointGeoFilterArgsDict']]]]] = None,
            global_delivery_rule: Optional[pulumi.Input[Union['EndpointGlobalDeliveryRuleArgs', 'EndpointGlobalDeliveryRuleArgsDict']]] = None,
            is_compression_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_http_allowed: Optional[pulumi.Input[builtins.bool]] = None,
            is_https_allowed: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            optimization_type: Optional[pulumi.Input[builtins.str]] = None,
            origin_host_header: Optional[pulumi.Input[builtins.str]] = None,
            origin_path: Optional[pulumi.Input[builtins.str]] = None,
            origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EndpointOriginArgs', 'EndpointOriginArgsDict']]]]] = None,
            probe_path: Optional[pulumi.Input[builtins.str]] = None,
            profile_name: Optional[pulumi.Input[builtins.str]] = None,
            querystring_caching_behaviour: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'Endpoint':
        """
        Get an existing Endpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] content_types_to_compresses: An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointDeliveryRuleArgs', 'EndpointDeliveryRuleArgsDict']]]] delivery_rules: Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] fqdn: The Fully Qualified Domain Name of the CDN Endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointGeoFilterArgs', 'EndpointGeoFilterArgsDict']]]] geo_filters: A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        :param pulumi.Input[Union['EndpointGlobalDeliveryRuleArgs', 'EndpointGlobalDeliveryRuleArgsDict']] global_delivery_rule: Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        :param pulumi.Input[builtins.bool] is_compression_enabled: Indicates whether compression is to be enabled.
        :param pulumi.Input[builtins.bool] is_http_allowed: Specifies if http allowed. Defaults to `true`.
        :param pulumi.Input[builtins.bool] is_https_allowed: Specifies if https allowed. Defaults to `true`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] optimization_type: What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        :param pulumi.Input[builtins.str] origin_host_header: The host header CDN provider will send along with content requests to origins.
        :param pulumi.Input[builtins.str] origin_path: The path used at for origin requests.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EndpointOriginArgs', 'EndpointOriginArgsDict']]]] origins: The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] probe_path: the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.
               
               > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        :param pulumi.Input[builtins.str] profile_name: The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] querystring_caching_behaviour: Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointState.__new__(_EndpointState)

        __props__.__dict__["content_types_to_compresses"] = content_types_to_compresses
        __props__.__dict__["delivery_rules"] = delivery_rules
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["geo_filters"] = geo_filters
        __props__.__dict__["global_delivery_rule"] = global_delivery_rule
        __props__.__dict__["is_compression_enabled"] = is_compression_enabled
        __props__.__dict__["is_http_allowed"] = is_http_allowed
        __props__.__dict__["is_https_allowed"] = is_https_allowed
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["optimization_type"] = optimization_type
        __props__.__dict__["origin_host_header"] = origin_host_header
        __props__.__dict__["origin_path"] = origin_path
        __props__.__dict__["origins"] = origins
        __props__.__dict__["probe_path"] = probe_path
        __props__.__dict__["profile_name"] = profile_name
        __props__.__dict__["querystring_caching_behaviour"] = querystring_caching_behaviour
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return Endpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contentTypesToCompresses")
    def content_types_to_compresses(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An array of strings that indicates a content types on which compression will be applied. The value for the elements should be MIME types.
        """
        return pulumi.get(self, "content_types_to_compresses")

    @property
    @pulumi.getter(name="deliveryRules")
    def delivery_rules(self) -> pulumi.Output[Optional[Sequence['outputs.EndpointDeliveryRule']]]:
        """
        Rules for the rules engine. An endpoint can contain up until 4 of those rules that consist of conditions and actions. A `delivery_rule` blocks as defined below.
        """
        return pulumi.get(self, "delivery_rules")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[builtins.str]:
        """
        The Fully Qualified Domain Name of the CDN Endpoint.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter(name="geoFilters")
    def geo_filters(self) -> pulumi.Output[Optional[Sequence['outputs.EndpointGeoFilter']]]:
        """
        A set of Geo Filters for this CDN Endpoint. Each `geo_filter` block supports fields documented below.
        """
        return pulumi.get(self, "geo_filters")

    @property
    @pulumi.getter(name="globalDeliveryRule")
    def global_delivery_rule(self) -> pulumi.Output[Optional['outputs.EndpointGlobalDeliveryRule']]:
        """
        Actions that are valid for all resources regardless of any conditions. A `global_delivery_rule` block as defined below.
        """
        return pulumi.get(self, "global_delivery_rule")

    @property
    @pulumi.getter(name="isCompressionEnabled")
    def is_compression_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether compression is to be enabled.
        """
        return pulumi.get(self, "is_compression_enabled")

    @property
    @pulumi.getter(name="isHttpAllowed")
    def is_http_allowed(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if http allowed. Defaults to `true`.
        """
        return pulumi.get(self, "is_http_allowed")

    @property
    @pulumi.getter(name="isHttpsAllowed")
    def is_https_allowed(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if https allowed. Defaults to `true`.
        """
        return pulumi.get(self, "is_https_allowed")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optimizationType")
    def optimization_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        What types of optimization should this CDN Endpoint optimize for? Possible values include `DynamicSiteAcceleration`, `GeneralMediaStreaming`, `GeneralWebDelivery`, `LargeFileDownload` and `VideoOnDemandMediaStreaming`.
        """
        return pulumi.get(self, "optimization_type")

    @property
    @pulumi.getter(name="originHostHeader")
    def origin_host_header(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The host header CDN provider will send along with content requests to origins.
        """
        return pulumi.get(self, "origin_host_header")

    @property
    @pulumi.getter(name="originPath")
    def origin_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path used at for origin requests.
        """
        return pulumi.get(self, "origin_path")

    @property
    @pulumi.getter
    def origins(self) -> pulumi.Output[Sequence['outputs.EndpointOrigin']]:
        """
        The set of origins of the CDN endpoint. When multiple origins exist, the first origin will be used as primary and rest will be used as failover options. Each `origin` block supports fields documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "origins")

    @property
    @pulumi.getter(name="probePath")
    def probe_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        the path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the `origin_path`.

        > **Note:** `global_delivery_rule` and `delivery_rule` are currently only available for `Microsoft_Standard` CDN profiles.
        """
        return pulumi.get(self, "probe_path")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> pulumi.Output[builtins.str]:
        """
        The CDN Profile to which to attach the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="querystringCachingBehaviour")
    def querystring_caching_behaviour(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets query string caching behavior. Allowed values are `IgnoreQueryString`, `BypassCaching` and `UseQueryString`. `NotSet` value can be used for `Premium Verizon` CDN profile. Defaults to `IgnoreQueryString`.
        """
        return pulumi.get(self, "querystring_caching_behaviour")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the CDN Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

