# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorCustomDomainArgs', 'FrontdoorCustomDomain']

@pulumi.input_type
class FrontdoorCustomDomainArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: pulumi.Input[builtins.str],
                 host_name: pulumi.Input[builtins.str],
                 tls: pulumi.Input['FrontdoorCustomDomainTlsArgs'],
                 dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FrontdoorCustomDomain resource.
        :param pulumi.Input[builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] host_name: The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input['FrontdoorCustomDomainTlsArgs'] tls: A `tls` block as defined below.
        :param pulumi.Input[builtins.str] dns_zone_id: The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.
               
               <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.
               
               > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        :param pulumi.Input[builtins.str] name: The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        """
        pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "tls", tls)
        if dns_zone_id is not None:
            pulumi.set(__self__, "dns_zone_id", dns_zone_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Input[builtins.str]:
        """
        The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def tls(self) -> pulumi.Input['FrontdoorCustomDomainTlsArgs']:
        """
        A `tls` block as defined below.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: pulumi.Input['FrontdoorCustomDomainTlsArgs']):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.

        <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.

        > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        """
        return pulumi.get(self, "dns_zone_id")

    @dns_zone_id.setter
    def dns_zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_zone_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FrontdoorCustomDomainState:
    def __init__(__self__, *,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 host_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tls: Optional[pulumi.Input['FrontdoorCustomDomainTlsArgs']] = None,
                 validation_token: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FrontdoorCustomDomain resources.
        :param pulumi.Input[builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] dns_zone_id: The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.
               
               <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.
               
               > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        :param pulumi.Input[builtins.str] expiration_date: The date time that the token expires.
        :param pulumi.Input[builtins.str] host_name: The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input['FrontdoorCustomDomainTlsArgs'] tls: A `tls` block as defined below.
        :param pulumi.Input[builtins.str] validation_token: Challenge used for DNS TXT record or file based validation.
        """
        if cdn_frontdoor_profile_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_profile_id", cdn_frontdoor_profile_id)
        if dns_zone_id is not None:
            pulumi.set(__self__, "dns_zone_id", dns_zone_id)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if validation_token is not None:
            pulumi.set(__self__, "validation_token", validation_token)

    @property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @cdn_frontdoor_profile_id.setter
    def cdn_frontdoor_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_profile_id", value)

    @property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.

        <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.

        > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        """
        return pulumi.get(self, "dns_zone_id")

    @dns_zone_id.setter
    def dns_zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_zone_id", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date time that the token expires.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input['FrontdoorCustomDomainTlsArgs']]:
        """
        A `tls` block as defined below.
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input['FrontdoorCustomDomainTlsArgs']]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter(name="validationToken")
    def validation_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Challenge used for DNS TXT record or file based validation.
        """
        return pulumi.get(self, "validation_token")

    @validation_token.setter
    def validation_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "validation_token", value)


@pulumi.type_token("azure:cdn/frontdoorCustomDomain:FrontdoorCustomDomain")
class FrontdoorCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tls: Optional[pulumi.Input[Union['FrontdoorCustomDomainTlsArgs', 'FrontdoorCustomDomainTlsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="sub-domain.domain.com",
            resource_group_name=example.name)
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_custom_domain = azure.cdn.FrontdoorCustomDomain("example",
            name="example-customDomain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name="contoso.fabrikam.com",
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        ```

        ## Example DNS Auth TXT Record Usage

        The name of your DNS TXT record should be in the format of `_dnsauth.<your_subdomain>`. So, for example, if we use the `host_name` in the example usage above you would create a DNS TXT record with the name of `_dnsauth.contoso` which contains the value of the Front Door Custom Domains `validation_token` field. See the [product documentation](https://learn.microsoft.com/azure/frontdoor/standard-premium/how-to-add-custom-domain) for more information.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.dns.TxtRecord("example",
            name=std.join(separator=".",
                input=[
                    "_dnsauth",
                    "contoso",
                ]).result,
            zone_name=example_azurerm_dns_zone["name"],
            resource_group_name=example_azurerm_resource_group["name"],
            ttl=3600,
            records=[{
                "value": example_azurerm_cdn_frontdoor_custom_domain["validationToken"],
            }])
        ```

        ## Example CNAME Record Usage

        !> **Note:** You **must** include the `depends_on` meta-argument which references both the `cdn.FrontdoorRoute` and the `cdn.FrontdoorSecurityPolicy` that are associated with your Custom Domain. The reason for these `depends_on` meta-arguments is because all of the resources for the Custom Domain need to be associated within Front Door before the CNAME record can be written to the domains DNS, else the CNAME validation will fail and Front Door will not enable traffic to the Domain.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.dns.CNameRecord("example",
            name="contoso",
            zone_name=example_azurerm_dns_zone["name"],
            resource_group_name=example_azurerm_resource_group["name"],
            ttl=3600,
            record=example_azurerm_cdn_frontdoor_endpoint["hostName"],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_azurerm_cdn_frontdoor_route,
                    example_azurerm_cdn_frontdoor_security_policy,
                ]))
        ```

        ## Import

        Front Door Custom Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorCustomDomain:FrontdoorCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/customDomains/customDomain1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] dns_zone_id: The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.
               
               <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.
               
               > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        :param pulumi.Input[builtins.str] host_name: The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[Union['FrontdoorCustomDomainTlsArgs', 'FrontdoorCustomDomainTlsArgsDict']] tls: A `tls` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="sub-domain.domain.com",
            resource_group_name=example.name)
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_custom_domain = azure.cdn.FrontdoorCustomDomain("example",
            name="example-customDomain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name="contoso.fabrikam.com",
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        ```

        ## Example DNS Auth TXT Record Usage

        The name of your DNS TXT record should be in the format of `_dnsauth.<your_subdomain>`. So, for example, if we use the `host_name` in the example usage above you would create a DNS TXT record with the name of `_dnsauth.contoso` which contains the value of the Front Door Custom Domains `validation_token` field. See the [product documentation](https://learn.microsoft.com/azure/frontdoor/standard-premium/how-to-add-custom-domain) for more information.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.dns.TxtRecord("example",
            name=std.join(separator=".",
                input=[
                    "_dnsauth",
                    "contoso",
                ]).result,
            zone_name=example_azurerm_dns_zone["name"],
            resource_group_name=example_azurerm_resource_group["name"],
            ttl=3600,
            records=[{
                "value": example_azurerm_cdn_frontdoor_custom_domain["validationToken"],
            }])
        ```

        ## Example CNAME Record Usage

        !> **Note:** You **must** include the `depends_on` meta-argument which references both the `cdn.FrontdoorRoute` and the `cdn.FrontdoorSecurityPolicy` that are associated with your Custom Domain. The reason for these `depends_on` meta-arguments is because all of the resources for the Custom Domain need to be associated within Front Door before the CNAME record can be written to the domains DNS, else the CNAME validation will fail and Front Door will not enable traffic to the Domain.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.dns.CNameRecord("example",
            name="contoso",
            zone_name=example_azurerm_dns_zone["name"],
            resource_group_name=example_azurerm_resource_group["name"],
            ttl=3600,
            record=example_azurerm_cdn_frontdoor_endpoint["hostName"],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_azurerm_cdn_frontdoor_route,
                    example_azurerm_cdn_frontdoor_security_policy,
                ]))
        ```

        ## Import

        Front Door Custom Domains can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorCustomDomain:FrontdoorCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/customDomains/customDomain1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 host_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tls: Optional[pulumi.Input[Union['FrontdoorCustomDomainTlsArgs', 'FrontdoorCustomDomainTlsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorCustomDomainArgs.__new__(FrontdoorCustomDomainArgs)

            if cdn_frontdoor_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_profile_id'")
            __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
            __props__.__dict__["dns_zone_id"] = dns_zone_id
            if host_name is None and not opts.urn:
                raise TypeError("Missing required property 'host_name'")
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["name"] = name
            if tls is None and not opts.urn:
                raise TypeError("Missing required property 'tls'")
            __props__.__dict__["tls"] = tls
            __props__.__dict__["expiration_date"] = None
            __props__.__dict__["validation_token"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:cdn/frontdoorCustomEndpoint:FrontdoorCustomEndpoint")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(FrontdoorCustomDomain, __self__).__init__(
            'azure:cdn/frontdoorCustomDomain:FrontdoorCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdn_frontdoor_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            dns_zone_id: Optional[pulumi.Input[builtins.str]] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            host_name: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tls: Optional[pulumi.Input[Union['FrontdoorCustomDomainTlsArgs', 'FrontdoorCustomDomainTlsArgsDict']]] = None,
            validation_token: Optional[pulumi.Input[builtins.str]] = None) -> 'FrontdoorCustomDomain':
        """
        Get an existing FrontdoorCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cdn_frontdoor_profile_id: The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] dns_zone_id: The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.
               
               <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.
               
               > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        :param pulumi.Input[builtins.str] expiration_date: The date time that the token expires.
        :param pulumi.Input[builtins.str] host_name: The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        :param pulumi.Input[Union['FrontdoorCustomDomainTlsArgs', 'FrontdoorCustomDomainTlsArgsDict']] tls: A `tls` block as defined below.
        :param pulumi.Input[builtins.str] validation_token: Challenge used for DNS TXT record or file based validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorCustomDomainState.__new__(_FrontdoorCustomDomainState)

        __props__.__dict__["cdn_frontdoor_profile_id"] = cdn_frontdoor_profile_id
        __props__.__dict__["dns_zone_id"] = dns_zone_id
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["name"] = name
        __props__.__dict__["tls"] = tls
        __props__.__dict__["validation_token"] = validation_token
        return FrontdoorCustomDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cdnFrontdoorProfileId")
    def cdn_frontdoor_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Front Door Profile. Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_profile_id")

    @property
    @pulumi.getter(name="dnsZoneId")
    def dns_zone_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Azure DNS Zone which should be used for this Front Door Custom Domain. If you are using Azure to host your [DNS domains](https://learn.microsoft.com/azure/dns/dns-overview), you must delegate the domain provider's domain name system (DNS) to an Azure DNS Zone. For more information, see [Delegate a domain to Azure DNS](https://learn.microsoft.com/azure/dns/dns-delegate-domain-azure-dns). Otherwise, if you're using your own domain provider to handle your DNS, you must validate the Front Door Custom Domain by creating the DNS TXT records manually.

        <!-- * `pre_validated_cdn_frontdoor_custom_domain_id` - (Optional) The resource ID of the pre-validated Front Door Custom Domain. This domain type is used when you wish to onboard a validated Azure service domain, and then configure the Azure service behind an Azure Front Door.

        > **Note:** Currently `pre_validated_cdn_frontdoor_custom_domain_id` only supports domains validated by Static Web App. -->
        """
        return pulumi.get(self, "dns_zone_id")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[builtins.str]:
        """
        The date time that the token expires.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[builtins.str]:
        """
        The host name of the domain. The `host_name` field must be the FQDN of your domain(e.g. `contoso.fabrikam.com`). Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Front Door Custom Domain. Possible values must be between 2 and 260 characters in length, must begin with a letter or number, end with a letter or number and contain only letters, numbers and hyphens. Changing this forces a new Front Door Custom Domain to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tls(self) -> pulumi.Output['outputs.FrontdoorCustomDomainTls']:
        """
        A `tls` block as defined below.
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter(name="validationToken")
    def validation_token(self) -> pulumi.Output[builtins.str]:
        """
        Challenge used for DNS TXT record or file based validation.
        """
        return pulumi.get(self, "validation_token")

