# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FrontdoorCustomDomainAssociationArgs', 'FrontdoorCustomDomainAssociation']

@pulumi.input_type
class FrontdoorCustomDomainAssociationArgs:
    def __init__(__self__, *,
                 cdn_frontdoor_custom_domain_id: pulumi.Input[builtins.str],
                 cdn_frontdoor_route_ids: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        The set of arguments for constructing a FrontdoorCustomDomainAssociation resource.
        :param pulumi.Input[builtins.str] cdn_frontdoor_custom_domain_id: The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cdn_frontdoor_route_ids: One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.
               
               > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        pulumi.set(__self__, "cdn_frontdoor_custom_domain_id", cdn_frontdoor_custom_domain_id)
        pulumi.set(__self__, "cdn_frontdoor_route_ids", cdn_frontdoor_route_ids)

    @property
    @pulumi.getter(name="cdnFrontdoorCustomDomainId")
    def cdn_frontdoor_custom_domain_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_custom_domain_id")

    @cdn_frontdoor_custom_domain_id.setter
    def cdn_frontdoor_custom_domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cdn_frontdoor_custom_domain_id", value)

    @property
    @pulumi.getter(name="cdnFrontdoorRouteIds")
    def cdn_frontdoor_route_ids(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.

        > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        return pulumi.get(self, "cdn_frontdoor_route_ids")

    @cdn_frontdoor_route_ids.setter
    def cdn_frontdoor_route_ids(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "cdn_frontdoor_route_ids", value)


@pulumi.input_type
class _FrontdoorCustomDomainAssociationState:
    def __init__(__self__, *,
                 cdn_frontdoor_custom_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 cdn_frontdoor_route_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FrontdoorCustomDomainAssociation resources.
        :param pulumi.Input[builtins.str] cdn_frontdoor_custom_domain_id: The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cdn_frontdoor_route_ids: One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.
               
               > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        if cdn_frontdoor_custom_domain_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_custom_domain_id", cdn_frontdoor_custom_domain_id)
        if cdn_frontdoor_route_ids is not None:
            pulumi.set(__self__, "cdn_frontdoor_route_ids", cdn_frontdoor_route_ids)

    @property
    @pulumi.getter(name="cdnFrontdoorCustomDomainId")
    def cdn_frontdoor_custom_domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_custom_domain_id")

    @cdn_frontdoor_custom_domain_id.setter
    def cdn_frontdoor_custom_domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_custom_domain_id", value)

    @property
    @pulumi.getter(name="cdnFrontdoorRouteIds")
    def cdn_frontdoor_route_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.

        > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        return pulumi.get(self, "cdn_frontdoor_route_ids")

    @cdn_frontdoor_route_ids.setter
    def cdn_frontdoor_route_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "cdn_frontdoor_route_ids", value)


@pulumi.type_token("azure:cdn/frontdoorCustomDomainAssociation:FrontdoorCustomDomainAssociation")
class FrontdoorCustomDomainAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_custom_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 cdn_frontdoor_route_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages the association between a Front Door (standard/premium) Custom Domain and one or more Front Door (standard/premium) Routes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="domain.com",
            resource_group_name=example.name)
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origin-group",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            session_affinity_enabled=True,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes=10,
            health_probe={
                "interval_in_seconds": 240,
                "path": "/healthProbe",
                "protocol": "Https",
                "request_type": "HEAD",
            },
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name="contoso.com",
            http_port=80,
            https_port=443,
            origin_host_header="www.contoso.com",
            priority=1,
            weight=1)
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_rule_set = azure.cdn.FrontdoorRuleSet("example",
            name="ExampleRuleSet",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_custom_domain = azure.cdn.FrontdoorCustomDomain("example",
            name="example-customDomain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name=std.join_output(separator=".",
                input=[
                    "contoso",
                    example_zone.name,
                ]).apply(lambda invoke: invoke.result),
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        example_frontdoor_route = azure.cdn.FrontdoorRoute("example",
            name="example-route",
            cdn_frontdoor_endpoint_id=example_frontdoor_endpoint.id,
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            cdn_frontdoor_origin_ids=[example_frontdoor_origin.id],
            cdn_frontdoor_rule_set_ids=[example_frontdoor_rule_set.id],
            enabled=True,
            forwarding_protocol="HttpsOnly",
            https_redirect_enabled=True,
            patterns_to_matches=["/*"],
            supported_protocols=[
                "Http",
                "Https",
            ],
            cdn_frontdoor_custom_domain_ids=[example_frontdoor_custom_domain.id],
            link_to_default_domain=False)
        example_frontdoor_custom_domain_association = azure.cdn.FrontdoorCustomDomainAssociation("example",
            cdn_frontdoor_custom_domain_id=example_frontdoor_custom_domain.id,
            cdn_frontdoor_route_ids=[example_frontdoor_route.id])
        ```

        ## Import

        Front Door Custom Domain Associations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorCustomDomainAssociation:FrontdoorCustomDomainAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/associations/assoc1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cdn_frontdoor_custom_domain_id: The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cdn_frontdoor_route_ids: One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.
               
               > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorCustomDomainAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the association between a Front Door (standard/premium) Custom Domain and one or more Front Door (standard/premium) Routes.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_zone = azure.dns.Zone("example",
            name="domain.com",
            resource_group_name=example.name)
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Standard_AzureFrontDoor")
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-origin-group",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            session_affinity_enabled=True,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes=10,
            health_probe={
                "interval_in_seconds": 240,
                "path": "/healthProbe",
                "protocol": "Https",
                "request_type": "HEAD",
            },
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name="contoso.com",
            http_port=80,
            https_port=443,
            origin_host_header="www.contoso.com",
            priority=1,
            weight=1)
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_rule_set = azure.cdn.FrontdoorRuleSet("example",
            name="ExampleRuleSet",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_custom_domain = azure.cdn.FrontdoorCustomDomain("example",
            name="example-customDomain",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            dns_zone_id=example_zone.id,
            host_name=std.join_output(separator=".",
                input=[
                    "contoso",
                    example_zone.name,
                ]).apply(lambda invoke: invoke.result),
            tls={
                "certificate_type": "ManagedCertificate",
                "minimum_tls_version": "TLS12",
            })
        example_frontdoor_route = azure.cdn.FrontdoorRoute("example",
            name="example-route",
            cdn_frontdoor_endpoint_id=example_frontdoor_endpoint.id,
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            cdn_frontdoor_origin_ids=[example_frontdoor_origin.id],
            cdn_frontdoor_rule_set_ids=[example_frontdoor_rule_set.id],
            enabled=True,
            forwarding_protocol="HttpsOnly",
            https_redirect_enabled=True,
            patterns_to_matches=["/*"],
            supported_protocols=[
                "Http",
                "Https",
            ],
            cdn_frontdoor_custom_domain_ids=[example_frontdoor_custom_domain.id],
            link_to_default_domain=False)
        example_frontdoor_custom_domain_association = azure.cdn.FrontdoorCustomDomainAssociation("example",
            cdn_frontdoor_custom_domain_id=example_frontdoor_custom_domain.id,
            cdn_frontdoor_route_ids=[example_frontdoor_route.id])
        ```

        ## Import

        Front Door Custom Domain Associations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorCustomDomainAssociation:FrontdoorCustomDomainAssociation example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/associations/assoc1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorCustomDomainAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorCustomDomainAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cdn_frontdoor_custom_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 cdn_frontdoor_route_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorCustomDomainAssociationArgs.__new__(FrontdoorCustomDomainAssociationArgs)

            if cdn_frontdoor_custom_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_custom_domain_id'")
            __props__.__dict__["cdn_frontdoor_custom_domain_id"] = cdn_frontdoor_custom_domain_id
            if cdn_frontdoor_route_ids is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_route_ids'")
            __props__.__dict__["cdn_frontdoor_route_ids"] = cdn_frontdoor_route_ids
        super(FrontdoorCustomDomainAssociation, __self__).__init__(
            'azure:cdn/frontdoorCustomDomainAssociation:FrontdoorCustomDomainAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cdn_frontdoor_custom_domain_id: Optional[pulumi.Input[builtins.str]] = None,
            cdn_frontdoor_route_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'FrontdoorCustomDomainAssociation':
        """
        Get an existing FrontdoorCustomDomainAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cdn_frontdoor_custom_domain_id: The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] cdn_frontdoor_route_ids: One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.
               
               > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorCustomDomainAssociationState.__new__(_FrontdoorCustomDomainAssociationState)

        __props__.__dict__["cdn_frontdoor_custom_domain_id"] = cdn_frontdoor_custom_domain_id
        __props__.__dict__["cdn_frontdoor_route_ids"] = cdn_frontdoor_route_ids
        return FrontdoorCustomDomainAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cdnFrontdoorCustomDomainId")
    def cdn_frontdoor_custom_domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Front Door Custom Domain that should be managed by the association resource. Changing this forces a new association resource to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_custom_domain_id")

    @property
    @pulumi.getter(name="cdnFrontdoorRouteIds")
    def cdn_frontdoor_route_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        One or more IDs of the Front Door Route to which the Front Door Custom Domain is associated with.

        > **Note:** This should include all of the Front Door Route resources that the Front Door Custom Domain is associated with. If the list of Front Door Routes is not complete you will receive the service side error `This resource is still associated with a route. Please delete the association with the route first before deleting this resource` when you attempt to `destroy`/`delete` your Front Door Custom Domain.
        """
        return pulumi.get(self, "cdn_frontdoor_route_ids")

