# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorFirewallPolicyArgs', 'FrontdoorFirewallPolicy']

@pulumi.input_type
class FrontdoorFirewallPolicyArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 sku_name: pulumi.Input[builtins.str],
                 custom_block_response_body: Optional[pulumi.Input[builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 js_challenge_cookie_expiration_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 log_scrubbing: Optional[pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs']] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 request_body_check_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a FrontdoorFirewallPolicy resource.
        :param pulumi.Input[builtins.str] mode: The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.
               
               > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        :param pulumi.Input[builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the Front Door Firewall Policy enabled? Defaults to `true`.
        :param pulumi.Input[builtins.int] js_challenge_cookie_expiration_in_minutes: Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.
               
               > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.
               
               !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs'] log_scrubbing: A `log_scrubbing` block as defined below.
               
               !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[builtins.bool] request_body_check_enabled: Should policy managed rules inspect the request body content? Defaults to `true`.
               
               > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Front Door Firewall Policy.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if custom_block_response_body is not None:
            pulumi.set(__self__, "custom_block_response_body", custom_block_response_body)
        if custom_block_response_status_code is not None:
            pulumi.set(__self__, "custom_block_response_status_code", custom_block_response_status_code)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if js_challenge_cookie_expiration_in_minutes is not None:
            pulumi.set(__self__, "js_challenge_cookie_expiration_in_minutes", js_challenge_cookie_expiration_in_minutes)
        if log_scrubbing is not None:
            pulumi.set(__self__, "log_scrubbing", log_scrubbing)
        if managed_rules is not None:
            pulumi.set(__self__, "managed_rules", managed_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if request_body_check_enabled is not None:
            pulumi.set(__self__, "request_body_check_enabled", request_body_check_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[builtins.str]:
        """
        The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.

        > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @custom_block_response_body.setter
    def custom_block_response_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_block_response_body", value)

    @property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @custom_block_response_status_code.setter
    def custom_block_response_status_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "custom_block_response_status_code", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]]]:
        """
        One or more `custom_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Front Door Firewall Policy enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="jsChallengeCookieExpirationInMinutes")
    def js_challenge_cookie_expiration_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.

        > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.

        !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        """
        return pulumi.get(self, "js_challenge_cookie_expiration_in_minutes")

    @js_challenge_cookie_expiration_in_minutes.setter
    def js_challenge_cookie_expiration_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "js_challenge_cookie_expiration_in_minutes", value)

    @property
    @pulumi.getter(name="logScrubbing")
    def log_scrubbing(self) -> Optional[pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs']]:
        """
        A `log_scrubbing` block as defined below.

        !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        """
        return pulumi.get(self, "log_scrubbing")

    @log_scrubbing.setter
    def log_scrubbing(self, value: Optional[pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs']]):
        pulumi.set(self, "log_scrubbing", value)

    @property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]]]:
        """
        One or more `managed_rule` blocks as defined below.
        """
        return pulumi.get(self, "managed_rules")

    @managed_rules.setter
    def managed_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]]]):
        pulumi.set(self, "managed_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="requestBodyCheckEnabled")
    def request_body_check_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should policy managed rules inspect the request body content? Defaults to `true`.

        > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        """
        return pulumi.get(self, "request_body_check_enabled")

    @request_body_check_enabled.setter
    def request_body_check_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "request_body_check_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Front Door Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FrontdoorFirewallPolicyState:
    def __init__(__self__, *,
                 custom_block_response_body: Optional[pulumi.Input[builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frontend_endpoint_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 js_challenge_cookie_expiration_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 log_scrubbing: Optional[pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs']] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 request_body_check_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering FrontdoorFirewallPolicy resources.
        :param pulumi.Input[builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the Front Door Firewall Policy enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] frontend_endpoint_ids: The Front Door Profiles frontend endpoints associated with this Front Door Firewall Policy.
        :param pulumi.Input[builtins.int] js_challenge_cookie_expiration_in_minutes: Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.
               
               > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.
               
               !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs'] log_scrubbing: A `log_scrubbing` block as defined below.
               
               !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] mode: The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        :param pulumi.Input[builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[builtins.bool] request_body_check_enabled: Should policy managed rules inspect the request body content? Defaults to `true`.
               
               > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.
               
               > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Front Door Firewall Policy.
        """
        if custom_block_response_body is not None:
            pulumi.set(__self__, "custom_block_response_body", custom_block_response_body)
        if custom_block_response_status_code is not None:
            pulumi.set(__self__, "custom_block_response_status_code", custom_block_response_status_code)
        if custom_rules is not None:
            pulumi.set(__self__, "custom_rules", custom_rules)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frontend_endpoint_ids is not None:
            pulumi.set(__self__, "frontend_endpoint_ids", frontend_endpoint_ids)
        if js_challenge_cookie_expiration_in_minutes is not None:
            pulumi.set(__self__, "js_challenge_cookie_expiration_in_minutes", js_challenge_cookie_expiration_in_minutes)
        if log_scrubbing is not None:
            pulumi.set(__self__, "log_scrubbing", log_scrubbing)
        if managed_rules is not None:
            pulumi.set(__self__, "managed_rules", managed_rules)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if request_body_check_enabled is not None:
            pulumi.set(__self__, "request_body_check_enabled", request_body_check_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @custom_block_response_body.setter
    def custom_block_response_body(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_block_response_body", value)

    @property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @custom_block_response_status_code.setter
    def custom_block_response_status_code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "custom_block_response_status_code", value)

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]]]:
        """
        One or more `custom_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_rules")

    @custom_rules.setter
    def custom_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyCustomRuleArgs']]]]):
        pulumi.set(self, "custom_rules", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the Front Door Firewall Policy enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="frontendEndpointIds")
    def frontend_endpoint_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The Front Door Profiles frontend endpoints associated with this Front Door Firewall Policy.
        """
        return pulumi.get(self, "frontend_endpoint_ids")

    @frontend_endpoint_ids.setter
    def frontend_endpoint_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "frontend_endpoint_ids", value)

    @property
    @pulumi.getter(name="jsChallengeCookieExpirationInMinutes")
    def js_challenge_cookie_expiration_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.

        > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.

        !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        """
        return pulumi.get(self, "js_challenge_cookie_expiration_in_minutes")

    @js_challenge_cookie_expiration_in_minutes.setter
    def js_challenge_cookie_expiration_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "js_challenge_cookie_expiration_in_minutes", value)

    @property
    @pulumi.getter(name="logScrubbing")
    def log_scrubbing(self) -> Optional[pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs']]:
        """
        A `log_scrubbing` block as defined below.

        !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        """
        return pulumi.get(self, "log_scrubbing")

    @log_scrubbing.setter
    def log_scrubbing(self, value: Optional[pulumi.Input['FrontdoorFirewallPolicyLogScrubbingArgs']]):
        pulumi.set(self, "log_scrubbing", value)

    @property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]]]:
        """
        One or more `managed_rule` blocks as defined below.
        """
        return pulumi.get(self, "managed_rules")

    @managed_rules.setter
    def managed_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FrontdoorFirewallPolicyManagedRuleArgs']]]]):
        pulumi.set(self, "managed_rules", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @property
    @pulumi.getter(name="requestBodyCheckEnabled")
    def request_body_check_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should policy managed rules inspect the request body content? Defaults to `true`.

        > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        """
        return pulumi.get(self, "request_body_check_enabled")

    @request_body_check_enabled.setter
    def request_body_check_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "request_body_check_enabled", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.

        > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Front Door Firewall Policy.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:cdn/frontdoorFirewallPolicy:FrontdoorFirewallPolicy")
class FrontdoorFirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_block_response_body: Optional[pulumi.Input[builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyCustomRuleArgs', 'FrontdoorFirewallPolicyCustomRuleArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 js_challenge_cookie_expiration_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 log_scrubbing: Optional[pulumi.Input[Union['FrontdoorFirewallPolicyLogScrubbingArgs', 'FrontdoorFirewallPolicyLogScrubbingArgsDict']]] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyManagedRuleArgs', 'FrontdoorFirewallPolicyManagedRuleArgsDict']]]]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 request_body_check_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Firewall Policy instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_firewall_policy = azure.cdn.FrontdoorFirewallPolicy("example",
            name="examplecdnfdwafpolicy",
            resource_group_name=example.name,
            sku_name=example_frontdoor_profile.sku_name,
            enabled=True,
            mode="Prevention",
            redirect_url="https://www.contoso.com",
            custom_block_response_status_code=403,
            custom_block_response_body="PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
            js_challenge_cookie_expiration_in_minutes=45,
            log_scrubbing={
                "enabled": True,
                "scrubbing_rules": [{
                    "enabled": True,
                    "match_variable": "RequestCookieNames",
                    "operator": "Equals",
                    "selector": "ChocolateChip",
                }],
            },
            custom_rules=[
                {
                    "name": "Rule1",
                    "enabled": True,
                    "priority": 1,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [{
                        "match_variable": "RemoteAddr",
                        "operator": "IPMatch",
                        "negation_condition": False,
                        "match_values": [
                            "10.0.1.0/24",
                            "10.0.0.0/24",
                        ],
                    }],
                },
                {
                    "name": "Rule2",
                    "enabled": True,
                    "priority": 50,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [
                        {
                            "match_variable": "RemoteAddr",
                            "operator": "IPMatch",
                            "negation_condition": False,
                            "match_values": ["192.168.1.0/24"],
                        },
                        {
                            "match_variable": "RequestHeader",
                            "selector": "UserAgent",
                            "operator": "Contains",
                            "negation_condition": False,
                            "match_values": ["windows"],
                            "transforms": [
                                "Lowercase",
                                "Trim",
                            ],
                        },
                    ],
                },
                {
                    "name": "CustomJSChallenge",
                    "enabled": True,
                    "priority": 100,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "JSChallenge",
                    "match_conditions": [{
                        "match_variable": "RemoteAddr",
                        "operator": "IPMatch",
                        "negation_condition": False,
                        "match_values": ["192.168.1.0/24"],
                    }],
                },
            ],
            managed_rules=[
                {
                    "type": "DefaultRuleSet",
                    "version": "1.0",
                    "action": "Log",
                    "exclusions": [{
                        "match_variable": "QueryStringArgNames",
                        "operator": "Equals",
                        "selector": "not_suspicious",
                    }],
                    "overrides": [
                        {
                            "rule_group_name": "PHP",
                            "rules": [{
                                "rule_id": "933100",
                                "enabled": False,
                                "action": "Block",
                            }],
                        },
                        {
                            "rule_group_name": "SQLI",
                            "exclusions": [{
                                "match_variable": "QueryStringArgNames",
                                "operator": "Equals",
                                "selector": "really_not_suspicious",
                            }],
                            "rules": [{
                                "rule_id": "942200",
                                "action": "Block",
                                "exclusions": [{
                                    "match_variable": "QueryStringArgNames",
                                    "operator": "Equals",
                                    "selector": "innocent",
                                }],
                            }],
                        },
                    ],
                },
                {
                    "type": "Microsoft_BotManagerRuleSet",
                    "version": "1.1",
                    "action": "Log",
                    "overrides": [{
                        "rule_group_name": "BadBots",
                        "rules": [{
                            "action": "JSChallenge",
                            "enabled": True,
                            "rule_id": "Bot100200",
                        }],
                    }],
                },
            ])
        ```

        ## `scrubbing_rule` Examples:

        The following table shows examples of `scrubbing_rule`'s that can be used to protect sensitive data:

        | Match Variable               | Operator       | Selector      | What Gets Scrubbed                                                            |
        | :--------------------------- | :------------- | :------------ | :---------------------------------------------------------------------------- |
        | `RequestHeaderNames`         | Equals         | keyToBlock    | {"matchVariableName":"HeaderValue:keyToBlock","matchVariableValue":"****"}    |
        | `RequestCookieNames`         | Equals         | cookieToBlock | {"matchVariableName":"CookieValue:cookieToBlock","matchVariableValue":"****"} |
        | `RequestBodyPostArgNames`    | Equals         | var           | {"matchVariableName":"PostParamValue:var","matchVariableValue":"****"}        |
        | `RequestBodyJsonArgNames`    | Equals         | JsonValue     | {"matchVariableName":"JsonValue:key","matchVariableValue":"****"}             |
        | `QueryStringArgNames`        | Equals         | foo           | {"matchVariableName":"QueryParamValue:foo","matchVariableValue":"****"}       |
        | `RequestIPAddress`           | Equals Any     | Not Supported | {"matchVariableName":"ClientIP","matchVariableValue":"****"}                  |
        | `RequestUri`                 | Equals Any     | Not Supported | {"matchVariableName":"URI","matchVariableValue":"****"}                       |

        ***

        ## Import

        Front Door Firewall Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorFirewallPolicy:FrontdoorFirewallPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/firewallPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyCustomRuleArgs', 'FrontdoorFirewallPolicyCustomRuleArgsDict']]]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the Front Door Firewall Policy enabled? Defaults to `true`.
        :param pulumi.Input[builtins.int] js_challenge_cookie_expiration_in_minutes: Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.
               
               > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.
               
               !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input[Union['FrontdoorFirewallPolicyLogScrubbingArgs', 'FrontdoorFirewallPolicyLogScrubbingArgsDict']] log_scrubbing: A `log_scrubbing` block as defined below.
               
               !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyManagedRuleArgs', 'FrontdoorFirewallPolicyManagedRuleArgsDict']]]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] mode: The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        :param pulumi.Input[builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[builtins.bool] request_body_check_enabled: Should policy managed rules inspect the request body content? Defaults to `true`.
               
               > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.
               
               > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Front Door Firewall Policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorFirewallPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Firewall Policy instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_firewall_policy = azure.cdn.FrontdoorFirewallPolicy("example",
            name="examplecdnfdwafpolicy",
            resource_group_name=example.name,
            sku_name=example_frontdoor_profile.sku_name,
            enabled=True,
            mode="Prevention",
            redirect_url="https://www.contoso.com",
            custom_block_response_status_code=403,
            custom_block_response_body="PGh0bWw+CjxoZWFkZXI+PHRpdGxlPkhlbGxvPC90aXRsZT48L2hlYWRlcj4KPGJvZHk+CkhlbGxvIHdvcmxkCjwvYm9keT4KPC9odG1sPg==",
            js_challenge_cookie_expiration_in_minutes=45,
            log_scrubbing={
                "enabled": True,
                "scrubbing_rules": [{
                    "enabled": True,
                    "match_variable": "RequestCookieNames",
                    "operator": "Equals",
                    "selector": "ChocolateChip",
                }],
            },
            custom_rules=[
                {
                    "name": "Rule1",
                    "enabled": True,
                    "priority": 1,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [{
                        "match_variable": "RemoteAddr",
                        "operator": "IPMatch",
                        "negation_condition": False,
                        "match_values": [
                            "10.0.1.0/24",
                            "10.0.0.0/24",
                        ],
                    }],
                },
                {
                    "name": "Rule2",
                    "enabled": True,
                    "priority": 50,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "Block",
                    "match_conditions": [
                        {
                            "match_variable": "RemoteAddr",
                            "operator": "IPMatch",
                            "negation_condition": False,
                            "match_values": ["192.168.1.0/24"],
                        },
                        {
                            "match_variable": "RequestHeader",
                            "selector": "UserAgent",
                            "operator": "Contains",
                            "negation_condition": False,
                            "match_values": ["windows"],
                            "transforms": [
                                "Lowercase",
                                "Trim",
                            ],
                        },
                    ],
                },
                {
                    "name": "CustomJSChallenge",
                    "enabled": True,
                    "priority": 100,
                    "rate_limit_duration_in_minutes": 1,
                    "rate_limit_threshold": 10,
                    "type": "MatchRule",
                    "action": "JSChallenge",
                    "match_conditions": [{
                        "match_variable": "RemoteAddr",
                        "operator": "IPMatch",
                        "negation_condition": False,
                        "match_values": ["192.168.1.0/24"],
                    }],
                },
            ],
            managed_rules=[
                {
                    "type": "DefaultRuleSet",
                    "version": "1.0",
                    "action": "Log",
                    "exclusions": [{
                        "match_variable": "QueryStringArgNames",
                        "operator": "Equals",
                        "selector": "not_suspicious",
                    }],
                    "overrides": [
                        {
                            "rule_group_name": "PHP",
                            "rules": [{
                                "rule_id": "933100",
                                "enabled": False,
                                "action": "Block",
                            }],
                        },
                        {
                            "rule_group_name": "SQLI",
                            "exclusions": [{
                                "match_variable": "QueryStringArgNames",
                                "operator": "Equals",
                                "selector": "really_not_suspicious",
                            }],
                            "rules": [{
                                "rule_id": "942200",
                                "action": "Block",
                                "exclusions": [{
                                    "match_variable": "QueryStringArgNames",
                                    "operator": "Equals",
                                    "selector": "innocent",
                                }],
                            }],
                        },
                    ],
                },
                {
                    "type": "Microsoft_BotManagerRuleSet",
                    "version": "1.1",
                    "action": "Log",
                    "overrides": [{
                        "rule_group_name": "BadBots",
                        "rules": [{
                            "action": "JSChallenge",
                            "enabled": True,
                            "rule_id": "Bot100200",
                        }],
                    }],
                },
            ])
        ```

        ## `scrubbing_rule` Examples:

        The following table shows examples of `scrubbing_rule`'s that can be used to protect sensitive data:

        | Match Variable               | Operator       | Selector      | What Gets Scrubbed                                                            |
        | :--------------------------- | :------------- | :------------ | :---------------------------------------------------------------------------- |
        | `RequestHeaderNames`         | Equals         | keyToBlock    | {"matchVariableName":"HeaderValue:keyToBlock","matchVariableValue":"****"}    |
        | `RequestCookieNames`         | Equals         | cookieToBlock | {"matchVariableName":"CookieValue:cookieToBlock","matchVariableValue":"****"} |
        | `RequestBodyPostArgNames`    | Equals         | var           | {"matchVariableName":"PostParamValue:var","matchVariableValue":"****"}        |
        | `RequestBodyJsonArgNames`    | Equals         | JsonValue     | {"matchVariableName":"JsonValue:key","matchVariableValue":"****"}             |
        | `QueryStringArgNames`        | Equals         | foo           | {"matchVariableName":"QueryParamValue:foo","matchVariableValue":"****"}       |
        | `RequestIPAddress`           | Equals Any     | Not Supported | {"matchVariableName":"ClientIP","matchVariableValue":"****"}                  |
        | `RequestUri`                 | Equals Any     | Not Supported | {"matchVariableName":"URI","matchVariableValue":"****"}                       |

        ***

        ## Import

        Front Door Firewall Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorFirewallPolicy:FrontdoorFirewallPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Network/frontDoorWebApplicationFirewallPolicies/firewallPolicy1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorFirewallPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorFirewallPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_block_response_body: Optional[pulumi.Input[builtins.str]] = None,
                 custom_block_response_status_code: Optional[pulumi.Input[builtins.int]] = None,
                 custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyCustomRuleArgs', 'FrontdoorFirewallPolicyCustomRuleArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 js_challenge_cookie_expiration_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 log_scrubbing: Optional[pulumi.Input[Union['FrontdoorFirewallPolicyLogScrubbingArgs', 'FrontdoorFirewallPolicyLogScrubbingArgsDict']]] = None,
                 managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyManagedRuleArgs', 'FrontdoorFirewallPolicyManagedRuleArgsDict']]]]] = None,
                 mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[builtins.str]] = None,
                 request_body_check_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorFirewallPolicyArgs.__new__(FrontdoorFirewallPolicyArgs)

            __props__.__dict__["custom_block_response_body"] = custom_block_response_body
            __props__.__dict__["custom_block_response_status_code"] = custom_block_response_status_code
            __props__.__dict__["custom_rules"] = custom_rules
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["js_challenge_cookie_expiration_in_minutes"] = js_challenge_cookie_expiration_in_minutes
            __props__.__dict__["log_scrubbing"] = log_scrubbing
            __props__.__dict__["managed_rules"] = managed_rules
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["request_body_check_enabled"] = request_body_check_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["frontend_endpoint_ids"] = None
        super(FrontdoorFirewallPolicy, __self__).__init__(
            'azure:cdn/frontdoorFirewallPolicy:FrontdoorFirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_block_response_body: Optional[pulumi.Input[builtins.str]] = None,
            custom_block_response_status_code: Optional[pulumi.Input[builtins.int]] = None,
            custom_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyCustomRuleArgs', 'FrontdoorFirewallPolicyCustomRuleArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            frontend_endpoint_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            js_challenge_cookie_expiration_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
            log_scrubbing: Optional[pulumi.Input[Union['FrontdoorFirewallPolicyLogScrubbingArgs', 'FrontdoorFirewallPolicyLogScrubbingArgsDict']]] = None,
            managed_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyManagedRuleArgs', 'FrontdoorFirewallPolicyManagedRuleArgsDict']]]]] = None,
            mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[builtins.str]] = None,
            request_body_check_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            sku_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'FrontdoorFirewallPolicy':
        """
        Get an existing FrontdoorFirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] custom_block_response_body: If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        :param pulumi.Input[builtins.int] custom_block_response_status_code: If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyCustomRuleArgs', 'FrontdoorFirewallPolicyCustomRuleArgsDict']]]] custom_rules: One or more `custom_rule` blocks as defined below.
        :param pulumi.Input[builtins.bool] enabled: Is the Front Door Firewall Policy enabled? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] frontend_endpoint_ids: The Front Door Profiles frontend endpoints associated with this Front Door Firewall Policy.
        :param pulumi.Input[builtins.int] js_challenge_cookie_expiration_in_minutes: Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.
               
               > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.
               
               !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input[Union['FrontdoorFirewallPolicyLogScrubbingArgs', 'FrontdoorFirewallPolicyLogScrubbingArgsDict']] log_scrubbing: A `log_scrubbing` block as defined below.
               
               !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FrontdoorFirewallPolicyManagedRuleArgs', 'FrontdoorFirewallPolicyManagedRuleArgsDict']]]] managed_rules: One or more `managed_rule` blocks as defined below.
        :param pulumi.Input[builtins.str] mode: The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        :param pulumi.Input[builtins.str] name: The name of the policy. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] redirect_url: If action type is redirect, this field represents redirect URL for the client.
        :param pulumi.Input[builtins.bool] request_body_check_enabled: Should policy managed rules inspect the request body content? Defaults to `true`.
               
               > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku_name: The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.
               
               > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Front Door Firewall Policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorFirewallPolicyState.__new__(_FrontdoorFirewallPolicyState)

        __props__.__dict__["custom_block_response_body"] = custom_block_response_body
        __props__.__dict__["custom_block_response_status_code"] = custom_block_response_status_code
        __props__.__dict__["custom_rules"] = custom_rules
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frontend_endpoint_ids"] = frontend_endpoint_ids
        __props__.__dict__["js_challenge_cookie_expiration_in_minutes"] = js_challenge_cookie_expiration_in_minutes
        __props__.__dict__["log_scrubbing"] = log_scrubbing
        __props__.__dict__["managed_rules"] = managed_rules
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["request_body_check_enabled"] = request_body_check_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        return FrontdoorFirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customBlockResponseBody")
    def custom_block_response_body(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response body. The body must be specified in base64 encoding.
        """
        return pulumi.get(self, "custom_block_response_body")

    @property
    @pulumi.getter(name="customBlockResponseStatusCode")
    def custom_block_response_status_code(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        If a `custom_rule` block's action type is `block`, this is the response status code. Possible values are `200`, `403`, `405`, `406`, or `429`.
        """
        return pulumi.get(self, "custom_block_response_status_code")

    @property
    @pulumi.getter(name="customRules")
    def custom_rules(self) -> pulumi.Output[Optional[Sequence['outputs.FrontdoorFirewallPolicyCustomRule']]]:
        """
        One or more `custom_rule` blocks as defined below.
        """
        return pulumi.get(self, "custom_rules")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Is the Front Door Firewall Policy enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="frontendEndpointIds")
    def frontend_endpoint_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The Front Door Profiles frontend endpoints associated with this Front Door Firewall Policy.
        """
        return pulumi.get(self, "frontend_endpoint_ids")

    @property
    @pulumi.getter(name="jsChallengeCookieExpirationInMinutes")
    def js_challenge_cookie_expiration_in_minutes(self) -> pulumi.Output[builtins.int]:
        """
        Specifies the JavaScript challenge cookie lifetime in minutes, after which the user will be revalidated. Possible values are between `5` to `1440` minutes. Defaults to `30` minutes.

        > **Note:** The `js_challenge_cookie_expiration_in_minutes` field can only be set on `Premium_AzureFrontDoor` sku's. Please see the [Product Documentation](https://learn.microsoft.com/azure/web-application-firewall/waf-javascript-challenge) for more information.

        !> **Note:** Setting the`js_challenge_cookie_expiration_in_minutes` policy is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        """
        return pulumi.get(self, "js_challenge_cookie_expiration_in_minutes")

    @property
    @pulumi.getter(name="logScrubbing")
    def log_scrubbing(self) -> pulumi.Output[Optional['outputs.FrontdoorFirewallPolicyLogScrubbing']]:
        """
        A `log_scrubbing` block as defined below.

        !> **Note:** Setting the`log_scrubbing` block is currently in **PREVIEW**. Please see the [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/) for legal terms that apply to Azure features that are in beta, preview, or otherwise not yet released into general availability.
        """
        return pulumi.get(self, "log_scrubbing")

    @property
    @pulumi.getter(name="managedRules")
    def managed_rules(self) -> pulumi.Output[Optional[Sequence['outputs.FrontdoorFirewallPolicyManagedRule']]]:
        """
        One or more `managed_rule` blocks as defined below.
        """
        return pulumi.get(self, "managed_rules")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[builtins.str]:
        """
        The Front Door Firewall Policy mode. Possible values are `Detection`, `Prevention`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        If action type is redirect, this field represents redirect URL for the client.
        """
        return pulumi.get(self, "redirect_url")

    @property
    @pulumi.getter(name="requestBodyCheckEnabled")
    def request_body_check_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Should policy managed rules inspect the request body content? Defaults to `true`.

        > **Note:** When run in `Detection` mode, the Front Door Firewall Policy doesn't take any other actions other than monitoring and logging the request and its matched Front Door Rule to the Web Application Firewall logs.
        """
        return pulumi.get(self, "request_body_check_enabled")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[builtins.str]:
        """
        The sku's pricing tier for this Front Door Firewall Policy. Possible values include `Standard_AzureFrontDoor` or `Premium_AzureFrontDoor`. Changing this forces a new resource to be created.

        > **Note:** The `Standard_AzureFrontDoor` Front Door Firewall Policy sku may contain `custom` rules only. The `Premium_AzureFrontDoor` Front Door Firewall Policy sku's may contain both `custom` and `managed` rules.
        """
        return pulumi.get(self, "sku_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the Front Door Firewall Policy.
        """
        return pulumi.get(self, "tags")

