# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFrontdoorEndpointResult',
    'AwaitableGetFrontdoorEndpointResult',
    'get_frontdoor_endpoint',
    'get_frontdoor_endpoint_output',
]

@pulumi.output_type
class GetFrontdoorEndpointResult:
    """
    A collection of values returned by getFrontdoorEndpoint.
    """
    def __init__(__self__, enabled=None, host_name=None, id=None, name=None, profile_name=None, resource_group_name=None, tags=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if host_name and not isinstance(host_name, str):
            raise TypeError("Expected argument 'host_name' to be a str")
        pulumi.set(__self__, "host_name", host_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if profile_name and not isinstance(profile_name, str):
            raise TypeError("Expected argument 'profile_name' to be a str")
        pulumi.set(__self__, "profile_name", profile_name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether this Front Door Endpoint is enabled or not.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> builtins.str:
        """
        Specifies the host name of the Front Door Endpoint, in the format `{endpointName}.{dnsZone}` (for example, `contoso.azureedge.net`).
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> builtins.str:
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        Specifies a mapping of Tags assigned to this Front Door Endpoint.
        """
        return pulumi.get(self, "tags")


class AwaitableGetFrontdoorEndpointResult(GetFrontdoorEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFrontdoorEndpointResult(
            enabled=self.enabled,
            host_name=self.host_name,
            id=self.id,
            name=self.name,
            profile_name=self.profile_name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_frontdoor_endpoint(name: Optional[builtins.str] = None,
                           profile_name: Optional[builtins.str] = None,
                           resource_group_name: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFrontdoorEndpointResult:
    """
    Use this data source to access information about an existing Front Door (standard/premium) Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cdn.get_frontdoor_endpoint(name="existing-endpoint",
        profile_name="existing-cdn-profile",
        resource_group_name="existing-resources")
    ```


    :param builtins.str name: Specifies the name of the Front Door Endpoint.
    :param builtins.str profile_name: The name of the Front Door Profile within which Front Door Endpoint exists.
    :param builtins.str resource_group_name: The name of the Resource Group where the Front Door Profile exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['profileName'] = profile_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cdn/getFrontdoorEndpoint:getFrontdoorEndpoint', __args__, opts=opts, typ=GetFrontdoorEndpointResult).value

    return AwaitableGetFrontdoorEndpointResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        host_name=pulumi.get(__ret__, 'host_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        profile_name=pulumi.get(__ret__, 'profile_name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_frontdoor_endpoint_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                  profile_name: Optional[pulumi.Input[builtins.str]] = None,
                                  resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFrontdoorEndpointResult]:
    """
    Use this data source to access information about an existing Front Door (standard/premium) Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cdn.get_frontdoor_endpoint(name="existing-endpoint",
        profile_name="existing-cdn-profile",
        resource_group_name="existing-resources")
    ```


    :param builtins.str name: Specifies the name of the Front Door Endpoint.
    :param builtins.str profile_name: The name of the Front Door Profile within which Front Door Endpoint exists.
    :param builtins.str resource_group_name: The name of the Resource Group where the Front Door Profile exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['profileName'] = profile_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cdn/getFrontdoorEndpoint:getFrontdoorEndpoint', __args__, opts=opts, typ=GetFrontdoorEndpointResult)
    return __ret__.apply(lambda __response__: GetFrontdoorEndpointResult(
        enabled=pulumi.get(__response__, 'enabled'),
        host_name=pulumi.get(__response__, 'host_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        profile_name=pulumi.get(__response__, 'profile_name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
