# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExperimentArgs', 'Experiment']

@pulumi.input_type
class ExperimentArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 selectors: pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]],
                 steps: pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]],
                 identity: Optional[pulumi.Input['ExperimentIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Experiment resource.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]] selectors: One or more `selectors` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]] steps: One or more `steps` blocks as defined below.
        :param pulumi.Input['ExperimentIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "selectors", selectors)
        pulumi.set(__self__, "steps", steps)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def selectors(self) -> pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]]:
        """
        One or more `selectors` blocks as defined below.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]]:
        """
        One or more `steps` blocks as defined below.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ExperimentIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ExperimentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ExperimentState:
    def __init__(__self__, *,
                 identity: Optional[pulumi.Input['ExperimentIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]]] = None):
        """
        Input properties used for looking up and filtering Experiment resources.
        :param pulumi.Input['ExperimentIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]] selectors: One or more `selectors` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]] steps: One or more `steps` blocks as defined below.
        """
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if steps is not None:
            pulumi.set(__self__, "steps", steps)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ExperimentIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ExperimentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]]]:
        """
        One or more `selectors` blocks as defined below.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentSelectorArgs']]]]):
        pulumi.set(self, "selectors", value)

    @property
    @pulumi.getter
    def steps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]]]:
        """
        One or more `steps` blocks as defined below.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ExperimentStepArgs']]]]):
        pulumi.set(self, "steps", value)


@pulumi.type_token("azure:chaosstudio/experiment:Experiment")
class Experiment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['ExperimentIdentityArgs', 'ExperimentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentSelectorArgs', 'ExperimentSelectorArgsDict']]]]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentStepArgs', 'ExperimentStepArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Chaos Studio Experiment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example.name,
            location=example.location,
            name="example")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "example",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            admin_password="example",
            disable_password_authentication=False,
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_target = azure.chaosstudio.Target("example",
            location=example.location,
            target_resource_id=example_linux_virtual_machine.id,
            target_type="Microsoft-VirtualMachine")
        example_capability = azure.chaosstudio.Capability("example",
            chaos_studio_target_id=example_target.id,
            capability_type="Shutdown-1.0")
        example_experiment = azure.chaosstudio.Experiment("example",
            location=example.location,
            name="example",
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            },
            selectors=[{
                "name": "Selector1",
                "chaos_studio_target_ids": [example_target.id],
            }],
            steps=[{
                "name": "example",
                "branches": [{
                    "name": "example",
                    "actions": [{
                        "urn": example_capability.capability_urn,
                        "selector_name": "Selector1",
                        "parameters": {
                            "abruptShutdown": "false",
                        },
                        "action_type": "continuous",
                        "duration": "PT10M",
                    }],
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Chaos`: 2023-11-01

        ## Import

        Chaos Studio Experiments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:chaosstudio/experiment:Experiment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Chaos/experiments/experiment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ExperimentIdentityArgs', 'ExperimentIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentSelectorArgs', 'ExperimentSelectorArgsDict']]]] selectors: One or more `selectors` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentStepArgs', 'ExperimentStepArgsDict']]]] steps: One or more `steps` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExperimentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Chaos Studio Experiment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="westeurope")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example.name,
            location=example.location,
            name="example")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "example",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            admin_password="example",
            disable_password_authentication=False,
            network_interface_ids=[example_network_interface.id],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_target = azure.chaosstudio.Target("example",
            location=example.location,
            target_resource_id=example_linux_virtual_machine.id,
            target_type="Microsoft-VirtualMachine")
        example_capability = azure.chaosstudio.Capability("example",
            chaos_studio_target_id=example_target.id,
            capability_type="Shutdown-1.0")
        example_experiment = azure.chaosstudio.Experiment("example",
            location=example.location,
            name="example",
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            },
            selectors=[{
                "name": "Selector1",
                "chaos_studio_target_ids": [example_target.id],
            }],
            steps=[{
                "name": "example",
                "branches": [{
                    "name": "example",
                    "actions": [{
                        "urn": example_capability.capability_urn,
                        "selector_name": "Selector1",
                        "parameters": {
                            "abruptShutdown": "false",
                        },
                        "action_type": "continuous",
                        "duration": "PT10M",
                    }],
                }],
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Chaos`: 2023-11-01

        ## Import

        Chaos Studio Experiments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:chaosstudio/experiment:Experiment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Chaos/experiments/experiment1
        ```

        :param str resource_name: The name of the resource.
        :param ExperimentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExperimentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['ExperimentIdentityArgs', 'ExperimentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentSelectorArgs', 'ExperimentSelectorArgsDict']]]]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentStepArgs', 'ExperimentStepArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExperimentArgs.__new__(ExperimentArgs)

            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if selectors is None and not opts.urn:
                raise TypeError("Missing required property 'selectors'")
            __props__.__dict__["selectors"] = selectors
            if steps is None and not opts.urn:
                raise TypeError("Missing required property 'steps'")
            __props__.__dict__["steps"] = steps
        super(Experiment, __self__).__init__(
            'azure:chaosstudio/experiment:Experiment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity: Optional[pulumi.Input[Union['ExperimentIdentityArgs', 'ExperimentIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentSelectorArgs', 'ExperimentSelectorArgsDict']]]]] = None,
            steps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ExperimentStepArgs', 'ExperimentStepArgsDict']]]]] = None) -> 'Experiment':
        """
        Get an existing Experiment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ExperimentIdentityArgs', 'ExperimentIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentSelectorArgs', 'ExperimentSelectorArgsDict']]]] selectors: One or more `selectors` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ExperimentStepArgs', 'ExperimentStepArgsDict']]]] steps: One or more `steps` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExperimentState.__new__(_ExperimentState)

        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["selectors"] = selectors
        __props__.__dict__["steps"] = steps
        return Experiment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ExperimentIdentity']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Chaos Studio Experiment. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Resource Group where the Chaos Studio Experiment should exist. Changing this forces a new Chaos Studio Experiment to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def selectors(self) -> pulumi.Output[Sequence['outputs.ExperimentSelector']]:
        """
        One or more `selectors` blocks as defined below.
        """
        return pulumi.get(self, "selectors")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.ExperimentStep']]:
        """
        One or more `steps` blocks as defined below.
        """
        return pulumi.get(self, "steps")

