# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AIServicesCustomerManagedKey',
    'AIServicesIdentity',
    'AIServicesNetworkAcls',
    'AIServicesNetworkAclsVirtualNetworkRule',
    'AIServicesStorage',
    'AccountCustomerManagedKey',
    'AccountIdentity',
    'AccountNetworkAcls',
    'AccountNetworkAclsVirtualNetworkRule',
    'AccountRaiPolicyContentFilter',
    'AccountStorage',
    'DeploymentModel',
    'DeploymentSku',
    'GetAccountIdentityResult',
]

@pulumi.output_type
class AIServicesCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityClientId":
            suggest = "identity_client_id"
        elif key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "managedHsmKeyId":
            suggest = "managed_hsm_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AIServicesCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AIServicesCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AIServicesCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_client_id: Optional[builtins.str] = None,
                 key_vault_key_id: Optional[builtins.str] = None,
                 managed_hsm_key_id: Optional[builtins.str] = None):
        """
        :param builtins.str identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there are multiple identities attached to the Azure AI Service.
        :param builtins.str key_vault_key_id: The ID of the Key Vault Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        :param builtins.str managed_hsm_key_id: The ID of the managed HSM Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[builtins.str]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there are multiple identities attached to the Azure AI Service.
        """
        return pulumi.get(self, "identity_client_id")

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[builtins.str]:
        """
        The ID of the Key Vault Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        return pulumi.get(self, "key_vault_key_id")

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[builtins.str]:
        """
        The ID of the managed HSM Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")


@pulumi.output_type
class AIServicesIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AIServicesIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AIServicesIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AIServicesIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this AI Services Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Services Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Services Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Services Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AIServicesNetworkAcls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AIServicesNetworkAcls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AIServicesNetworkAcls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AIServicesNetworkAcls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: builtins.str,
                 bypass: Optional[builtins.str] = None,
                 ip_rules: Optional[Sequence[builtins.str]] = None,
                 virtual_network_rules: Optional[Sequence['outputs.AIServicesNetworkAclsVirtualNetworkRule']] = None):
        """
        :param builtins.str default_action: The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        :param builtins.str bypass: Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
               *
        :param Sequence[builtins.str] ip_rules: One or more IP Addresses, or CIDR Blocks which should be able to access the AI Services Account.
        :param Sequence['AIServicesNetworkAclsVirtualNetworkRuleArgs'] virtual_network_rules: A `virtual_network_rules` block as defined below.
        """
        pulumi.set(__self__, "default_action", default_action)
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> builtins.str:
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def bypass(self) -> Optional[builtins.str]:
        """
        Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        *
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the AI Services Account.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.AIServicesNetworkAclsVirtualNetworkRule']]:
        """
        A `virtual_network_rules` block as defined below.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class AIServicesNetworkAclsVirtualNetworkRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AIServicesNetworkAclsVirtualNetworkRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AIServicesNetworkAclsVirtualNetworkRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AIServicesNetworkAclsVirtualNetworkRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 ignore_missing_vnet_service_endpoint: Optional[builtins.bool] = None):
        """
        :param builtins.str subnet_id: The ID of the subnet which should be able to access this AI Services Account.
        :param builtins.bool ignore_missing_vnet_service_endpoint: Whether to ignore a missing Virtual Network Service Endpoint or not. Default to `false`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the subnet which should be able to access this AI Services Account.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[builtins.bool]:
        """
        Whether to ignore a missing Virtual Network Service Endpoint or not. Default to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")


@pulumi.output_type
class AIServicesStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AIServicesStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AIServicesStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AIServicesStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: builtins.str,
                 identity_client_id: Optional[builtins.str] = None):
        """
        :param builtins.str storage_account_id: The ID of the Storage Account.
        :param builtins.str identity_client_id: The client ID of the Managed Identity associated with the Storage Account.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        The ID of the Storage Account.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[builtins.str]:
        """
        The client ID of the Managed Identity associated with the Storage Account.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class AccountCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_key_id: builtins.str,
                 identity_client_id: Optional[builtins.str] = None):
        """
        :param builtins.str key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        :param builtins.str identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> builtins.str:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        return pulumi.get(self, "key_vault_key_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[builtins.str]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class AccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: builtins.str,
                 identity_ids: Optional[Sequence[builtins.str]] = None,
                 principal_id: Optional[builtins.str] = None,
                 tenant_id: Optional[builtins.str] = None):
        """
        :param builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Cognitive Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cognitive Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Cognitive Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cognitive Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AccountNetworkAcls(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "virtualNetworkRules":
            suggest = "virtual_network_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkAcls. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkAcls.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkAcls.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: builtins.str,
                 bypass: Optional[builtins.str] = None,
                 ip_rules: Optional[Sequence[builtins.str]] = None,
                 virtual_network_rules: Optional[Sequence['outputs.AccountNetworkAclsVirtualNetworkRule']] = None):
        """
        :param builtins.str default_action: The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        :param builtins.str bypass: Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`.
               
               > **Note:** `bypass` can only be set when `kind` is set to `OpenAI`
        :param Sequence[builtins.str] ip_rules: One or more IP Addresses, or CIDR Blocks which should be able to access the Cognitive Account.
        :param Sequence['AccountNetworkAclsVirtualNetworkRuleArgs'] virtual_network_rules: A `virtual_network_rules` block as defined below.
        """
        pulumi.set(__self__, "default_action", default_action)
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> builtins.str:
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def bypass(self) -> Optional[builtins.str]:
        """
        Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`.

        > **Note:** `bypass` can only be set when `kind` is set to `OpenAI`
        """
        return pulumi.get(self, "bypass")

    @property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the Cognitive Account.
        """
        return pulumi.get(self, "ip_rules")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[Sequence['outputs.AccountNetworkAclsVirtualNetworkRule']]:
        """
        A `virtual_network_rules` block as defined below.
        """
        return pulumi.get(self, "virtual_network_rules")


@pulumi.output_type
class AccountNetworkAclsVirtualNetworkRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ignoreMissingVnetServiceEndpoint":
            suggest = "ignore_missing_vnet_service_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkAclsVirtualNetworkRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkAclsVirtualNetworkRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkAclsVirtualNetworkRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: builtins.str,
                 ignore_missing_vnet_service_endpoint: Optional[builtins.bool] = None):
        """
        :param builtins.str subnet_id: The ID of the subnet which should be able to access this Cognitive Account.
        :param builtins.bool ignore_missing_vnet_service_endpoint: Whether ignore missing vnet service endpoint or not. Default to `false`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> builtins.str:
        """
        The ID of the subnet which should be able to access this Cognitive Account.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[builtins.bool]:
        """
        Whether ignore missing vnet service endpoint or not. Default to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")


@pulumi.output_type
class AccountRaiPolicyContentFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blockEnabled":
            suggest = "block_enabled"
        elif key == "filterEnabled":
            suggest = "filter_enabled"
        elif key == "severityThreshold":
            suggest = "severity_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountRaiPolicyContentFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountRaiPolicyContentFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountRaiPolicyContentFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 block_enabled: builtins.bool,
                 filter_enabled: builtins.bool,
                 name: builtins.str,
                 severity_threshold: builtins.str,
                 source: builtins.str):
        """
        :param builtins.bool block_enabled: Whether the filter should block content. Possible values are `true` or `false`.
        :param builtins.bool filter_enabled: Whether the filter is enabled. Possible values are `true` or `false`.
        :param builtins.str name: The name of the content filter.
        :param builtins.str severity_threshold: The severity threshold for the filter. Possible values are `Low`, `Medium` or `High`.
        :param builtins.str source: Content source to apply the content filter. Possible values are `Prompt` or `Completion`.
        """
        pulumi.set(__self__, "block_enabled", block_enabled)
        pulumi.set(__self__, "filter_enabled", filter_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "severity_threshold", severity_threshold)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="blockEnabled")
    def block_enabled(self) -> builtins.bool:
        """
        Whether the filter should block content. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "block_enabled")

    @property
    @pulumi.getter(name="filterEnabled")
    def filter_enabled(self) -> builtins.bool:
        """
        Whether the filter is enabled. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "filter_enabled")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the content filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="severityThreshold")
    def severity_threshold(self) -> builtins.str:
        """
        The severity threshold for the filter. Possible values are `Low`, `Medium` or `High`.
        """
        return pulumi.get(self, "severity_threshold")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        Content source to apply the content filter. Possible values are `Prompt` or `Completion`.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class AccountStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "identityClientId":
            suggest = "identity_client_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_id: builtins.str,
                 identity_client_id: Optional[builtins.str] = None):
        """
        :param builtins.str storage_account_id: Full resource id of a Microsoft.Storage resource.
        :param builtins.str identity_client_id: The client ID of the managed identity associated with the storage resource.
               
               > **Note:** Not all `kind` support a `storage` block. For example the `kind` `OpenAI` does not support it.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        Full resource id of a Microsoft.Storage resource.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[builtins.str]:
        """
        The client ID of the managed identity associated with the storage resource.

        > **Note:** Not all `kind` support a `storage` block. For example the `kind` `OpenAI` does not support it.
        """
        return pulumi.get(self, "identity_client_id")


@pulumi.output_type
class DeploymentModel(dict):
    def __init__(__self__, *,
                 format: builtins.str,
                 name: builtins.str,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str format: The format of the Cognitive Services Account Deployment model. Possible values are `OpenAI` and `Cohere`. Changing this forces a new resource to be created.
        :param builtins.str name: The name of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.
        :param builtins.str version: The version of Cognitive Services Account Deployment model. If `version` is not specified, the default version of the model at the time will be assigned.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def format(self) -> builtins.str:
        """
        The format of the Cognitive Services Account Deployment model. Possible values are `OpenAI` and `Cohere`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version of Cognitive Services Account Deployment model. If `version` is not specified, the default version of the model at the time will be assigned.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DeploymentSku(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 capacity: Optional[builtins.int] = None,
                 family: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 tier: Optional[builtins.str] = None):
        """
        :param builtins.int capacity: Tokens-per-Minute (TPM). The unit of measure for this field is in the thousands of Tokens-per-Minute. Defaults to `1` which means that the limitation is `1000` tokens per minute. If the resources SKU supports scale in/out then the capacity field should be included in the resources' configuration. If the scale in/out is not supported by the resources SKU then this field can be safely omitted. For more information about TPM please see the [product documentation](https://learn.microsoft.com/azure/ai-services/openai/how-to/quota?tabs=rest).
        :param builtins.str family: If the service has different generations of hardware, for the same SKU, then that can be captured here. Changing this forces a new resource to be created.
        :param builtins.str size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. Changing this forces a new resource to be created.
        :param builtins.str tier: Possible values are `Free`, `Basic`, `Standard`, `Premium`, `Enterprise`. This property is required only when multiple tiers are available with the SKU name. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.int]:
        """
        Tokens-per-Minute (TPM). The unit of measure for this field is in the thousands of Tokens-per-Minute. Defaults to `1` which means that the limitation is `1000` tokens per minute. If the resources SKU supports scale in/out then the capacity field should be included in the resources' configuration. If the scale in/out is not supported by the resources SKU then this field can be safely omitted. For more information about TPM please see the [product documentation](https://learn.microsoft.com/azure/ai-services/openai/how-to/quota?tabs=rest).
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def family(self) -> Optional[builtins.str]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tier(self) -> Optional[builtins.str]:
        """
        Possible values are `Free`, `Basic`, `Standard`, `Premium`, `Enterprise`. This property is required only when multiple tiers are available with the SKU name. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class GetAccountIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[builtins.str],
                 principal_id: builtins.str,
                 tenant_id: builtins.str,
                 type: builtins.str):
        """
        :param Sequence[builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Cognitive Account.
        :param builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Cognitive Account.
        :param builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Cognitive Account.
        :param builtins.str type: The type of Managed Service Identity that is configured on this Cognitive Account.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Cognitive Account.
        """
        return pulumi.get(self, "identity_ids")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Cognitive Account.
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Cognitive Account.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of Managed Service Identity that is configured on this Cognitive Account.
        """
        return pulumi.get(self, "type")


