# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceEmailDomainAssociationArgs', 'ServiceEmailDomainAssociation']

@pulumi.input_type
class ServiceEmailDomainAssociationArgs:
    def __init__(__self__, *,
                 communication_service_id: pulumi.Input[builtins.str],
                 email_service_domain_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ServiceEmailDomainAssociation resource.
        :param pulumi.Input[builtins.str] communication_service_id: The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        :param pulumi.Input[builtins.str] email_service_domain_id: The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        pulumi.set(__self__, "communication_service_id", communication_service_id)
        pulumi.set(__self__, "email_service_domain_id", email_service_domain_id)

    @property
    @pulumi.getter(name="communicationServiceId")
    def communication_service_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        """
        return pulumi.get(self, "communication_service_id")

    @communication_service_id.setter
    def communication_service_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "communication_service_id", value)

    @property
    @pulumi.getter(name="emailServiceDomainId")
    def email_service_domain_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        return pulumi.get(self, "email_service_domain_id")

    @email_service_domain_id.setter
    def email_service_domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "email_service_domain_id", value)


@pulumi.input_type
class _ServiceEmailDomainAssociationState:
    def __init__(__self__, *,
                 communication_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_service_domain_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceEmailDomainAssociation resources.
        :param pulumi.Input[builtins.str] communication_service_id: The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        :param pulumi.Input[builtins.str] email_service_domain_id: The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        if communication_service_id is not None:
            pulumi.set(__self__, "communication_service_id", communication_service_id)
        if email_service_domain_id is not None:
            pulumi.set(__self__, "email_service_domain_id", email_service_domain_id)

    @property
    @pulumi.getter(name="communicationServiceId")
    def communication_service_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        """
        return pulumi.get(self, "communication_service_id")

    @communication_service_id.setter
    def communication_service_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "communication_service_id", value)

    @property
    @pulumi.getter(name="emailServiceDomainId")
    def email_service_domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        return pulumi.get(self, "email_service_domain_id")

    @email_service_domain_id.setter
    def email_service_domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email_service_domain_id", value)


@pulumi.type_token("azure:communication/serviceEmailDomainAssociation:ServiceEmailDomainAssociation")
class ServiceEmailDomainAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 communication_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_service_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a communication service email domain association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="group1",
            location="West Europe")
        example_service = azure.communication.Service("example",
            name="CommunicationService1",
            resource_group_name=example.name,
            data_location="United States")
        example_email_service = azure.communication.EmailService("example",
            name="emailCommunicationService1",
            resource_group_name=example.name,
            data_location="United States")
        example_email_service_domain = azure.communication.EmailServiceDomain("example",
            name="AzureManagedDomain",
            email_service_id=example_email_service.id,
            domain_management="AzureManaged")
        example_service_email_domain_association = azure.communication.ServiceEmailDomainAssociation("example",
            communication_service_id=example_service.id,
            email_service_domain_id=example_email_service_domain.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Communication`: 2023-03-31

        ## Import

        Communication service email domain association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:communication/serviceEmailDomainAssociation:ServiceEmailDomainAssociation example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Communication/communicationServices/communicationService1|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Communication/emailServices/emailCommunicationService1/domains/domain1"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] communication_service_id: The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        :param pulumi.Input[builtins.str] email_service_domain_id: The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceEmailDomainAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a communication service email domain association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="group1",
            location="West Europe")
        example_service = azure.communication.Service("example",
            name="CommunicationService1",
            resource_group_name=example.name,
            data_location="United States")
        example_email_service = azure.communication.EmailService("example",
            name="emailCommunicationService1",
            resource_group_name=example.name,
            data_location="United States")
        example_email_service_domain = azure.communication.EmailServiceDomain("example",
            name="AzureManagedDomain",
            email_service_id=example_email_service.id,
            domain_management="AzureManaged")
        example_service_email_domain_association = azure.communication.ServiceEmailDomainAssociation("example",
            communication_service_id=example_service.id,
            email_service_domain_id=example_email_service_domain.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Communication`: 2023-03-31

        ## Import

        Communication service email domain association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:communication/serviceEmailDomainAssociation:ServiceEmailDomainAssociation example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Communication/communicationServices/communicationService1|/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Communication/emailServices/emailCommunicationService1/domains/domain1"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceEmailDomainAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceEmailDomainAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 communication_service_id: Optional[pulumi.Input[builtins.str]] = None,
                 email_service_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceEmailDomainAssociationArgs.__new__(ServiceEmailDomainAssociationArgs)

            if communication_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'communication_service_id'")
            __props__.__dict__["communication_service_id"] = communication_service_id
            if email_service_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'email_service_domain_id'")
            __props__.__dict__["email_service_domain_id"] = email_service_domain_id
        super(ServiceEmailDomainAssociation, __self__).__init__(
            'azure:communication/serviceEmailDomainAssociation:ServiceEmailDomainAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            communication_service_id: Optional[pulumi.Input[builtins.str]] = None,
            email_service_domain_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceEmailDomainAssociation':
        """
        Get an existing ServiceEmailDomainAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] communication_service_id: The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        :param pulumi.Input[builtins.str] email_service_domain_id: The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceEmailDomainAssociationState.__new__(_ServiceEmailDomainAssociationState)

        __props__.__dict__["communication_service_id"] = communication_service_id
        __props__.__dict__["email_service_domain_id"] = email_service_domain_id
        return ServiceEmailDomainAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="communicationServiceId")
    def communication_service_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Communication Service. Changing this forces a new communication service email domain association to be created.
        """
        return pulumi.get(self, "communication_service_id")

    @property
    @pulumi.getter(name="emailServiceDomainId")
    def email_service_domain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the EMail Service Domain. Changing this forces a new communication service email domain association to be created.
        """
        return pulumi.get(self, "email_service_domain_id")

