# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GalleryApplicationArgs', 'GalleryApplication']

@pulumi.input_type
class GalleryApplicationArgs:
    def __init__(__self__, *,
                 gallery_id: pulumi.Input[builtins.str],
                 supported_os_type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_of_life_date: Optional[pulumi.Input[builtins.str]] = None,
                 eula: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[builtins.str]] = None,
                 release_note_uri: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a GalleryApplication resource.
        :param pulumi.Input[builtins.str] gallery_id: The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] supported_os_type: The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] description: A description of the Gallery Application.
        :param pulumi.Input[builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application.
        :param pulumi.Input[builtins.str] eula: The End User Licence Agreement of the Gallery Application.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with the Gallery Application.
        :param pulumi.Input[builtins.str] release_note_uri: The URI containing the Release Notes associated with the Gallery Application.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Gallery Application.
        """
        pulumi.set(__self__, "gallery_id", gallery_id)
        pulumi.set(__self__, "supported_os_type", supported_os_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if eula is not None:
            pulumi.set(__self__, "eula", eula)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if privacy_statement_uri is not None:
            pulumi.set(__self__, "privacy_statement_uri", privacy_statement_uri)
        if release_note_uri is not None:
            pulumi.set(__self__, "release_note_uri", release_note_uri)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="galleryId")
    def gallery_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_id")

    @gallery_id.setter
    def gallery_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gallery_id", value)

    @property
    @pulumi.getter(name="supportedOsType")
    def supported_os_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "supported_os_type")

    @supported_os_type.setter
    def supported_os_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "supported_os_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Gallery Application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end of life date in RFC3339 format of the Gallery Application.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @property
    @pulumi.getter
    def eula(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The End User Licence Agreement of the Gallery Application.
        """
        return pulumi.get(self, "eula")

    @eula.setter
    def eula(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "eula", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI containing the Privacy Statement associated with the Gallery Application.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @privacy_statement_uri.setter
    def privacy_statement_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_statement_uri", value)

    @property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI containing the Release Notes associated with the Gallery Application.
        """
        return pulumi.get(self, "release_note_uri")

    @release_note_uri.setter
    def release_note_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_note_uri", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Gallery Application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _GalleryApplicationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_of_life_date: Optional[pulumi.Input[builtins.str]] = None,
                 eula: Optional[pulumi.Input[builtins.str]] = None,
                 gallery_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[builtins.str]] = None,
                 release_note_uri: Optional[pulumi.Input[builtins.str]] = None,
                 supported_os_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering GalleryApplication resources.
        :param pulumi.Input[builtins.str] description: A description of the Gallery Application.
        :param pulumi.Input[builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application.
        :param pulumi.Input[builtins.str] eula: The End User Licence Agreement of the Gallery Application.
        :param pulumi.Input[builtins.str] gallery_id: The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with the Gallery Application.
        :param pulumi.Input[builtins.str] release_note_uri: The URI containing the Release Notes associated with the Gallery Application.
        :param pulumi.Input[builtins.str] supported_os_type: The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Gallery Application.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if eula is not None:
            pulumi.set(__self__, "eula", eula)
        if gallery_id is not None:
            pulumi.set(__self__, "gallery_id", gallery_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if privacy_statement_uri is not None:
            pulumi.set(__self__, "privacy_statement_uri", privacy_statement_uri)
        if release_note_uri is not None:
            pulumi.set(__self__, "release_note_uri", release_note_uri)
        if supported_os_type is not None:
            pulumi.set(__self__, "supported_os_type", supported_os_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the Gallery Application.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The end of life date in RFC3339 format of the Gallery Application.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @property
    @pulumi.getter
    def eula(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The End User Licence Agreement of the Gallery Application.
        """
        return pulumi.get(self, "eula")

    @eula.setter
    def eula(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "eula", value)

    @property
    @pulumi.getter(name="galleryId")
    def gallery_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_id")

    @gallery_id.setter
    def gallery_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gallery_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI containing the Privacy Statement associated with the Gallery Application.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @privacy_statement_uri.setter
    def privacy_statement_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "privacy_statement_uri", value)

    @property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI containing the Release Notes associated with the Gallery Application.
        """
        return pulumi.get(self, "release_note_uri")

    @release_note_uri.setter
    def release_note_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_note_uri", value)

    @property
    @pulumi.getter(name="supportedOsType")
    def supported_os_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "supported_os_type")

    @supported_os_type.setter
    def supported_os_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "supported_os_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Gallery Application.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:compute/galleryApplication:GalleryApplication")
class GalleryApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_of_life_date: Optional[pulumi.Input[builtins.str]] = None,
                 eula: Optional[pulumi.Input[builtins.str]] = None,
                 gallery_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[builtins.str]] = None,
                 release_note_uri: Optional[pulumi.Input[builtins.str]] = None,
                 supported_os_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Gallery Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="examplegallery",
            resource_group_name=example.name,
            location=example.location)
        example_gallery_application = azure.compute.GalleryApplication("example",
            name="example-app",
            gallery_id=example_shared_image_gallery.id,
            location=example.location,
            supported_os_type="Linux")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2022-03-03

        ## Import

        Gallery Applications can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/galleryApplication:GalleryApplication example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/galleries/gallery1/applications/galleryApplication1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the Gallery Application.
        :param pulumi.Input[builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application.
        :param pulumi.Input[builtins.str] eula: The End User Licence Agreement of the Gallery Application.
        :param pulumi.Input[builtins.str] gallery_id: The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with the Gallery Application.
        :param pulumi.Input[builtins.str] release_note_uri: The URI containing the Release Notes associated with the Gallery Application.
        :param pulumi.Input[builtins.str] supported_os_type: The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Gallery Application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GalleryApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Gallery Application.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="examplegallery",
            resource_group_name=example.name,
            location=example.location)
        example_gallery_application = azure.compute.GalleryApplication("example",
            name="example-app",
            gallery_id=example_shared_image_gallery.id,
            location=example.location,
            supported_os_type="Linux")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2022-03-03

        ## Import

        Gallery Applications can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/galleryApplication:GalleryApplication example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Compute/galleries/gallery1/applications/galleryApplication1
        ```

        :param str resource_name: The name of the resource.
        :param GalleryApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GalleryApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 end_of_life_date: Optional[pulumi.Input[builtins.str]] = None,
                 eula: Optional[pulumi.Input[builtins.str]] = None,
                 gallery_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[builtins.str]] = None,
                 release_note_uri: Optional[pulumi.Input[builtins.str]] = None,
                 supported_os_type: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GalleryApplicationArgs.__new__(GalleryApplicationArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["end_of_life_date"] = end_of_life_date
            __props__.__dict__["eula"] = eula
            if gallery_id is None and not opts.urn:
                raise TypeError("Missing required property 'gallery_id'")
            __props__.__dict__["gallery_id"] = gallery_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["privacy_statement_uri"] = privacy_statement_uri
            __props__.__dict__["release_note_uri"] = release_note_uri
            if supported_os_type is None and not opts.urn:
                raise TypeError("Missing required property 'supported_os_type'")
            __props__.__dict__["supported_os_type"] = supported_os_type
            __props__.__dict__["tags"] = tags
        super(GalleryApplication, __self__).__init__(
            'azure:compute/galleryApplication:GalleryApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            end_of_life_date: Optional[pulumi.Input[builtins.str]] = None,
            eula: Optional[pulumi.Input[builtins.str]] = None,
            gallery_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            privacy_statement_uri: Optional[pulumi.Input[builtins.str]] = None,
            release_note_uri: Optional[pulumi.Input[builtins.str]] = None,
            supported_os_type: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None) -> 'GalleryApplication':
        """
        Get an existing GalleryApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the Gallery Application.
        :param pulumi.Input[builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Gallery Application.
        :param pulumi.Input[builtins.str] eula: The End User Licence Agreement of the Gallery Application.
        :param pulumi.Input[builtins.str] gallery_id: The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Gallery Application. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with the Gallery Application.
        :param pulumi.Input[builtins.str] release_note_uri: The URI containing the Release Notes associated with the Gallery Application.
        :param pulumi.Input[builtins.str] supported_os_type: The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Gallery Application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GalleryApplicationState.__new__(_GalleryApplicationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["end_of_life_date"] = end_of_life_date
        __props__.__dict__["eula"] = eula
        __props__.__dict__["gallery_id"] = gallery_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["privacy_statement_uri"] = privacy_statement_uri
        __props__.__dict__["release_note_uri"] = release_note_uri
        __props__.__dict__["supported_os_type"] = supported_os_type
        __props__.__dict__["tags"] = tags
        return GalleryApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the Gallery Application.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The end of life date in RFC3339 format of the Gallery Application.
        """
        return pulumi.get(self, "end_of_life_date")

    @property
    @pulumi.getter
    def eula(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The End User Licence Agreement of the Gallery Application.
        """
        return pulumi.get(self, "eula")

    @property
    @pulumi.getter(name="galleryId")
    def gallery_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Gallery Application exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URI containing the Privacy Statement associated with the Gallery Application.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URI containing the Release Notes associated with the Gallery Application.
        """
        return pulumi.get(self, "release_note_uri")

    @property
    @pulumi.getter(name="supportedOsType")
    def supported_os_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the Operating System supported for the Gallery Application. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "supported_os_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the Gallery Application.
        """
        return pulumi.get(self, "tags")

