# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDedicatedHostResult',
    'AwaitableGetDedicatedHostResult',
    'get_dedicated_host',
    'get_dedicated_host_output',
]

@pulumi.output_type
class GetDedicatedHostResult:
    """
    A collection of values returned by getDedicatedHost.
    """
    def __init__(__self__, dedicated_host_group_name=None, id=None, location=None, name=None, resource_group_name=None, tags=None):
        if dedicated_host_group_name and not isinstance(dedicated_host_group_name, str):
            raise TypeError("Expected argument 'dedicated_host_group_name' to be a str")
        pulumi.set(__self__, "dedicated_host_group_name", dedicated_host_group_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="dedicatedHostGroupName")
    def dedicated_host_group_name(self) -> builtins.str:
        return pulumi.get(self, "dedicated_host_group_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location where the Dedicated Host exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Dedicated Host.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDedicatedHostResult(GetDedicatedHostResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedHostResult(
            dedicated_host_group_name=self.dedicated_host_group_name,
            id=self.id,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_dedicated_host(dedicated_host_group_name: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       resource_group_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedHostResult:
    """
    Use this data source to access information about an existing Dedicated Host.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_dedicated_host(name="example-host",
        dedicated_host_group_name="example-host-group",
        resource_group_name="example-resources")
    pulumi.export("dedicatedHostId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param builtins.str dedicated_host_group_name: Specifies the name of the Dedicated Host Group the Dedicated Host is located in.
    :param builtins.str name: Specifies the name of the Dedicated Host.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Dedicated Host is located in.
    """
    __args__ = dict()
    __args__['dedicatedHostGroupName'] = dedicated_host_group_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getDedicatedHost:getDedicatedHost', __args__, opts=opts, typ=GetDedicatedHostResult).value

    return AwaitableGetDedicatedHostResult(
        dedicated_host_group_name=pulumi.get(__ret__, 'dedicated_host_group_name'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_dedicated_host_output(dedicated_host_group_name: Optional[pulumi.Input[builtins.str]] = None,
                              name: Optional[pulumi.Input[builtins.str]] = None,
                              resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDedicatedHostResult]:
    """
    Use this data source to access information about an existing Dedicated Host.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_dedicated_host(name="example-host",
        dedicated_host_group_name="example-host-group",
        resource_group_name="example-resources")
    pulumi.export("dedicatedHostId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2024-03-01


    :param builtins.str dedicated_host_group_name: Specifies the name of the Dedicated Host Group the Dedicated Host is located in.
    :param builtins.str name: Specifies the name of the Dedicated Host.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Dedicated Host is located in.
    """
    __args__ = dict()
    __args__['dedicatedHostGroupName'] = dedicated_host_group_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getDedicatedHost:getDedicatedHost', __args__, opts=opts, typ=GetDedicatedHostResult)
    return __ret__.apply(lambda __response__: GetDedicatedHostResult(
        dedicated_host_group_name=pulumi.get(__response__, 'dedicated_host_group_name'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
