# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiskEncryptionSetResult',
    'AwaitableGetDiskEncryptionSetResult',
    'get_disk_encryption_set',
    'get_disk_encryption_set_output',
]

@pulumi.output_type
class GetDiskEncryptionSetResult:
    """
    A collection of values returned by getDiskEncryptionSet.
    """
    def __init__(__self__, auto_key_rotation_enabled=None, id=None, identities=None, key_vault_key_url=None, location=None, name=None, resource_group_name=None, tags=None):
        if auto_key_rotation_enabled and not isinstance(auto_key_rotation_enabled, bool):
            raise TypeError("Expected argument 'auto_key_rotation_enabled' to be a bool")
        pulumi.set(__self__, "auto_key_rotation_enabled", auto_key_rotation_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if key_vault_key_url and not isinstance(key_vault_key_url, str):
            raise TypeError("Expected argument 'key_vault_key_url' to be a str")
        pulumi.set(__self__, "key_vault_key_url", key_vault_key_url)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoKeyRotationEnabled")
    def auto_key_rotation_enabled(self) -> builtins.bool:
        """
        Is the Azure Disk Encryption Set Key automatically rotated to latest version?
        """
        return pulumi.get(self, "auto_key_rotation_enabled")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetDiskEncryptionSetIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter(name="keyVaultKeyUrl")
    def key_vault_key_url(self) -> builtins.str:
        """
        The URL for the Key Vault Key or Key Vault Secret that is currently being used by the service.
        """
        return pulumi.get(self, "key_vault_key_url")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The location where the Disk Encryption Set exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Disk Encryption Set.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDiskEncryptionSetResult(GetDiskEncryptionSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiskEncryptionSetResult(
            auto_key_rotation_enabled=self.auto_key_rotation_enabled,
            id=self.id,
            identities=self.identities,
            key_vault_key_url=self.key_vault_key_url,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_disk_encryption_set(name: Optional[builtins.str] = None,
                            resource_group_name: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiskEncryptionSetResult:
    """
    Use this data source to access information about an existing Disk Encryption Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    existing = azure.compute.get_disk_encryption_set(name="example-des",
        resource_group_name="example-resources")
    pulumi.export("id", existing.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-02


    :param builtins.str name: The name of the existing Disk Encryption Set.
    :param builtins.str resource_group_name: The name of the Resource Group where the Disk Encryption Set exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getDiskEncryptionSet:getDiskEncryptionSet', __args__, opts=opts, typ=GetDiskEncryptionSetResult).value

    return AwaitableGetDiskEncryptionSetResult(
        auto_key_rotation_enabled=pulumi.get(__ret__, 'auto_key_rotation_enabled'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        key_vault_key_url=pulumi.get(__ret__, 'key_vault_key_url'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_disk_encryption_set_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                   resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiskEncryptionSetResult]:
    """
    Use this data source to access information about an existing Disk Encryption Set.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    existing = azure.compute.get_disk_encryption_set(name="example-des",
        resource_group_name="example-resources")
    pulumi.export("id", existing.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-02


    :param builtins.str name: The name of the existing Disk Encryption Set.
    :param builtins.str resource_group_name: The name of the Resource Group where the Disk Encryption Set exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getDiskEncryptionSet:getDiskEncryptionSet', __args__, opts=opts, typ=GetDiskEncryptionSetResult)
    return __ret__.apply(lambda __response__: GetDiskEncryptionSetResult(
        auto_key_rotation_enabled=pulumi.get(__response__, 'auto_key_rotation_enabled'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        key_vault_key_url=pulumi.get(__response__, 'key_vault_key_url'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
