# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSharedImageResult',
    'AwaitableGetSharedImageResult',
    'get_shared_image',
    'get_shared_image_output',
]

@pulumi.output_type
class GetSharedImageResult:
    """
    A collection of values returned by getSharedImage.
    """
    def __init__(__self__, accelerated_network_support_enabled=None, architecture=None, confidential_vm_enabled=None, confidential_vm_supported=None, description=None, eula=None, gallery_name=None, hibernation_enabled=None, hyper_v_generation=None, id=None, identifiers=None, location=None, name=None, os_type=None, privacy_statement_uri=None, purchase_plans=None, release_note_uri=None, resource_group_name=None, specialized=None, tags=None, trusted_launch_enabled=None, trusted_launch_supported=None):
        if accelerated_network_support_enabled and not isinstance(accelerated_network_support_enabled, bool):
            raise TypeError("Expected argument 'accelerated_network_support_enabled' to be a bool")
        pulumi.set(__self__, "accelerated_network_support_enabled", accelerated_network_support_enabled)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if confidential_vm_enabled and not isinstance(confidential_vm_enabled, bool):
            raise TypeError("Expected argument 'confidential_vm_enabled' to be a bool")
        pulumi.set(__self__, "confidential_vm_enabled", confidential_vm_enabled)
        if confidential_vm_supported and not isinstance(confidential_vm_supported, bool):
            raise TypeError("Expected argument 'confidential_vm_supported' to be a bool")
        pulumi.set(__self__, "confidential_vm_supported", confidential_vm_supported)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if eula and not isinstance(eula, str):
            raise TypeError("Expected argument 'eula' to be a str")
        pulumi.set(__self__, "eula", eula)
        if gallery_name and not isinstance(gallery_name, str):
            raise TypeError("Expected argument 'gallery_name' to be a str")
        pulumi.set(__self__, "gallery_name", gallery_name)
        if hibernation_enabled and not isinstance(hibernation_enabled, bool):
            raise TypeError("Expected argument 'hibernation_enabled' to be a bool")
        pulumi.set(__self__, "hibernation_enabled", hibernation_enabled)
        if hyper_v_generation and not isinstance(hyper_v_generation, str):
            raise TypeError("Expected argument 'hyper_v_generation' to be a str")
        pulumi.set(__self__, "hyper_v_generation", hyper_v_generation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifiers and not isinstance(identifiers, list):
            raise TypeError("Expected argument 'identifiers' to be a list")
        pulumi.set(__self__, "identifiers", identifiers)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if privacy_statement_uri and not isinstance(privacy_statement_uri, str):
            raise TypeError("Expected argument 'privacy_statement_uri' to be a str")
        pulumi.set(__self__, "privacy_statement_uri", privacy_statement_uri)
        if purchase_plans and not isinstance(purchase_plans, list):
            raise TypeError("Expected argument 'purchase_plans' to be a list")
        pulumi.set(__self__, "purchase_plans", purchase_plans)
        if release_note_uri and not isinstance(release_note_uri, str):
            raise TypeError("Expected argument 'release_note_uri' to be a str")
        pulumi.set(__self__, "release_note_uri", release_note_uri)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if specialized and not isinstance(specialized, bool):
            raise TypeError("Expected argument 'specialized' to be a bool")
        pulumi.set(__self__, "specialized", specialized)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if trusted_launch_enabled and not isinstance(trusted_launch_enabled, bool):
            raise TypeError("Expected argument 'trusted_launch_enabled' to be a bool")
        pulumi.set(__self__, "trusted_launch_enabled", trusted_launch_enabled)
        if trusted_launch_supported and not isinstance(trusted_launch_supported, bool):
            raise TypeError("Expected argument 'trusted_launch_supported' to be a bool")
        pulumi.set(__self__, "trusted_launch_supported", trusted_launch_supported)

    @property
    @pulumi.getter(name="acceleratedNetworkSupportEnabled")
    def accelerated_network_support_enabled(self) -> builtins.bool:
        """
        Specifies if the Shared Image supports Accelerated Network.
        """
        return pulumi.get(self, "accelerated_network_support_enabled")

    @property
    @pulumi.getter
    def architecture(self) -> builtins.str:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="confidentialVmEnabled")
    def confidential_vm_enabled(self) -> builtins.bool:
        """
        Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines.
        """
        return pulumi.get(self, "confidential_vm_enabled")

    @property
    @pulumi.getter(name="confidentialVmSupported")
    def confidential_vm_supported(self) -> builtins.bool:
        """
        Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image.
        """
        return pulumi.get(self, "confidential_vm_supported")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of this Shared Image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def eula(self) -> builtins.str:
        """
        The End User Licence Agreement for the Shared Image.
        """
        return pulumi.get(self, "eula")

    @property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> builtins.str:
        return pulumi.get(self, "gallery_name")

    @property
    @pulumi.getter(name="hibernationEnabled")
    def hibernation_enabled(self) -> builtins.bool:
        """
        Specifies if the Shared Image supports hibernation.
        """
        return pulumi.get(self, "hibernation_enabled")

    @property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> builtins.str:
        """
        The generation of HyperV that the Virtual Machine used to create the Shared Image is based on.
        """
        return pulumi.get(self, "hyper_v_generation")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifiers(self) -> Sequence['outputs.GetSharedImageIdentifierResult']:
        """
        An `identifier` block as defined below.
        """
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        """
        The supported Azure location where the Shared Image Gallery exists.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        (Required) The Purchase Plan Name for this Shared Image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> builtins.str:
        """
        The type of Operating System present in this Shared Image.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> builtins.str:
        """
        The URI containing the Privacy Statement for this Shared Image.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @property
    @pulumi.getter(name="purchasePlans")
    def purchase_plans(self) -> Sequence['outputs.GetSharedImagePurchasePlanResult']:
        """
        (Optional) A `purchase_plan` block as defined below.
        """
        return pulumi.get(self, "purchase_plans")

    @property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> builtins.str:
        """
        The URI containing the Release Notes for this Shared Image.
        """
        return pulumi.get(self, "release_note_uri")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def specialized(self) -> builtins.bool:
        """
        Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run).
        """
        return pulumi.get(self, "specialized")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Shared Image.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> builtins.bool:
        """
        Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @property
    @pulumi.getter(name="trustedLaunchSupported")
    def trusted_launch_supported(self) -> builtins.bool:
        """
        Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image.
        """
        return pulumi.get(self, "trusted_launch_supported")


class AwaitableGetSharedImageResult(GetSharedImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSharedImageResult(
            accelerated_network_support_enabled=self.accelerated_network_support_enabled,
            architecture=self.architecture,
            confidential_vm_enabled=self.confidential_vm_enabled,
            confidential_vm_supported=self.confidential_vm_supported,
            description=self.description,
            eula=self.eula,
            gallery_name=self.gallery_name,
            hibernation_enabled=self.hibernation_enabled,
            hyper_v_generation=self.hyper_v_generation,
            id=self.id,
            identifiers=self.identifiers,
            location=self.location,
            name=self.name,
            os_type=self.os_type,
            privacy_statement_uri=self.privacy_statement_uri,
            purchase_plans=self.purchase_plans,
            release_note_uri=self.release_note_uri,
            resource_group_name=self.resource_group_name,
            specialized=self.specialized,
            tags=self.tags,
            trusted_launch_enabled=self.trusted_launch_enabled,
            trusted_launch_supported=self.trusted_launch_supported)


def get_shared_image(gallery_name: Optional[builtins.str] = None,
                     name: Optional[builtins.str] = None,
                     resource_group_name: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSharedImageResult:
    """
    Use this data source to access information about an existing Shared Image within a Shared Image Gallery.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_shared_image(name="my-image",
        gallery_name="my-image-gallery",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-03


    :param builtins.str gallery_name: The name of the Shared Image Gallery in which the Shared Image exists.
    :param builtins.str name: The name of the Shared Image.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists.
    """
    __args__ = dict()
    __args__['galleryName'] = gallery_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getSharedImage:getSharedImage', __args__, opts=opts, typ=GetSharedImageResult).value

    return AwaitableGetSharedImageResult(
        accelerated_network_support_enabled=pulumi.get(__ret__, 'accelerated_network_support_enabled'),
        architecture=pulumi.get(__ret__, 'architecture'),
        confidential_vm_enabled=pulumi.get(__ret__, 'confidential_vm_enabled'),
        confidential_vm_supported=pulumi.get(__ret__, 'confidential_vm_supported'),
        description=pulumi.get(__ret__, 'description'),
        eula=pulumi.get(__ret__, 'eula'),
        gallery_name=pulumi.get(__ret__, 'gallery_name'),
        hibernation_enabled=pulumi.get(__ret__, 'hibernation_enabled'),
        hyper_v_generation=pulumi.get(__ret__, 'hyper_v_generation'),
        id=pulumi.get(__ret__, 'id'),
        identifiers=pulumi.get(__ret__, 'identifiers'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        os_type=pulumi.get(__ret__, 'os_type'),
        privacy_statement_uri=pulumi.get(__ret__, 'privacy_statement_uri'),
        purchase_plans=pulumi.get(__ret__, 'purchase_plans'),
        release_note_uri=pulumi.get(__ret__, 'release_note_uri'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        specialized=pulumi.get(__ret__, 'specialized'),
        tags=pulumi.get(__ret__, 'tags'),
        trusted_launch_enabled=pulumi.get(__ret__, 'trusted_launch_enabled'),
        trusted_launch_supported=pulumi.get(__ret__, 'trusted_launch_supported'))
def get_shared_image_output(gallery_name: Optional[pulumi.Input[builtins.str]] = None,
                            name: Optional[pulumi.Input[builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSharedImageResult]:
    """
    Use this data source to access information about an existing Shared Image within a Shared Image Gallery.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_shared_image(name="my-image",
        gallery_name="my-image-gallery",
        resource_group_name="example-resources")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-03


    :param builtins.str gallery_name: The name of the Shared Image Gallery in which the Shared Image exists.
    :param builtins.str name: The name of the Shared Image.
    :param builtins.str resource_group_name: The name of the Resource Group in which the Shared Image Gallery exists.
    """
    __args__ = dict()
    __args__['galleryName'] = gallery_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getSharedImage:getSharedImage', __args__, opts=opts, typ=GetSharedImageResult)
    return __ret__.apply(lambda __response__: GetSharedImageResult(
        accelerated_network_support_enabled=pulumi.get(__response__, 'accelerated_network_support_enabled'),
        architecture=pulumi.get(__response__, 'architecture'),
        confidential_vm_enabled=pulumi.get(__response__, 'confidential_vm_enabled'),
        confidential_vm_supported=pulumi.get(__response__, 'confidential_vm_supported'),
        description=pulumi.get(__response__, 'description'),
        eula=pulumi.get(__response__, 'eula'),
        gallery_name=pulumi.get(__response__, 'gallery_name'),
        hibernation_enabled=pulumi.get(__response__, 'hibernation_enabled'),
        hyper_v_generation=pulumi.get(__response__, 'hyper_v_generation'),
        id=pulumi.get(__response__, 'id'),
        identifiers=pulumi.get(__response__, 'identifiers'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        os_type=pulumi.get(__response__, 'os_type'),
        privacy_statement_uri=pulumi.get(__response__, 'privacy_statement_uri'),
        purchase_plans=pulumi.get(__response__, 'purchase_plans'),
        release_note_uri=pulumi.get(__response__, 'release_note_uri'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        specialized=pulumi.get(__response__, 'specialized'),
        tags=pulumi.get(__response__, 'tags'),
        trusted_launch_enabled=pulumi.get(__response__, 'trusted_launch_enabled'),
        trusted_launch_supported=pulumi.get(__response__, 'trusted_launch_supported')))
