# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    """
    A collection of values returned by getSnapshot.
    """
    def __init__(__self__, creation_option=None, disk_size_gb=None, encryption_settings=None, id=None, name=None, os_type=None, resource_group_name=None, source_resource_id=None, source_uri=None, storage_account_id=None, time_created=None, trusted_launch_enabled=None):
        if creation_option and not isinstance(creation_option, str):
            raise TypeError("Expected argument 'creation_option' to be a str")
        pulumi.set(__self__, "creation_option", creation_option)
        if disk_size_gb and not isinstance(disk_size_gb, int):
            raise TypeError("Expected argument 'disk_size_gb' to be a int")
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if encryption_settings and not isinstance(encryption_settings, list):
            raise TypeError("Expected argument 'encryption_settings' to be a list")
        pulumi.set(__self__, "encryption_settings", encryption_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_resource_id and not isinstance(source_resource_id, str):
            raise TypeError("Expected argument 'source_resource_id' to be a str")
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri and not isinstance(source_uri, str):
            raise TypeError("Expected argument 'source_uri' to be a str")
        pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id and not isinstance(storage_account_id, str):
            raise TypeError("Expected argument 'storage_account_id' to be a str")
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if trusted_launch_enabled and not isinstance(trusted_launch_enabled, bool):
            raise TypeError("Expected argument 'trusted_launch_enabled' to be a bool")
        pulumi.set(__self__, "trusted_launch_enabled", trusted_launch_enabled)

    @property
    @pulumi.getter(name="creationOption")
    def creation_option(self) -> builtins.str:
        return pulumi.get(self, "creation_option")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> builtins.int:
        """
        The size of the Snapshotted Disk in GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Sequence['outputs.GetSnapshotEncryptionSettingResult']:
        return pulumi.get(self, "encryption_settings")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> builtins.str:
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> builtins.str:
        """
        The reference to an existing snapshot.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> builtins.str:
        """
        The URI to a Managed or Unmanaged Disk.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> builtins.str:
        """
        The ID of an storage account.
        """
        return pulumi.get(self, "storage_account_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> builtins.bool:
        """
        Whether Trusted Launch is enabled for the Snapshot.
        """
        return pulumi.get(self, "trusted_launch_enabled")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            creation_option=self.creation_option,
            disk_size_gb=self.disk_size_gb,
            encryption_settings=self.encryption_settings,
            id=self.id,
            name=self.name,
            os_type=self.os_type,
            resource_group_name=self.resource_group_name,
            source_resource_id=self.source_resource_id,
            source_uri=self.source_uri,
            storage_account_id=self.storage_account_id,
            time_created=self.time_created,
            trusted_launch_enabled=self.trusted_launch_enabled)


def get_snapshot(name: Optional[builtins.str] = None,
                 resource_group_name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    Use this data source to access information about an existing Snapshot.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_snapshot(name="my-snapshot",
        resource_group_name="my-resource-group")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-02


    :param builtins.str name: Specifies the name of the Snapshot.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Snapshot is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:compute/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        creation_option=pulumi.get(__ret__, 'creation_option'),
        disk_size_gb=pulumi.get(__ret__, 'disk_size_gb'),
        encryption_settings=pulumi.get(__ret__, 'encryption_settings'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        os_type=pulumi.get(__ret__, 'os_type'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        source_resource_id=pulumi.get(__ret__, 'source_resource_id'),
        source_uri=pulumi.get(__ret__, 'source_uri'),
        storage_account_id=pulumi.get(__ret__, 'storage_account_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        trusted_launch_enabled=pulumi.get(__ret__, 'trusted_launch_enabled'))
def get_snapshot_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    Use this data source to access information about an existing Snapshot.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.compute.get_snapshot(name="my-snapshot",
        resource_group_name="my-resource-group")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Compute`: 2022-03-02


    :param builtins.str name: Specifies the name of the Snapshot.
    :param builtins.str resource_group_name: Specifies the name of the resource group the Snapshot is located in.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:compute/getSnapshot:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult)
    return __ret__.apply(lambda __response__: GetSnapshotResult(
        creation_option=pulumi.get(__response__, 'creation_option'),
        disk_size_gb=pulumi.get(__response__, 'disk_size_gb'),
        encryption_settings=pulumi.get(__response__, 'encryption_settings'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        os_type=pulumi.get(__response__, 'os_type'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        source_resource_id=pulumi.get(__response__, 'source_resource_id'),
        source_uri=pulumi.get(__response__, 'source_uri'),
        storage_account_id=pulumi.get(__response__, 'storage_account_id'),
        time_created=pulumi.get(__response__, 'time_created'),
        trusted_launch_enabled=pulumi.get(__response__, 'trusted_launch_enabled')))
