# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ImplicitDataDiskFromSourceArgs', 'ImplicitDataDiskFromSource']

@pulumi.input_type
class ImplicitDataDiskFromSourceArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[builtins.str],
                 disk_size_gb: pulumi.Input[builtins.int],
                 lun: pulumi.Input[builtins.int],
                 source_resource_id: pulumi.Input[builtins.str],
                 virtual_machine_id: pulumi.Input[builtins.str],
                 caching: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ImplicitDataDiskFromSource resource.
        :param pulumi.Input[builtins.str] create_option: Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] lun: The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] caching: Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] write_accelerator_enabled: Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "source_resource_id", source_resource_id)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Input[builtins.int]:
        """
        The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        return pulumi.get(self, "write_accelerator_enabled")

    @write_accelerator_enabled.setter
    def write_accelerator_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "write_accelerator_enabled", value)


@pulumi.input_type
class _ImplicitDataDiskFromSourceState:
    def __init__(__self__, *,
                 caching: Optional[pulumi.Input[builtins.str]] = None,
                 create_option: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 lun: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ImplicitDataDiskFromSource resources.
        :param pulumi.Input[builtins.str] caching: Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        :param pulumi.Input[builtins.str] create_option: Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] lun: The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] write_accelerator_enabled: Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @property
    @pulumi.getter
    def caching(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @caching.setter
    def caching(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "caching", value)

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_option", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def lun(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lun")

    @lun.setter
    def lun(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lun", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        return pulumi.get(self, "write_accelerator_enabled")

    @write_accelerator_enabled.setter
    def write_accelerator_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "write_accelerator_enabled", value)


@pulumi.type_token("azure:compute/implicitDataDiskFromSource:ImplicitDataDiskFromSource")
class ImplicitDataDiskFromSource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 caching: Optional[pulumi.Input[builtins.str]] = None,
                 create_option: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 lun: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Manages an implicit Data Disk of a Virtual Machine.

        > **Note:** The Implicit Data Disk will be deleted instantly after this resource is destroyed. If you want to detach this disk only, you may set `detach_implicit_data_disk_on_deletion` field to `true` within the `virtual_machine` block in the provider `features` block.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        config = pulumi.Config()
        prefix = config.get("prefix")
        if prefix is None:
            prefix = "example"
        vm_name = f"{prefix}-vm"
        example = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location="West Europe")
        main = azure.network.VirtualNetwork("main",
            name=f"{prefix}-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        internal = azure.network.Subnet("internal",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=main.name,
            address_prefixes=["10.0.2.0/24"])
        main_network_interface = azure.network.NetworkInterface("main",
            name=f"{prefix}-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": internal.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_virtual_machine = azure.compute.VirtualMachine("example",
            name=vm_name,
            location=example.location,
            resource_group_name=example.name,
            network_interface_ids=[main_network_interface.id],
            vm_size="Standard_F2",
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "myosdisk1",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Standard_LRS",
            },
            os_profile={
                "computer_name": vm_name,
                "admin_username": "testadmin",
                "admin_password": "Password1234!",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        example_managed_disk = azure.compute.ManagedDisk("example",
            name=f"{vm_name}-disk1",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=10)
        example_snapshot = azure.compute.Snapshot("example",
            name=f"{vm_name}-snapshot1",
            location=example.location,
            resource_group_name=example.name,
            create_option="Copy",
            source_uri=example_managed_disk.id)
        example_implicit_data_disk_from_source = azure.compute.ImplicitDataDiskFromSource("example",
            name=f"{vm_name}-implicitdisk1",
            virtual_machine_id=test_azurerm_virtual_machine["id"],
            lun=0,
            caching="None",
            create_option="Copy",
            disk_size_gb=20,
            source_resource_id=test["id"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-03-01, 2023-04-02

        ## Import

        The implicit Data Disk of the Virtual Machine can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/implicitDataDiskFromSource:ImplicitDataDiskFromSource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/machine1/dataDisks/disk1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] caching: Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        :param pulumi.Input[builtins.str] create_option: Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] lun: The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] write_accelerator_enabled: Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImplicitDataDiskFromSourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an implicit Data Disk of a Virtual Machine.

        > **Note:** The Implicit Data Disk will be deleted instantly after this resource is destroyed. If you want to detach this disk only, you may set `detach_implicit_data_disk_on_deletion` field to `true` within the `virtual_machine` block in the provider `features` block.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        config = pulumi.Config()
        prefix = config.get("prefix")
        if prefix is None:
            prefix = "example"
        vm_name = f"{prefix}-vm"
        example = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location="West Europe")
        main = azure.network.VirtualNetwork("main",
            name=f"{prefix}-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        internal = azure.network.Subnet("internal",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=main.name,
            address_prefixes=["10.0.2.0/24"])
        main_network_interface = azure.network.NetworkInterface("main",
            name=f"{prefix}-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": internal.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_virtual_machine = azure.compute.VirtualMachine("example",
            name=vm_name,
            location=example.location,
            resource_group_name=example.name,
            network_interface_ids=[main_network_interface.id],
            vm_size="Standard_F2",
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "myosdisk1",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Standard_LRS",
            },
            os_profile={
                "computer_name": vm_name,
                "admin_username": "testadmin",
                "admin_password": "Password1234!",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        example_managed_disk = azure.compute.ManagedDisk("example",
            name=f"{vm_name}-disk1",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=10)
        example_snapshot = azure.compute.Snapshot("example",
            name=f"{vm_name}-snapshot1",
            location=example.location,
            resource_group_name=example.name,
            create_option="Copy",
            source_uri=example_managed_disk.id)
        example_implicit_data_disk_from_source = azure.compute.ImplicitDataDiskFromSource("example",
            name=f"{vm_name}-implicitdisk1",
            virtual_machine_id=test_azurerm_virtual_machine["id"],
            lun=0,
            caching="None",
            create_option="Copy",
            disk_size_gb=20,
            source_resource_id=test["id"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-03-01, 2023-04-02

        ## Import

        The implicit Data Disk of the Virtual Machine can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/implicitDataDiskFromSource:ImplicitDataDiskFromSource example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachines/machine1/dataDisks/disk1
        ```

        :param str resource_name: The name of the resource.
        :param ImplicitDataDiskFromSourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImplicitDataDiskFromSourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 caching: Optional[pulumi.Input[builtins.str]] = None,
                 create_option: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 lun: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 write_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImplicitDataDiskFromSourceArgs.__new__(ImplicitDataDiskFromSourceArgs)

            __props__.__dict__["caching"] = caching
            if create_option is None and not opts.urn:
                raise TypeError("Missing required property 'create_option'")
            __props__.__dict__["create_option"] = create_option
            if disk_size_gb is None and not opts.urn:
                raise TypeError("Missing required property 'disk_size_gb'")
            __props__.__dict__["disk_size_gb"] = disk_size_gb
            if lun is None and not opts.urn:
                raise TypeError("Missing required property 'lun'")
            __props__.__dict__["lun"] = lun
            __props__.__dict__["name"] = name
            if source_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_resource_id'")
            __props__.__dict__["source_resource_id"] = source_resource_id
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
            __props__.__dict__["write_accelerator_enabled"] = write_accelerator_enabled
        super(ImplicitDataDiskFromSource, __self__).__init__(
            'azure:compute/implicitDataDiskFromSource:ImplicitDataDiskFromSource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            caching: Optional[pulumi.Input[builtins.str]] = None,
            create_option: Optional[pulumi.Input[builtins.str]] = None,
            disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
            lun: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            source_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
            write_accelerator_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'ImplicitDataDiskFromSource':
        """
        Get an existing ImplicitDataDiskFromSource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] caching: Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        :param pulumi.Input[builtins.str] create_option: Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] lun: The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_resource_id: The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] virtual_machine_id: The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.bool] write_accelerator_enabled: Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImplicitDataDiskFromSourceState.__new__(_ImplicitDataDiskFromSourceState)

        __props__.__dict__["caching"] = caching
        __props__.__dict__["create_option"] = create_option
        __props__.__dict__["disk_size_gb"] = disk_size_gb
        __props__.__dict__["lun"] = lun
        __props__.__dict__["name"] = name
        __props__.__dict__["source_resource_id"] = source_resource_id
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        __props__.__dict__["write_accelerator_enabled"] = write_accelerator_enabled
        return ImplicitDataDiskFromSource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def caching(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the caching requirements for this Data Disk. Possible values are `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Create Option of the Data Disk. The only possible value is `Copy`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_option")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter
    def lun(self) -> pulumi.Output[builtins.int]:
        """
        The Logical Unit Number of the Data Disk, which needs to be unique within the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lun")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of this Data Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the source resource which this Data Disk was created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Virtual Machine to which the Data Disk should be attached. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
        """
        return pulumi.get(self, "write_accelerator_enabled")

