# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedDiskSasTokenArgs', 'ManagedDiskSasToken']

@pulumi.input_type
class ManagedDiskSasTokenArgs:
    def __init__(__self__, *,
                 access_level: pulumi.Input[builtins.str],
                 duration_in_seconds: pulumi.Input[builtins.int],
                 managed_disk_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ManagedDiskSasToken resource.
        :param pulumi.Input[builtins.str] access_level: The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.
               
               Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
               for additional details on the fields above.
        :param pulumi.Input[builtins.int] duration_in_seconds: The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_disk_id: The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        pulumi.set(__self__, "managed_disk_id", managed_disk_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Input[builtins.str]:
        """
        The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.

        Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
        for additional details on the fields above.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> pulumi.Input[builtins.int]:
        """
        The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_in_seconds")

    @duration_in_seconds.setter
    def duration_in_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "duration_in_seconds", value)

    @property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disk_id")

    @managed_disk_id.setter
    def managed_disk_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_disk_id", value)


@pulumi.input_type
class _ManagedDiskSasTokenState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 managed_disk_id: Optional[pulumi.Input[builtins.str]] = None,
                 sas_url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedDiskSasToken resources.
        :param pulumi.Input[builtins.str] access_level: The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.
               
               Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
               for additional details on the fields above.
        :param pulumi.Input[builtins.int] duration_in_seconds: The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_disk_id: The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sas_url: The computed Shared Access Signature (SAS) of the Managed Disk.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        if managed_disk_id is not None:
            pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        if sas_url is not None:
            pulumi.set(__self__, "sas_url", sas_url)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.

        Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
        for additional details on the fields above.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_in_seconds")

    @duration_in_seconds.setter
    def duration_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "duration_in_seconds", value)

    @property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disk_id")

    @managed_disk_id.setter
    def managed_disk_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_disk_id", value)

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The computed Shared Access Signature (SAS) of the Managed Disk.
        """
        return pulumi.get(self, "sas_url")

    @sas_url.setter
    def sas_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sas_url", value)


@pulumi.type_token("azure:compute/managedDiskSasToken:ManagedDiskSasToken")
class ManagedDiskSasToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 managed_disk_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Disk SAS Token.

        Use this resource to obtain a Shared Access Signature (SAS Token) for an existing Managed Disk.

        Shared access signatures allow fine-grained, ephemeral access control to various aspects of Managed Disk similar to blob/storage account container.

        With the help of this resource, data from the disk can be copied from managed disk to a storage blob or to some other system without the need of azcopy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        test = azure.core.ResourceGroup("test",
            name="testrg",
            location="West Europe")
        test_managed_disk = azure.compute.ManagedDisk("test",
            name="tst-disk-export",
            location=test.location,
            resource_group_name=test.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=1)
        test_managed_disk_sas_token = azure.compute.ManagedDiskSasToken("test",
            managed_disk_id=test_managed_disk.id,
            duration_in_seconds=300,
            access_level="Read")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2023-04-02

        ## Import

        Disk SAS Token can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/managedDiskSasToken:ManagedDiskSasToken example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/disks/manageddisk1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_level: The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.
               
               Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
               for additional details on the fields above.
        :param pulumi.Input[builtins.int] duration_in_seconds: The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_disk_id: The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDiskSasTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Disk SAS Token.

        Use this resource to obtain a Shared Access Signature (SAS Token) for an existing Managed Disk.

        Shared access signatures allow fine-grained, ephemeral access control to various aspects of Managed Disk similar to blob/storage account container.

        With the help of this resource, data from the disk can be copied from managed disk to a storage blob or to some other system without the need of azcopy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        test = azure.core.ResourceGroup("test",
            name="testrg",
            location="West Europe")
        test_managed_disk = azure.compute.ManagedDisk("test",
            name="tst-disk-export",
            location=test.location,
            resource_group_name=test.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=1)
        test_managed_disk_sas_token = azure.compute.ManagedDiskSasToken("test",
            managed_disk_id=test_managed_disk.id,
            duration_in_seconds=300,
            access_level="Read")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2023-04-02

        ## Import

        Disk SAS Token can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/managedDiskSasToken:ManagedDiskSasToken example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/disks/manageddisk1
        ```

        :param str resource_name: The name of the resource.
        :param ManagedDiskSasTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDiskSasTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[builtins.str]] = None,
                 duration_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 managed_disk_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDiskSasTokenArgs.__new__(ManagedDiskSasTokenArgs)

            if access_level is None and not opts.urn:
                raise TypeError("Missing required property 'access_level'")
            __props__.__dict__["access_level"] = access_level
            if duration_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'duration_in_seconds'")
            __props__.__dict__["duration_in_seconds"] = duration_in_seconds
            if managed_disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_disk_id'")
            __props__.__dict__["managed_disk_id"] = managed_disk_id
            __props__.__dict__["sas_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sasUrl"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedDiskSasToken, __self__).__init__(
            'azure:compute/managedDiskSasToken:ManagedDiskSasToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[builtins.str]] = None,
            duration_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            managed_disk_id: Optional[pulumi.Input[builtins.str]] = None,
            sas_url: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedDiskSasToken':
        """
        Get an existing ManagedDiskSasToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_level: The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.
               
               Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
               for additional details on the fields above.
        :param pulumi.Input[builtins.int] duration_in_seconds: The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] managed_disk_id: The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sas_url: The computed Shared Access Signature (SAS) of the Managed Disk.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDiskSasTokenState.__new__(_ManagedDiskSasTokenState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["duration_in_seconds"] = duration_in_seconds
        __props__.__dict__["managed_disk_id"] = managed_disk_id
        __props__.__dict__["sas_url"] = sas_url
        return ManagedDiskSasToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[builtins.str]:
        """
        The level of access required on the disk. Supported are Read, Write. Changing this forces a new resource to be created.

        Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/compute/disks/grant-access)
        for additional details on the fields above.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        The duration for which the export should be allowed. Should be between 30 & 4294967295 seconds. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "duration_in_seconds")

    @property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of an existing Managed Disk which should be exported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disk_id")

    @property
    @pulumi.getter(name="sasUrl")
    def sas_url(self) -> pulumi.Output[builtins.str]:
        """
        The computed Shared Access Signature (SAS) of the Managed Disk.
        """
        return pulumi.get(self, "sas_url")

