# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetBudgetResourceGroupResult',
    'AwaitableGetBudgetResourceGroupResult',
    'get_budget_resource_group',
    'get_budget_resource_group_output',
]

@pulumi.output_type
class GetBudgetResourceGroupResult:
    """
    A collection of values returned by getBudgetResourceGroup.
    """
    def __init__(__self__, amount=None, filters=None, id=None, name=None, notifications=None, resource_group_id=None, time_grain=None, time_periods=None):
        if amount and not isinstance(amount, float):
            raise TypeError("Expected argument 'amount' to be a float")
        pulumi.set(__self__, "amount", amount)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notifications and not isinstance(notifications, list):
            raise TypeError("Expected argument 'notifications' to be a list")
        pulumi.set(__self__, "notifications", notifications)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if time_grain and not isinstance(time_grain, str):
            raise TypeError("Expected argument 'time_grain' to be a str")
        pulumi.set(__self__, "time_grain", time_grain)
        if time_periods and not isinstance(time_periods, list):
            raise TypeError("Expected argument 'time_periods' to be a list")
        pulumi.set(__self__, "time_periods", time_periods)

    @property
    @pulumi.getter
    def amount(self) -> builtins.float:
        """
        The total amount of cost to track with the budget.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetBudgetResourceGroupFilterResult']:
        """
        A `filter` block as defined below.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the tag used for the filter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> Sequence['outputs.GetBudgetResourceGroupNotificationResult']:
        """
        A `notification` block as defined below.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> builtins.str:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="timeGrain")
    def time_grain(self) -> builtins.str:
        """
        The time covered by a budget.
        """
        return pulumi.get(self, "time_grain")

    @property
    @pulumi.getter(name="timePeriods")
    def time_periods(self) -> Sequence['outputs.GetBudgetResourceGroupTimePeriodResult']:
        """
        A `time_period` block as defined below.
        """
        return pulumi.get(self, "time_periods")


class AwaitableGetBudgetResourceGroupResult(GetBudgetResourceGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBudgetResourceGroupResult(
            amount=self.amount,
            filters=self.filters,
            id=self.id,
            name=self.name,
            notifications=self.notifications,
            resource_group_id=self.resource_group_id,
            time_grain=self.time_grain,
            time_periods=self.time_periods)


def get_budget_resource_group(name: Optional[builtins.str] = None,
                              resource_group_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBudgetResourceGroupResult:
    """
    Use this data source to access information about an existing Consumption Budget for a specific resource group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.consumption.get_budget_resource_group(name="existing",
        resource_group_id=example_azurerm_resource_group["id"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Consumption`: 2019-10-01


    :param builtins.str name: The name of this Consumption Budget.
    :param builtins.str resource_group_id: The ID of the subscription.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupId'] = resource_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:consumption/getBudgetResourceGroup:getBudgetResourceGroup', __args__, opts=opts, typ=GetBudgetResourceGroupResult).value

    return AwaitableGetBudgetResourceGroupResult(
        amount=pulumi.get(__ret__, 'amount'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        notifications=pulumi.get(__ret__, 'notifications'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        time_grain=pulumi.get(__ret__, 'time_grain'),
        time_periods=pulumi.get(__ret__, 'time_periods'))
def get_budget_resource_group_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                     resource_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBudgetResourceGroupResult]:
    """
    Use this data source to access information about an existing Consumption Budget for a specific resource group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.consumption.get_budget_resource_group(name="existing",
        resource_group_id=example_azurerm_resource_group["id"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Consumption`: 2019-10-01


    :param builtins.str name: The name of this Consumption Budget.
    :param builtins.str resource_group_id: The ID of the subscription.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupId'] = resource_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:consumption/getBudgetResourceGroup:getBudgetResourceGroup', __args__, opts=opts, typ=GetBudgetResourceGroupResult)
    return __ret__.apply(lambda __response__: GetBudgetResourceGroupResult(
        amount=pulumi.get(__response__, 'amount'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        notifications=pulumi.get(__response__, 'notifications'),
        resource_group_id=pulumi.get(__response__, 'resource_group_id'),
        time_grain=pulumi.get(__response__, 'time_grain'),
        time_periods=pulumi.get(__response__, 'time_periods')))
