# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 container_app_environment_id: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 revision_mode: pulumi.Input[builtins.str],
                 template: pulumi.Input['AppTemplateArgs'],
                 dapr: Optional[pulumi.Input['AppDaprArgs']] = None,
                 identity: Optional[pulumi.Input['AppIdentityArgs']] = None,
                 ingress: Optional[pulumi.Input['AppIngressArgs']] = None,
                 max_inactive_revisions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] revision_mode: The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        :param pulumi.Input['AppTemplateArgs'] template: A `template` block as detailed below.
        :param pulumi.Input['AppDaprArgs'] dapr: A `dapr` block as detailed below.
        :param pulumi.Input['AppIdentityArgs'] identity: An `identity` block as detailed below.
        :param pulumi.Input['AppIngressArgs'] ingress: An `ingress` block as detailed below.
        :param pulumi.Input[builtins.int] max_inactive_revisions: The maximum of inactive revisions allowed for this Container App.
        :param pulumi.Input[builtins.str] name: The name for this Container App. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]] registries: A `registry` block as detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]] secrets: One or more `secret` block as detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Container App.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the Workload Profile in the Container App Environment to place this Container App.
               
               > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "revision_mode", revision_mode)
        pulumi.set(__self__, "template", template)
        if dapr is not None:
            pulumi.set(__self__, "dapr", dapr)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if max_inactive_revisions is not None:
            pulumi.set(__self__, "max_inactive_revisions", max_inactive_revisions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workload_profile_name is not None:
            pulumi.set(__self__, "workload_profile_name", workload_profile_name)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_app_environment_id", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="revisionMode")
    def revision_mode(self) -> pulumi.Input[builtins.str]:
        """
        The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        """
        return pulumi.get(self, "revision_mode")

    @revision_mode.setter
    def revision_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "revision_mode", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['AppTemplateArgs']:
        """
        A `template` block as detailed below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['AppTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def dapr(self) -> Optional[pulumi.Input['AppDaprArgs']]:
        """
        A `dapr` block as detailed below.
        """
        return pulumi.get(self, "dapr")

    @dapr.setter
    def dapr(self, value: Optional[pulumi.Input['AppDaprArgs']]):
        pulumi.set(self, "dapr", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AppIdentityArgs']]:
        """
        An `identity` block as detailed below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AppIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input['AppIngressArgs']]:
        """
        An `ingress` block as detailed below.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input['AppIngressArgs']]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="maxInactiveRevisions")
    def max_inactive_revisions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum of inactive revisions allowed for this Container App.
        """
        return pulumi.get(self, "max_inactive_revisions")

    @max_inactive_revisions.setter
    def max_inactive_revisions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_inactive_revisions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this Container App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]]]:
        """
        A `registry` block as detailed below.
        """
        return pulumi.get(self, "registries")

    @registries.setter
    def registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]]]):
        pulumi.set(self, "registries", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]]]:
        """
        One or more `secret` block as detailed below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Container App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workloadProfileName")
    def workload_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Workload Profile in the Container App Environment to place this Container App.

        > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        return pulumi.get(self, "workload_profile_name")

    @workload_profile_name.setter
    def workload_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_profile_name", value)


@pulumi.input_type
class _AppState:
    def __init__(__self__, *,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
                 dapr: Optional[pulumi.Input['AppDaprArgs']] = None,
                 identity: Optional[pulumi.Input['AppIdentityArgs']] = None,
                 ingress: Optional[pulumi.Input['AppIngressArgs']] = None,
                 latest_revision_fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 latest_revision_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 max_inactive_revisions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 revision_mode: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template: Optional[pulumi.Input['AppTemplateArgs']] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering App resources.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: The ID of the Custom Domain Verification for this Container App.
        :param pulumi.Input['AppDaprArgs'] dapr: A `dapr` block as detailed below.
        :param pulumi.Input['AppIdentityArgs'] identity: An `identity` block as detailed below.
        :param pulumi.Input['AppIngressArgs'] ingress: An `ingress` block as detailed below.
        :param pulumi.Input[builtins.str] latest_revision_fqdn: The FQDN of the Latest Revision of the Container App.
        :param pulumi.Input[builtins.str] latest_revision_name: The name of the latest Container Revision.
        :param pulumi.Input[builtins.str] location: The location this Container App is deployed in. This is the same as the Environment in which it is deployed.
        :param pulumi.Input[builtins.int] max_inactive_revisions: The maximum of inactive revisions allowed for this Container App.
        :param pulumi.Input[builtins.str] name: The name for this Container App. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_addresses: A list of the Public IP Addresses which the Container App uses for outbound network access.
        :param pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]] registries: A `registry` block as detailed below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] revision_mode: The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]] secrets: One or more `secret` block as detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Container App.
        :param pulumi.Input['AppTemplateArgs'] template: A `template` block as detailed below.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the Workload Profile in the Container App Environment to place this Container App.
               
               > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        if container_app_environment_id is not None:
            pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if dapr is not None:
            pulumi.set(__self__, "dapr", dapr)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if latest_revision_fqdn is not None:
            pulumi.set(__self__, "latest_revision_fqdn", latest_revision_fqdn)
        if latest_revision_name is not None:
            pulumi.set(__self__, "latest_revision_name", latest_revision_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_inactive_revisions is not None:
            pulumi.set(__self__, "max_inactive_revisions", max_inactive_revisions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if revision_mode is not None:
            pulumi.set(__self__, "revision_mode", revision_mode)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if workload_profile_name is not None:
            pulumi.set(__self__, "workload_profile_name", workload_profile_name)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_app_environment_id", value)

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Custom Domain Verification for this Container App.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @property
    @pulumi.getter
    def dapr(self) -> Optional[pulumi.Input['AppDaprArgs']]:
        """
        A `dapr` block as detailed below.
        """
        return pulumi.get(self, "dapr")

    @dapr.setter
    def dapr(self, value: Optional[pulumi.Input['AppDaprArgs']]):
        pulumi.set(self, "dapr", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AppIdentityArgs']]:
        """
        An `identity` block as detailed below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AppIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input['AppIngressArgs']]:
        """
        An `ingress` block as detailed below.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input['AppIngressArgs']]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter(name="latestRevisionFqdn")
    def latest_revision_fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FQDN of the Latest Revision of the Container App.
        """
        return pulumi.get(self, "latest_revision_fqdn")

    @latest_revision_fqdn.setter
    def latest_revision_fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latest_revision_fqdn", value)

    @property
    @pulumi.getter(name="latestRevisionName")
    def latest_revision_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the latest Container Revision.
        """
        return pulumi.get(self, "latest_revision_name")

    @latest_revision_name.setter
    def latest_revision_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "latest_revision_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location this Container App is deployed in. This is the same as the Environment in which it is deployed.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxInactiveRevisions")
    def max_inactive_revisions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum of inactive revisions allowed for this Container App.
        """
        return pulumi.get(self, "max_inactive_revisions")

    @max_inactive_revisions.setter
    def max_inactive_revisions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_inactive_revisions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this Container App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the Public IP Addresses which the Container App uses for outbound network access.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @property
    @pulumi.getter
    def registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]]]:
        """
        A `registry` block as detailed below.
        """
        return pulumi.get(self, "registries")

    @registries.setter
    def registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppRegistryArgs']]]]):
        pulumi.set(self, "registries", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="revisionMode")
    def revision_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        """
        return pulumi.get(self, "revision_mode")

    @revision_mode.setter
    def revision_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_mode", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]]]:
        """
        One or more `secret` block as detailed below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the Container App.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['AppTemplateArgs']]:
        """
        A `template` block as detailed below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['AppTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="workloadProfileName")
    def workload_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Workload Profile in the Container App Environment to place this Container App.

        > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        return pulumi.get(self, "workload_profile_name")

    @workload_profile_name.setter
    def workload_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_profile_name", value)


@pulumi.type_token("azure:containerapp/app:App")
class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 dapr: Optional[pulumi.Input[Union['AppDaprArgs', 'AppDaprArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['AppIdentityArgs', 'AppIdentityArgsDict']]] = None,
                 ingress: Optional[pulumi.Input[Union['AppIngressArgs', 'AppIngressArgsDict']]] = None,
                 max_inactive_revisions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppRegistryArgs', 'AppRegistryArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 revision_mode: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppSecretArgs', 'AppSecretArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['AppTemplateArgs', 'AppTemplateArgsDict']]] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container App.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="Example-Environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_app = azure.containerapp.App("example",
            name="example-app",
            container_app_environment_id=example_environment.id,
            resource_group_name=example.name,
            revision_mode="Single",
            template={
                "containers": [{
                    "name": "examplecontainerapp",
                    "image": "mcr.microsoft.com/k8se/quickstart:latest",
                    "cpu": 0.25,
                    "memory": "0.5Gi",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App`: 2025-01-01

        ## Import

        A Container App can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/app:App example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/containerApps/myContainerApp"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AppDaprArgs', 'AppDaprArgsDict']] dapr: A `dapr` block as detailed below.
        :param pulumi.Input[Union['AppIdentityArgs', 'AppIdentityArgsDict']] identity: An `identity` block as detailed below.
        :param pulumi.Input[Union['AppIngressArgs', 'AppIngressArgsDict']] ingress: An `ingress` block as detailed below.
        :param pulumi.Input[builtins.int] max_inactive_revisions: The maximum of inactive revisions allowed for this Container App.
        :param pulumi.Input[builtins.str] name: The name for this Container App. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppRegistryArgs', 'AppRegistryArgsDict']]]] registries: A `registry` block as detailed below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] revision_mode: The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppSecretArgs', 'AppSecretArgsDict']]]] secrets: One or more `secret` block as detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Container App.
        :param pulumi.Input[Union['AppTemplateArgs', 'AppTemplateArgsDict']] template: A `template` block as detailed below.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the Workload Profile in the Container App Environment to place this Container App.
               
               > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="Example-Environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_app = azure.containerapp.App("example",
            name="example-app",
            container_app_environment_id=example_environment.id,
            resource_group_name=example.name,
            revision_mode="Single",
            template={
                "containers": [{
                    "name": "examplecontainerapp",
                    "image": "mcr.microsoft.com/k8se/quickstart:latest",
                    "cpu": 0.25,
                    "memory": "0.5Gi",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App`: 2025-01-01

        ## Import

        A Container App can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/app:App example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/containerApps/myContainerApp"
        ```

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 dapr: Optional[pulumi.Input[Union['AppDaprArgs', 'AppDaprArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['AppIdentityArgs', 'AppIdentityArgsDict']]] = None,
                 ingress: Optional[pulumi.Input[Union['AppIngressArgs', 'AppIngressArgsDict']]] = None,
                 max_inactive_revisions: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppRegistryArgs', 'AppRegistryArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 revision_mode: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppSecretArgs', 'AppSecretArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['AppTemplateArgs', 'AppTemplateArgsDict']]] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppArgs.__new__(AppArgs)

            if container_app_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_environment_id'")
            __props__.__dict__["container_app_environment_id"] = container_app_environment_id
            __props__.__dict__["dapr"] = dapr
            __props__.__dict__["identity"] = identity
            __props__.__dict__["ingress"] = ingress
            __props__.__dict__["max_inactive_revisions"] = max_inactive_revisions
            __props__.__dict__["name"] = name
            __props__.__dict__["registries"] = registries
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if revision_mode is None and not opts.urn:
                raise TypeError("Missing required property 'revision_mode'")
            __props__.__dict__["revision_mode"] = revision_mode
            __props__.__dict__["secrets"] = None if secrets is None else pulumi.Output.secret(secrets)
            __props__.__dict__["tags"] = tags
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["workload_profile_name"] = workload_profile_name
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["latest_revision_fqdn"] = None
            __props__.__dict__["latest_revision_name"] = None
            __props__.__dict__["location"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["customDomainVerificationId", "secrets"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(App, __self__).__init__(
            'azure:containerapp/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[builtins.str]] = None,
            dapr: Optional[pulumi.Input[Union['AppDaprArgs', 'AppDaprArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['AppIdentityArgs', 'AppIdentityArgsDict']]] = None,
            ingress: Optional[pulumi.Input[Union['AppIngressArgs', 'AppIngressArgsDict']]] = None,
            latest_revision_fqdn: Optional[pulumi.Input[builtins.str]] = None,
            latest_revision_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            max_inactive_revisions: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppRegistryArgs', 'AppRegistryArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            revision_mode: Optional[pulumi.Input[builtins.str]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppSecretArgs', 'AppSecretArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            template: Optional[pulumi.Input[Union['AppTemplateArgs', 'AppTemplateArgsDict']]] = None,
            workload_profile_name: Optional[pulumi.Input[builtins.str]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] custom_domain_verification_id: The ID of the Custom Domain Verification for this Container App.
        :param pulumi.Input[Union['AppDaprArgs', 'AppDaprArgsDict']] dapr: A `dapr` block as detailed below.
        :param pulumi.Input[Union['AppIdentityArgs', 'AppIdentityArgsDict']] identity: An `identity` block as detailed below.
        :param pulumi.Input[Union['AppIngressArgs', 'AppIngressArgsDict']] ingress: An `ingress` block as detailed below.
        :param pulumi.Input[builtins.str] latest_revision_fqdn: The FQDN of the Latest Revision of the Container App.
        :param pulumi.Input[builtins.str] latest_revision_name: The name of the latest Container Revision.
        :param pulumi.Input[builtins.str] location: The location this Container App is deployed in. This is the same as the Environment in which it is deployed.
        :param pulumi.Input[builtins.int] max_inactive_revisions: The maximum of inactive revisions allowed for this Container App.
        :param pulumi.Input[builtins.str] name: The name for this Container App. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_addresses: A list of the Public IP Addresses which the Container App uses for outbound network access.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppRegistryArgs', 'AppRegistryArgsDict']]]] registries: A `registry` block as detailed below.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] revision_mode: The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppSecretArgs', 'AppSecretArgsDict']]]] secrets: One or more `secret` block as detailed below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the Container App.
        :param pulumi.Input[Union['AppTemplateArgs', 'AppTemplateArgsDict']] template: A `template` block as detailed below.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the Workload Profile in the Container App Environment to place this Container App.
               
               > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppState.__new__(_AppState)

        __props__.__dict__["container_app_environment_id"] = container_app_environment_id
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["dapr"] = dapr
        __props__.__dict__["identity"] = identity
        __props__.__dict__["ingress"] = ingress
        __props__.__dict__["latest_revision_fqdn"] = latest_revision_fqdn
        __props__.__dict__["latest_revision_name"] = latest_revision_name
        __props__.__dict__["location"] = location
        __props__.__dict__["max_inactive_revisions"] = max_inactive_revisions
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["registries"] = registries
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["revision_mode"] = revision_mode
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template"] = template
        __props__.__dict__["workload_profile_name"] = workload_profile_name
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Container App Environment within which this Container App should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Custom Domain Verification for this Container App.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @property
    @pulumi.getter
    def dapr(self) -> pulumi.Output[Optional['outputs.AppDapr']]:
        """
        A `dapr` block as detailed below.
        """
        return pulumi.get(self, "dapr")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AppIdentity']]:
        """
        An `identity` block as detailed below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def ingress(self) -> pulumi.Output[Optional['outputs.AppIngress']]:
        """
        An `ingress` block as detailed below.
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter(name="latestRevisionFqdn")
    def latest_revision_fqdn(self) -> pulumi.Output[builtins.str]:
        """
        The FQDN of the Latest Revision of the Container App.
        """
        return pulumi.get(self, "latest_revision_fqdn")

    @property
    @pulumi.getter(name="latestRevisionName")
    def latest_revision_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the latest Container Revision.
        """
        return pulumi.get(self, "latest_revision_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location this Container App is deployed in. This is the same as the Environment in which it is deployed.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maxInactiveRevisions")
    def max_inactive_revisions(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum of inactive revisions allowed for this Container App.
        """
        return pulumi.get(self, "max_inactive_revisions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for this Container App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of the Public IP Addresses which the Container App uses for outbound network access.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter
    def registries(self) -> pulumi.Output[Optional[Sequence['outputs.AppRegistry']]]:
        """
        A `registry` block as detailed below.
        """
        return pulumi.get(self, "registries")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which the Container App Environment is to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="revisionMode")
    def revision_mode(self) -> pulumi.Output[builtins.str]:
        """
        The revisions operational mode for the Container App. Possible values include `Single` and `Multiple`. In `Single` mode, a single revision is in operation at any given time. In `Multiple` mode, more than one revision can be active at a time and can be configured with load distribution via the `traffic_weight` block in the `ingress` configuration.
        """
        return pulumi.get(self, "revision_mode")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Sequence['outputs.AppSecret']]]:
        """
        One or more `secret` block as detailed below.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the Container App.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.AppTemplate']:
        """
        A `template` block as detailed below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="workloadProfileName")
    def workload_profile_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the Workload Profile in the Container App Environment to place this Container App.

        > **Note:** Omit this value to use the default `Consumption` Workload Profile.
        """
        return pulumi.get(self, "workload_profile_name")

