# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EnvironmentCertificateArgs', 'EnvironmentCertificate']

@pulumi.input_type
class EnvironmentCertificateArgs:
    def __init__(__self__, *,
                 certificate_blob_base64: pulumi.Input[builtins.str],
                 certificate_password: pulumi.Input[builtins.str],
                 container_app_environment_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a EnvironmentCertificate resource.
        :param pulumi.Input[builtins.str] certificate_blob_base64: The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] certificate_password: The password for the Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] container_app_environment_id: The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "certificate_blob_base64", certificate_blob_base64)
        pulumi.set(__self__, "certificate_password", certificate_password)
        pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="certificateBlobBase64")
    def certificate_blob_base64(self) -> pulumi.Input[builtins.str]:
        """
        The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_blob_base64")

    @certificate_blob_base64.setter
    def certificate_blob_base64(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_blob_base64", value)

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> pulumi.Input[builtins.str]:
        """
        The password for the Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_password", value)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Input[builtins.str]:
        """
        The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_app_environment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _EnvironmentCertificateState:
    def __init__(__self__, *,
                 certificate_blob_base64: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_password: Optional[pulumi.Input[builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_date: Optional[pulumi.Input[builtins.str]] = None,
                 issue_date: Optional[pulumi.Input[builtins.str]] = None,
                 issuer: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 subject_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EnvironmentCertificate resources.
        :param pulumi.Input[builtins.str] certificate_blob_base64: The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] certificate_password: The password for the Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] container_app_environment_id: The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date for the Certificate.
        :param pulumi.Input[builtins.str] issue_date: The date of issue for the Certificate.
        :param pulumi.Input[builtins.str] issuer: The Certificate Issuer.
        :param pulumi.Input[builtins.str] name: The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subject_name: The Subject Name for the Certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] thumbprint: The Thumbprint of the Certificate.
        """
        if certificate_blob_base64 is not None:
            pulumi.set(__self__, "certificate_blob_base64", certificate_blob_base64)
        if certificate_password is not None:
            pulumi.set(__self__, "certificate_password", certificate_password)
        if container_app_environment_id is not None:
            pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if issue_date is not None:
            pulumi.set(__self__, "issue_date", issue_date)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subject_name is not None:
            pulumi.set(__self__, "subject_name", subject_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter(name="certificateBlobBase64")
    def certificate_blob_base64(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_blob_base64")

    @certificate_blob_base64.setter
    def certificate_blob_base64(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_blob_base64", value)

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_password")

    @certificate_password.setter
    def certificate_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_password", value)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_app_environment_id", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date for the Certificate.
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="issueDate")
    def issue_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date of issue for the Certificate.
        """
        return pulumi.get(self, "issue_date")

    @issue_date.setter
    def issue_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issue_date", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Certificate Issuer.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Subject Name for the Certificate.
        """
        return pulumi.get(self, "subject_name")

    @subject_name.setter
    def subject_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subject_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.type_token("azure:containerapp/environmentCertificate:EnvironmentCertificate")
class EnvironmentCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_blob_base64: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_password: Optional[pulumi.Input[builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Container App Environment Certificate.

        ## Import

        A Container App Environment Certificate can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentCertificate:EnvironmentCertificate example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myenv/certificates/mycertificate"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_blob_base64: The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] certificate_password: The password for the Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] container_app_environment_id: The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App Environment Certificate.

        ## Import

        A Container App Environment Certificate can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerapp/environmentCertificate:EnvironmentCertificate example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.App/managedEnvironments/myenv/certificates/mycertificate"
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_blob_base64: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_password: Optional[pulumi.Input[builtins.str]] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentCertificateArgs.__new__(EnvironmentCertificateArgs)

            if certificate_blob_base64 is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_blob_base64'")
            __props__.__dict__["certificate_blob_base64"] = certificate_blob_base64
            if certificate_password is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_password'")
            __props__.__dict__["certificate_password"] = None if certificate_password is None else pulumi.Output.secret(certificate_password)
            if container_app_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_environment_id'")
            __props__.__dict__["container_app_environment_id"] = container_app_environment_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["expiration_date"] = None
            __props__.__dict__["issue_date"] = None
            __props__.__dict__["issuer"] = None
            __props__.__dict__["subject_name"] = None
            __props__.__dict__["thumbprint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificatePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EnvironmentCertificate, __self__).__init__(
            'azure:containerapp/environmentCertificate:EnvironmentCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_blob_base64: Optional[pulumi.Input[builtins.str]] = None,
            certificate_password: Optional[pulumi.Input[builtins.str]] = None,
            container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
            expiration_date: Optional[pulumi.Input[builtins.str]] = None,
            issue_date: Optional[pulumi.Input[builtins.str]] = None,
            issuer: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            subject_name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            thumbprint: Optional[pulumi.Input[builtins.str]] = None) -> 'EnvironmentCertificate':
        """
        Get an existing EnvironmentCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate_blob_base64: The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] certificate_password: The password for the Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] container_app_environment_id: The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] expiration_date: The expiration date for the Certificate.
        :param pulumi.Input[builtins.str] issue_date: The date of issue for the Certificate.
        :param pulumi.Input[builtins.str] issuer: The Certificate Issuer.
        :param pulumi.Input[builtins.str] name: The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subject_name: The Subject Name for the Certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] thumbprint: The Thumbprint of the Certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentCertificateState.__new__(_EnvironmentCertificateState)

        __props__.__dict__["certificate_blob_base64"] = certificate_blob_base64
        __props__.__dict__["certificate_password"] = certificate_password
        __props__.__dict__["container_app_environment_id"] = container_app_environment_id
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["issue_date"] = issue_date
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["name"] = name
        __props__.__dict__["subject_name"] = subject_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["thumbprint"] = thumbprint
        return EnvironmentCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateBlobBase64")
    def certificate_blob_base64(self) -> pulumi.Output[builtins.str]:
        """
        The Certificate Private Key as a base64 encoded PFX or PEM. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_blob_base64")

    @property
    @pulumi.getter(name="certificatePassword")
    def certificate_password(self) -> pulumi.Output[builtins.str]:
        """
        The password for the Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_password")

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The Container App Managed Environment ID to configure this Certificate on. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[builtins.str]:
        """
        The expiration date for the Certificate.
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="issueDate")
    def issue_date(self) -> pulumi.Output[builtins.str]:
        """
        The date of issue for the Certificate.
        """
        return pulumi.get(self, "issue_date")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[builtins.str]:
        """
        The Certificate Issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Container Apps Environment Certificate. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> pulumi.Output[builtins.str]:
        """
        The Subject Name for the Certificate.
        """
        return pulumi.get(self, "subject_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[builtins.str]:
        """
        The Thumbprint of the Certificate.
        """
        return pulumi.get(self, "thumbprint")

