# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 container_app_environment_id: pulumi.Input[builtins.str],
                 replica_timeout_in_seconds: pulumi.Input[builtins.int],
                 resource_group_name: pulumi.Input[builtins.str],
                 template: pulumi.Input['JobTemplateArgs'],
                 event_trigger_config: Optional[pulumi.Input['JobEventTriggerConfigArgs']] = None,
                 identity: Optional[pulumi.Input['JobIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 manual_trigger_config: Optional[pulumi.Input['JobManualTriggerConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]]] = None,
                 replica_retry_limit: Optional[pulumi.Input[builtins.int]] = None,
                 schedule_trigger_config: Optional[pulumi.Input['JobScheduleTriggerConfigArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.int] replica_timeout_in_seconds: The maximum number of seconds a replica is allowed to run.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input['JobTemplateArgs'] template: A `template` block as defined below.
        :param pulumi.Input['JobEventTriggerConfigArgs'] event_trigger_config: A `event_trigger_config` block as defined below.
        :param pulumi.Input['JobIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['JobManualTriggerConfigArgs'] manual_trigger_config: A `manual_trigger_config` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]] registries: One or more `registry` blocks as defined below.
        :param pulumi.Input[builtins.int] replica_retry_limit: The maximum number of times a replica is allowed to retry.
        :param pulumi.Input['JobScheduleTriggerConfigArgs'] schedule_trigger_config: A `schedule_trigger_config` block as defined below.
               
               > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the workload profile to use for the Container App Job.
        """
        pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        pulumi.set(__self__, "replica_timeout_in_seconds", replica_timeout_in_seconds)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "template", template)
        if event_trigger_config is not None:
            pulumi.set(__self__, "event_trigger_config", event_trigger_config)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if manual_trigger_config is not None:
            pulumi.set(__self__, "manual_trigger_config", manual_trigger_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if replica_retry_limit is not None:
            pulumi.set(__self__, "replica_retry_limit", replica_retry_limit)
        if schedule_trigger_config is not None:
            pulumi.set(__self__, "schedule_trigger_config", schedule_trigger_config)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workload_profile_name is not None:
            pulumi.set(__self__, "workload_profile_name", workload_profile_name)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_app_environment_id", value)

    @property
    @pulumi.getter(name="replicaTimeoutInSeconds")
    def replica_timeout_in_seconds(self) -> pulumi.Input[builtins.int]:
        """
        The maximum number of seconds a replica is allowed to run.
        """
        return pulumi.get(self, "replica_timeout_in_seconds")

    @replica_timeout_in_seconds.setter
    def replica_timeout_in_seconds(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "replica_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['JobTemplateArgs']:
        """
        A `template` block as defined below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['JobTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="eventTriggerConfig")
    def event_trigger_config(self) -> Optional[pulumi.Input['JobEventTriggerConfigArgs']]:
        """
        A `event_trigger_config` block as defined below.
        """
        return pulumi.get(self, "event_trigger_config")

    @event_trigger_config.setter
    def event_trigger_config(self, value: Optional[pulumi.Input['JobEventTriggerConfigArgs']]):
        pulumi.set(self, "event_trigger_config", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['JobIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['JobIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="manualTriggerConfig")
    def manual_trigger_config(self) -> Optional[pulumi.Input['JobManualTriggerConfigArgs']]:
        """
        A `manual_trigger_config` block as defined below.
        """
        return pulumi.get(self, "manual_trigger_config")

    @manual_trigger_config.setter
    def manual_trigger_config(self, value: Optional[pulumi.Input['JobManualTriggerConfigArgs']]):
        pulumi.set(self, "manual_trigger_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]]]:
        """
        One or more `registry` blocks as defined below.
        """
        return pulumi.get(self, "registries")

    @registries.setter
    def registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]]]):
        pulumi.set(self, "registries", value)

    @property
    @pulumi.getter(name="replicaRetryLimit")
    def replica_retry_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of times a replica is allowed to retry.
        """
        return pulumi.get(self, "replica_retry_limit")

    @replica_retry_limit.setter
    def replica_retry_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_retry_limit", value)

    @property
    @pulumi.getter(name="scheduleTriggerConfig")
    def schedule_trigger_config(self) -> Optional[pulumi.Input['JobScheduleTriggerConfigArgs']]:
        """
        A `schedule_trigger_config` block as defined below.

        > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        """
        return pulumi.get(self, "schedule_trigger_config")

    @schedule_trigger_config.setter
    def schedule_trigger_config(self, value: Optional[pulumi.Input['JobScheduleTriggerConfigArgs']]):
        pulumi.set(self, "schedule_trigger_config", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workloadProfileName")
    def workload_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the workload profile to use for the Container App Job.
        """
        return pulumi.get(self, "workload_profile_name")

    @workload_profile_name.setter
    def workload_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_profile_name", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_stream_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 event_trigger_config: Optional[pulumi.Input['JobEventTriggerConfigArgs']] = None,
                 identity: Optional[pulumi.Input['JobIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 manual_trigger_config: Optional[pulumi.Input['JobManualTriggerConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]]] = None,
                 replica_retry_limit: Optional[pulumi.Input[builtins.int]] = None,
                 replica_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_trigger_config: Optional[pulumi.Input['JobScheduleTriggerConfigArgs']] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template: Optional[pulumi.Input['JobTemplateArgs']] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] event_stream_endpoint: The endpoint for the Container App Job event stream.
        :param pulumi.Input['JobEventTriggerConfigArgs'] event_trigger_config: A `event_trigger_config` block as defined below.
        :param pulumi.Input['JobIdentityArgs'] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['JobManualTriggerConfigArgs'] manual_trigger_config: A `manual_trigger_config` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_addresses: A list of the Public IP Addresses which the Container App uses for outbound network access.
        :param pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]] registries: One or more `registry` blocks as defined below.
        :param pulumi.Input[builtins.int] replica_retry_limit: The maximum number of times a replica is allowed to retry.
        :param pulumi.Input[builtins.int] replica_timeout_in_seconds: The maximum number of seconds a replica is allowed to run.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input['JobScheduleTriggerConfigArgs'] schedule_trigger_config: A `schedule_trigger_config` block as defined below.
               
               > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['JobTemplateArgs'] template: A `template` block as defined below.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the workload profile to use for the Container App Job.
        """
        if container_app_environment_id is not None:
            pulumi.set(__self__, "container_app_environment_id", container_app_environment_id)
        if event_stream_endpoint is not None:
            pulumi.set(__self__, "event_stream_endpoint", event_stream_endpoint)
        if event_trigger_config is not None:
            pulumi.set(__self__, "event_trigger_config", event_trigger_config)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if manual_trigger_config is not None:
            pulumi.set(__self__, "manual_trigger_config", manual_trigger_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if registries is not None:
            pulumi.set(__self__, "registries", registries)
        if replica_retry_limit is not None:
            pulumi.set(__self__, "replica_retry_limit", replica_retry_limit)
        if replica_timeout_in_seconds is not None:
            pulumi.set(__self__, "replica_timeout_in_seconds", replica_timeout_in_seconds)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if schedule_trigger_config is not None:
            pulumi.set(__self__, "schedule_trigger_config", schedule_trigger_config)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if workload_profile_name is not None:
            pulumi.set(__self__, "workload_profile_name", workload_profile_name)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @container_app_environment_id.setter
    def container_app_environment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_app_environment_id", value)

    @property
    @pulumi.getter(name="eventStreamEndpoint")
    def event_stream_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint for the Container App Job event stream.
        """
        return pulumi.get(self, "event_stream_endpoint")

    @event_stream_endpoint.setter
    def event_stream_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "event_stream_endpoint", value)

    @property
    @pulumi.getter(name="eventTriggerConfig")
    def event_trigger_config(self) -> Optional[pulumi.Input['JobEventTriggerConfigArgs']]:
        """
        A `event_trigger_config` block as defined below.
        """
        return pulumi.get(self, "event_trigger_config")

    @event_trigger_config.setter
    def event_trigger_config(self, value: Optional[pulumi.Input['JobEventTriggerConfigArgs']]):
        pulumi.set(self, "event_trigger_config", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['JobIdentityArgs']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['JobIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="manualTriggerConfig")
    def manual_trigger_config(self) -> Optional[pulumi.Input['JobManualTriggerConfigArgs']]:
        """
        A `manual_trigger_config` block as defined below.
        """
        return pulumi.get(self, "manual_trigger_config")

    @manual_trigger_config.setter
    def manual_trigger_config(self, value: Optional[pulumi.Input['JobManualTriggerConfigArgs']]):
        pulumi.set(self, "manual_trigger_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the Public IP Addresses which the Container App uses for outbound network access.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @property
    @pulumi.getter
    def registries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]]]:
        """
        One or more `registry` blocks as defined below.
        """
        return pulumi.get(self, "registries")

    @registries.setter
    def registries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobRegistryArgs']]]]):
        pulumi.set(self, "registries", value)

    @property
    @pulumi.getter(name="replicaRetryLimit")
    def replica_retry_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of times a replica is allowed to retry.
        """
        return pulumi.get(self, "replica_retry_limit")

    @replica_retry_limit.setter
    def replica_retry_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_retry_limit", value)

    @property
    @pulumi.getter(name="replicaTimeoutInSeconds")
    def replica_timeout_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of seconds a replica is allowed to run.
        """
        return pulumi.get(self, "replica_timeout_in_seconds")

    @replica_timeout_in_seconds.setter
    def replica_timeout_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replica_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="scheduleTriggerConfig")
    def schedule_trigger_config(self) -> Optional[pulumi.Input['JobScheduleTriggerConfigArgs']]:
        """
        A `schedule_trigger_config` block as defined below.

        > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        """
        return pulumi.get(self, "schedule_trigger_config")

    @schedule_trigger_config.setter
    def schedule_trigger_config(self, value: Optional[pulumi.Input['JobScheduleTriggerConfigArgs']]):
        pulumi.set(self, "schedule_trigger_config", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['JobTemplateArgs']]:
        """
        A `template` block as defined below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['JobTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="workloadProfileName")
    def workload_profile_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the workload profile to use for the Container App Job.
        """
        return pulumi.get(self, "workload_profile_name")

    @workload_profile_name.setter
    def workload_profile_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_profile_name", value)


@pulumi.type_token("azure:containerapp/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_trigger_config: Optional[pulumi.Input[Union['JobEventTriggerConfigArgs', 'JobEventTriggerConfigArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 manual_trigger_config: Optional[pulumi.Input[Union['JobManualTriggerConfigArgs', 'JobManualTriggerConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobRegistryArgs', 'JobRegistryArgsDict']]]]] = None,
                 replica_retry_limit: Optional[pulumi.Input[builtins.int]] = None,
                 replica_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_trigger_config: Optional[pulumi.Input[Union['JobScheduleTriggerConfigArgs', 'JobScheduleTriggerConfigArgsDict']]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobSecretArgs', 'JobSecretArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']]] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container App Job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-log-analytics-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="example-container-app-environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_job = azure.containerapp.Job("example",
            name="example-container-app-job",
            location=example.location,
            resource_group_name=example.name,
            container_app_environment_id=example_environment.id,
            replica_timeout_in_seconds=10,
            replica_retry_limit=10,
            manual_trigger_config={
                "parallelism": 4,
                "replica_completion_count": 1,
            },
            template={
                "containers": [{
                    "image": "repo/testcontainerAppsJob0:v1",
                    "name": "testcontainerappsjob0",
                    "readiness_probes": [{
                        "transport": "HTTP",
                        "port": 5000,
                    }],
                    "liveness_probes": [{
                        "transport": "HTTP",
                        "port": 5000,
                        "path": "/health",
                        "headers": [{
                            "name": "Cache-Control",
                            "value": "no-cache",
                        }],
                        "initial_delay": 5,
                        "interval_seconds": 20,
                        "timeout": 2,
                        "failure_count_threshold": 1,
                    }],
                    "startup_probes": [{
                        "transport": "TCP",
                        "port": 5000,
                    }],
                    "cpu": 0.5,
                    "memory": "1Gi",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App`: 2025-01-01

        ## Import

        A Container App Job can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:containerapp/job:Job example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.App/jobs/example-container-app-job"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['JobEventTriggerConfigArgs', 'JobEventTriggerConfigArgsDict']] event_trigger_config: A `event_trigger_config` block as defined below.
        :param pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['JobManualTriggerConfigArgs', 'JobManualTriggerConfigArgsDict']] manual_trigger_config: A `manual_trigger_config` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobRegistryArgs', 'JobRegistryArgsDict']]]] registries: One or more `registry` blocks as defined below.
        :param pulumi.Input[builtins.int] replica_retry_limit: The maximum number of times a replica is allowed to retry.
        :param pulumi.Input[builtins.int] replica_timeout_in_seconds: The maximum number of seconds a replica is allowed to run.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['JobScheduleTriggerConfigArgs', 'JobScheduleTriggerConfigArgsDict']] schedule_trigger_config: A `schedule_trigger_config` block as defined below.
               
               > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobSecretArgs', 'JobSecretArgsDict']]]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']] template: A `template` block as defined below.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the workload profile to use for the Container App Job.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container App Job.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example-log-analytics-workspace",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_environment = azure.containerapp.Environment("example",
            name="example-container-app-environment",
            location=example.location,
            resource_group_name=example.name,
            log_analytics_workspace_id=example_analytics_workspace.id)
        example_job = azure.containerapp.Job("example",
            name="example-container-app-job",
            location=example.location,
            resource_group_name=example.name,
            container_app_environment_id=example_environment.id,
            replica_timeout_in_seconds=10,
            replica_retry_limit=10,
            manual_trigger_config={
                "parallelism": 4,
                "replica_completion_count": 1,
            },
            template={
                "containers": [{
                    "image": "repo/testcontainerAppsJob0:v1",
                    "name": "testcontainerappsjob0",
                    "readiness_probes": [{
                        "transport": "HTTP",
                        "port": 5000,
                    }],
                    "liveness_probes": [{
                        "transport": "HTTP",
                        "port": 5000,
                        "path": "/health",
                        "headers": [{
                            "name": "Cache-Control",
                            "value": "no-cache",
                        }],
                        "initial_delay": 5,
                        "interval_seconds": 20,
                        "timeout": 2,
                        "failure_count_threshold": 1,
                    }],
                    "startup_probes": [{
                        "transport": "TCP",
                        "port": 5000,
                    }],
                    "cpu": 0.5,
                    "memory": "1Gi",
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.App`: 2025-01-01

        ## Import

        A Container App Job can be imported using the resource id, e.g.

        ```sh
        $ pulumi import azure:containerapp/job:Job example "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.App/jobs/example-container-app-job"
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
                 event_trigger_config: Optional[pulumi.Input[Union['JobEventTriggerConfigArgs', 'JobEventTriggerConfigArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 manual_trigger_config: Optional[pulumi.Input[Union['JobManualTriggerConfigArgs', 'JobManualTriggerConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobRegistryArgs', 'JobRegistryArgsDict']]]]] = None,
                 replica_retry_limit: Optional[pulumi.Input[builtins.int]] = None,
                 replica_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_trigger_config: Optional[pulumi.Input[Union['JobScheduleTriggerConfigArgs', 'JobScheduleTriggerConfigArgsDict']]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobSecretArgs', 'JobSecretArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template: Optional[pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']]] = None,
                 workload_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            if container_app_environment_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_app_environment_id'")
            __props__.__dict__["container_app_environment_id"] = container_app_environment_id
            __props__.__dict__["event_trigger_config"] = event_trigger_config
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["manual_trigger_config"] = manual_trigger_config
            __props__.__dict__["name"] = name
            __props__.__dict__["registries"] = registries
            __props__.__dict__["replica_retry_limit"] = replica_retry_limit
            if replica_timeout_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'replica_timeout_in_seconds'")
            __props__.__dict__["replica_timeout_in_seconds"] = replica_timeout_in_seconds
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["schedule_trigger_config"] = schedule_trigger_config
            __props__.__dict__["secrets"] = None if secrets is None else pulumi.Output.secret(secrets)
            __props__.__dict__["tags"] = tags
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["workload_profile_name"] = workload_profile_name
            __props__.__dict__["event_stream_endpoint"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secrets"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Job, __self__).__init__(
            'azure:containerapp/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_app_environment_id: Optional[pulumi.Input[builtins.str]] = None,
            event_stream_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            event_trigger_config: Optional[pulumi.Input[Union['JobEventTriggerConfigArgs', 'JobEventTriggerConfigArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            manual_trigger_config: Optional[pulumi.Input[Union['JobManualTriggerConfigArgs', 'JobManualTriggerConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            registries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobRegistryArgs', 'JobRegistryArgsDict']]]]] = None,
            replica_retry_limit: Optional[pulumi.Input[builtins.int]] = None,
            replica_timeout_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            schedule_trigger_config: Optional[pulumi.Input[Union['JobScheduleTriggerConfigArgs', 'JobScheduleTriggerConfigArgsDict']]] = None,
            secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobSecretArgs', 'JobSecretArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            template: Optional[pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']]] = None,
            workload_profile_name: Optional[pulumi.Input[builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] container_app_environment_id: The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] event_stream_endpoint: The endpoint for the Container App Job event stream.
        :param pulumi.Input[Union['JobEventTriggerConfigArgs', 'JobEventTriggerConfigArgsDict']] event_trigger_config: A `event_trigger_config` block as defined below.
        :param pulumi.Input[Union['JobIdentityArgs', 'JobIdentityArgsDict']] identity: A `identity` block as defined below.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['JobManualTriggerConfigArgs', 'JobManualTriggerConfigArgsDict']] manual_trigger_config: A `manual_trigger_config` block as defined below.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] outbound_ip_addresses: A list of the Public IP Addresses which the Container App uses for outbound network access.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobRegistryArgs', 'JobRegistryArgsDict']]]] registries: One or more `registry` blocks as defined below.
        :param pulumi.Input[builtins.int] replica_retry_limit: The maximum number of times a replica is allowed to retry.
        :param pulumi.Input[builtins.int] replica_timeout_in_seconds: The maximum number of seconds a replica is allowed to run.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['JobScheduleTriggerConfigArgs', 'JobScheduleTriggerConfigArgsDict']] schedule_trigger_config: A `schedule_trigger_config` block as defined below.
               
               > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobSecretArgs', 'JobSecretArgsDict']]]] secrets: One or more `secret` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['JobTemplateArgs', 'JobTemplateArgsDict']] template: A `template` block as defined below.
        :param pulumi.Input[builtins.str] workload_profile_name: The name of the workload profile to use for the Container App Job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["container_app_environment_id"] = container_app_environment_id
        __props__.__dict__["event_stream_endpoint"] = event_stream_endpoint
        __props__.__dict__["event_trigger_config"] = event_trigger_config
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["manual_trigger_config"] = manual_trigger_config
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["registries"] = registries
        __props__.__dict__["replica_retry_limit"] = replica_retry_limit
        __props__.__dict__["replica_timeout_in_seconds"] = replica_timeout_in_seconds
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["schedule_trigger_config"] = schedule_trigger_config
        __props__.__dict__["secrets"] = secrets
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template"] = template
        __props__.__dict__["workload_profile_name"] = workload_profile_name
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerAppEnvironmentId")
    def container_app_environment_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Container App Environment in which to create the Container App Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_app_environment_id")

    @property
    @pulumi.getter(name="eventStreamEndpoint")
    def event_stream_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint for the Container App Job event stream.
        """
        return pulumi.get(self, "event_stream_endpoint")

    @property
    @pulumi.getter(name="eventTriggerConfig")
    def event_trigger_config(self) -> pulumi.Output[Optional['outputs.JobEventTriggerConfig']]:
        """
        A `event_trigger_config` block as defined below.
        """
        return pulumi.get(self, "event_trigger_config")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.JobIdentity']]:
        """
        A `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="manualTriggerConfig")
    def manual_trigger_config(self) -> pulumi.Output[Optional['outputs.JobManualTriggerConfig']]:
        """
        A `manual_trigger_config` block as defined below.
        """
        return pulumi.get(self, "manual_trigger_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Container App Job resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of the Public IP Addresses which the Container App uses for outbound network access.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @property
    @pulumi.getter
    def registries(self) -> pulumi.Output[Optional[Sequence['outputs.JobRegistry']]]:
        """
        One or more `registry` blocks as defined below.
        """
        return pulumi.get(self, "registries")

    @property
    @pulumi.getter(name="replicaRetryLimit")
    def replica_retry_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of times a replica is allowed to retry.
        """
        return pulumi.get(self, "replica_retry_limit")

    @property
    @pulumi.getter(name="replicaTimeoutInSeconds")
    def replica_timeout_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        The maximum number of seconds a replica is allowed to run.
        """
        return pulumi.get(self, "replica_timeout_in_seconds")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Container App Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="scheduleTriggerConfig")
    def schedule_trigger_config(self) -> pulumi.Output[Optional['outputs.JobScheduleTriggerConfig']]:
        """
        A `schedule_trigger_config` block as defined below.

        > **Note:** Only one of `manual_trigger_config`, `event_trigger_config` or `schedule_trigger_config` can be specified.
        """
        return pulumi.get(self, "schedule_trigger_config")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output[Optional[Sequence['outputs.JobSecret']]]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.JobTemplate']:
        """
        A `template` block as defined below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="workloadProfileName")
    def workload_profile_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the workload profile to use for the Container App Job.
        """
        return pulumi.get(self, "workload_profile_name")

