# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetUpdateStrategyArgs', 'FleetUpdateStrategy']

@pulumi.input_type
class FleetUpdateStrategyArgs:
    def __init__(__self__, *,
                 kubernetes_fleet_manager_id: pulumi.Input[builtins.str],
                 stages: pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FleetUpdateStrategy resource.
        :param pulumi.Input[builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]] stages: One or more `stage` blocks as defined below.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        pulumi.set(__self__, "kubernetes_fleet_manager_id", kubernetes_fleet_manager_id)
        pulumi.set(__self__, "stages", stages)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="kubernetesFleetManagerId")
    def kubernetes_fleet_manager_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_manager_id")

    @kubernetes_fleet_manager_id.setter
    def kubernetes_fleet_manager_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kubernetes_fleet_manager_id", value)

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]]:
        """
        One or more `stage` blocks as defined below.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]]):
        pulumi.set(self, "stages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FleetUpdateStrategyState:
    def __init__(__self__, *,
                 kubernetes_fleet_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]]] = None):
        """
        Input properties used for looking up and filtering FleetUpdateStrategy resources.
        :param pulumi.Input[builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]] stages: One or more `stage` blocks as defined below.
        """
        if kubernetes_fleet_manager_id is not None:
            pulumi.set(__self__, "kubernetes_fleet_manager_id", kubernetes_fleet_manager_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter(name="kubernetesFleetManagerId")
    def kubernetes_fleet_manager_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_manager_id")

    @kubernetes_fleet_manager_id.setter
    def kubernetes_fleet_manager_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kubernetes_fleet_manager_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]]]:
        """
        One or more `stage` blocks as defined below.
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetUpdateStrategyStageArgs']]]]):
        pulumi.set(self, "stages", value)


@pulumi.type_token("azure:containerservice/fleetUpdateStrategy:FleetUpdateStrategy")
class FleetUpdateStrategy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kubernetes_fleet_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateStrategyStageArgs', 'FleetUpdateStrategyStageArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Kubernetes Fleet Update Strategy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="westeurope")
        example_kubernetes_fleet_manager = azure.containerservice.KubernetesFleetManager("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        example_fleet_update_strategy = azure.containerservice.FleetUpdateStrategy("example",
            name="example",
            kubernetes_fleet_manager_id=example_kubernetes_fleet_manager.id,
            stages=[{
                "name": "example-stage-1",
                "groups": [{
                    "name": "example-group-1",
                }],
                "after_stage_wait_in_seconds": 21,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService`: 2024-04-01

        ## Import

        Kubernetes Fleet Update Strategies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/fleetUpdateStrategy:FleetUpdateStrategy example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.ContainerService/fleets/fleet1/updateStrategies/updateStrategy1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateStrategyStageArgs', 'FleetUpdateStrategyStageArgsDict']]]] stages: One or more `stage` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetUpdateStrategyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kubernetes Fleet Update Strategy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="westeurope")
        example_kubernetes_fleet_manager = azure.containerservice.KubernetesFleetManager("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        example_fleet_update_strategy = azure.containerservice.FleetUpdateStrategy("example",
            name="example",
            kubernetes_fleet_manager_id=example_kubernetes_fleet_manager.id,
            stages=[{
                "name": "example-stage-1",
                "groups": [{
                    "name": "example-group-1",
                }],
                "after_stage_wait_in_seconds": 21,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerService`: 2024-04-01

        ## Import

        Kubernetes Fleet Update Strategies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/fleetUpdateStrategy:FleetUpdateStrategy example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.ContainerService/fleets/fleet1/updateStrategies/updateStrategy1
        ```

        :param str resource_name: The name of the resource.
        :param FleetUpdateStrategyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetUpdateStrategyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 kubernetes_fleet_manager_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateStrategyStageArgs', 'FleetUpdateStrategyStageArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetUpdateStrategyArgs.__new__(FleetUpdateStrategyArgs)

            if kubernetes_fleet_manager_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_fleet_manager_id'")
            __props__.__dict__["kubernetes_fleet_manager_id"] = kubernetes_fleet_manager_id
            __props__.__dict__["name"] = name
            if stages is None and not opts.urn:
                raise TypeError("Missing required property 'stages'")
            __props__.__dict__["stages"] = stages
        super(FleetUpdateStrategy, __self__).__init__(
            'azure:containerservice/fleetUpdateStrategy:FleetUpdateStrategy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            kubernetes_fleet_manager_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateStrategyStageArgs', 'FleetUpdateStrategyStageArgsDict']]]]] = None) -> 'FleetUpdateStrategy':
        """
        Get an existing FleetUpdateStrategy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] kubernetes_fleet_manager_id: The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetUpdateStrategyStageArgs', 'FleetUpdateStrategyStageArgsDict']]]] stages: One or more `stage` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetUpdateStrategyState.__new__(_FleetUpdateStrategyState)

        __props__.__dict__["kubernetes_fleet_manager_id"] = kubernetes_fleet_manager_id
        __props__.__dict__["name"] = name
        __props__.__dict__["stages"] = stages
        return FleetUpdateStrategy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="kubernetesFleetManagerId")
    def kubernetes_fleet_manager_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Fleet Manager. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_manager_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Kubernetes Fleet Update Strategy. Changing this forces a new Kubernetes Fleet Update Strategy to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Sequence['outputs.FleetUpdateStrategyStage']]:
        """
        One or more `stage` blocks as defined below.
        """
        return pulumi.get(self, "stages")

