# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRegistryCacheRuleResult',
    'AwaitableGetRegistryCacheRuleResult',
    'get_registry_cache_rule',
    'get_registry_cache_rule_output',
]

@pulumi.output_type
class GetRegistryCacheRuleResult:
    """
    A collection of values returned by getRegistryCacheRule.
    """
    def __init__(__self__, container_registry_id=None, credential_set_id=None, id=None, name=None, source_repo=None, target_repo=None):
        if container_registry_id and not isinstance(container_registry_id, str):
            raise TypeError("Expected argument 'container_registry_id' to be a str")
        pulumi.set(__self__, "container_registry_id", container_registry_id)
        if credential_set_id and not isinstance(credential_set_id, str):
            raise TypeError("Expected argument 'credential_set_id' to be a str")
        pulumi.set(__self__, "credential_set_id", credential_set_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source_repo and not isinstance(source_repo, str):
            raise TypeError("Expected argument 'source_repo' to be a str")
        pulumi.set(__self__, "source_repo", source_repo)
        if target_repo and not isinstance(target_repo, str):
            raise TypeError("Expected argument 'target_repo' to be a str")
        pulumi.set(__self__, "target_repo", target_repo)

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> builtins.str:
        return pulumi.get(self, "container_registry_id")

    @property
    @pulumi.getter(name="credentialSetId")
    def credential_set_id(self) -> builtins.str:
        """
        The ARM resource ID of the credential store which is associated with the cache rule.
        """
        return pulumi.get(self, "credential_set_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceRepo")
    def source_repo(self) -> builtins.str:
        """
        The name of the source repository path.
        """
        return pulumi.get(self, "source_repo")

    @property
    @pulumi.getter(name="targetRepo")
    def target_repo(self) -> builtins.str:
        """
        The name of the new repository path to store artifacts.
        """
        return pulumi.get(self, "target_repo")


class AwaitableGetRegistryCacheRuleResult(GetRegistryCacheRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryCacheRuleResult(
            container_registry_id=self.container_registry_id,
            credential_set_id=self.credential_set_id,
            id=self.id,
            name=self.name,
            source_repo=self.source_repo,
            target_repo=self.target_repo)


def get_registry_cache_rule(container_registry_id: Optional[builtins.str] = None,
                            name: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryCacheRuleResult:
    """
    Use this data source to access information about an existing Container Registry Cache Rule.


    :param builtins.str container_registry_id: The ID of the container registry where the cache rule should apply. Changing this forces a new resource to be created.
    :param builtins.str name: Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
    """
    __args__ = dict()
    __args__['containerRegistryId'] = container_registry_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:containerservice/getRegistryCacheRule:getRegistryCacheRule', __args__, opts=opts, typ=GetRegistryCacheRuleResult).value

    return AwaitableGetRegistryCacheRuleResult(
        container_registry_id=pulumi.get(__ret__, 'container_registry_id'),
        credential_set_id=pulumi.get(__ret__, 'credential_set_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        source_repo=pulumi.get(__ret__, 'source_repo'),
        target_repo=pulumi.get(__ret__, 'target_repo'))
def get_registry_cache_rule_output(container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                                   name: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegistryCacheRuleResult]:
    """
    Use this data source to access information about an existing Container Registry Cache Rule.


    :param builtins.str container_registry_id: The ID of the container registry where the cache rule should apply. Changing this forces a new resource to be created.
    :param builtins.str name: Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
    """
    __args__ = dict()
    __args__['containerRegistryId'] = container_registry_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:containerservice/getRegistryCacheRule:getRegistryCacheRule', __args__, opts=opts, typ=GetRegistryCacheRuleResult)
    return __ret__.apply(lambda __response__: GetRegistryCacheRuleResult(
        container_registry_id=pulumi.get(__response__, 'container_registry_id'),
        credential_set_id=pulumi.get(__response__, 'credential_set_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        source_repo=pulumi.get(__response__, 'source_repo'),
        target_repo=pulumi.get(__response__, 'target_repo')))
