# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 containers: pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]],
                 os_type: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 diagnostics: Optional[pulumi.Input['GroupDiagnosticsArgs']] = None,
                 dns_config: Optional[pulumi.Input['GroupDnsConfigArgs']] = None,
                 dns_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 dns_name_label_reuse_policy: Optional[pulumi.Input[builtins.str]] = None,
                 exposed_ports: Optional[pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]]] = None,
                 identity: Optional[pulumi.Input['GroupIdentityArgs']] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]] containers: The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] os_type: The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.
               
               > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input['GroupDiagnosticsArgs'] diagnostics: A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input['GroupDnsConfigArgs'] dns_config: A `dns_config` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] dns_name_label: The DNS label/name for the container group's IP. Changing this forces a new resource to be created.
               
               > **Note:** DNS label/name is not supported when deploying to virtual networks.
        :param pulumi.Input[builtins.str] dns_name_label_reuse_policy: The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]] exposed_ports: Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        :param pulumi.Input['GroupIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]] image_registry_credentials: An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]] init_containers: The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ip_address_type: Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.
               
               > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        :param pulumi.Input[builtins.str] key_vault_key_id: The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_user_assigned_identity_id: The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] priority: The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.
               
               > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        :param pulumi.Input[builtins.str] restart_policy: Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_ids: The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if dns_name_label is not None:
            pulumi.set(__self__, "dns_name_label", dns_name_label)
        if dns_name_label_reuse_policy is not None:
            pulumi.set(__self__, "dns_name_label_reuse_policy", dns_name_label_reuse_policy)
        if exposed_ports is not None:
            pulumi.set(__self__, "exposed_ports", exposed_ports)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if key_vault_user_assigned_identity_id is not None:
            pulumi.set(__self__, "key_vault_user_assigned_identity_id", key_vault_user_assigned_identity_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile_id is not None:
            warnings.warn("""the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""", DeprecationWarning)
            pulumi.log.warn("""network_profile_id is deprecated: the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""")
        if network_profile_id is not None:
            pulumi.set(__self__, "network_profile_id", network_profile_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]]:
        """
        The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[builtins.str]:
        """
        The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.

        > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['GroupDiagnosticsArgs']]:
        """
        A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['GroupDiagnosticsArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['GroupDnsConfigArgs']]:
        """
        A `dns_config` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['GroupDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @property
    @pulumi.getter(name="dnsNameLabel")
    def dns_name_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS label/name for the container group's IP. Changing this forces a new resource to be created.

        > **Note:** DNS label/name is not supported when deploying to virtual networks.
        """
        return pulumi.get(self, "dns_name_label")

    @dns_name_label.setter
    def dns_name_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_name_label", value)

    @property
    @pulumi.getter(name="dnsNameLabelReusePolicy")
    def dns_name_label_reuse_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_name_label_reuse_policy")

    @dns_name_label_reuse_policy.setter
    def dns_name_label_reuse_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_name_label_reuse_policy", value)

    @property
    @pulumi.getter(name="exposedPorts")
    def exposed_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]]]:
        """
        Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.

        > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        """
        return pulumi.get(self, "exposed_ports")

    @exposed_ports.setter
    def exposed_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]]]):
        pulumi.set(self, "exposed_ports", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['GroupIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['GroupIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]]]:
        """
        An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]]]:
        """
        The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.

        > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter(name="keyVaultUserAssignedIdentityId")
    def key_vault_user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        """
        return pulumi.get(self, "key_vault_user_assigned_identity_id")

    @key_vault_user_assigned_identity_id.setter
    def key_vault_user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_user_assigned_identity_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Container Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkProfileId")
    @_utilities.deprecated("""the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""")
    def network_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "network_profile_id")

    @network_profile_id.setter
    def network_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_profile_id", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.

        > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]]] = None,
                 diagnostics: Optional[pulumi.Input['GroupDiagnosticsArgs']] = None,
                 dns_config: Optional[pulumi.Input['GroupDnsConfigArgs']] = None,
                 dns_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 dns_name_label_reuse_policy: Optional[pulumi.Input[builtins.str]] = None,
                 exposed_ports: Optional[pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]]] = None,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['GroupIdentityArgs']] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]]] = None,
                 ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]] containers: The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input['GroupDiagnosticsArgs'] diagnostics: A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input['GroupDnsConfigArgs'] dns_config: A `dns_config` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] dns_name_label: The DNS label/name for the container group's IP. Changing this forces a new resource to be created.
               
               > **Note:** DNS label/name is not supported when deploying to virtual networks.
        :param pulumi.Input[builtins.str] dns_name_label_reuse_policy: The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]] exposed_ports: Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        :param pulumi.Input[builtins.str] fqdn: The FQDN of the container group derived from `dns_name_label`.
        :param pulumi.Input['GroupIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]] image_registry_credentials: An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]] init_containers: The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ip_address: The IP address allocated to the container group.
        :param pulumi.Input[builtins.str] ip_address_type: Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.
               
               > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        :param pulumi.Input[builtins.str] key_vault_key_id: The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_user_assigned_identity_id: The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] os_type: The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.
               
               > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        :param pulumi.Input[builtins.str] priority: The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.
               
               > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] restart_policy: Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_ids: The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if dns_config is not None:
            pulumi.set(__self__, "dns_config", dns_config)
        if dns_name_label is not None:
            pulumi.set(__self__, "dns_name_label", dns_name_label)
        if dns_name_label_reuse_policy is not None:
            pulumi.set(__self__, "dns_name_label_reuse_policy", dns_name_label_reuse_policy)
        if exposed_ports is not None:
            pulumi.set(__self__, "exposed_ports", exposed_ports)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if key_vault_user_assigned_identity_id is not None:
            pulumi.set(__self__, "key_vault_user_assigned_identity_id", key_vault_user_assigned_identity_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profile_id is not None:
            warnings.warn("""the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""", DeprecationWarning)
            pulumi.log.warn("""network_profile_id is deprecated: the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""")
        if network_profile_id is not None:
            pulumi.set(__self__, "network_profile_id", network_profile_id)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]]]:
        """
        The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input['GroupDiagnosticsArgs']]:
        """
        A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input['GroupDiagnosticsArgs']]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> Optional[pulumi.Input['GroupDnsConfigArgs']]:
        """
        A `dns_config` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_config")

    @dns_config.setter
    def dns_config(self, value: Optional[pulumi.Input['GroupDnsConfigArgs']]):
        pulumi.set(self, "dns_config", value)

    @property
    @pulumi.getter(name="dnsNameLabel")
    def dns_name_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DNS label/name for the container group's IP. Changing this forces a new resource to be created.

        > **Note:** DNS label/name is not supported when deploying to virtual networks.
        """
        return pulumi.get(self, "dns_name_label")

    @dns_name_label.setter
    def dns_name_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_name_label", value)

    @property
    @pulumi.getter(name="dnsNameLabelReusePolicy")
    def dns_name_label_reuse_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_name_label_reuse_policy")

    @dns_name_label_reuse_policy.setter
    def dns_name_label_reuse_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_name_label_reuse_policy", value)

    @property
    @pulumi.getter(name="exposedPorts")
    def exposed_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]]]:
        """
        Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.

        > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        """
        return pulumi.get(self, "exposed_ports")

    @exposed_ports.setter
    def exposed_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupExposedPortArgs']]]]):
        pulumi.set(self, "exposed_ports", value)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The FQDN of the container group derived from `dns_name_label`.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['GroupIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['GroupIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]]]:
        """
        An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]]]:
        """
        The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address allocated to the container group.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.

        > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter(name="keyVaultUserAssignedIdentityId")
    def key_vault_user_assigned_identity_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        """
        return pulumi.get(self, "key_vault_user_assigned_identity_id")

    @key_vault_user_assigned_identity_id.setter
    def key_vault_user_assigned_identity_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_user_assigned_identity_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Container Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkProfileId")
    @_utilities.deprecated("""the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""")
    def network_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "network_profile_id")

    @network_profile_id.setter
    def network_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_profile_id", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.

        > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.

        > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:containerservice/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupContainerArgs', 'GroupContainerArgsDict']]]]] = None,
                 diagnostics: Optional[pulumi.Input[Union['GroupDiagnosticsArgs', 'GroupDiagnosticsArgsDict']]] = None,
                 dns_config: Optional[pulumi.Input[Union['GroupDnsConfigArgs', 'GroupDnsConfigArgsDict']]] = None,
                 dns_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 dns_name_label_reuse_policy: Optional[pulumi.Input[builtins.str]] = None,
                 exposed_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupExposedPortArgs', 'GroupExposedPortArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['GroupIdentityArgs', 'GroupIdentityArgsDict']]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupImageRegistryCredentialArgs', 'GroupImageRegistryCredentialArgsDict']]]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupInitContainerArgs', 'GroupInitContainerArgsDict']]]]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Manages as an Azure Container Group instance.

        ## Example Usage

        This example provisions a Basic Container.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_group = azure.containerservice.Group("example",
            name="example-continst",
            location=example.location,
            resource_group_name=example.name,
            ip_address_type="Public",
            dns_name_label="aci-label",
            os_type="Linux",
            containers=[
                {
                    "name": "hello-world",
                    "image": "mcr.microsoft.com/azuredocs/aci-helloworld:latest",
                    "cpu": 0.5,
                    "memory": 1.5,
                    "ports": [{
                        "port": 443,
                        "protocol": "TCP",
                    }],
                },
                {
                    "name": "sidecar",
                    "image": "mcr.microsoft.com/azuredocs/aci-tutorial-sidecar",
                    "cpu": 0.5,
                    "memory": 1.5,
                },
            ],
            tags={
                "environment": "testing",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerInstance`: 2023-05-01

        ## Import

        Container Group's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/group:Group containerGroup1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerInstance/containerGroups/myContainerGroup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupContainerArgs', 'GroupContainerArgsDict']]]] containers: The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GroupDiagnosticsArgs', 'GroupDiagnosticsArgsDict']] diagnostics: A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GroupDnsConfigArgs', 'GroupDnsConfigArgsDict']] dns_config: A `dns_config` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] dns_name_label: The DNS label/name for the container group's IP. Changing this forces a new resource to be created.
               
               > **Note:** DNS label/name is not supported when deploying to virtual networks.
        :param pulumi.Input[builtins.str] dns_name_label_reuse_policy: The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupExposedPortArgs', 'GroupExposedPortArgsDict']]]] exposed_ports: Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        :param pulumi.Input[Union['GroupIdentityArgs', 'GroupIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupImageRegistryCredentialArgs', 'GroupImageRegistryCredentialArgsDict']]]] image_registry_credentials: An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupInitContainerArgs', 'GroupInitContainerArgsDict']]]] init_containers: The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ip_address_type: Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.
               
               > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        :param pulumi.Input[builtins.str] key_vault_key_id: The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_user_assigned_identity_id: The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] os_type: The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.
               
               > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        :param pulumi.Input[builtins.str] priority: The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.
               
               > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] restart_policy: Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_ids: The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages as an Azure Container Group instance.

        ## Example Usage

        This example provisions a Basic Container.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_group = azure.containerservice.Group("example",
            name="example-continst",
            location=example.location,
            resource_group_name=example.name,
            ip_address_type="Public",
            dns_name_label="aci-label",
            os_type="Linux",
            containers=[
                {
                    "name": "hello-world",
                    "image": "mcr.microsoft.com/azuredocs/aci-helloworld:latest",
                    "cpu": 0.5,
                    "memory": 1.5,
                    "ports": [{
                        "port": 443,
                        "protocol": "TCP",
                    }],
                },
                {
                    "name": "sidecar",
                    "image": "mcr.microsoft.com/azuredocs/aci-tutorial-sidecar",
                    "cpu": 0.5,
                    "memory": 1.5,
                },
            ],
            tags={
                "environment": "testing",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerInstance`: 2023-05-01

        ## Import

        Container Group's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/group:Group containerGroup1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerInstance/containerGroups/myContainerGroup1
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupContainerArgs', 'GroupContainerArgsDict']]]]] = None,
                 diagnostics: Optional[pulumi.Input[Union['GroupDiagnosticsArgs', 'GroupDiagnosticsArgsDict']]] = None,
                 dns_config: Optional[pulumi.Input[Union['GroupDnsConfigArgs', 'GroupDnsConfigArgsDict']]] = None,
                 dns_name_label: Optional[pulumi.Input[builtins.str]] = None,
                 dns_name_label_reuse_policy: Optional[pulumi.Input[builtins.str]] = None,
                 exposed_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupExposedPortArgs', 'GroupExposedPortArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['GroupIdentityArgs', 'GroupIdentityArgsDict']]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupImageRegistryCredentialArgs', 'GroupImageRegistryCredentialArgsDict']]]]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupInitContainerArgs', 'GroupInitContainerArgsDict']]]]] = None,
                 ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_vault_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_type: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restart_policy: Optional[pulumi.Input[builtins.str]] = None,
                 sku: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_ids: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            if containers is None and not opts.urn:
                raise TypeError("Missing required property 'containers'")
            __props__.__dict__["containers"] = containers
            __props__.__dict__["diagnostics"] = diagnostics
            __props__.__dict__["dns_config"] = dns_config
            __props__.__dict__["dns_name_label"] = dns_name_label
            __props__.__dict__["dns_name_label_reuse_policy"] = dns_name_label_reuse_policy
            __props__.__dict__["exposed_ports"] = exposed_ports
            __props__.__dict__["identity"] = identity
            __props__.__dict__["image_registry_credentials"] = image_registry_credentials
            __props__.__dict__["init_containers"] = init_containers
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            __props__.__dict__["key_vault_user_assigned_identity_id"] = key_vault_user_assigned_identity_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_profile_id"] = network_profile_id
            if os_type is None and not opts.urn:
                raise TypeError("Missing required property 'os_type'")
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["priority"] = priority
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["restart_policy"] = restart_policy
            __props__.__dict__["sku"] = sku
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zones"] = zones
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["ip_address"] = None
        super(Group, __self__).__init__(
            'azure:containerservice/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupContainerArgs', 'GroupContainerArgsDict']]]]] = None,
            diagnostics: Optional[pulumi.Input[Union['GroupDiagnosticsArgs', 'GroupDiagnosticsArgsDict']]] = None,
            dns_config: Optional[pulumi.Input[Union['GroupDnsConfigArgs', 'GroupDnsConfigArgsDict']]] = None,
            dns_name_label: Optional[pulumi.Input[builtins.str]] = None,
            dns_name_label_reuse_policy: Optional[pulumi.Input[builtins.str]] = None,
            exposed_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupExposedPortArgs', 'GroupExposedPortArgsDict']]]]] = None,
            fqdn: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['GroupIdentityArgs', 'GroupIdentityArgsDict']]] = None,
            image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupImageRegistryCredentialArgs', 'GroupImageRegistryCredentialArgsDict']]]]] = None,
            init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GroupInitContainerArgs', 'GroupInitContainerArgsDict']]]]] = None,
            ip_address: Optional[pulumi.Input[builtins.str]] = None,
            ip_address_type: Optional[pulumi.Input[builtins.str]] = None,
            key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
            key_vault_user_assigned_identity_id: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            os_type: Optional[pulumi.Input[builtins.str]] = None,
            priority: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            restart_policy: Optional[pulumi.Input[builtins.str]] = None,
            sku: Optional[pulumi.Input[builtins.str]] = None,
            subnet_ids: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupContainerArgs', 'GroupContainerArgsDict']]]] containers: The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GroupDiagnosticsArgs', 'GroupDiagnosticsArgsDict']] diagnostics: A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GroupDnsConfigArgs', 'GroupDnsConfigArgsDict']] dns_config: A `dns_config` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] dns_name_label: The DNS label/name for the container group's IP. Changing this forces a new resource to be created.
               
               > **Note:** DNS label/name is not supported when deploying to virtual networks.
        :param pulumi.Input[builtins.str] dns_name_label_reuse_policy: The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupExposedPortArgs', 'GroupExposedPortArgsDict']]]] exposed_ports: Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        :param pulumi.Input[builtins.str] fqdn: The FQDN of the container group derived from `dns_name_label`.
        :param pulumi.Input[Union['GroupIdentityArgs', 'GroupIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupImageRegistryCredentialArgs', 'GroupImageRegistryCredentialArgsDict']]]] image_registry_credentials: An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GroupInitContainerArgs', 'GroupInitContainerArgsDict']]]] init_containers: The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] ip_address: The IP address allocated to the container group.
        :param pulumi.Input[builtins.str] ip_address_type: Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.
               
               > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        :param pulumi.Input[builtins.str] key_vault_key_id: The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] key_vault_user_assigned_identity_id: The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] os_type: The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.
               
               > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        :param pulumi.Input[builtins.str] priority: The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.
               
               > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] restart_policy: Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] sku: Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] subnet_ids: The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] zones: A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["containers"] = containers
        __props__.__dict__["diagnostics"] = diagnostics
        __props__.__dict__["dns_config"] = dns_config
        __props__.__dict__["dns_name_label"] = dns_name_label
        __props__.__dict__["dns_name_label_reuse_policy"] = dns_name_label_reuse_policy
        __props__.__dict__["exposed_ports"] = exposed_ports
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["identity"] = identity
        __props__.__dict__["image_registry_credentials"] = image_registry_credentials
        __props__.__dict__["init_containers"] = init_containers
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["ip_address_type"] = ip_address_type
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["key_vault_user_assigned_identity_id"] = key_vault_user_assigned_identity_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profile_id"] = network_profile_id
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["priority"] = priority
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["restart_policy"] = restart_policy
        __props__.__dict__["sku"] = sku
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zones"] = zones
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Sequence['outputs.GroupContainer']]:
        """
        The definition of a container that is part of the group as documented in the `container` block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def diagnostics(self) -> pulumi.Output[Optional['outputs.GroupDiagnostics']]:
        """
        A `diagnostics` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "diagnostics")

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> pulumi.Output[Optional['outputs.GroupDnsConfig']]:
        """
        A `dns_config` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_config")

    @property
    @pulumi.getter(name="dnsNameLabel")
    def dns_name_label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The DNS label/name for the container group's IP. Changing this forces a new resource to be created.

        > **Note:** DNS label/name is not supported when deploying to virtual networks.
        """
        return pulumi.get(self, "dns_name_label")

    @property
    @pulumi.getter(name="dnsNameLabelReusePolicy")
    def dns_name_label_reuse_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The value representing the security enum. `Noreuse`, `ResourceGroupReuse`, `SubscriptionReuse`, `TenantReuse` or `Unsecure`. Defaults to `Unsecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dns_name_label_reuse_policy")

    @property
    @pulumi.getter(name="exposedPorts")
    def exposed_ports(self) -> pulumi.Output[Sequence['outputs.GroupExposedPort']]:
        """
        Zero or more `exposed_port` blocks as defined below. Changing this forces a new resource to be created.

        > **Note:** The `exposed_port` can only contain ports that are also exposed on one or more containers in the group.
        """
        return pulumi.get(self, "exposed_ports")

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[builtins.str]:
        """
        The FQDN of the container group derived from `dns_name_label`.
        """
        return pulumi.get(self, "fqdn")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.GroupIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> pulumi.Output[Optional[Sequence['outputs.GroupImageRegistryCredential']]]:
        """
        An `image_registry_credential` block as documented below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_registry_credentials")

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> pulumi.Output[Optional[Sequence['outputs.GroupInitContainer']]]:
        """
        The definition of an init container that is part of the group as documented in the `init_container` block below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "init_containers")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[builtins.str]:
        """
        The IP address allocated to the container group.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the IP address type of the container. `Public`, `Private` or `None`. Changing this forces a new resource to be created. If set to `Private`, `subnet_ids` also needs to be set. Defaults to `Public`.

        > **Note:** `dns_name_label` and `os_type` set to `windows` are not compatible with `Private` `ip_address_type`
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Key Vault key URI for CMK encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_key_id")

    @property
    @pulumi.getter(name="keyVaultUserAssignedIdentityId")
    def key_vault_user_assigned_identity_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user assigned identity that has access to the Key Vault Key. If not specified, the RP principal named "Azure Container Instance Service" will be used instead. Make sure the identity has the proper `key_permissions` set, at least with `Get`, `UnwrapKey`, `WrapKey` and `GetRotationPolicy`.
        """
        return pulumi.get(self, "key_vault_user_assigned_identity_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Container Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkProfileId")
    @_utilities.deprecated("""the 'network_profile_id' has been removed from the latest versions of the container instance API and has been deprecated. It no longer functions and will be removed from the 4.0 AzureRM provider. Please use the 'subnet_ids' field instead""")
    def network_profile_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "network_profile_id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[builtins.str]:
        """
        The OS for the container group. Allowed values are `Linux` and `Windows`. Changing this forces a new resource to be created.

        > **Note:** if `os_type` is set to `Windows` currently only a single `container` block is supported. Windows containers are not supported in virtual networks.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The priority of the Container Group. Possible values are `Regular` and `Spot`. Changing this forces a new resource to be created.

        > **Note:** When `priority` is set to `Spot`, the `ip_address_type` has to be `None`.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which to create the Container Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Restart policy for the container group. Allowed values are `Always`, `Never`, `OnFailure`. Defaults to `Always`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the sku of the Container Group. Possible values are `Confidential`, `Dedicated` and `Standard`. Defaults to `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The subnet resource IDs for a container group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of Availability Zones in which this Container Group is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "zones")

