# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryCacheRuleArgs', 'RegistryCacheRule']

@pulumi.input_type
class RegistryCacheRuleArgs:
    def __init__(__self__, *,
                 container_registry_id: pulumi.Input[builtins.str],
                 source_repo: pulumi.Input[builtins.str],
                 target_repo: pulumi.Input[builtins.str],
                 credential_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryCacheRule resource.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_repo: The name of the source repository path. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_repo: The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] credential_set_id: The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "container_registry_id", container_registry_id)
        pulumi.set(__self__, "source_repo", source_repo)
        pulumi.set(__self__, "target_repo", target_repo)
        if credential_set_id is not None:
            pulumi.set(__self__, "credential_set_id", credential_set_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_registry_id", value)

    @property
    @pulumi.getter(name="sourceRepo")
    def source_repo(self) -> pulumi.Input[builtins.str]:
        """
        The name of the source repository path. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_repo")

    @source_repo.setter
    def source_repo(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_repo", value)

    @property
    @pulumi.getter(name="targetRepo")
    def target_repo(self) -> pulumi.Input[builtins.str]:
        """
        The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_repo")

    @target_repo.setter
    def target_repo(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_repo", value)

    @property
    @pulumi.getter(name="credentialSetId")
    def credential_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        """
        return pulumi.get(self, "credential_set_id")

    @credential_set_id.setter
    def credential_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_set_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryCacheRuleState:
    def __init__(__self__, *,
                 container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 credential_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_repo: Optional[pulumi.Input[builtins.str]] = None,
                 target_repo: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryCacheRule resources.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] credential_set_id: The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_repo: The name of the source repository path. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_repo: The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        """
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if credential_set_id is not None:
            pulumi.set(__self__, "credential_set_id", credential_set_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_repo is not None:
            pulumi.set(__self__, "source_repo", source_repo)
        if target_repo is not None:
            pulumi.set(__self__, "target_repo", target_repo)

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @property
    @pulumi.getter(name="credentialSetId")
    def credential_set_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        """
        return pulumi.get(self, "credential_set_id")

    @credential_set_id.setter
    def credential_set_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "credential_set_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceRepo")
    def source_repo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the source repository path. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_repo")

    @source_repo.setter
    def source_repo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_repo", value)

    @property
    @pulumi.getter(name="targetRepo")
    def target_repo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_repo")

    @target_repo.setter
    def target_repo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_repo", value)


@pulumi.type_token("azure:containerservice/registryCacheRule:RegistryCacheRule")
class RegistryCacheRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 credential_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_repo: Optional[pulumi.Input[builtins.str]] = None,
                 target_repo: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Container Registry Cache Rule.

        > **Note:** All arguments including the access key will be stored in the raw state as plain-text.
        [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        acr = azure.containerservice.Registry("acr",
            name="containerRegistry1",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        cache_rule = azure.containerservice.RegistryCacheRule("cache_rule",
            name="cacherule",
            container_registry_id=acr.id,
            target_repo="target",
            source_repo="docker.io/hello-world",
            credential_set_id=acr.id.apply(lambda id: f"{id}/credentialSets/example"))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-07-01

        ## Import

        Container Registry Cache Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryCacheRule:RegistryCacheRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/cacheRules/myCacheRule
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] credential_set_id: The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_repo: The name of the source repository path. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_repo: The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryCacheRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Container Registry Cache Rule.

        > **Note:** All arguments including the access key will be stored in the raw state as plain-text.
        [Read more about sensitive data in state](https://www.terraform.io/docs/state/sensitive-data.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        acr = azure.containerservice.Registry("acr",
            name="containerRegistry1",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        cache_rule = azure.containerservice.RegistryCacheRule("cache_rule",
            name="cacherule",
            container_registry_id=acr.id,
            target_repo="target",
            source_repo="docker.io/hello-world",
            credential_set_id=acr.id.apply(lambda id: f"{id}/credentialSets/example"))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-07-01

        ## Import

        Container Registry Cache Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryCacheRule:RegistryCacheRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.ContainerRegistry/registries/myRegistry/cacheRules/myCacheRule
        ```

        :param str resource_name: The name of the resource.
        :param RegistryCacheRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryCacheRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 credential_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_repo: Optional[pulumi.Input[builtins.str]] = None,
                 target_repo: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryCacheRuleArgs.__new__(RegistryCacheRuleArgs)

            if container_registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_id'")
            __props__.__dict__["container_registry_id"] = container_registry_id
            __props__.__dict__["credential_set_id"] = credential_set_id
            __props__.__dict__["name"] = name
            if source_repo is None and not opts.urn:
                raise TypeError("Missing required property 'source_repo'")
            __props__.__dict__["source_repo"] = source_repo
            if target_repo is None and not opts.urn:
                raise TypeError("Missing required property 'target_repo'")
            __props__.__dict__["target_repo"] = target_repo
        super(RegistryCacheRule, __self__).__init__(
            'azure:containerservice/registryCacheRule:RegistryCacheRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
            credential_set_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            source_repo: Optional[pulumi.Input[builtins.str]] = None,
            target_repo: Optional[pulumi.Input[builtins.str]] = None) -> 'RegistryCacheRule':
        """
        Get an existing RegistryCacheRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] credential_set_id: The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        :param pulumi.Input[builtins.str] name: Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_repo: The name of the source repository path. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] target_repo: The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryCacheRuleState.__new__(_RegistryCacheRuleState)

        __props__.__dict__["container_registry_id"] = container_registry_id
        __props__.__dict__["credential_set_id"] = credential_set_id
        __props__.__dict__["name"] = name
        __props__.__dict__["source_repo"] = source_repo
        __props__.__dict__["target_repo"] = target_repo
        return RegistryCacheRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Container Registry where the Cache Rule should apply. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @property
    @pulumi.getter(name="credentialSetId")
    def credential_set_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARM resource ID of the Credential Store which is associated with the Cache Rule.
        """
        return pulumi.get(self, "credential_set_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Container Registry Cache Rule. Only Alphanumeric characters allowed. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceRepo")
    def source_repo(self) -> pulumi.Output[builtins.str]:
        """
        The name of the source repository path. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_repo")

    @property
    @pulumi.getter(name="targetRepo")
    def target_repo(self) -> pulumi.Output[builtins.str]:
        """
        The name of the new repository path to store artifacts. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_repo")

