# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistryCredentialSetArgs', 'RegistryCredentialSet']

@pulumi.input_type
class RegistryCredentialSetArgs:
    def __init__(__self__, *,
                 authentication_credentials: pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs'],
                 container_registry_id: pulumi.Input[builtins.str],
                 identity: pulumi.Input['RegistryCredentialSetIdentityArgs'],
                 login_server: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryCredentialSet resource.
        :param pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs'] authentication_credentials: A `authentication_credentials` block as defined below.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input['RegistryCredentialSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] login_server: The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        pulumi.set(__self__, "authentication_credentials", authentication_credentials)
        pulumi.set(__self__, "container_registry_id", container_registry_id)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "login_server", login_server)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="authenticationCredentials")
    def authentication_credentials(self) -> pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs']:
        """
        A `authentication_credentials` block as defined below.
        """
        return pulumi.get(self, "authentication_credentials")

    @authentication_credentials.setter
    def authentication_credentials(self, value: pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs']):
        pulumi.set(self, "authentication_credentials", value)

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "container_registry_id", value)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input['RegistryCredentialSetIdentityArgs']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['RegistryCredentialSetIdentityArgs']):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> pulumi.Input[builtins.str]:
        """
        The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "login_server")

    @login_server.setter
    def login_server(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "login_server", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryCredentialSetState:
    def __init__(__self__, *,
                 authentication_credentials: Optional[pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs']] = None,
                 container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['RegistryCredentialSetIdentityArgs']] = None,
                 login_server: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryCredentialSet resources.
        :param pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs'] authentication_credentials: A `authentication_credentials` block as defined below.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input['RegistryCredentialSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] login_server: The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        if authentication_credentials is not None:
            pulumi.set(__self__, "authentication_credentials", authentication_credentials)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if login_server is not None:
            pulumi.set(__self__, "login_server", login_server)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="authenticationCredentials")
    def authentication_credentials(self) -> Optional[pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs']]:
        """
        A `authentication_credentials` block as defined below.
        """
        return pulumi.get(self, "authentication_credentials")

    @authentication_credentials.setter
    def authentication_credentials(self, value: Optional[pulumi.Input['RegistryCredentialSetAuthenticationCredentialsArgs']]):
        pulumi.set(self, "authentication_credentials", value)

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['RegistryCredentialSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['RegistryCredentialSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "login_server")

    @login_server.setter
    def login_server(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "login_server", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:containerservice/registryCredentialSet:RegistryCredentialSet")
class RegistryCredentialSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_credentials: Optional[pulumi.Input[Union['RegistryCredentialSetAuthenticationCredentialsArgs', 'RegistryCredentialSetAuthenticationCredentialsArgsDict']]] = None,
                 container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['RegistryCredentialSetIdentityArgs', 'RegistryCredentialSetIdentityArgsDict']]] = None,
                 login_server: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container Registry Credential Set.

        ## Example Usage

        ### Minimal)

        > **Note:** Be aware that you will need to permit the Identity that is created for the Container Registry to have `get` on secrets to the Key Vault, e.g. using the `keyvault.AccessPolicy` resource.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="exampleContainerRegistry",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_credential_set = azure.containerservice.RegistryCredentialSet("example",
            name="exampleCredentialSet",
            container_registry_id=example_registry.id,
            login_server="docker.io",
            identity={
                "type": "SystemAssigned",
            },
            authentication_credentials={
                "username_secret_id": "https://example-keyvault.vault.azure.net/secrets/example-user-name",
                "password_secret_id": "https://example-keyvault.vault.azure.net/secrets/example-user-password",
            })
        ```

        ### Full)

        This example provisions a key vault with two secrets, a container registry, a container registry credential set, and an access policy to allow the container registry to read the secrets from the key vault.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [],
                "key_permissions": [],
                "secret_permissions": [
                    "Get",
                    "Set",
                    "Delete",
                    "Purge",
                ],
            }])
        example_user = azure.keyvault.Secret("example_user",
            key_vault_id=example_key_vault.id,
            name="example-user-name",
            value="name")
        example_password = azure.keyvault.Secret("example_password",
            key_vault_id=example_key_vault.id,
            name="example-user-password",
            value="password")
        example_registry = azure.containerservice.Registry("example",
            name="exampleContainerRegistry",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_credential_set = azure.containerservice.RegistryCredentialSet("example",
            name="exampleCredentialSet",
            container_registry_id=example_registry.id,
            login_server="docker.io",
            identity={
                "type": "SystemAssigned",
            },
            authentication_credentials={
                "username_secret_id": example_user.versionless_id,
                "password_secret_id": example_password.versionless_id,
            })
        read_secrets = azure.keyvault.AccessPolicy("read_secrets",
            key_vault_id=example_key_vault.id,
            tenant_id=example_registry_credential_set.identity.tenant_id,
            object_id=example_registry_credential_set.identity.principal_id,
            secret_permissions=["Get"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-07-01

        ## Import

        Container Registry Credential Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryCredentialSet:RegistryCredentialSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/credentialSets/credentialSet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegistryCredentialSetAuthenticationCredentialsArgs', 'RegistryCredentialSetAuthenticationCredentialsArgsDict']] authentication_credentials: A `authentication_credentials` block as defined below.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input[Union['RegistryCredentialSetIdentityArgs', 'RegistryCredentialSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] login_server: The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryCredentialSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container Registry Credential Set.

        ## Example Usage

        ### Minimal)

        > **Note:** Be aware that you will need to permit the Identity that is created for the Container Registry to have `get` on secrets to the Key Vault, e.g. using the `keyvault.AccessPolicy` resource.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="exampleContainerRegistry",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_credential_set = azure.containerservice.RegistryCredentialSet("example",
            name="exampleCredentialSet",
            container_registry_id=example_registry.id,
            login_server="docker.io",
            identity={
                "type": "SystemAssigned",
            },
            authentication_credentials={
                "username_secret_id": "https://example-keyvault.vault.azure.net/secrets/example-user-name",
                "password_secret_id": "https://example-keyvault.vault.azure.net/secrets/example-user-password",
            })
        ```

        ### Full)

        This example provisions a key vault with two secrets, a container registry, a container registry credential set, and an access policy to allow the container registry to read the secrets from the key vault.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "certificate_permissions": [],
                "key_permissions": [],
                "secret_permissions": [
                    "Get",
                    "Set",
                    "Delete",
                    "Purge",
                ],
            }])
        example_user = azure.keyvault.Secret("example_user",
            key_vault_id=example_key_vault.id,
            name="example-user-name",
            value="name")
        example_password = azure.keyvault.Secret("example_password",
            key_vault_id=example_key_vault.id,
            name="example-user-password",
            value="password")
        example_registry = azure.containerservice.Registry("example",
            name="exampleContainerRegistry",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_credential_set = azure.containerservice.RegistryCredentialSet("example",
            name="exampleCredentialSet",
            container_registry_id=example_registry.id,
            login_server="docker.io",
            identity={
                "type": "SystemAssigned",
            },
            authentication_credentials={
                "username_secret_id": example_user.versionless_id,
                "password_secret_id": example_password.versionless_id,
            })
        read_secrets = azure.keyvault.AccessPolicy("read_secrets",
            key_vault_id=example_key_vault.id,
            tenant_id=example_registry_credential_set.identity.tenant_id,
            object_id=example_registry_credential_set.identity.principal_id,
            secret_permissions=["Get"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-07-01

        ## Import

        Container Registry Credential Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryCredentialSet:RegistryCredentialSet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/credentialSets/credentialSet1
        ```

        :param str resource_name: The name of the resource.
        :param RegistryCredentialSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryCredentialSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_credentials: Optional[pulumi.Input[Union['RegistryCredentialSetAuthenticationCredentialsArgs', 'RegistryCredentialSetAuthenticationCredentialsArgsDict']]] = None,
                 container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['RegistryCredentialSetIdentityArgs', 'RegistryCredentialSetIdentityArgsDict']]] = None,
                 login_server: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryCredentialSetArgs.__new__(RegistryCredentialSetArgs)

            if authentication_credentials is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_credentials'")
            __props__.__dict__["authentication_credentials"] = authentication_credentials
            if container_registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_id'")
            __props__.__dict__["container_registry_id"] = container_registry_id
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            if login_server is None and not opts.urn:
                raise TypeError("Missing required property 'login_server'")
            __props__.__dict__["login_server"] = login_server
            __props__.__dict__["name"] = name
        super(RegistryCredentialSet, __self__).__init__(
            'azure:containerservice/registryCredentialSet:RegistryCredentialSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_credentials: Optional[pulumi.Input[Union['RegistryCredentialSetAuthenticationCredentialsArgs', 'RegistryCredentialSetAuthenticationCredentialsArgsDict']]] = None,
            container_registry_id: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['RegistryCredentialSetIdentityArgs', 'RegistryCredentialSetIdentityArgsDict']]] = None,
            login_server: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'RegistryCredentialSet':
        """
        Get an existing RegistryCredentialSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegistryCredentialSetAuthenticationCredentialsArgs', 'RegistryCredentialSetAuthenticationCredentialsArgsDict']] authentication_credentials: A `authentication_credentials` block as defined below.
        :param pulumi.Input[builtins.str] container_registry_id: The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input[Union['RegistryCredentialSetIdentityArgs', 'RegistryCredentialSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[builtins.str] login_server: The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryCredentialSetState.__new__(_RegistryCredentialSetState)

        __props__.__dict__["authentication_credentials"] = authentication_credentials
        __props__.__dict__["container_registry_id"] = container_registry_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["login_server"] = login_server
        __props__.__dict__["name"] = name
        return RegistryCredentialSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationCredentials")
    def authentication_credentials(self) -> pulumi.Output['outputs.RegistryCredentialSetAuthenticationCredentials']:
        """
        A `authentication_credentials` block as defined below.
        """
        return pulumi.get(self, "authentication_credentials")

    @property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Container Registry. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "container_registry_id")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.RegistryCredentialSetIdentity']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="loginServer")
    def login_server(self) -> pulumi.Output[builtins.str]:
        """
        The login server for the Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "login_server")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Container Registry Credential Set. Changing this forces a new Container Registry Credential Set to be created.
        """
        return pulumi.get(self, "name")

