# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetExtendedLocationsResult',
    'AwaitableGetExtendedLocationsResult',
    'get_extended_locations',
    'get_extended_locations_output',
]

@pulumi.output_type
class GetExtendedLocationsResult:
    """
    A collection of values returned by getExtendedLocations.
    """
    def __init__(__self__, extended_locations=None, id=None, location=None):
        if extended_locations and not isinstance(extended_locations, list):
            raise TypeError("Expected argument 'extended_locations' to be a list")
        pulumi.set(__self__, "extended_locations", extended_locations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter(name="extendedLocations")
    def extended_locations(self) -> Sequence[builtins.str]:
        """
        The available extended locations for the Azure Location.
        """
        return pulumi.get(self, "extended_locations")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")


class AwaitableGetExtendedLocationsResult(GetExtendedLocationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExtendedLocationsResult(
            extended_locations=self.extended_locations,
            id=self.id,
            location=self.location)


def get_extended_locations(location: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExtendedLocationsResult:
    """
    This data source return the available Extended Locations for a specific Azure Region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.core.get_extended_locations(location="West Europe")
    ```


    :param builtins.str location: The Azure location to retrieve the Extended Locations for.
    """
    __args__ = dict()
    __args__['location'] = location
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:core/getExtendedLocations:getExtendedLocations', __args__, opts=opts, typ=GetExtendedLocationsResult).value

    return AwaitableGetExtendedLocationsResult(
        extended_locations=pulumi.get(__ret__, 'extended_locations'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'))
def get_extended_locations_output(location: Optional[pulumi.Input[builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExtendedLocationsResult]:
    """
    This data source return the available Extended Locations for a specific Azure Region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.core.get_extended_locations(location="West Europe")
    ```


    :param builtins.str location: The Azure location to retrieve the Extended Locations for.
    """
    __args__ = dict()
    __args__['location'] = location
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:core/getExtendedLocations:getExtendedLocations', __args__, opts=opts, typ=GetExtendedLocationsResult)
    return __ret__.apply(lambda __response__: GetExtendedLocationsResult(
        extended_locations=pulumi.get(__response__, 'extended_locations'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location')))
