# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, display_name=None, id=None, location_placement_id=None, quota_id=None, spending_limit=None, state=None, subscription_id=None, tags=None, tenant_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location_placement_id and not isinstance(location_placement_id, str):
            raise TypeError("Expected argument 'location_placement_id' to be a str")
        pulumi.set(__self__, "location_placement_id", location_placement_id)
        if quota_id and not isinstance(quota_id, str):
            raise TypeError("Expected argument 'quota_id' to be a str")
        pulumi.set(__self__, "quota_id", quota_id)
        if spending_limit and not isinstance(spending_limit, str):
            raise TypeError("Expected argument 'spending_limit' to be a str")
        pulumi.set(__self__, "spending_limit", spending_limit)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The subscription display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="locationPlacementId")
    def location_placement_id(self) -> builtins.str:
        """
        The subscription location placement ID.
        """
        return pulumi.get(self, "location_placement_id")

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> builtins.str:
        """
        The subscription quota ID.
        """
        return pulumi.get(self, "quota_id")

    @property
    @pulumi.getter(name="spendingLimit")
    def spending_limit(self) -> builtins.str:
        """
        The subscription spending limit.
        """
        return pulumi.get(self, "spending_limit")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The subscription state. Possible values are Enabled, Warned, PastDue, Disabled, and Deleted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        The subscription GUID.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Subscription.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> builtins.str:
        """
        The subscription tenant ID.
        """
        return pulumi.get(self, "tenant_id")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            display_name=self.display_name,
            id=self.id,
            location_placement_id=self.location_placement_id,
            quota_id=self.quota_id,
            spending_limit=self.spending_limit,
            state=self.state,
            subscription_id=self.subscription_id,
            tags=self.tags,
            tenant_id=self.tenant_id)


def get_subscription(subscription_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Use this data source to access information about an existing Subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    current = azure.core.get_subscription()
    pulumi.export("currentSubscriptionDisplayName", current.display_name)
    ```


    :param builtins.str subscription_id: Specifies the ID of the subscription. If this argument is omitted, the subscription ID of the current Azure Resource Manager provider is used.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:core/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        location_placement_id=pulumi.get(__ret__, 'location_placement_id'),
        quota_id=pulumi.get(__ret__, 'quota_id'),
        spending_limit=pulumi.get(__ret__, 'spending_limit'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        tags=pulumi.get(__ret__, 'tags'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'))
def get_subscription_output(subscription_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Use this data source to access information about an existing Subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    current = azure.core.get_subscription()
    pulumi.export("currentSubscriptionDisplayName", current.display_name)
    ```


    :param builtins.str subscription_id: Specifies the ID of the subscription. If this argument is omitted, the subscription ID of the current Azure Resource Manager provider is used.
    """
    __args__ = dict()
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:core/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSubscriptionResult(
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        location_placement_id=pulumi.get(__response__, 'location_placement_id'),
        quota_id=pulumi.get(__response__, 'quota_id'),
        spending_limit=pulumi.get(__response__, 'spending_limit'),
        state=pulumi.get(__response__, 'state'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        tags=pulumi.get(__response__, 'tags'),
        tenant_id=pulumi.get(__response__, 'tenant_id')))
