# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceDeploymentScriptPowerShellArgs', 'ResourceDeploymentScriptPowerShell']

@pulumi.input_type
class ResourceDeploymentScriptPowerShellArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[builtins.str],
                 retention_interval: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str],
                 cleanup_preference: Optional[pulumi.Input[builtins.str]] = None,
                 command_line: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]]] = None,
                 force_update_tag: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_script_uri: Optional[pulumi.Input[builtins.str]] = None,
                 script_content: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs']] = None,
                 supporting_script_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ResourceDeploymentScriptPowerShell resource.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] retention_interval: Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] version: Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] cleanup_preference: Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] command_line: Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs'] container: A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]] environment_variables: An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] force_update_tag: Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] primary_script_uri: Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] script_content: Script body. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs'] storage_account: A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supporting_script_uris: Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Deployment Script.
        :param pulumi.Input[builtins.str] timeout: Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "version", version)
        if cleanup_preference is not None:
            pulumi.set(__self__, "cleanup_preference", cleanup_preference)
        if command_line is not None:
            pulumi.set(__self__, "command_line", command_line)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_script_uri is not None:
            pulumi.set(__self__, "primary_script_uri", primary_script_uri)
        if script_content is not None:
            pulumi.set(__self__, "script_content", script_content)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)
        if supporting_script_uris is not None:
            pulumi.set(__self__, "supporting_script_uris", supporting_script_uris)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> pulumi.Input[builtins.str]:
        """
        Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "retention_interval")

    @retention_interval.setter
    def retention_interval(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "retention_interval", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="cleanupPreference")
    def cleanup_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "cleanup_preference")

    @cleanup_preference.setter
    def cleanup_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cleanup_preference", value)

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "command_line")

    @command_line.setter
    def command_line(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "command_line", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs']]:
        """
        A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]]]:
        """
        An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryScriptUri")
    def primary_script_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "primary_script_uri")

    @primary_script_uri.setter
    def primary_script_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_script_uri", value)

    @property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Script body. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "script_content")

    @script_content.setter
    def script_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script_content", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs']]:
        """
        A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs']]):
        pulumi.set(self, "storage_account", value)

    @property
    @pulumi.getter(name="supportingScriptUris")
    def supporting_script_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "supporting_script_uris")

    @supporting_script_uris.setter
    def supporting_script_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "supporting_script_uris", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Resource Deployment Script.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _ResourceDeploymentScriptPowerShellState:
    def __init__(__self__, *,
                 cleanup_preference: Optional[pulumi.Input[builtins.str]] = None,
                 command_line: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]]] = None,
                 force_update_tag: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 outputs: Optional[pulumi.Input[builtins.str]] = None,
                 primary_script_uri: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_interval: Optional[pulumi.Input[builtins.str]] = None,
                 script_content: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs']] = None,
                 supporting_script_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ResourceDeploymentScriptPowerShell resources.
        :param pulumi.Input[builtins.str] cleanup_preference: Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] command_line: Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs'] container: A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]] environment_variables: An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] force_update_tag: Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] outputs: List of script outputs.
        :param pulumi.Input[builtins.str] primary_script_uri: Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] retention_interval: Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] script_content: Script body. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs'] storage_account: A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supporting_script_uris: Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Deployment Script.
        :param pulumi.Input[builtins.str] timeout: Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] version: Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        """
        if cleanup_preference is not None:
            pulumi.set(__self__, "cleanup_preference", cleanup_preference)
        if command_line is not None:
            pulumi.set(__self__, "command_line", command_line)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outputs is not None:
            pulumi.set(__self__, "outputs", outputs)
        if primary_script_uri is not None:
            pulumi.set(__self__, "primary_script_uri", primary_script_uri)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if script_content is not None:
            pulumi.set(__self__, "script_content", script_content)
        if storage_account is not None:
            pulumi.set(__self__, "storage_account", storage_account)
        if supporting_script_uris is not None:
            pulumi.set(__self__, "supporting_script_uris", supporting_script_uris)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cleanupPreference")
    def cleanup_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "cleanup_preference")

    @cleanup_preference.setter
    def cleanup_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cleanup_preference", value)

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "command_line")

    @command_line.setter
    def command_line(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "command_line", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs']]:
        """
        A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]]]:
        """
        An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs']]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "force_update_tag")

    @force_update_tag.setter
    def force_update_tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "force_update_tag", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def outputs(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        List of script outputs.
        """
        return pulumi.get(self, "outputs")

    @outputs.setter
    def outputs(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "outputs", value)

    @property
    @pulumi.getter(name="primaryScriptUri")
    def primary_script_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "primary_script_uri")

    @primary_script_uri.setter
    def primary_script_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_script_uri", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "retention_interval")

    @retention_interval.setter
    def retention_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "retention_interval", value)

    @property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Script body. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "script_content")

    @script_content.setter
    def script_content(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script_content", value)

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> Optional[pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs']]:
        """
        A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "storage_account")

    @storage_account.setter
    def storage_account(self, value: Optional[pulumi.Input['ResourceDeploymentScriptPowerShellStorageAccountArgs']]):
        pulumi.set(self, "storage_account", value)

    @property
    @pulumi.getter(name="supportingScriptUris")
    def supporting_script_uris(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "supporting_script_uris")

    @supporting_script_uris.setter
    def supporting_script_uris(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "supporting_script_uris", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Resource Deployment Script.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:core/resourceDeploymentScriptPowerShell:ResourceDeploymentScriptPowerShell")
class ResourceDeploymentScriptPowerShell(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_preference: Optional[pulumi.Input[builtins.str]] = None,
                 command_line: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellContainerArgs', 'ResourceDeploymentScriptPowerShellContainerArgsDict']]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs', 'ResourceDeploymentScriptPowerShellEnvironmentVariableArgsDict']]]]] = None,
                 force_update_tag: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellIdentityArgs', 'ResourceDeploymentScriptPowerShellIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_script_uri: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_interval: Optional[pulumi.Input[builtins.str]] = None,
                 script_content: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellStorageAccountArgs', 'ResourceDeploymentScriptPowerShellStorageAccountArgsDict']]] = None,
                 supporting_script_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Resource Deployment Script of Azure PowerShell.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-uai",
            location=example.location,
            resource_group_name=example.name)
        example_resource_deployment_script_power_shell = azure.core.ResourceDeploymentScriptPowerShell("example",
            name="example-rdsaps",
            resource_group_name=example.name,
            location="West Europe",
            version="8.3",
            retention_interval="P1D",
            command_line="-name \\"John Dole\\"",
            cleanup_preference="OnSuccess",
            force_update_tag="1",
            timeout="PT30M",
            script_content=\"\"\"          param([string] $name)
                    $output = 'Hello {0}.' -f $name
                    Write-Output $output
                    $DeploymentScriptOutputs = @{}
                    $DeploymentScriptOutputs['text'] = $output
        \"\"\",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Resources`: 2020-10-01

        ## Import

        Resource Deployment Script can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/resourceDeploymentScriptPowerShell:ResourceDeploymentScriptPowerShell example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Resources/deploymentScripts/script1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cleanup_preference: Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] command_line: Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Union['ResourceDeploymentScriptPowerShellContainerArgs', 'ResourceDeploymentScriptPowerShellContainerArgsDict']] container: A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs', 'ResourceDeploymentScriptPowerShellEnvironmentVariableArgsDict']]]] environment_variables: An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] force_update_tag: Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Union['ResourceDeploymentScriptPowerShellIdentityArgs', 'ResourceDeploymentScriptPowerShellIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] primary_script_uri: Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] retention_interval: Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] script_content: Script body. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Union['ResourceDeploymentScriptPowerShellStorageAccountArgs', 'ResourceDeploymentScriptPowerShellStorageAccountArgsDict']] storage_account: A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supporting_script_uris: Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Deployment Script.
        :param pulumi.Input[builtins.str] timeout: Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] version: Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceDeploymentScriptPowerShellArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Resource Deployment Script of Azure PowerShell.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-uai",
            location=example.location,
            resource_group_name=example.name)
        example_resource_deployment_script_power_shell = azure.core.ResourceDeploymentScriptPowerShell("example",
            name="example-rdsaps",
            resource_group_name=example.name,
            location="West Europe",
            version="8.3",
            retention_interval="P1D",
            command_line="-name \\"John Dole\\"",
            cleanup_preference="OnSuccess",
            force_update_tag="1",
            timeout="PT30M",
            script_content=\"\"\"          param([string] $name)
                    $output = 'Hello {0}.' -f $name
                    Write-Output $output
                    $DeploymentScriptOutputs = @{}
                    $DeploymentScriptOutputs['text'] = $output
        \"\"\",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Resources`: 2020-10-01

        ## Import

        Resource Deployment Script can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/resourceDeploymentScriptPowerShell:ResourceDeploymentScriptPowerShell example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Resources/deploymentScripts/script1
        ```

        :param str resource_name: The name of the resource.
        :param ResourceDeploymentScriptPowerShellArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceDeploymentScriptPowerShellArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_preference: Optional[pulumi.Input[builtins.str]] = None,
                 command_line: Optional[pulumi.Input[builtins.str]] = None,
                 container: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellContainerArgs', 'ResourceDeploymentScriptPowerShellContainerArgsDict']]] = None,
                 environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs', 'ResourceDeploymentScriptPowerShellEnvironmentVariableArgsDict']]]]] = None,
                 force_update_tag: Optional[pulumi.Input[builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellIdentityArgs', 'ResourceDeploymentScriptPowerShellIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 primary_script_uri: Optional[pulumi.Input[builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 retention_interval: Optional[pulumi.Input[builtins.str]] = None,
                 script_content: Optional[pulumi.Input[builtins.str]] = None,
                 storage_account: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellStorageAccountArgs', 'ResourceDeploymentScriptPowerShellStorageAccountArgsDict']]] = None,
                 supporting_script_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceDeploymentScriptPowerShellArgs.__new__(ResourceDeploymentScriptPowerShellArgs)

            __props__.__dict__["cleanup_preference"] = cleanup_preference
            __props__.__dict__["command_line"] = command_line
            __props__.__dict__["container"] = container
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["force_update_tag"] = force_update_tag
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_script_uri"] = primary_script_uri
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if retention_interval is None and not opts.urn:
                raise TypeError("Missing required property 'retention_interval'")
            __props__.__dict__["retention_interval"] = retention_interval
            __props__.__dict__["script_content"] = script_content
            __props__.__dict__["storage_account"] = storage_account
            __props__.__dict__["supporting_script_uris"] = supporting_script_uris
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeout"] = timeout
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["outputs"] = None
        super(ResourceDeploymentScriptPowerShell, __self__).__init__(
            'azure:core/resourceDeploymentScriptPowerShell:ResourceDeploymentScriptPowerShell',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cleanup_preference: Optional[pulumi.Input[builtins.str]] = None,
            command_line: Optional[pulumi.Input[builtins.str]] = None,
            container: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellContainerArgs', 'ResourceDeploymentScriptPowerShellContainerArgsDict']]] = None,
            environment_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs', 'ResourceDeploymentScriptPowerShellEnvironmentVariableArgsDict']]]]] = None,
            force_update_tag: Optional[pulumi.Input[builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellIdentityArgs', 'ResourceDeploymentScriptPowerShellIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            outputs: Optional[pulumi.Input[builtins.str]] = None,
            primary_script_uri: Optional[pulumi.Input[builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            retention_interval: Optional[pulumi.Input[builtins.str]] = None,
            script_content: Optional[pulumi.Input[builtins.str]] = None,
            storage_account: Optional[pulumi.Input[Union['ResourceDeploymentScriptPowerShellStorageAccountArgs', 'ResourceDeploymentScriptPowerShellStorageAccountArgsDict']]] = None,
            supporting_script_uris: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            timeout: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'ResourceDeploymentScriptPowerShell':
        """
        Get an existing ResourceDeploymentScriptPowerShell resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cleanup_preference: Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] command_line: Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Union['ResourceDeploymentScriptPowerShellContainerArgs', 'ResourceDeploymentScriptPowerShellContainerArgsDict']] container: A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceDeploymentScriptPowerShellEnvironmentVariableArgs', 'ResourceDeploymentScriptPowerShellEnvironmentVariableArgsDict']]]] environment_variables: An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] force_update_tag: Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Union['ResourceDeploymentScriptPowerShellIdentityArgs', 'ResourceDeploymentScriptPowerShellIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] location: Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] name: Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] outputs: List of script outputs.
        :param pulumi.Input[builtins.str] primary_script_uri: Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] resource_group_name: Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] retention_interval: Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] script_content: Script body. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Union['ResourceDeploymentScriptPowerShellStorageAccountArgs', 'ResourceDeploymentScriptPowerShellStorageAccountArgsDict']] storage_account: A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] supporting_script_uris: Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags which should be assigned to the Resource Deployment Script.
        :param pulumi.Input[builtins.str] timeout: Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        :param pulumi.Input[builtins.str] version: Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceDeploymentScriptPowerShellState.__new__(_ResourceDeploymentScriptPowerShellState)

        __props__.__dict__["cleanup_preference"] = cleanup_preference
        __props__.__dict__["command_line"] = command_line
        __props__.__dict__["container"] = container
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["force_update_tag"] = force_update_tag
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["outputs"] = outputs
        __props__.__dict__["primary_script_uri"] = primary_script_uri
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_interval"] = retention_interval
        __props__.__dict__["script_content"] = script_content
        __props__.__dict__["storage_account"] = storage_account
        __props__.__dict__["supporting_script_uris"] = supporting_script_uris
        __props__.__dict__["tags"] = tags
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["version"] = version
        return ResourceDeploymentScriptPowerShell(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cleanupPreference")
    def cleanup_preference(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the cleanup preference when the script execution gets in a terminal state. Possible values are `Always`, `OnExpiration`, `OnSuccess`. Defaults to `Always`. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "cleanup_preference")

    @property
    @pulumi.getter(name="commandLine")
    def command_line(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Command line arguments to pass to the script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "command_line")

    @property
    @pulumi.getter
    def container(self) -> pulumi.Output[Optional['outputs.ResourceDeploymentScriptPowerShellContainer']]:
        """
        A `container` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Sequence['outputs.ResourceDeploymentScriptPowerShellEnvironmentVariable']]]:
        """
        An `environment_variable` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "force_update_tag")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ResourceDeploymentScriptPowerShellIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Azure Region where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name which should be used for this Resource Deployment Script. The name length must be from 1 to 260 characters. The name can only contain alphanumeric, underscore, parentheses, hyphen and period, and it cannot end with a period. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def outputs(self) -> pulumi.Output[builtins.str]:
        """
        List of script outputs.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter(name="primaryScriptUri")
    def primary_script_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Uri for the script. This is the entry point for the external script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "primary_script_uri")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the Resource Group where the Resource Deployment Script should exist. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> pulumi.Output[builtins.str]:
        """
        Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. The time duration should be between `1` hour and `26` hours (inclusive) and should be specified in ISO 8601 format. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="scriptContent")
    def script_content(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Script body. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "script_content")

    @property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> pulumi.Output[Optional['outputs.ResourceDeploymentScriptPowerShellStorageAccount']]:
        """
        A `storage_account` block as defined below. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "storage_account")

    @property
    @pulumi.getter(name="supportingScriptUris")
    def supporting_script_uris(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Supporting files for the external script. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "supporting_script_uris")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Resource Deployment Script.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Maximum allowed script execution time specified in ISO 8601 format. Needs to be greater than 0 and smaller than 1 day. Defaults to `P1D`. Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the version of the Azure PowerShell that should be used in the format `X.Y` (e.g. `9.7`). A canonical list of versions [is available from the Microsoft Container Registry API](https://mcr.microsoft.com/v2/azure-powershell/tags/list). Changing this forces a new Resource Deployment Script to be created.
        """
        return pulumi.get(self, "version")

