# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AccountAnalyticalStorageArgs',
    'AccountAnalyticalStorageArgsDict',
    'AccountBackupArgs',
    'AccountBackupArgsDict',
    'AccountCapabilityArgs',
    'AccountCapabilityArgsDict',
    'AccountCapacityArgs',
    'AccountCapacityArgsDict',
    'AccountConsistencyPolicyArgs',
    'AccountConsistencyPolicyArgsDict',
    'AccountCorsRuleArgs',
    'AccountCorsRuleArgsDict',
    'AccountGeoLocationArgs',
    'AccountGeoLocationArgsDict',
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'AccountRestoreArgs',
    'AccountRestoreArgsDict',
    'AccountRestoreDatabaseArgs',
    'AccountRestoreDatabaseArgsDict',
    'AccountRestoreGremlinDatabaseArgs',
    'AccountRestoreGremlinDatabaseArgsDict',
    'AccountVirtualNetworkRuleArgs',
    'AccountVirtualNetworkRuleArgsDict',
    'CassandraClusterIdentityArgs',
    'CassandraClusterIdentityArgsDict',
    'CassandraKeyspaceAutoscaleSettingsArgs',
    'CassandraKeyspaceAutoscaleSettingsArgsDict',
    'CassandraTableAutoscaleSettingsArgs',
    'CassandraTableAutoscaleSettingsArgsDict',
    'CassandraTableSchemaArgs',
    'CassandraTableSchemaArgsDict',
    'CassandraTableSchemaClusterKeyArgs',
    'CassandraTableSchemaClusterKeyArgsDict',
    'CassandraTableSchemaColumnArgs',
    'CassandraTableSchemaColumnArgsDict',
    'CassandraTableSchemaPartitionKeyArgs',
    'CassandraTableSchemaPartitionKeyArgsDict',
    'GremlinDatabaseAutoscaleSettingsArgs',
    'GremlinDatabaseAutoscaleSettingsArgsDict',
    'GremlinGraphAutoscaleSettingsArgs',
    'GremlinGraphAutoscaleSettingsArgsDict',
    'GremlinGraphConflictResolutionPolicyArgs',
    'GremlinGraphConflictResolutionPolicyArgsDict',
    'GremlinGraphIndexPolicyArgs',
    'GremlinGraphIndexPolicyArgsDict',
    'GremlinGraphIndexPolicyCompositeIndexArgs',
    'GremlinGraphIndexPolicyCompositeIndexArgsDict',
    'GremlinGraphIndexPolicyCompositeIndexIndexArgs',
    'GremlinGraphIndexPolicyCompositeIndexIndexArgsDict',
    'GremlinGraphIndexPolicySpatialIndexArgs',
    'GremlinGraphIndexPolicySpatialIndexArgsDict',
    'GremlinGraphUniqueKeyArgs',
    'GremlinGraphUniqueKeyArgsDict',
    'MongoClusterConnectionStringArgs',
    'MongoClusterConnectionStringArgsDict',
    'MongoCollectionAutoscaleSettingsArgs',
    'MongoCollectionAutoscaleSettingsArgsDict',
    'MongoCollectionIndexArgs',
    'MongoCollectionIndexArgsDict',
    'MongoCollectionSystemIndexArgs',
    'MongoCollectionSystemIndexArgsDict',
    'MongoDatabaseAutoscaleSettingsArgs',
    'MongoDatabaseAutoscaleSettingsArgsDict',
    'MongoRoleDefinitionPrivilegeArgs',
    'MongoRoleDefinitionPrivilegeArgsDict',
    'MongoRoleDefinitionPrivilegeResourceArgs',
    'MongoRoleDefinitionPrivilegeResourceArgsDict',
    'PostgresqlClusterMaintenanceWindowArgs',
    'PostgresqlClusterMaintenanceWindowArgsDict',
    'PostgresqlClusterServerArgs',
    'PostgresqlClusterServerArgsDict',
    'SqlContainerAutoscaleSettingsArgs',
    'SqlContainerAutoscaleSettingsArgsDict',
    'SqlContainerConflictResolutionPolicyArgs',
    'SqlContainerConflictResolutionPolicyArgsDict',
    'SqlContainerIndexingPolicyArgs',
    'SqlContainerIndexingPolicyArgsDict',
    'SqlContainerIndexingPolicyCompositeIndexArgs',
    'SqlContainerIndexingPolicyCompositeIndexArgsDict',
    'SqlContainerIndexingPolicyCompositeIndexIndexArgs',
    'SqlContainerIndexingPolicyCompositeIndexIndexArgsDict',
    'SqlContainerIndexingPolicyExcludedPathArgs',
    'SqlContainerIndexingPolicyExcludedPathArgsDict',
    'SqlContainerIndexingPolicyIncludedPathArgs',
    'SqlContainerIndexingPolicyIncludedPathArgsDict',
    'SqlContainerIndexingPolicySpatialIndexArgs',
    'SqlContainerIndexingPolicySpatialIndexArgsDict',
    'SqlContainerUniqueKeyArgs',
    'SqlContainerUniqueKeyArgsDict',
    'SqlDatabaseAutoscaleSettingsArgs',
    'SqlDatabaseAutoscaleSettingsArgsDict',
    'SqlRoleDefinitionPermissionArgs',
    'SqlRoleDefinitionPermissionArgsDict',
    'TableAutoscaleSettingsArgs',
    'TableAutoscaleSettingsArgsDict',
]

MYPY = False

if not MYPY:
    class AccountAnalyticalStorageArgsDict(TypedDict):
        schema_type: pulumi.Input[builtins.str]
        """
        The schema type of the Analytical Storage for this Cosmos DB account. Possible values are `FullFidelity` and `WellDefined`.
        """
elif False:
    AccountAnalyticalStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountAnalyticalStorageArgs:
    def __init__(__self__, *,
                 schema_type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] schema_type: The schema type of the Analytical Storage for this Cosmos DB account. Possible values are `FullFidelity` and `WellDefined`.
        """
        pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> pulumi.Input[builtins.str]:
        """
        The schema type of the Analytical Storage for this Cosmos DB account. Possible values are `FullFidelity` and `WellDefined`.
        """
        return pulumi.get(self, "schema_type")

    @schema_type.setter
    def schema_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "schema_type", value)


if not MYPY:
    class AccountBackupArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The type of the `backup`. Possible values are `Continuous` and `Periodic`.

        > **Note:** Migration of `Periodic` to `Continuous` is one-way, changing `Continuous` to `Periodic` forces a new resource to be created.
        """
        interval_in_minutes: NotRequired[pulumi.Input[builtins.int]]
        """
        The interval in minutes between two backups. Possible values are between 60 and 1440. Defaults to `240`.
        """
        retention_in_hours: NotRequired[pulumi.Input[builtins.int]]
        """
        The time in hours that each backup is retained. Possible values are between 8 and 720. Defaults to `8`.
        """
        storage_redundancy: NotRequired[pulumi.Input[builtins.str]]
        """
        The storage redundancy is used to indicate the type of backup residency. Possible values are `Geo`, `Local` and `Zone`. Defaults to `Geo`.

        > **Note:** You can only configure `interval_in_minutes`, `retention_in_hours` and `storage_redundancy` when the `type` field is set to `Periodic`.
        """
        tier: NotRequired[pulumi.Input[builtins.str]]
        """
        The continuous backup tier. Possible values are `Continuous7Days` and `Continuous30Days`.
        """
elif False:
    AccountBackupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountBackupArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 interval_in_minutes: Optional[pulumi.Input[builtins.int]] = None,
                 retention_in_hours: Optional[pulumi.Input[builtins.int]] = None,
                 storage_redundancy: Optional[pulumi.Input[builtins.str]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The type of the `backup`. Possible values are `Continuous` and `Periodic`.
               
               > **Note:** Migration of `Periodic` to `Continuous` is one-way, changing `Continuous` to `Periodic` forces a new resource to be created.
        :param pulumi.Input[builtins.int] interval_in_minutes: The interval in minutes between two backups. Possible values are between 60 and 1440. Defaults to `240`.
        :param pulumi.Input[builtins.int] retention_in_hours: The time in hours that each backup is retained. Possible values are between 8 and 720. Defaults to `8`.
        :param pulumi.Input[builtins.str] storage_redundancy: The storage redundancy is used to indicate the type of backup residency. Possible values are `Geo`, `Local` and `Zone`. Defaults to `Geo`.
               
               > **Note:** You can only configure `interval_in_minutes`, `retention_in_hours` and `storage_redundancy` when the `type` field is set to `Periodic`.
        :param pulumi.Input[builtins.str] tier: The continuous backup tier. Possible values are `Continuous7Days` and `Continuous30Days`.
        """
        pulumi.set(__self__, "type", type)
        if interval_in_minutes is not None:
            pulumi.set(__self__, "interval_in_minutes", interval_in_minutes)
        if retention_in_hours is not None:
            pulumi.set(__self__, "retention_in_hours", retention_in_hours)
        if storage_redundancy is not None:
            pulumi.set(__self__, "storage_redundancy", storage_redundancy)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the `backup`. Possible values are `Continuous` and `Periodic`.

        > **Note:** Migration of `Periodic` to `Continuous` is one-way, changing `Continuous` to `Periodic` forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="intervalInMinutes")
    def interval_in_minutes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The interval in minutes between two backups. Possible values are between 60 and 1440. Defaults to `240`.
        """
        return pulumi.get(self, "interval_in_minutes")

    @interval_in_minutes.setter
    def interval_in_minutes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interval_in_minutes", value)

    @property
    @pulumi.getter(name="retentionInHours")
    def retention_in_hours(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time in hours that each backup is retained. Possible values are between 8 and 720. Defaults to `8`.
        """
        return pulumi.get(self, "retention_in_hours")

    @retention_in_hours.setter
    def retention_in_hours(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "retention_in_hours", value)

    @property
    @pulumi.getter(name="storageRedundancy")
    def storage_redundancy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage redundancy is used to indicate the type of backup residency. Possible values are `Geo`, `Local` and `Zone`. Defaults to `Geo`.

        > **Note:** You can only configure `interval_in_minutes`, `retention_in_hours` and `storage_redundancy` when the `type` field is set to `Periodic`.
        """
        return pulumi.get(self, "storage_redundancy")

    @storage_redundancy.setter
    def storage_redundancy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_redundancy", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The continuous backup tier. Possible values are `Continuous7Days` and `Continuous30Days`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)


if not MYPY:
    class AccountCapabilityArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
elif False:
    AccountCapabilityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountCapabilityArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class AccountCapacityArgsDict(TypedDict):
        total_throughput_limit: pulumi.Input[builtins.int]
        """
        The total throughput limit imposed on this Cosmos DB account (RU/s). Possible values are at least `-1`. `-1` means no limit.
        """
elif False:
    AccountCapacityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountCapacityArgs:
    def __init__(__self__, *,
                 total_throughput_limit: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] total_throughput_limit: The total throughput limit imposed on this Cosmos DB account (RU/s). Possible values are at least `-1`. `-1` means no limit.
        """
        pulumi.set(__self__, "total_throughput_limit", total_throughput_limit)

    @property
    @pulumi.getter(name="totalThroughputLimit")
    def total_throughput_limit(self) -> pulumi.Input[builtins.int]:
        """
        The total throughput limit imposed on this Cosmos DB account (RU/s). Possible values are at least `-1`. `-1` means no limit.
        """
        return pulumi.get(self, "total_throughput_limit")

    @total_throughput_limit.setter
    def total_throughput_limit(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "total_throughput_limit", value)


if not MYPY:
    class AccountConsistencyPolicyArgsDict(TypedDict):
        consistency_level: pulumi.Input[builtins.str]
        """
        The Consistency Level to use for this CosmosDB Account - can be either `BoundedStaleness`, `Eventual`, `Session`, `Strong` or `ConsistentPrefix`.
        """
        max_interval_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. The accepted range for this value is `5` - `86400` (1 day). Defaults to `5`. Required when `consistency_level` is set to `BoundedStaleness`.
        """
        max_staleness_prefix: NotRequired[pulumi.Input[builtins.int]]
        """
        When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. The accepted range for this value is `10` – `2147483647`. Defaults to `100`. Required when `consistency_level` is set to `BoundedStaleness`.

        > **Note:** `max_interval_in_seconds` and `max_staleness_prefix` can only be set to values other than default when the `consistency_level` is set to `BoundedStaleness`.
        """
elif False:
    AccountConsistencyPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountConsistencyPolicyArgs:
    def __init__(__self__, *,
                 consistency_level: pulumi.Input[builtins.str],
                 max_interval_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 max_staleness_prefix: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.str] consistency_level: The Consistency Level to use for this CosmosDB Account - can be either `BoundedStaleness`, `Eventual`, `Session`, `Strong` or `ConsistentPrefix`.
        :param pulumi.Input[builtins.int] max_interval_in_seconds: When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. The accepted range for this value is `5` - `86400` (1 day). Defaults to `5`. Required when `consistency_level` is set to `BoundedStaleness`.
        :param pulumi.Input[builtins.int] max_staleness_prefix: When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. The accepted range for this value is `10` – `2147483647`. Defaults to `100`. Required when `consistency_level` is set to `BoundedStaleness`.
               
               > **Note:** `max_interval_in_seconds` and `max_staleness_prefix` can only be set to values other than default when the `consistency_level` is set to `BoundedStaleness`.
        """
        pulumi.set(__self__, "consistency_level", consistency_level)
        if max_interval_in_seconds is not None:
            pulumi.set(__self__, "max_interval_in_seconds", max_interval_in_seconds)
        if max_staleness_prefix is not None:
            pulumi.set(__self__, "max_staleness_prefix", max_staleness_prefix)

    @property
    @pulumi.getter(name="consistencyLevel")
    def consistency_level(self) -> pulumi.Input[builtins.str]:
        """
        The Consistency Level to use for this CosmosDB Account - can be either `BoundedStaleness`, `Eventual`, `Session`, `Strong` or `ConsistentPrefix`.
        """
        return pulumi.get(self, "consistency_level")

    @consistency_level.setter
    def consistency_level(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "consistency_level", value)

    @property
    @pulumi.getter(name="maxIntervalInSeconds")
    def max_interval_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. The accepted range for this value is `5` - `86400` (1 day). Defaults to `5`. Required when `consistency_level` is set to `BoundedStaleness`.
        """
        return pulumi.get(self, "max_interval_in_seconds")

    @max_interval_in_seconds.setter
    def max_interval_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_interval_in_seconds", value)

    @property
    @pulumi.getter(name="maxStalenessPrefix")
    def max_staleness_prefix(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. The accepted range for this value is `10` – `2147483647`. Defaults to `100`. Required when `consistency_level` is set to `BoundedStaleness`.

        > **Note:** `max_interval_in_seconds` and `max_staleness_prefix` can only be set to values other than default when the `consistency_level` is set to `BoundedStaleness`.
        """
        return pulumi.get(self, "max_staleness_prefix")

    @max_staleness_prefix.setter
    def max_staleness_prefix(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_staleness_prefix", value)


if not MYPY:
    class AccountCorsRuleArgsDict(TypedDict):
        allowed_headers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of headers that are allowed to be a part of the cross-origin request.
        """
        allowed_methods: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of HTTP headers that are allowed to be executed by the origin. Valid options are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        """
        allowed_origins: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of origin domains that will be allowed by CORS.
        """
        exposed_headers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of response headers that are exposed to CORS clients.
        """
        max_age_in_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of seconds the client should cache a preflight response. Possible values are between `1` and `2147483647`.
        """
elif False:
    AccountCorsRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountCorsRuleArgs:
    def __init__(__self__, *,
                 allowed_headers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_methods: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 allowed_origins: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 exposed_headers: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 max_age_in_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_headers: A list of headers that are allowed to be a part of the cross-origin request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_methods: A list of HTTP headers that are allowed to be executed by the origin. Valid options are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_origins: A list of origin domains that will be allowed by CORS.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exposed_headers: A list of response headers that are exposed to CORS clients.
        :param pulumi.Input[builtins.int] max_age_in_seconds: The number of seconds the client should cache a preflight response. Possible values are between `1` and `2147483647`.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        if max_age_in_seconds is not None:
            pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of headers that are allowed to be a part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @allowed_headers.setter
    def allowed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_headers", value)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of HTTP headers that are allowed to be executed by the origin. Valid options are `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        """
        return pulumi.get(self, "allowed_methods")

    @allowed_methods.setter
    def allowed_methods(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_methods", value)

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of origin domains that will be allowed by CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @allowed_origins.setter
    def allowed_origins(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "allowed_origins", value)

    @property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of response headers that are exposed to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @exposed_headers.setter
    def exposed_headers(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "exposed_headers", value)

    @property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds the client should cache a preflight response. Possible values are between `1` and `2147483647`.
        """
        return pulumi.get(self, "max_age_in_seconds")

    @max_age_in_seconds.setter
    def max_age_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_age_in_seconds", value)


if not MYPY:
    class AccountGeoLocationArgsDict(TypedDict):
        failover_priority: pulumi.Input[builtins.int]
        """
        The failover priority of the region. A failover priority of `0` indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. Changing this causes the location to be re-provisioned and cannot be changed for the location with failover priority `0`.
        """
        location: pulumi.Input[builtins.str]
        """
        The name of the Azure region to host replicated data.
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        The CosmosDB Account ID.
        """
        zone_redundant: NotRequired[pulumi.Input[builtins.bool]]
        """
        Should zone redundancy be enabled for this region? Defaults to `false`.
        """
elif False:
    AccountGeoLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountGeoLocationArgs:
    def __init__(__self__, *,
                 failover_priority: pulumi.Input[builtins.int],
                 location: pulumi.Input[builtins.str],
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 zone_redundant: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] failover_priority: The failover priority of the region. A failover priority of `0` indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. Changing this causes the location to be re-provisioned and cannot be changed for the location with failover priority `0`.
        :param pulumi.Input[builtins.str] location: The name of the Azure region to host replicated data.
        :param pulumi.Input[builtins.str] id: The CosmosDB Account ID.
        :param pulumi.Input[builtins.bool] zone_redundant: Should zone redundancy be enabled for this region? Defaults to `false`.
        """
        pulumi.set(__self__, "failover_priority", failover_priority)
        pulumi.set(__self__, "location", location)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if zone_redundant is not None:
            pulumi.set(__self__, "zone_redundant", zone_redundant)

    @property
    @pulumi.getter(name="failoverPriority")
    def failover_priority(self) -> pulumi.Input[builtins.int]:
        """
        The failover priority of the region. A failover priority of `0` indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists. Changing this causes the location to be re-provisioned and cannot be changed for the location with failover priority `0`.
        """
        return pulumi.get(self, "failover_priority")

    @failover_priority.setter
    def failover_priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "failover_priority", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Azure region to host replicated data.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CosmosDB Account ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="zoneRedundant")
    def zone_redundant(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Should zone redundancy be enabled for this region? Defaults to `false`.
        """
        return pulumi.get(self, "zone_redundant")

    @zone_redundant.setter
    def zone_redundant(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "zone_redundant", value)


if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        The Type of Managed Identity assigned to this Cosmos account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cosmos Account.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: The Type of Managed Identity assigned to this Cosmos account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cosmos Account.
        :param pulumi.Input[builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The Type of Managed Identity assigned to this Cosmos account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cosmos Account.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AccountRestoreArgsDict(TypedDict):
        restore_timestamp_in_utc: pulumi.Input[builtins.str]
        """
        The creation time of the database or the collection (Datetime Format `RFC 3339`). Changing this forces a new resource to be created.
        """
        source_cosmosdb_account_id: pulumi.Input[builtins.str]
        """
        The resource ID of the restorable database account from which the restore has to be initiated. The example is `/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}`. Changing this forces a new resource to be created.

        > **Note:** Any database account with `Continuous` type (live account or accounts deleted in last 30 days) is a restorable database account and there cannot be Create/Update/Delete operations on the restorable database accounts. They can only be read and retrieved by `cosmosdb_get_restorable_database_accounts`.
        """
        databases: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccountRestoreDatabaseArgsDict']]]]
        """
        A `database` block as defined below. Changing this forces a new resource to be created.
        """
        gremlin_databases: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccountRestoreGremlinDatabaseArgsDict']]]]
        """
        One or more `gremlin_database` blocks as defined below. Changing this forces a new resource to be created.
        """
        tables_to_restores: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of specific tables available for restore. Changing this forces a new resource to be created.
        """
elif False:
    AccountRestoreArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountRestoreArgs:
    def __init__(__self__, *,
                 restore_timestamp_in_utc: pulumi.Input[builtins.str],
                 source_cosmosdb_account_id: pulumi.Input[builtins.str],
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['AccountRestoreDatabaseArgs']]]] = None,
                 gremlin_databases: Optional[pulumi.Input[Sequence[pulumi.Input['AccountRestoreGremlinDatabaseArgs']]]] = None,
                 tables_to_restores: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] restore_timestamp_in_utc: The creation time of the database or the collection (Datetime Format `RFC 3339`). Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] source_cosmosdb_account_id: The resource ID of the restorable database account from which the restore has to be initiated. The example is `/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}`. Changing this forces a new resource to be created.
               
               > **Note:** Any database account with `Continuous` type (live account or accounts deleted in last 30 days) is a restorable database account and there cannot be Create/Update/Delete operations on the restorable database accounts. They can only be read and retrieved by `cosmosdb_get_restorable_database_accounts`.
        :param pulumi.Input[Sequence[pulumi.Input['AccountRestoreDatabaseArgs']]] databases: A `database` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AccountRestoreGremlinDatabaseArgs']]] gremlin_databases: One or more `gremlin_database` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tables_to_restores: A list of specific tables available for restore. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "restore_timestamp_in_utc", restore_timestamp_in_utc)
        pulumi.set(__self__, "source_cosmosdb_account_id", source_cosmosdb_account_id)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if gremlin_databases is not None:
            pulumi.set(__self__, "gremlin_databases", gremlin_databases)
        if tables_to_restores is not None:
            pulumi.set(__self__, "tables_to_restores", tables_to_restores)

    @property
    @pulumi.getter(name="restoreTimestampInUtc")
    def restore_timestamp_in_utc(self) -> pulumi.Input[builtins.str]:
        """
        The creation time of the database or the collection (Datetime Format `RFC 3339`). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "restore_timestamp_in_utc")

    @restore_timestamp_in_utc.setter
    def restore_timestamp_in_utc(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "restore_timestamp_in_utc", value)

    @property
    @pulumi.getter(name="sourceCosmosdbAccountId")
    def source_cosmosdb_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The resource ID of the restorable database account from which the restore has to be initiated. The example is `/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}`. Changing this forces a new resource to be created.

        > **Note:** Any database account with `Continuous` type (live account or accounts deleted in last 30 days) is a restorable database account and there cannot be Create/Update/Delete operations on the restorable database accounts. They can only be read and retrieved by `cosmosdb_get_restorable_database_accounts`.
        """
        return pulumi.get(self, "source_cosmosdb_account_id")

    @source_cosmosdb_account_id.setter
    def source_cosmosdb_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_cosmosdb_account_id", value)

    @property
    @pulumi.getter
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountRestoreDatabaseArgs']]]]:
        """
        A `database` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountRestoreDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter(name="gremlinDatabases")
    def gremlin_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountRestoreGremlinDatabaseArgs']]]]:
        """
        One or more `gremlin_database` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gremlin_databases")

    @gremlin_databases.setter
    def gremlin_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountRestoreGremlinDatabaseArgs']]]]):
        pulumi.set(self, "gremlin_databases", value)

    @property
    @pulumi.getter(name="tablesToRestores")
    def tables_to_restores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of specific tables available for restore. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tables_to_restores")

    @tables_to_restores.setter
    def tables_to_restores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tables_to_restores", value)


if not MYPY:
    class AccountRestoreDatabaseArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The database name for the restore request. Changing this forces a new resource to be created.
        """
        collection_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of the collection names for the restore request. Changing this forces a new resource to be created.
        """
elif False:
    AccountRestoreDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountRestoreDatabaseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 collection_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] name: The database name for the restore request. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] collection_names: A list of the collection names for the restore request. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if collection_names is not None:
            pulumi.set(__self__, "collection_names", collection_names)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The database name for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="collectionNames")
    def collection_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the collection names for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "collection_names")

    @collection_names.setter
    def collection_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "collection_names", value)


if not MYPY:
    class AccountRestoreGremlinDatabaseArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The Gremlin Database name for the restore request. Changing this forces a new resource to be created.
        """
        graph_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of the Graph names for the restore request. Changing this forces a new resource to be created.
        """
elif False:
    AccountRestoreGremlinDatabaseArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountRestoreGremlinDatabaseArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 graph_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] name: The Gremlin Database name for the restore request. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] graph_names: A list of the Graph names for the restore request. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if graph_names is not None:
            pulumi.set(__self__, "graph_names", graph_names)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The Gremlin Database name for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="graphNames")
    def graph_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of the Graph names for the restore request. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "graph_names")

    @graph_names.setter
    def graph_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "graph_names", value)


if not MYPY:
    class AccountVirtualNetworkRuleArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The ID of the virtual network subnet.
        """
        ignore_missing_vnet_service_endpoint: NotRequired[pulumi.Input[builtins.bool]]
        """
        If set to true, the specified subnet will be added as a virtual network rule even if its CosmosDB service endpoint is not active. Defaults to `false`.
        """
elif False:
    AccountVirtualNetworkRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountVirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] id: The ID of the virtual network subnet.
        :param pulumi.Input[builtins.bool] ignore_missing_vnet_service_endpoint: If set to true, the specified subnet will be added as a virtual network rule even if its CosmosDB service endpoint is not active. Defaults to `false`.
        """
        pulumi.set(__self__, "id", id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the virtual network subnet.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to true, the specified subnet will be added as a virtual network rule even if its CosmosDB service endpoint is not active. Defaults to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @ignore_missing_vnet_service_endpoint.setter
    def ignore_missing_vnet_service_endpoint(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ignore_missing_vnet_service_endpoint", value)


if not MYPY:
    class CassandraClusterIdentityArgsDict(TypedDict):
        type: pulumi.Input[builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Cassandra Cluster. The only possible value is `SystemAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[builtins.str]]
        tenant_id: NotRequired[pulumi.Input[builtins.str]]
elif False:
    CassandraClusterIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraClusterIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Cassandra Cluster. The only possible value is `SystemAssigned`.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Cassandra Cluster. The only possible value is `SystemAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class CassandraKeyspaceAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the Cassandra KeySpace (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    CassandraKeyspaceAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraKeyspaceAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the Cassandra KeySpace (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the Cassandra KeySpace (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class CassandraTableAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the Cassandra Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    CassandraTableAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraTableAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the Cassandra Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the Cassandra Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class CassandraTableSchemaArgsDict(TypedDict):
        columns: pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaColumnArgsDict']]]
        """
        One or more `column` blocks as defined below.
        """
        partition_keys: pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaPartitionKeyArgsDict']]]
        """
        One or more `partition_key` blocks as defined below.
        """
        cluster_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaClusterKeyArgsDict']]]]
        """
        One or more `cluster_key` blocks as defined below.
        """
elif False:
    CassandraTableSchemaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraTableSchemaArgs:
    def __init__(__self__, *,
                 columns: pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaColumnArgs']]],
                 partition_keys: pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaPartitionKeyArgs']]],
                 cluster_keys: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaClusterKeyArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaColumnArgs']]] columns: One or more `column` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaPartitionKeyArgs']]] partition_keys: One or more `partition_key` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaClusterKeyArgs']]] cluster_keys: One or more `cluster_key` blocks as defined below.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "partition_keys", partition_keys)
        if cluster_keys is not None:
            pulumi.set(__self__, "cluster_keys", cluster_keys)

    @property
    @pulumi.getter
    def columns(self) -> pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaColumnArgs']]]:
        """
        One or more `column` blocks as defined below.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaColumnArgs']]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter(name="partitionKeys")
    def partition_keys(self) -> pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaPartitionKeyArgs']]]:
        """
        One or more `partition_key` blocks as defined below.
        """
        return pulumi.get(self, "partition_keys")

    @partition_keys.setter
    def partition_keys(self, value: pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaPartitionKeyArgs']]]):
        pulumi.set(self, "partition_keys", value)

    @property
    @pulumi.getter(name="clusterKeys")
    def cluster_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaClusterKeyArgs']]]]:
        """
        One or more `cluster_key` blocks as defined below.
        """
        return pulumi.get(self, "cluster_keys")

    @cluster_keys.setter
    def cluster_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CassandraTableSchemaClusterKeyArgs']]]]):
        pulumi.set(self, "cluster_keys", value)


if not MYPY:
    class CassandraTableSchemaClusterKeyArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the cluster key to be created.
        """
        order_by: pulumi.Input[builtins.str]
        """
        Order of the key. Currently supported values are `Asc` and `Desc`.
        """
elif False:
    CassandraTableSchemaClusterKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraTableSchemaClusterKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 order_by: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the cluster key to be created.
        :param pulumi.Input[builtins.str] order_by: Order of the key. Currently supported values are `Asc` and `Desc`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "order_by", order_by)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the cluster key to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> pulumi.Input[builtins.str]:
        """
        Order of the key. Currently supported values are `Asc` and `Desc`.
        """
        return pulumi.get(self, "order_by")

    @order_by.setter
    def order_by(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "order_by", value)


if not MYPY:
    class CassandraTableSchemaColumnArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the column to be created.
        """
        type: pulumi.Input[builtins.str]
        """
        Type of the column to be created.
        """
elif False:
    CassandraTableSchemaColumnArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraTableSchemaColumnArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the column to be created.
        :param pulumi.Input[builtins.str] type: Type of the column to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the column to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of the column to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class CassandraTableSchemaPartitionKeyArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the column to partition by.
        """
elif False:
    CassandraTableSchemaPartitionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CassandraTableSchemaPartitionKeyArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the column to partition by.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the column to partition by.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class GremlinDatabaseAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the Gremlin database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    GremlinDatabaseAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinDatabaseAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the Gremlin database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the Gremlin database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class GremlinGraphAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the Gremlin graph (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    GremlinGraphAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the Gremlin graph (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the Gremlin graph (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class GremlinGraphConflictResolutionPolicyArgsDict(TypedDict):
        mode: pulumi.Input[builtins.str]
        """
        Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        """
        conflict_resolution_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The conflict resolution path in the case of LastWriterWins mode.
        """
        conflict_resolution_procedure: NotRequired[pulumi.Input[builtins.str]]
        """
        The procedure to resolve conflicts in the case of custom mode.
        """
elif False:
    GremlinGraphConflictResolutionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphConflictResolutionPolicyArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[builtins.str],
                 conflict_resolution_path: Optional[pulumi.Input[builtins.str]] = None,
                 conflict_resolution_procedure: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mode: Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        :param pulumi.Input[builtins.str] conflict_resolution_path: The conflict resolution path in the case of LastWriterWins mode.
        :param pulumi.Input[builtins.str] conflict_resolution_procedure: The procedure to resolve conflicts in the case of custom mode.
        """
        pulumi.set(__self__, "mode", mode)
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The conflict resolution path in the case of LastWriterWins mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @conflict_resolution_path.setter
    def conflict_resolution_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conflict_resolution_path", value)

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The procedure to resolve conflicts in the case of custom mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")

    @conflict_resolution_procedure.setter
    def conflict_resolution_procedure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conflict_resolution_procedure", value)


if not MYPY:
    class GremlinGraphIndexPolicyArgsDict(TypedDict):
        indexing_mode: pulumi.Input[builtins.str]
        """
        Indicates the indexing mode. Possible values include: `Consistent`, `Lazy`, `None`.
        """
        automatic: NotRequired[pulumi.Input[builtins.bool]]
        """
        Indicates if the indexing policy is automatic. Defaults to `true`.
        """
        composite_indices: NotRequired[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexArgsDict']]]]
        """
        One or more `composite_index` blocks as defined below.
        """
        excluded_paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of paths to exclude from indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        """
        included_paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of paths to include in the indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        """
        spatial_indices: NotRequired[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicySpatialIndexArgsDict']]]]
        """
        One or more `spatial_index` blocks as defined below.
        """
elif False:
    GremlinGraphIndexPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphIndexPolicyArgs:
    def __init__(__self__, *,
                 indexing_mode: pulumi.Input[builtins.str],
                 automatic: Optional[pulumi.Input[builtins.bool]] = None,
                 composite_indices: Optional[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexArgs']]]] = None,
                 excluded_paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 included_paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 spatial_indices: Optional[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicySpatialIndexArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] indexing_mode: Indicates the indexing mode. Possible values include: `Consistent`, `Lazy`, `None`.
        :param pulumi.Input[builtins.bool] automatic: Indicates if the indexing policy is automatic. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexArgs']]] composite_indices: One or more `composite_index` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] excluded_paths: List of paths to exclude from indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] included_paths: List of paths to include in the indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        :param pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicySpatialIndexArgs']]] spatial_indices: One or more `spatial_index` blocks as defined below.
        """
        pulumi.set(__self__, "indexing_mode", indexing_mode)
        if automatic is not None:
            pulumi.set(__self__, "automatic", automatic)
        if composite_indices is not None:
            pulumi.set(__self__, "composite_indices", composite_indices)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if spatial_indices is not None:
            pulumi.set(__self__, "spatial_indices", spatial_indices)

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> pulumi.Input[builtins.str]:
        """
        Indicates the indexing mode. Possible values include: `Consistent`, `Lazy`, `None`.
        """
        return pulumi.get(self, "indexing_mode")

    @indexing_mode.setter
    def indexing_mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "indexing_mode", value)

    @property
    @pulumi.getter
    def automatic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates if the indexing policy is automatic. Defaults to `true`.
        """
        return pulumi.get(self, "automatic")

    @automatic.setter
    def automatic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automatic", value)

    @property
    @pulumi.getter(name="compositeIndices")
    def composite_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexArgs']]]]:
        """
        One or more `composite_index` blocks as defined below.
        """
        return pulumi.get(self, "composite_indices")

    @composite_indices.setter
    def composite_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexArgs']]]]):
        pulumi.set(self, "composite_indices", value)

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of paths to exclude from indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        """
        return pulumi.get(self, "excluded_paths")

    @excluded_paths.setter
    def excluded_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "excluded_paths", value)

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of paths to include in the indexing. Required if `indexing_mode` is `Consistent` or `Lazy`.
        """
        return pulumi.get(self, "included_paths")

    @included_paths.setter
    def included_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "included_paths", value)

    @property
    @pulumi.getter(name="spatialIndices")
    def spatial_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicySpatialIndexArgs']]]]:
        """
        One or more `spatial_index` blocks as defined below.
        """
        return pulumi.get(self, "spatial_indices")

    @spatial_indices.setter
    def spatial_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicySpatialIndexArgs']]]]):
        pulumi.set(self, "spatial_indices", value)


if not MYPY:
    class GremlinGraphIndexPolicyCompositeIndexArgsDict(TypedDict):
        indices: pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexIndexArgsDict']]]
        """
        One or more `index` blocks as defined below.
        """
elif False:
    GremlinGraphIndexPolicyCompositeIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphIndexPolicyCompositeIndexArgs:
    def __init__(__self__, *,
                 indices: pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexIndexArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexIndexArgs']]] indices: One or more `index` blocks as defined below.
        """
        pulumi.set(__self__, "indices", indices)

    @property
    @pulumi.getter
    def indices(self) -> pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexIndexArgs']]]:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: pulumi.Input[Sequence[pulumi.Input['GremlinGraphIndexPolicyCompositeIndexIndexArgs']]]):
        pulumi.set(self, "indices", value)


if not MYPY:
    class GremlinGraphIndexPolicyCompositeIndexIndexArgsDict(TypedDict):
        order: pulumi.Input[builtins.str]
        """
        Order of the index. Possible values are `Ascending` or `Descending`.
        """
        path: pulumi.Input[builtins.str]
        """
        Path for which the indexing behaviour applies to.
        """
elif False:
    GremlinGraphIndexPolicyCompositeIndexIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphIndexPolicyCompositeIndexIndexArgs:
    def __init__(__self__, *,
                 order: pulumi.Input[builtins.str],
                 path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] order: Order of the index. Possible values are `Ascending` or `Descending`.
        :param pulumi.Input[builtins.str] path: Path for which the indexing behaviour applies to.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[builtins.str]:
        """
        Order of the index. Possible values are `Ascending` or `Descending`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path for which the indexing behaviour applies to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class GremlinGraphIndexPolicySpatialIndexArgsDict(TypedDict):
        path: pulumi.Input[builtins.str]
        """
        Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
elif False:
    GremlinGraphIndexPolicySpatialIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphIndexPolicySpatialIndexArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] path: Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        pulumi.set(__self__, "path", path)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "types", value)


if not MYPY:
    class GremlinGraphUniqueKeyArgsDict(TypedDict):
        paths: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
elif False:
    GremlinGraphUniqueKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GremlinGraphUniqueKeyArgs:
    def __init__(__self__, *,
                 paths: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "paths", value)


if not MYPY:
    class MongoClusterConnectionStringArgsDict(TypedDict):
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        The description of the connection string.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the Mongo Cluster connection string. The `<user>:<password>` placeholder returned from API will be replaced by the real `administrator_username` and `administrator_password` if available in the state.
        """
elif False:
    MongoClusterConnectionStringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoClusterConnectionStringArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] description: The description of the connection string.
        :param pulumi.Input[builtins.str] name: The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] value: The value of the Mongo Cluster connection string. The `<user>:<password>` placeholder returned from API will be replaced by the real `administrator_username` and `administrator_password` if available in the state.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the connection string.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for the MongoDB Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the Mongo Cluster connection string. The `<user>:<password>` placeholder returned from API will be replaced by the real `administrator_username` and `administrator_password` if available in the state.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class MongoCollectionAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the MongoDB collection (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    MongoCollectionAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoCollectionAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the MongoDB collection (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the MongoDB collection (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class MongoCollectionIndexArgsDict(TypedDict):
        keys: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        Specifies the list of user settable keys for each Cosmos DB Mongo Collection.
        """
        unique: NotRequired[pulumi.Input[builtins.bool]]
        """
        Is the index unique or not? Defaults to `false`.

        > **Note:** An index with an "_id" key must be specified.
        """
elif False:
    MongoCollectionIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoCollectionIndexArgs:
    def __init__(__self__, *,
                 keys: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 unique: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keys: Specifies the list of user settable keys for each Cosmos DB Mongo Collection.
        :param pulumi.Input[builtins.bool] unique: Is the index unique or not? Defaults to `false`.
               
               > **Note:** An index with an "_id" key must be specified.
        """
        pulumi.set(__self__, "keys", keys)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter
    def keys(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Specifies the list of user settable keys for each Cosmos DB Mongo Collection.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the index unique or not? Defaults to `false`.

        > **Note:** An index with an "_id" key must be specified.
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unique", value)


if not MYPY:
    class MongoCollectionSystemIndexArgsDict(TypedDict):
        keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The list of system keys which are not settable for each Cosmos DB Mongo Collection.
        """
        unique: NotRequired[pulumi.Input[builtins.bool]]
        """
        Identifies whether the table contains no duplicate values.
        """
elif False:
    MongoCollectionSystemIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoCollectionSystemIndexArgs:
    def __init__(__self__, *,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 unique: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] keys: The list of system keys which are not settable for each Cosmos DB Mongo Collection.
        :param pulumi.Input[builtins.bool] unique: Identifies whether the table contains no duplicate values.
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if unique is not None:
            pulumi.set(__self__, "unique", unique)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of system keys which are not settable for each Cosmos DB Mongo Collection.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter
    def unique(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Identifies whether the table contains no duplicate values.
        """
        return pulumi.get(self, "unique")

    @unique.setter
    def unique(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "unique", value)


if not MYPY:
    class MongoDatabaseAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the MongoDB database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    MongoDatabaseAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoDatabaseAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the MongoDB database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the MongoDB database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class MongoRoleDefinitionPrivilegeArgsDict(TypedDict):
        actions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of actions that are allowed.
        """
        resource: pulumi.Input['MongoRoleDefinitionPrivilegeResourceArgsDict']
        """
        A `resource` block as defined below.
        """
elif False:
    MongoRoleDefinitionPrivilegeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoRoleDefinitionPrivilegeArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 resource: pulumi.Input['MongoRoleDefinitionPrivilegeResourceArgs']):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] actions: A list of actions that are allowed.
        :param pulumi.Input['MongoRoleDefinitionPrivilegeResourceArgs'] resource: A `resource` block as defined below.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "resource", resource)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of actions that are allowed.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input['MongoRoleDefinitionPrivilegeResourceArgs']:
        """
        A `resource` block as defined below.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input['MongoRoleDefinitionPrivilegeResourceArgs']):
        pulumi.set(self, "resource", value)


if not MYPY:
    class MongoRoleDefinitionPrivilegeResourceArgsDict(TypedDict):
        collection_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Mongo DB Collection that the Role Definition is applied.
        """
        db_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Mongo DB that the Role Definition is applied.
        """
elif False:
    MongoRoleDefinitionPrivilegeResourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MongoRoleDefinitionPrivilegeResourceArgs:
    def __init__(__self__, *,
                 collection_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] collection_name: The name of the Mongo DB Collection that the Role Definition is applied.
        :param pulumi.Input[builtins.str] db_name: The name of the Mongo DB that the Role Definition is applied.
        """
        if collection_name is not None:
            pulumi.set(__self__, "collection_name", collection_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Mongo DB Collection that the Role Definition is applied.
        """
        return pulumi.get(self, "collection_name")

    @collection_name.setter
    def collection_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collection_name", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Mongo DB that the Role Definition is applied.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_name", value)


if not MYPY:
    class PostgresqlClusterMaintenanceWindowArgsDict(TypedDict):
        day_of_week: NotRequired[pulumi.Input[builtins.int]]
        """
        The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        """
        start_hour: NotRequired[pulumi.Input[builtins.int]]
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        start_minute: NotRequired[pulumi.Input[builtins.int]]
        """
        The start minute for maintenance window. Defaults to `0`.
        """
elif False:
    PostgresqlClusterMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PostgresqlClusterMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[builtins.int]] = None,
                 start_hour: Optional[pulumi.Input[builtins.int]] = None,
                 start_minute: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] day_of_week: The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        :param pulumi.Input[builtins.int] start_hour: The start hour for maintenance window. Defaults to `0`.
        :param pulumi.Input[builtins.int] start_minute: The start minute for maintenance window. Defaults to `0`.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The day of week for maintenance window, where the week starts on a Sunday, i.e. Sunday = `0`, Monday = `1`. Defaults to `0`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "day_of_week", value)

    @property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_hour")

    @start_hour.setter
    def start_hour(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_hour", value)

    @property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The start minute for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")

    @start_minute.setter
    def start_minute(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_minute", value)


if not MYPY:
    class PostgresqlClusterServerArgsDict(TypedDict):
        fqdn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Fully Qualified Domain Name of the server.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
elif False:
    PostgresqlClusterServerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PostgresqlClusterServerArgs:
    def __init__(__self__, *,
                 fqdn: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] fqdn: The Fully Qualified Domain Name of the server.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Fully Qualified Domain Name of the server.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Azure Cosmos DB for PostgreSQL Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


if not MYPY:
    class SqlContainerAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the SQL container (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    SqlContainerAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the SQL container (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the SQL container (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class SqlContainerConflictResolutionPolicyArgsDict(TypedDict):
        mode: pulumi.Input[builtins.str]
        """
        Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        """
        conflict_resolution_path: NotRequired[pulumi.Input[builtins.str]]
        """
        The conflict resolution path in the case of `LastWriterWins` mode.
        """
        conflict_resolution_procedure: NotRequired[pulumi.Input[builtins.str]]
        """
        The procedure to resolve conflicts in the case of `Custom` mode.
        """
elif False:
    SqlContainerConflictResolutionPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerConflictResolutionPolicyArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[builtins.str],
                 conflict_resolution_path: Optional[pulumi.Input[builtins.str]] = None,
                 conflict_resolution_procedure: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] mode: Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        :param pulumi.Input[builtins.str] conflict_resolution_path: The conflict resolution path in the case of `LastWriterWins` mode.
        :param pulumi.Input[builtins.str] conflict_resolution_procedure: The procedure to resolve conflicts in the case of `Custom` mode.
        """
        pulumi.set(__self__, "mode", mode)
        if conflict_resolution_path is not None:
            pulumi.set(__self__, "conflict_resolution_path", conflict_resolution_path)
        if conflict_resolution_procedure is not None:
            pulumi.set(__self__, "conflict_resolution_procedure", conflict_resolution_procedure)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[builtins.str]:
        """
        Indicates the conflict resolution mode. Possible values include: `LastWriterWins`, `Custom`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="conflictResolutionPath")
    def conflict_resolution_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The conflict resolution path in the case of `LastWriterWins` mode.
        """
        return pulumi.get(self, "conflict_resolution_path")

    @conflict_resolution_path.setter
    def conflict_resolution_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conflict_resolution_path", value)

    @property
    @pulumi.getter(name="conflictResolutionProcedure")
    def conflict_resolution_procedure(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The procedure to resolve conflicts in the case of `Custom` mode.
        """
        return pulumi.get(self, "conflict_resolution_procedure")

    @conflict_resolution_procedure.setter
    def conflict_resolution_procedure(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conflict_resolution_procedure", value)


if not MYPY:
    class SqlContainerIndexingPolicyArgsDict(TypedDict):
        composite_indices: NotRequired[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexArgsDict']]]]
        """
        One or more `composite_index` blocks as defined below.
        """
        excluded_paths: NotRequired[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyExcludedPathArgsDict']]]]
        """
        One or more `excluded_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        """
        included_paths: NotRequired[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyIncludedPathArgsDict']]]]
        """
        One or more `included_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        """
        indexing_mode: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates the indexing mode. Possible values include: `consistent` and `none`. Defaults to `consistent`.
        """
        spatial_indices: NotRequired[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicySpatialIndexArgsDict']]]]
        """
        One or more `spatial_index` blocks as defined below.
        """
elif False:
    SqlContainerIndexingPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerIndexingPolicyArgs:
    def __init__(__self__, *,
                 composite_indices: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexArgs']]]] = None,
                 excluded_paths: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyExcludedPathArgs']]]] = None,
                 included_paths: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyIncludedPathArgs']]]] = None,
                 indexing_mode: Optional[pulumi.Input[builtins.str]] = None,
                 spatial_indices: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicySpatialIndexArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexArgs']]] composite_indices: One or more `composite_index` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyExcludedPathArgs']]] excluded_paths: One or more `excluded_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyIncludedPathArgs']]] included_paths: One or more `included_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        :param pulumi.Input[builtins.str] indexing_mode: Indicates the indexing mode. Possible values include: `consistent` and `none`. Defaults to `consistent`.
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicySpatialIndexArgs']]] spatial_indices: One or more `spatial_index` blocks as defined below.
        """
        if composite_indices is not None:
            pulumi.set(__self__, "composite_indices", composite_indices)
        if excluded_paths is not None:
            pulumi.set(__self__, "excluded_paths", excluded_paths)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)
        if indexing_mode is not None:
            pulumi.set(__self__, "indexing_mode", indexing_mode)
        if spatial_indices is not None:
            pulumi.set(__self__, "spatial_indices", spatial_indices)

    @property
    @pulumi.getter(name="compositeIndices")
    def composite_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexArgs']]]]:
        """
        One or more `composite_index` blocks as defined below.
        """
        return pulumi.get(self, "composite_indices")

    @composite_indices.setter
    def composite_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexArgs']]]]):
        pulumi.set(self, "composite_indices", value)

    @property
    @pulumi.getter(name="excludedPaths")
    def excluded_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyExcludedPathArgs']]]]:
        """
        One or more `excluded_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        """
        return pulumi.get(self, "excluded_paths")

    @excluded_paths.setter
    def excluded_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyExcludedPathArgs']]]]):
        pulumi.set(self, "excluded_paths", value)

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyIncludedPathArgs']]]]:
        """
        One or more `included_path` blocks as defined below. Either `included_path` or `excluded_path` must contain the `path` `/*`
        """
        return pulumi.get(self, "included_paths")

    @included_paths.setter
    def included_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyIncludedPathArgs']]]]):
        pulumi.set(self, "included_paths", value)

    @property
    @pulumi.getter(name="indexingMode")
    def indexing_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the indexing mode. Possible values include: `consistent` and `none`. Defaults to `consistent`.
        """
        return pulumi.get(self, "indexing_mode")

    @indexing_mode.setter
    def indexing_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "indexing_mode", value)

    @property
    @pulumi.getter(name="spatialIndices")
    def spatial_indices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicySpatialIndexArgs']]]]:
        """
        One or more `spatial_index` blocks as defined below.
        """
        return pulumi.get(self, "spatial_indices")

    @spatial_indices.setter
    def spatial_indices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicySpatialIndexArgs']]]]):
        pulumi.set(self, "spatial_indices", value)


if not MYPY:
    class SqlContainerIndexingPolicyCompositeIndexArgsDict(TypedDict):
        indices: pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexIndexArgsDict']]]
        """
        One or more `index` blocks as defined below.
        """
elif False:
    SqlContainerIndexingPolicyCompositeIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerIndexingPolicyCompositeIndexArgs:
    def __init__(__self__, *,
                 indices: pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexIndexArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexIndexArgs']]] indices: One or more `index` blocks as defined below.
        """
        pulumi.set(__self__, "indices", indices)

    @property
    @pulumi.getter
    def indices(self) -> pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexIndexArgs']]]:
        """
        One or more `index` blocks as defined below.
        """
        return pulumi.get(self, "indices")

    @indices.setter
    def indices(self, value: pulumi.Input[Sequence[pulumi.Input['SqlContainerIndexingPolicyCompositeIndexIndexArgs']]]):
        pulumi.set(self, "indices", value)


if not MYPY:
    class SqlContainerIndexingPolicyCompositeIndexIndexArgsDict(TypedDict):
        order: pulumi.Input[builtins.str]
        """
        Order of the index. Possible values are `Ascending` or `Descending`.
        """
        path: pulumi.Input[builtins.str]
        """
        Path for which the indexing behaviour applies to.
        """
elif False:
    SqlContainerIndexingPolicyCompositeIndexIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerIndexingPolicyCompositeIndexIndexArgs:
    def __init__(__self__, *,
                 order: pulumi.Input[builtins.str],
                 path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] order: Order of the index. Possible values are `Ascending` or `Descending`.
        :param pulumi.Input[builtins.str] path: Path for which the indexing behaviour applies to.
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[builtins.str]:
        """
        Order of the index. Possible values are `Ascending` or `Descending`.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path for which the indexing behaviour applies to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class SqlContainerIndexingPolicyExcludedPathArgsDict(TypedDict):
        path: pulumi.Input[builtins.str]
        """
        Path that is excluded from indexing.
        """
elif False:
    SqlContainerIndexingPolicyExcludedPathArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerIndexingPolicyExcludedPathArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] path: Path that is excluded from indexing.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path that is excluded from indexing.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class SqlContainerIndexingPolicyIncludedPathArgsDict(TypedDict):
        path: pulumi.Input[builtins.str]
        """
        Path for which the indexing behaviour applies to.
        """
elif False:
    SqlContainerIndexingPolicyIncludedPathArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerIndexingPolicyIncludedPathArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] path: Path for which the indexing behaviour applies to.
        """
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path for which the indexing behaviour applies to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class SqlContainerIndexingPolicySpatialIndexArgsDict(TypedDict):
        path: pulumi.Input[builtins.str]
        """
        Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        types: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A set of spatial types of the path.
        """
elif False:
    SqlContainerIndexingPolicySpatialIndexArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerIndexingPolicySpatialIndexArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] path: Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] types: A set of spatial types of the path.
        """
        pulumi.set(__self__, "path", path)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path for which the indexing behaviour applies to. According to the service design, all spatial types including `LineString`, `MultiPolygon`, `Point`, and `Polygon` will be applied to the path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of spatial types of the path.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "types", value)


if not MYPY:
    class SqlContainerUniqueKeyArgsDict(TypedDict):
        paths: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
elif False:
    SqlContainerUniqueKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlContainerUniqueKeyArgs:
    def __init__(__self__, *,
                 paths: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of paths to use for this unique key. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "paths", value)


if not MYPY:
    class SqlDatabaseAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the SQL database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    SqlDatabaseAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlDatabaseAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the SQL database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the SQL database (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


if not MYPY:
    class SqlRoleDefinitionPermissionArgsDict(TypedDict):
        data_actions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
elif False:
    SqlRoleDefinitionPermissionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SqlRoleDefinitionPermissionArgs:
    def __init__(__self__, *,
                 data_actions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_actions: A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
        pulumi.set(__self__, "data_actions", data_actions)

    @property
    @pulumi.getter(name="dataActions")
    def data_actions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A list of data actions that are allowed for the Cosmos DB SQL Role Definition.
        """
        return pulumi.get(self, "data_actions")

    @data_actions.setter
    def data_actions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "data_actions", value)


if not MYPY:
    class TableAutoscaleSettingsArgsDict(TypedDict):
        max_throughput: NotRequired[pulumi.Input[builtins.int]]
        """
        The maximum throughput of the Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
elif False:
    TableAutoscaleSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableAutoscaleSettingsArgs:
    def __init__(__self__, *,
                 max_throughput: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.int] max_throughput: The maximum throughput of the Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        if max_throughput is not None:
            pulumi.set(__self__, "max_throughput", max_throughput)

    @property
    @pulumi.getter(name="maxThroughput")
    def max_throughput(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum throughput of the Table (RU/s). Must be between `1,000` and `1,000,000`. Must be set in increments of `1,000`. Conflicts with `throughput`.
        """
        return pulumi.get(self, "max_throughput")

    @max_throughput.setter
    def max_throughput(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "max_throughput", value)


