# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 consistency_policy: pulumi.Input['AccountConsistencyPolicyArgs'],
                 geo_locations: pulumi.Input[Sequence[pulumi.Input['AccountGeoLocationArgs']]],
                 offer_type: pulumi.Input[builtins.str],
                 resource_group_name: pulumi.Input[builtins.str],
                 access_key_metadata_writes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 analytical_storage: Optional[pulumi.Input['AccountAnalyticalStorageArgs']] = None,
                 analytical_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup: Optional[pulumi.Input['AccountBackupArgs']] = None,
                 burst_capacity_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['AccountCapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input['AccountCapacityArgs']] = None,
                 cors_rule: Optional[pulumi.Input['AccountCorsRuleArgs']] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 free_tier_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 ip_range_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 mongo_server_version: Optional[pulumi.Input[builtins.str]] = None,
                 multiple_write_locations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_acl_bypass_for_azure_services: Optional[pulumi.Input[builtins.bool]] = None,
                 network_acl_bypass_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 partition_merge_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 restore: Optional[pulumi.Input['AccountRestoreArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountVirtualNetworkRuleArgs']]]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input[builtins.str] offer_type: Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input['AccountAnalyticalStorageArgs'] analytical_storage: An `analytical_storage` block as defined below.
        :param pulumi.Input['AccountCapacityArgs'] capacity: A `capacity` block as defined below.
        :param pulumi.Input[builtins.str] create_mode: The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.
               
               > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        :param pulumi.Input[builtins.str] default_identity_type: The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] minimal_tls_version: Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "consistency_policy", consistency_policy)
        pulumi.set(__self__, "geo_locations", geo_locations)
        pulumi.set(__self__, "offer_type", offer_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if access_key_metadata_writes_enabled is not None:
            pulumi.set(__self__, "access_key_metadata_writes_enabled", access_key_metadata_writes_enabled)
        if analytical_storage is not None:
            pulumi.set(__self__, "analytical_storage", analytical_storage)
        if analytical_storage_enabled is not None:
            pulumi.set(__self__, "analytical_storage_enabled", analytical_storage_enabled)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if burst_capacity_enabled is not None:
            pulumi.set(__self__, "burst_capacity_enabled", burst_capacity_enabled)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if cors_rule is not None:
            pulumi.set(__self__, "cors_rule", cors_rule)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if default_identity_type is not None:
            pulumi.set(__self__, "default_identity_type", default_identity_type)
        if free_tier_enabled is not None:
            pulumi.set(__self__, "free_tier_enabled", free_tier_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ip_range_filters is not None:
            pulumi.set(__self__, "ip_range_filters", ip_range_filters)
        if is_virtual_network_filter_enabled is not None:
            pulumi.set(__self__, "is_virtual_network_filter_enabled", is_virtual_network_filter_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if local_authentication_disabled is not None:
            pulumi.set(__self__, "local_authentication_disabled", local_authentication_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if minimal_tls_version is not None:
            pulumi.set(__self__, "minimal_tls_version", minimal_tls_version)
        if mongo_server_version is not None:
            pulumi.set(__self__, "mongo_server_version", mongo_server_version)
        if multiple_write_locations_enabled is not None:
            pulumi.set(__self__, "multiple_write_locations_enabled", multiple_write_locations_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acl_bypass_for_azure_services is not None:
            pulumi.set(__self__, "network_acl_bypass_for_azure_services", network_acl_bypass_for_azure_services)
        if network_acl_bypass_ids is not None:
            pulumi.set(__self__, "network_acl_bypass_ids", network_acl_bypass_ids)
        if partition_merge_enabled is not None:
            pulumi.set(__self__, "partition_merge_enabled", partition_merge_enabled)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @property
    @pulumi.getter(name="consistencyPolicy")
    def consistency_policy(self) -> pulumi.Input['AccountConsistencyPolicyArgs']:
        return pulumi.get(self, "consistency_policy")

    @consistency_policy.setter
    def consistency_policy(self, value: pulumi.Input['AccountConsistencyPolicyArgs']):
        pulumi.set(self, "consistency_policy", value)

    @property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> pulumi.Input[Sequence[pulumi.Input['AccountGeoLocationArgs']]]:
        return pulumi.get(self, "geo_locations")

    @geo_locations.setter
    def geo_locations(self, value: pulumi.Input[Sequence[pulumi.Input['AccountGeoLocationArgs']]]):
        pulumi.set(self, "geo_locations", value)

    @property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> pulumi.Input[builtins.str]:
        """
        Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        """
        return pulumi.get(self, "offer_type")

    @offer_type.setter
    def offer_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "offer_type", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter(name="accessKeyMetadataWritesEnabled")
    def access_key_metadata_writes_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "access_key_metadata_writes_enabled")

    @access_key_metadata_writes_enabled.setter
    def access_key_metadata_writes_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "access_key_metadata_writes_enabled", value)

    @property
    @pulumi.getter(name="analyticalStorage")
    def analytical_storage(self) -> Optional[pulumi.Input['AccountAnalyticalStorageArgs']]:
        """
        An `analytical_storage` block as defined below.
        """
        return pulumi.get(self, "analytical_storage")

    @analytical_storage.setter
    def analytical_storage(self, value: Optional[pulumi.Input['AccountAnalyticalStorageArgs']]):
        pulumi.set(self, "analytical_storage", value)

    @property
    @pulumi.getter(name="analyticalStorageEnabled")
    def analytical_storage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "analytical_storage_enabled")

    @analytical_storage_enabled.setter
    def analytical_storage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "analytical_storage_enabled", value)

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['AccountBackupArgs']]:
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['AccountBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="burstCapacityEnabled")
    def burst_capacity_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "burst_capacity_enabled")

    @burst_capacity_enabled.setter
    def burst_capacity_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "burst_capacity_enabled", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountCapabilityArgs']]]]:
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['AccountCapacityArgs']]:
        """
        A `capacity` block as defined below.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['AccountCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="corsRule")
    def cors_rule(self) -> Optional[pulumi.Input['AccountCorsRuleArgs']]:
        return pulumi.get(self, "cors_rule")

    @cors_rule.setter
    def cors_rule(self, value: Optional[pulumi.Input['AccountCorsRuleArgs']]):
        pulumi.set(self, "cors_rule", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.

        > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="defaultIdentityType")
    def default_identity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        """
        return pulumi.get(self, "default_identity_type")

    @default_identity_type.setter
    def default_identity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_identity_type", value)

    @property
    @pulumi.getter(name="freeTierEnabled")
    def free_tier_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "free_tier_enabled")

    @free_tier_enabled.setter
    def free_tier_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "free_tier_enabled", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="ipRangeFilters")
    def ip_range_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "ip_range_filters")

    @ip_range_filters.setter
    def ip_range_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_range_filters", value)

    @property
    @pulumi.getter(name="isVirtualNetworkFilterEnabled")
    def is_virtual_network_filter_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_virtual_network_filter_enabled")

    @is_virtual_network_filter_enabled.setter
    def is_virtual_network_filter_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_virtual_network_filter_enabled", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "local_authentication_disabled")

    @local_authentication_disabled.setter
    def local_authentication_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_authentication_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @property
    @pulumi.getter(name="minimalTlsVersion")
    def minimal_tls_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        """
        return pulumi.get(self, "minimal_tls_version")

    @minimal_tls_version.setter
    def minimal_tls_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimal_tls_version", value)

    @property
    @pulumi.getter(name="mongoServerVersion")
    def mongo_server_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "mongo_server_version")

    @mongo_server_version.setter
    def mongo_server_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mongo_server_version", value)

    @property
    @pulumi.getter(name="multipleWriteLocationsEnabled")
    def multiple_write_locations_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "multiple_write_locations_enabled")

    @multiple_write_locations_enabled.setter
    def multiple_write_locations_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multiple_write_locations_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkAclBypassForAzureServices")
    def network_acl_bypass_for_azure_services(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "network_acl_bypass_for_azure_services")

    @network_acl_bypass_for_azure_services.setter
    def network_acl_bypass_for_azure_services(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "network_acl_bypass_for_azure_services", value)

    @property
    @pulumi.getter(name="networkAclBypassIds")
    def network_acl_bypass_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "network_acl_bypass_ids")

    @network_acl_bypass_ids.setter
    def network_acl_bypass_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_acl_bypass_ids", value)

    @property
    @pulumi.getter(name="partitionMergeEnabled")
    def partition_merge_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "partition_merge_enabled")

    @partition_merge_enabled.setter
    def partition_merge_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "partition_merge_enabled", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['AccountRestoreArgs']]:
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['AccountRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountVirtualNetworkRuleArgs']]]]:
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountVirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 access_key_metadata_writes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 analytical_storage: Optional[pulumi.Input['AccountAnalyticalStorageArgs']] = None,
                 analytical_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup: Optional[pulumi.Input['AccountBackupArgs']] = None,
                 burst_capacity_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input['AccountCapabilityArgs']]]] = None,
                 capacity: Optional[pulumi.Input['AccountCapacityArgs']] = None,
                 consistency_policy: Optional[pulumi.Input['AccountConsistencyPolicyArgs']] = None,
                 cors_rule: Optional[pulumi.Input['AccountCorsRuleArgs']] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 free_tier_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input['AccountGeoLocationArgs']]]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 ip_range_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 mongo_server_version: Optional[pulumi.Input[builtins.str]] = None,
                 multiple_write_locations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_acl_bypass_for_azure_services: Optional[pulumi.Input[builtins.bool]] = None,
                 network_acl_bypass_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 offer_type: Optional[pulumi.Input[builtins.str]] = None,
                 partition_merge_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 primary_key: Optional[pulumi.Input[builtins.str]] = None,
                 primary_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 primary_readonly_key: Optional[pulumi.Input[builtins.str]] = None,
                 primary_readonly_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 primary_readonly_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 primary_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 read_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restore: Optional[pulumi.Input['AccountRestoreArgs']] = None,
                 secondary_key: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_readonly_key: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_readonly_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_readonly_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 secondary_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountVirtualNetworkRuleArgs']]]] = None,
                 write_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input['AccountAnalyticalStorageArgs'] analytical_storage: An `analytical_storage` block as defined below.
        :param pulumi.Input['AccountCapacityArgs'] capacity: A `capacity` block as defined below.
        :param pulumi.Input[builtins.str] create_mode: The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.
               
               > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        :param pulumi.Input[builtins.str] default_identity_type: The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        :param pulumi.Input[builtins.str] endpoint: The endpoint used to connect to the CosmosDB account.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] minimal_tls_version: Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_type: Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        :param pulumi.Input[builtins.str] primary_key: The Primary key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_mongodb_connection_string: Primary Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_readonly_key: The Primary read-only Key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_readonly_mongodb_connection_string: Primary readonly Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_readonly_sql_connection_string: Primary readonly SQL connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_sql_connection_string: Primary SQL connection string for the CosmosDB Account.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_endpoints: A list of read endpoints available for this CosmosDB account.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_key: The Secondary key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_mongodb_connection_string: Secondary Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_readonly_key: The Secondary read-only key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_readonly_mongodb_connection_string: Secondary readonly Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_readonly_sql_connection_string: Secondary readonly SQL connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_sql_connection_string: Secondary SQL connection string for the CosmosDB Account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] write_endpoints: A list of write endpoints available for this CosmosDB account.
        """
        if access_key_metadata_writes_enabled is not None:
            pulumi.set(__self__, "access_key_metadata_writes_enabled", access_key_metadata_writes_enabled)
        if analytical_storage is not None:
            pulumi.set(__self__, "analytical_storage", analytical_storage)
        if analytical_storage_enabled is not None:
            pulumi.set(__self__, "analytical_storage_enabled", analytical_storage_enabled)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if burst_capacity_enabled is not None:
            pulumi.set(__self__, "burst_capacity_enabled", burst_capacity_enabled)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if consistency_policy is not None:
            pulumi.set(__self__, "consistency_policy", consistency_policy)
        if cors_rule is not None:
            pulumi.set(__self__, "cors_rule", cors_rule)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if default_identity_type is not None:
            pulumi.set(__self__, "default_identity_type", default_identity_type)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if free_tier_enabled is not None:
            pulumi.set(__self__, "free_tier_enabled", free_tier_enabled)
        if geo_locations is not None:
            pulumi.set(__self__, "geo_locations", geo_locations)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if ip_range_filters is not None:
            pulumi.set(__self__, "ip_range_filters", ip_range_filters)
        if is_virtual_network_filter_enabled is not None:
            pulumi.set(__self__, "is_virtual_network_filter_enabled", is_virtual_network_filter_enabled)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if local_authentication_disabled is not None:
            pulumi.set(__self__, "local_authentication_disabled", local_authentication_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if minimal_tls_version is not None:
            pulumi.set(__self__, "minimal_tls_version", minimal_tls_version)
        if mongo_server_version is not None:
            pulumi.set(__self__, "mongo_server_version", mongo_server_version)
        if multiple_write_locations_enabled is not None:
            pulumi.set(__self__, "multiple_write_locations_enabled", multiple_write_locations_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acl_bypass_for_azure_services is not None:
            pulumi.set(__self__, "network_acl_bypass_for_azure_services", network_acl_bypass_for_azure_services)
        if network_acl_bypass_ids is not None:
            pulumi.set(__self__, "network_acl_bypass_ids", network_acl_bypass_ids)
        if offer_type is not None:
            pulumi.set(__self__, "offer_type", offer_type)
        if partition_merge_enabled is not None:
            pulumi.set(__self__, "partition_merge_enabled", partition_merge_enabled)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if primary_mongodb_connection_string is not None:
            pulumi.set(__self__, "primary_mongodb_connection_string", primary_mongodb_connection_string)
        if primary_readonly_key is not None:
            pulumi.set(__self__, "primary_readonly_key", primary_readonly_key)
        if primary_readonly_mongodb_connection_string is not None:
            pulumi.set(__self__, "primary_readonly_mongodb_connection_string", primary_readonly_mongodb_connection_string)
        if primary_readonly_sql_connection_string is not None:
            pulumi.set(__self__, "primary_readonly_sql_connection_string", primary_readonly_sql_connection_string)
        if primary_sql_connection_string is not None:
            pulumi.set(__self__, "primary_sql_connection_string", primary_sql_connection_string)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if read_endpoints is not None:
            pulumi.set(__self__, "read_endpoints", read_endpoints)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)
        if secondary_mongodb_connection_string is not None:
            pulumi.set(__self__, "secondary_mongodb_connection_string", secondary_mongodb_connection_string)
        if secondary_readonly_key is not None:
            pulumi.set(__self__, "secondary_readonly_key", secondary_readonly_key)
        if secondary_readonly_mongodb_connection_string is not None:
            pulumi.set(__self__, "secondary_readonly_mongodb_connection_string", secondary_readonly_mongodb_connection_string)
        if secondary_readonly_sql_connection_string is not None:
            pulumi.set(__self__, "secondary_readonly_sql_connection_string", secondary_readonly_sql_connection_string)
        if secondary_sql_connection_string is not None:
            pulumi.set(__self__, "secondary_sql_connection_string", secondary_sql_connection_string)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)
        if write_endpoints is not None:
            pulumi.set(__self__, "write_endpoints", write_endpoints)

    @property
    @pulumi.getter(name="accessKeyMetadataWritesEnabled")
    def access_key_metadata_writes_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "access_key_metadata_writes_enabled")

    @access_key_metadata_writes_enabled.setter
    def access_key_metadata_writes_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "access_key_metadata_writes_enabled", value)

    @property
    @pulumi.getter(name="analyticalStorage")
    def analytical_storage(self) -> Optional[pulumi.Input['AccountAnalyticalStorageArgs']]:
        """
        An `analytical_storage` block as defined below.
        """
        return pulumi.get(self, "analytical_storage")

    @analytical_storage.setter
    def analytical_storage(self, value: Optional[pulumi.Input['AccountAnalyticalStorageArgs']]):
        pulumi.set(self, "analytical_storage", value)

    @property
    @pulumi.getter(name="analyticalStorageEnabled")
    def analytical_storage_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "analytical_storage_enabled")

    @analytical_storage_enabled.setter
    def analytical_storage_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "analytical_storage_enabled", value)

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input['AccountBackupArgs']]:
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input['AccountBackupArgs']]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter(name="burstCapacityEnabled")
    def burst_capacity_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "burst_capacity_enabled")

    @burst_capacity_enabled.setter
    def burst_capacity_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "burst_capacity_enabled", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountCapabilityArgs']]]]:
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountCapabilityArgs']]]]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['AccountCapacityArgs']]:
        """
        A `capacity` block as defined below.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['AccountCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="consistencyPolicy")
    def consistency_policy(self) -> Optional[pulumi.Input['AccountConsistencyPolicyArgs']]:
        return pulumi.get(self, "consistency_policy")

    @consistency_policy.setter
    def consistency_policy(self, value: Optional[pulumi.Input['AccountConsistencyPolicyArgs']]):
        pulumi.set(self, "consistency_policy", value)

    @property
    @pulumi.getter(name="corsRule")
    def cors_rule(self) -> Optional[pulumi.Input['AccountCorsRuleArgs']]:
        return pulumi.get(self, "cors_rule")

    @cors_rule.setter
    def cors_rule(self, value: Optional[pulumi.Input['AccountCorsRuleArgs']]):
        pulumi.set(self, "cors_rule", value)

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.

        > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @property
    @pulumi.getter(name="defaultIdentityType")
    def default_identity_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        """
        return pulumi.get(self, "default_identity_type")

    @default_identity_type.setter
    def default_identity_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_identity_type", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The endpoint used to connect to the CosmosDB account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="freeTierEnabled")
    def free_tier_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "free_tier_enabled")

    @free_tier_enabled.setter
    def free_tier_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "free_tier_enabled", value)

    @property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountGeoLocationArgs']]]]:
        return pulumi.get(self, "geo_locations")

    @geo_locations.setter
    def geo_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountGeoLocationArgs']]]]):
        pulumi.set(self, "geo_locations", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="ipRangeFilters")
    def ip_range_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "ip_range_filters")

    @ip_range_filters.setter
    def ip_range_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ip_range_filters", value)

    @property
    @pulumi.getter(name="isVirtualNetworkFilterEnabled")
    def is_virtual_network_filter_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_virtual_network_filter_enabled")

    @is_virtual_network_filter_enabled.setter
    def is_virtual_network_filter_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_virtual_network_filter_enabled", value)

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "local_authentication_disabled")

    @local_authentication_disabled.setter
    def local_authentication_disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_authentication_disabled", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @property
    @pulumi.getter(name="minimalTlsVersion")
    def minimal_tls_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        """
        return pulumi.get(self, "minimal_tls_version")

    @minimal_tls_version.setter
    def minimal_tls_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimal_tls_version", value)

    @property
    @pulumi.getter(name="mongoServerVersion")
    def mongo_server_version(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "mongo_server_version")

    @mongo_server_version.setter
    def mongo_server_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mongo_server_version", value)

    @property
    @pulumi.getter(name="multipleWriteLocationsEnabled")
    def multiple_write_locations_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "multiple_write_locations_enabled")

    @multiple_write_locations_enabled.setter
    def multiple_write_locations_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multiple_write_locations_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkAclBypassForAzureServices")
    def network_acl_bypass_for_azure_services(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "network_acl_bypass_for_azure_services")

    @network_acl_bypass_for_azure_services.setter
    def network_acl_bypass_for_azure_services(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "network_acl_bypass_for_azure_services", value)

    @property
    @pulumi.getter(name="networkAclBypassIds")
    def network_acl_bypass_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "network_acl_bypass_ids")

    @network_acl_bypass_ids.setter
    def network_acl_bypass_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "network_acl_bypass_ids", value)

    @property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        """
        return pulumi.get(self, "offer_type")

    @offer_type.setter
    def offer_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "offer_type", value)

    @property
    @pulumi.getter(name="partitionMergeEnabled")
    def partition_merge_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "partition_merge_enabled")

    @partition_merge_enabled.setter
    def partition_merge_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "partition_merge_enabled", value)

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Primary key for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @property
    @pulumi.getter(name="primaryMongodbConnectionString")
    def primary_mongodb_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_mongodb_connection_string")

    @primary_mongodb_connection_string.setter
    def primary_mongodb_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_mongodb_connection_string", value)

    @property
    @pulumi.getter(name="primaryReadonlyKey")
    def primary_readonly_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Primary read-only Key for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_readonly_key")

    @primary_readonly_key.setter
    def primary_readonly_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_readonly_key", value)

    @property
    @pulumi.getter(name="primaryReadonlyMongodbConnectionString")
    def primary_readonly_mongodb_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary readonly Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_readonly_mongodb_connection_string")

    @primary_readonly_mongodb_connection_string.setter
    def primary_readonly_mongodb_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_readonly_mongodb_connection_string", value)

    @property
    @pulumi.getter(name="primaryReadonlySqlConnectionString")
    def primary_readonly_sql_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary readonly SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_readonly_sql_connection_string")

    @primary_readonly_sql_connection_string.setter
    def primary_readonly_sql_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_readonly_sql_connection_string", value)

    @property
    @pulumi.getter(name="primarySqlConnectionString")
    def primary_sql_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Primary SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_sql_connection_string")

    @primary_sql_connection_string.setter
    def primary_sql_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "primary_sql_connection_string", value)

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of read endpoints available for this CosmosDB account.
        """
        return pulumi.get(self, "read_endpoints")

    @read_endpoints.setter
    def read_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "read_endpoints", value)

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['AccountRestoreArgs']]:
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['AccountRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary key for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_key", value)

    @property
    @pulumi.getter(name="secondaryMongodbConnectionString")
    def secondary_mongodb_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_mongodb_connection_string")

    @secondary_mongodb_connection_string.setter
    def secondary_mongodb_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_mongodb_connection_string", value)

    @property
    @pulumi.getter(name="secondaryReadonlyKey")
    def secondary_readonly_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Secondary read-only key for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_readonly_key")

    @secondary_readonly_key.setter
    def secondary_readonly_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_readonly_key", value)

    @property
    @pulumi.getter(name="secondaryReadonlyMongodbConnectionString")
    def secondary_readonly_mongodb_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary readonly Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_readonly_mongodb_connection_string")

    @secondary_readonly_mongodb_connection_string.setter
    def secondary_readonly_mongodb_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_readonly_mongodb_connection_string", value)

    @property
    @pulumi.getter(name="secondaryReadonlySqlConnectionString")
    def secondary_readonly_sql_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary readonly SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_readonly_sql_connection_string")

    @secondary_readonly_sql_connection_string.setter
    def secondary_readonly_sql_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_readonly_sql_connection_string", value)

    @property
    @pulumi.getter(name="secondarySqlConnectionString")
    def secondary_sql_connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Secondary SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_sql_connection_string")

    @secondary_sql_connection_string.setter
    def secondary_sql_connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secondary_sql_connection_string", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountVirtualNetworkRuleArgs']]]]:
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountVirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)

    @property
    @pulumi.getter(name="writeEndpoints")
    def write_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of write endpoints available for this CosmosDB account.
        """
        return pulumi.get(self, "write_endpoints")

    @write_endpoints.setter
    def write_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "write_endpoints", value)


@pulumi.type_token("azure:cosmosdb/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_metadata_writes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 analytical_storage: Optional[pulumi.Input[Union['AccountAnalyticalStorageArgs', 'AccountAnalyticalStorageArgsDict']]] = None,
                 analytical_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup: Optional[pulumi.Input[Union['AccountBackupArgs', 'AccountBackupArgsDict']]] = None,
                 burst_capacity_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountCapabilityArgs', 'AccountCapabilityArgsDict']]]]] = None,
                 capacity: Optional[pulumi.Input[Union['AccountCapacityArgs', 'AccountCapacityArgsDict']]] = None,
                 consistency_policy: Optional[pulumi.Input[Union['AccountConsistencyPolicyArgs', 'AccountConsistencyPolicyArgsDict']]] = None,
                 cors_rule: Optional[pulumi.Input[Union['AccountCorsRuleArgs', 'AccountCorsRuleArgsDict']]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 free_tier_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountGeoLocationArgs', 'AccountGeoLocationArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 ip_range_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 mongo_server_version: Optional[pulumi.Input[builtins.str]] = None,
                 multiple_write_locations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_acl_bypass_for_azure_services: Optional[pulumi.Input[builtins.bool]] = None,
                 network_acl_bypass_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 offer_type: Optional[pulumi.Input[builtins.str]] = None,
                 partition_merge_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['AccountRestoreArgs', 'AccountRestoreArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountVirtualNetworkRuleArgs', 'AccountVirtualNetworkRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a CosmosDB (formally DocumentDB) Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        rg = azure.core.ResourceGroup("rg",
            name="sample-rg",
            location="westus")
        ri = random.RandomInteger("ri",
            min=10000,
            max=99999)
        db = azure.cosmosdb.Account("db",
            name=ri.result.apply(lambda result: f"tfex-cosmos-db-{result}"),
            location=example["location"],
            resource_group_name=example["name"],
            offer_type="Standard",
            kind="MongoDB",
            automatic_failover_enabled=True,
            capabilities=[
                {
                    "name": "EnableAggregationPipeline",
                },
                {
                    "name": "mongoEnableDocLevelTTL",
                },
                {
                    "name": "MongoDBv3.4",
                },
                {
                    "name": "EnableMongo",
                },
            ],
            consistency_policy={
                "consistency_level": "BoundedStaleness",
                "max_interval_in_seconds": 300,
                "max_staleness_prefix": 100000,
            },
            geo_locations=[
                {
                    "location": "eastus",
                    "failover_priority": 1,
                },
                {
                    "location": "westus",
                    "failover_priority": 0,
                },
            ])
        ```

        ## User Assigned Identity Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example_azurerm_resource_group["name"],
            location=example_azurerm_resource_group["location"],
            name="example-resource")
        example_account = azure.cosmosdb.Account("example",
            name="example-resource",
            location=example_azurerm_resource_group["location"],
            resource_group_name=example_azurerm_resource_group["name"],
            default_identity_type=std.join_output(separator="=",
                input=[
                    "UserAssignedIdentity",
                    example.id,
                ]).apply(lambda invoke: invoke.result),
            offer_type="Standard",
            kind="MongoDB",
            capabilities=[{
                "name": "EnableMongo",
            }],
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": "westus",
                "failover_priority": 0,
            }],
            identity={
                "type": "UserAssigned",
                "identity_ids": [example.id],
            })
        ```
        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2024-08-15

        ## Import

        CosmosDB Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/account:Account account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccountAnalyticalStorageArgs', 'AccountAnalyticalStorageArgsDict']] analytical_storage: An `analytical_storage` block as defined below.
        :param pulumi.Input[Union['AccountCapacityArgs', 'AccountCapacityArgsDict']] capacity: A `capacity` block as defined below.
        :param pulumi.Input[builtins.str] create_mode: The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.
               
               > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        :param pulumi.Input[builtins.str] default_identity_type: The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] minimal_tls_version: Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_type: Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a CosmosDB (formally DocumentDB) Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_random as random

        rg = azure.core.ResourceGroup("rg",
            name="sample-rg",
            location="westus")
        ri = random.RandomInteger("ri",
            min=10000,
            max=99999)
        db = azure.cosmosdb.Account("db",
            name=ri.result.apply(lambda result: f"tfex-cosmos-db-{result}"),
            location=example["location"],
            resource_group_name=example["name"],
            offer_type="Standard",
            kind="MongoDB",
            automatic_failover_enabled=True,
            capabilities=[
                {
                    "name": "EnableAggregationPipeline",
                },
                {
                    "name": "mongoEnableDocLevelTTL",
                },
                {
                    "name": "MongoDBv3.4",
                },
                {
                    "name": "EnableMongo",
                },
            ],
            consistency_policy={
                "consistency_level": "BoundedStaleness",
                "max_interval_in_seconds": 300,
                "max_staleness_prefix": 100000,
            },
            geo_locations=[
                {
                    "location": "eastus",
                    "failover_priority": 1,
                },
                {
                    "location": "westus",
                    "failover_priority": 0,
                },
            ])
        ```

        ## User Assigned Identity Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.authorization.UserAssignedIdentity("example",
            resource_group_name=example_azurerm_resource_group["name"],
            location=example_azurerm_resource_group["location"],
            name="example-resource")
        example_account = azure.cosmosdb.Account("example",
            name="example-resource",
            location=example_azurerm_resource_group["location"],
            resource_group_name=example_azurerm_resource_group["name"],
            default_identity_type=std.join_output(separator="=",
                input=[
                    "UserAssignedIdentity",
                    example.id,
                ]).apply(lambda invoke: invoke.result),
            offer_type="Standard",
            kind="MongoDB",
            capabilities=[{
                "name": "EnableMongo",
            }],
            consistency_policy={
                "consistency_level": "Strong",
            },
            geo_locations=[{
                "location": "westus",
                "failover_priority": 0,
            }],
            identity={
                "type": "UserAssigned",
                "identity_ids": [example.id],
            })
        ```
        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2024-08-15

        ## Import

        CosmosDB Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/account:Account account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DocumentDB/databaseAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key_metadata_writes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 analytical_storage: Optional[pulumi.Input[Union['AccountAnalyticalStorageArgs', 'AccountAnalyticalStorageArgsDict']]] = None,
                 analytical_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup: Optional[pulumi.Input[Union['AccountBackupArgs', 'AccountBackupArgsDict']]] = None,
                 burst_capacity_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountCapabilityArgs', 'AccountCapabilityArgsDict']]]]] = None,
                 capacity: Optional[pulumi.Input[Union['AccountCapacityArgs', 'AccountCapacityArgsDict']]] = None,
                 consistency_policy: Optional[pulumi.Input[Union['AccountConsistencyPolicyArgs', 'AccountConsistencyPolicyArgsDict']]] = None,
                 cors_rule: Optional[pulumi.Input[Union['AccountCorsRuleArgs', 'AccountCorsRuleArgsDict']]] = None,
                 create_mode: Optional[pulumi.Input[builtins.str]] = None,
                 default_identity_type: Optional[pulumi.Input[builtins.str]] = None,
                 free_tier_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountGeoLocationArgs', 'AccountGeoLocationArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 ip_range_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 is_virtual_network_filter_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[builtins.str]] = None,
                 mongo_server_version: Optional[pulumi.Input[builtins.str]] = None,
                 multiple_write_locations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_acl_bypass_for_azure_services: Optional[pulumi.Input[builtins.bool]] = None,
                 network_acl_bypass_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 offer_type: Optional[pulumi.Input[builtins.str]] = None,
                 partition_merge_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                 restore: Optional[pulumi.Input[Union['AccountRestoreArgs', 'AccountRestoreArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountVirtualNetworkRuleArgs', 'AccountVirtualNetworkRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            __props__.__dict__["access_key_metadata_writes_enabled"] = access_key_metadata_writes_enabled
            __props__.__dict__["analytical_storage"] = analytical_storage
            __props__.__dict__["analytical_storage_enabled"] = analytical_storage_enabled
            __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
            __props__.__dict__["backup"] = backup
            __props__.__dict__["burst_capacity_enabled"] = burst_capacity_enabled
            __props__.__dict__["capabilities"] = capabilities
            __props__.__dict__["capacity"] = capacity
            if consistency_policy is None and not opts.urn:
                raise TypeError("Missing required property 'consistency_policy'")
            __props__.__dict__["consistency_policy"] = consistency_policy
            __props__.__dict__["cors_rule"] = cors_rule
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["default_identity_type"] = default_identity_type
            __props__.__dict__["free_tier_enabled"] = free_tier_enabled
            if geo_locations is None and not opts.urn:
                raise TypeError("Missing required property 'geo_locations'")
            __props__.__dict__["geo_locations"] = geo_locations
            __props__.__dict__["identity"] = identity
            __props__.__dict__["ip_range_filters"] = ip_range_filters
            __props__.__dict__["is_virtual_network_filter_enabled"] = is_virtual_network_filter_enabled
            __props__.__dict__["key_vault_key_id"] = key_vault_key_id
            __props__.__dict__["kind"] = kind
            __props__.__dict__["local_authentication_disabled"] = local_authentication_disabled
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
            __props__.__dict__["minimal_tls_version"] = minimal_tls_version
            __props__.__dict__["mongo_server_version"] = mongo_server_version
            __props__.__dict__["multiple_write_locations_enabled"] = multiple_write_locations_enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["network_acl_bypass_for_azure_services"] = network_acl_bypass_for_azure_services
            __props__.__dict__["network_acl_bypass_ids"] = network_acl_bypass_ids
            if offer_type is None and not opts.urn:
                raise TypeError("Missing required property 'offer_type'")
            __props__.__dict__["offer_type"] = offer_type
            __props__.__dict__["partition_merge_enabled"] = partition_merge_enabled
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["restore"] = restore
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_rules"] = virtual_network_rules
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["primary_key"] = None
            __props__.__dict__["primary_mongodb_connection_string"] = None
            __props__.__dict__["primary_readonly_key"] = None
            __props__.__dict__["primary_readonly_mongodb_connection_string"] = None
            __props__.__dict__["primary_readonly_sql_connection_string"] = None
            __props__.__dict__["primary_sql_connection_string"] = None
            __props__.__dict__["read_endpoints"] = None
            __props__.__dict__["secondary_key"] = None
            __props__.__dict__["secondary_mongodb_connection_string"] = None
            __props__.__dict__["secondary_readonly_key"] = None
            __props__.__dict__["secondary_readonly_mongodb_connection_string"] = None
            __props__.__dict__["secondary_readonly_sql_connection_string"] = None
            __props__.__dict__["secondary_sql_connection_string"] = None
            __props__.__dict__["write_endpoints"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryKey", "primaryMongodbConnectionString", "primaryReadonlyKey", "primaryReadonlyMongodbConnectionString", "primaryReadonlySqlConnectionString", "primarySqlConnectionString", "secondaryKey", "secondaryMongodbConnectionString", "secondaryReadonlyKey", "secondaryReadonlyMongodbConnectionString", "secondaryReadonlySqlConnectionString", "secondarySqlConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'azure:cosmosdb/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key_metadata_writes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            analytical_storage: Optional[pulumi.Input[Union['AccountAnalyticalStorageArgs', 'AccountAnalyticalStorageArgsDict']]] = None,
            analytical_storage_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            automatic_failover_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            backup: Optional[pulumi.Input[Union['AccountBackupArgs', 'AccountBackupArgsDict']]] = None,
            burst_capacity_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountCapabilityArgs', 'AccountCapabilityArgsDict']]]]] = None,
            capacity: Optional[pulumi.Input[Union['AccountCapacityArgs', 'AccountCapacityArgsDict']]] = None,
            consistency_policy: Optional[pulumi.Input[Union['AccountConsistencyPolicyArgs', 'AccountConsistencyPolicyArgsDict']]] = None,
            cors_rule: Optional[pulumi.Input[Union['AccountCorsRuleArgs', 'AccountCorsRuleArgsDict']]] = None,
            create_mode: Optional[pulumi.Input[builtins.str]] = None,
            default_identity_type: Optional[pulumi.Input[builtins.str]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            free_tier_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            geo_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountGeoLocationArgs', 'AccountGeoLocationArgsDict']]]]] = None,
            identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
            ip_range_filters: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            is_virtual_network_filter_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            key_vault_key_id: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            local_authentication_disabled: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed_hsm_key_id: Optional[pulumi.Input[builtins.str]] = None,
            minimal_tls_version: Optional[pulumi.Input[builtins.str]] = None,
            mongo_server_version: Optional[pulumi.Input[builtins.str]] = None,
            multiple_write_locations_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_acl_bypass_for_azure_services: Optional[pulumi.Input[builtins.bool]] = None,
            network_acl_bypass_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            offer_type: Optional[pulumi.Input[builtins.str]] = None,
            partition_merge_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            primary_key: Optional[pulumi.Input[builtins.str]] = None,
            primary_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            primary_readonly_key: Optional[pulumi.Input[builtins.str]] = None,
            primary_readonly_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            primary_readonly_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            primary_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            read_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
            restore: Optional[pulumi.Input[Union['AccountRestoreArgs', 'AccountRestoreArgsDict']]] = None,
            secondary_key: Optional[pulumi.Input[builtins.str]] = None,
            secondary_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            secondary_readonly_key: Optional[pulumi.Input[builtins.str]] = None,
            secondary_readonly_mongodb_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            secondary_readonly_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            secondary_sql_connection_string: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountVirtualNetworkRuleArgs', 'AccountVirtualNetworkRuleArgsDict']]]]] = None,
            write_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccountAnalyticalStorageArgs', 'AccountAnalyticalStorageArgsDict']] analytical_storage: An `analytical_storage` block as defined below.
        :param pulumi.Input[Union['AccountCapacityArgs', 'AccountCapacityArgsDict']] capacity: A `capacity` block as defined below.
        :param pulumi.Input[builtins.str] create_mode: The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.
               
               > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        :param pulumi.Input[builtins.str] default_identity_type: The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        :param pulumi.Input[builtins.str] endpoint: The endpoint used to connect to the CosmosDB account.
        :param pulumi.Input[builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] minimal_tls_version: Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        :param pulumi.Input[builtins.str] name: Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] offer_type: Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        :param pulumi.Input[builtins.str] primary_key: The Primary key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_mongodb_connection_string: Primary Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_readonly_key: The Primary read-only Key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_readonly_mongodb_connection_string: Primary readonly Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_readonly_sql_connection_string: Primary readonly SQL connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] primary_sql_connection_string: Primary SQL connection string for the CosmosDB Account.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] read_endpoints: A list of read endpoints available for this CosmosDB account.
        :param pulumi.Input[builtins.str] resource_group_name: The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[builtins.str] secondary_key: The Secondary key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_mongodb_connection_string: Secondary Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_readonly_key: The Secondary read-only key for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_readonly_mongodb_connection_string: Secondary readonly Mongodb connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_readonly_sql_connection_string: Secondary readonly SQL connection string for the CosmosDB Account.
        :param pulumi.Input[builtins.str] secondary_sql_connection_string: Secondary SQL connection string for the CosmosDB Account.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] write_endpoints: A list of write endpoints available for this CosmosDB account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["access_key_metadata_writes_enabled"] = access_key_metadata_writes_enabled
        __props__.__dict__["analytical_storage"] = analytical_storage
        __props__.__dict__["analytical_storage_enabled"] = analytical_storage_enabled
        __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
        __props__.__dict__["backup"] = backup
        __props__.__dict__["burst_capacity_enabled"] = burst_capacity_enabled
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["consistency_policy"] = consistency_policy
        __props__.__dict__["cors_rule"] = cors_rule
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["default_identity_type"] = default_identity_type
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["free_tier_enabled"] = free_tier_enabled
        __props__.__dict__["geo_locations"] = geo_locations
        __props__.__dict__["identity"] = identity
        __props__.__dict__["ip_range_filters"] = ip_range_filters
        __props__.__dict__["is_virtual_network_filter_enabled"] = is_virtual_network_filter_enabled
        __props__.__dict__["key_vault_key_id"] = key_vault_key_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["local_authentication_disabled"] = local_authentication_disabled
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
        __props__.__dict__["minimal_tls_version"] = minimal_tls_version
        __props__.__dict__["mongo_server_version"] = mongo_server_version
        __props__.__dict__["multiple_write_locations_enabled"] = multiple_write_locations_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["network_acl_bypass_for_azure_services"] = network_acl_bypass_for_azure_services
        __props__.__dict__["network_acl_bypass_ids"] = network_acl_bypass_ids
        __props__.__dict__["offer_type"] = offer_type
        __props__.__dict__["partition_merge_enabled"] = partition_merge_enabled
        __props__.__dict__["primary_key"] = primary_key
        __props__.__dict__["primary_mongodb_connection_string"] = primary_mongodb_connection_string
        __props__.__dict__["primary_readonly_key"] = primary_readonly_key
        __props__.__dict__["primary_readonly_mongodb_connection_string"] = primary_readonly_mongodb_connection_string
        __props__.__dict__["primary_readonly_sql_connection_string"] = primary_readonly_sql_connection_string
        __props__.__dict__["primary_sql_connection_string"] = primary_sql_connection_string
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["read_endpoints"] = read_endpoints
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["restore"] = restore
        __props__.__dict__["secondary_key"] = secondary_key
        __props__.__dict__["secondary_mongodb_connection_string"] = secondary_mongodb_connection_string
        __props__.__dict__["secondary_readonly_key"] = secondary_readonly_key
        __props__.__dict__["secondary_readonly_mongodb_connection_string"] = secondary_readonly_mongodb_connection_string
        __props__.__dict__["secondary_readonly_sql_connection_string"] = secondary_readonly_sql_connection_string
        __props__.__dict__["secondary_sql_connection_string"] = secondary_sql_connection_string
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_rules"] = virtual_network_rules
        __props__.__dict__["write_endpoints"] = write_endpoints
        return Account(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKeyMetadataWritesEnabled")
    def access_key_metadata_writes_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "access_key_metadata_writes_enabled")

    @property
    @pulumi.getter(name="analyticalStorage")
    def analytical_storage(self) -> pulumi.Output['outputs.AccountAnalyticalStorage']:
        """
        An `analytical_storage` block as defined below.
        """
        return pulumi.get(self, "analytical_storage")

    @property
    @pulumi.getter(name="analyticalStorageEnabled")
    def analytical_storage_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "analytical_storage_enabled")

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "automatic_failover_enabled")

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output['outputs.AccountBackup']:
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="burstCapacityEnabled")
    def burst_capacity_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "burst_capacity_enabled")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output[Sequence['outputs.AccountCapability']]:
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output['outputs.AccountCapacity']:
        """
        A `capacity` block as defined below.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="consistencyPolicy")
    def consistency_policy(self) -> pulumi.Output['outputs.AccountConsistencyPolicy']:
        return pulumi.get(self, "consistency_policy")

    @property
    @pulumi.getter(name="corsRule")
    def cors_rule(self) -> pulumi.Output[Optional['outputs.AccountCorsRule']]:
        return pulumi.get(self, "cors_rule")

    @property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[builtins.str]:
        """
        The creation mode for the CosmosDB Account. Possible values are `Default` and `Restore`. Changing this forces a new resource to be created.

        > **Note:** `create_mode` can only be defined when the `backup.type` is set to `Continuous`.
        """
        return pulumi.get(self, "create_mode")

    @property
    @pulumi.getter(name="defaultIdentityType")
    def default_identity_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The default identity for accessing Key Vault. Possible values are `FirstPartyIdentity`, `SystemAssignedIdentity` or `UserAssignedIdentity`. Defaults to `FirstPartyIdentity`.
        """
        return pulumi.get(self, "default_identity_type")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The endpoint used to connect to the CosmosDB account.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="freeTierEnabled")
    def free_tier_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "free_tier_enabled")

    @property
    @pulumi.getter(name="geoLocations")
    def geo_locations(self) -> pulumi.Output[Sequence['outputs.AccountGeoLocation']]:
        return pulumi.get(self, "geo_locations")

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AccountIdentity']]:
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="ipRangeFilters")
    def ip_range_filters(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "ip_range_filters")

    @property
    @pulumi.getter(name="isVirtualNetworkFilterEnabled")
    def is_virtual_network_filter_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "is_virtual_network_filter_enabled")

    @property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "key_vault_key_id")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "local_authentication_disabled")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "managed_hsm_key_id")

    @property
    @pulumi.getter(name="minimalTlsVersion")
    def minimal_tls_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the minimal TLS version for the CosmosDB account. Possible values are: `Tls`, `Tls11`, and `Tls12`. Defaults to `Tls12`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more details.
        """
        return pulumi.get(self, "minimal_tls_version")

    @property
    @pulumi.getter(name="mongoServerVersion")
    def mongo_server_version(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "mongo_server_version")

    @property
    @pulumi.getter(name="multipleWriteLocationsEnabled")
    def multiple_write_locations_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "multiple_write_locations_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the name of the CosmosDB Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkAclBypassForAzureServices")
    def network_acl_bypass_for_azure_services(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "network_acl_bypass_for_azure_services")

    @property
    @pulumi.getter(name="networkAclBypassIds")
    def network_acl_bypass_ids(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "network_acl_bypass_ids")

    @property
    @pulumi.getter(name="offerType")
    def offer_type(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the Offer Type to use for this CosmosDB Account; currently, this can only be set to `Standard`.
        """
        return pulumi.get(self, "offer_type")

    @property
    @pulumi.getter(name="partitionMergeEnabled")
    def partition_merge_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "partition_merge_enabled")

    @property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> pulumi.Output[builtins.str]:
        """
        The Primary key for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_key")

    @property
    @pulumi.getter(name="primaryMongodbConnectionString")
    def primary_mongodb_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Primary Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_mongodb_connection_string")

    @property
    @pulumi.getter(name="primaryReadonlyKey")
    def primary_readonly_key(self) -> pulumi.Output[builtins.str]:
        """
        The Primary read-only Key for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_readonly_key")

    @property
    @pulumi.getter(name="primaryReadonlyMongodbConnectionString")
    def primary_readonly_mongodb_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Primary readonly Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_readonly_mongodb_connection_string")

    @property
    @pulumi.getter(name="primaryReadonlySqlConnectionString")
    def primary_readonly_sql_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Primary readonly SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_readonly_sql_connection_string")

    @property
    @pulumi.getter(name="primarySqlConnectionString")
    def primary_sql_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Primary SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "primary_sql_connection_string")

    @property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @property
    @pulumi.getter(name="readEndpoints")
    def read_endpoints(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of read endpoints available for this CosmosDB account.
        """
        return pulumi.get(self, "read_endpoints")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the resource group in which the CosmosDB Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.AccountRestore']]:
        return pulumi.get(self, "restore")

    @property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> pulumi.Output[builtins.str]:
        """
        The Secondary key for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_key")

    @property
    @pulumi.getter(name="secondaryMongodbConnectionString")
    def secondary_mongodb_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Secondary Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_mongodb_connection_string")

    @property
    @pulumi.getter(name="secondaryReadonlyKey")
    def secondary_readonly_key(self) -> pulumi.Output[builtins.str]:
        """
        The Secondary read-only key for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_readonly_key")

    @property
    @pulumi.getter(name="secondaryReadonlyMongodbConnectionString")
    def secondary_readonly_mongodb_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Secondary readonly Mongodb connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_readonly_mongodb_connection_string")

    @property
    @pulumi.getter(name="secondaryReadonlySqlConnectionString")
    def secondary_readonly_sql_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Secondary readonly SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_readonly_sql_connection_string")

    @property
    @pulumi.getter(name="secondarySqlConnectionString")
    def secondary_sql_connection_string(self) -> pulumi.Output[builtins.str]:
        """
        Secondary SQL connection string for the CosmosDB Account.
        """
        return pulumi.get(self, "secondary_sql_connection_string")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> pulumi.Output[Optional[Sequence['outputs.AccountVirtualNetworkRule']]]:
        return pulumi.get(self, "virtual_network_rules")

    @property
    @pulumi.getter(name="writeEndpoints")
    def write_endpoints(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of write endpoints available for this CosmosDB account.
        """
        return pulumi.get(self, "write_endpoints")

