# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CassandraDatacenterArgs', 'CassandraDatacenter']

@pulumi.input_type
class CassandraDatacenterArgs:
    def __init__(__self__, *,
                 cassandra_cluster_id: pulumi.Input[builtins.str],
                 delegated_management_subnet_id: pulumi.Input[builtins.str],
                 availability_zones_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_storage_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 base64_encoded_yaml_fragment: Optional[pulumi.Input[builtins.str]] = None,
                 disk_count: Optional[pulumi.Input[builtins.int]] = None,
                 disk_sku: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_disk_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CassandraDatacenter resource.
        :param pulumi.Input[builtins.str] cassandra_cluster_id: The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.bool] availability_zones_enabled: Determines whether availability zones are enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] backup_storage_customer_key_uri: The key URI of the customer key to use for the encryption of the backup Storage Account.
        :param pulumi.Input[builtins.str] base64_encoded_yaml_fragment: The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        :param pulumi.Input[builtins.int] disk_count: Determines the number of p30 disks that are attached to each node.
        :param pulumi.Input[builtins.str] disk_sku: The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] managed_disk_customer_key_uri: The key URI of the customer key to use for the encryption of the Managed Disk.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        :param pulumi.Input[builtins.str] sku_name: Determines the selected sku.
               
               > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        pulumi.set(__self__, "cassandra_cluster_id", cassandra_cluster_id)
        pulumi.set(__self__, "delegated_management_subnet_id", delegated_management_subnet_id)
        if availability_zones_enabled is not None:
            pulumi.set(__self__, "availability_zones_enabled", availability_zones_enabled)
        if backup_storage_customer_key_uri is not None:
            pulumi.set(__self__, "backup_storage_customer_key_uri", backup_storage_customer_key_uri)
        if base64_encoded_yaml_fragment is not None:
            pulumi.set(__self__, "base64_encoded_yaml_fragment", base64_encoded_yaml_fragment)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if disk_sku is not None:
            pulumi.set(__self__, "disk_sku", disk_sku)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_disk_customer_key_uri is not None:
            pulumi.set(__self__, "managed_disk_customer_key_uri", managed_disk_customer_key_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)

    @property
    @pulumi.getter(name="cassandraClusterId")
    def cassandra_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "cassandra_cluster_id")

    @cassandra_cluster_id.setter
    def cassandra_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cassandra_cluster_id", value)

    @property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @delegated_management_subnet_id.setter
    def delegated_management_subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delegated_management_subnet_id", value)

    @property
    @pulumi.getter(name="availabilityZonesEnabled")
    def availability_zones_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether availability zones are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "availability_zones_enabled")

    @availability_zones_enabled.setter
    def availability_zones_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_zones_enabled", value)

    @property
    @pulumi.getter(name="backupStorageCustomerKeyUri")
    def backup_storage_customer_key_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key URI of the customer key to use for the encryption of the backup Storage Account.
        """
        return pulumi.get(self, "backup_storage_customer_key_uri")

    @backup_storage_customer_key_uri.setter
    def backup_storage_customer_key_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_storage_customer_key_uri", value)

    @property
    @pulumi.getter(name="base64EncodedYamlFragment")
    def base64_encoded_yaml_fragment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        """
        return pulumi.get(self, "base64_encoded_yaml_fragment")

    @base64_encoded_yaml_fragment.setter
    def base64_encoded_yaml_fragment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base64_encoded_yaml_fragment", value)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Determines the number of p30 disks that are attached to each node.
        """
        return pulumi.get(self, "disk_count")

    @disk_count.setter
    def disk_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_count", value)

    @property
    @pulumi.getter(name="diskSku")
    def disk_sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        """
        return pulumi.get(self, "disk_sku")

    @disk_sku.setter
    def disk_sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_sku", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedDiskCustomerKeyUri")
    def managed_disk_customer_key_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key URI of the customer key to use for the encryption of the Managed Disk.
        """
        return pulumi.get(self, "managed_disk_customer_key_uri")

    @managed_disk_customer_key_uri.setter
    def managed_disk_customer_key_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_disk_customer_key_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines the selected sku.

        > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)


@pulumi.input_type
class _CassandraDatacenterState:
    def __init__(__self__, *,
                 availability_zones_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_storage_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 base64_encoded_yaml_fragment: Optional[pulumi.Input[builtins.str]] = None,
                 cassandra_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_management_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 disk_count: Optional[pulumi.Input[builtins.int]] = None,
                 disk_sku: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_disk_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CassandraDatacenter resources.
        :param pulumi.Input[builtins.bool] availability_zones_enabled: Determines whether availability zones are enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] backup_storage_customer_key_uri: The key URI of the customer key to use for the encryption of the backup Storage Account.
        :param pulumi.Input[builtins.str] base64_encoded_yaml_fragment: The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        :param pulumi.Input[builtins.str] cassandra_cluster_id: The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] disk_count: Determines the number of p30 disks that are attached to each node.
        :param pulumi.Input[builtins.str] disk_sku: The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] managed_disk_customer_key_uri: The key URI of the customer key to use for the encryption of the Managed Disk.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] seed_node_ip_addresses: A list of IP Address for the seed nodes in this Cassandra Datacenter.
        :param pulumi.Input[builtins.str] sku_name: Determines the selected sku.
               
               > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        if availability_zones_enabled is not None:
            pulumi.set(__self__, "availability_zones_enabled", availability_zones_enabled)
        if backup_storage_customer_key_uri is not None:
            pulumi.set(__self__, "backup_storage_customer_key_uri", backup_storage_customer_key_uri)
        if base64_encoded_yaml_fragment is not None:
            pulumi.set(__self__, "base64_encoded_yaml_fragment", base64_encoded_yaml_fragment)
        if cassandra_cluster_id is not None:
            pulumi.set(__self__, "cassandra_cluster_id", cassandra_cluster_id)
        if delegated_management_subnet_id is not None:
            pulumi.set(__self__, "delegated_management_subnet_id", delegated_management_subnet_id)
        if disk_count is not None:
            pulumi.set(__self__, "disk_count", disk_count)
        if disk_sku is not None:
            pulumi.set(__self__, "disk_sku", disk_sku)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_disk_customer_key_uri is not None:
            pulumi.set(__self__, "managed_disk_customer_key_uri", managed_disk_customer_key_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if seed_node_ip_addresses is not None:
            pulumi.set(__self__, "seed_node_ip_addresses", seed_node_ip_addresses)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)

    @property
    @pulumi.getter(name="availabilityZonesEnabled")
    def availability_zones_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether availability zones are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "availability_zones_enabled")

    @availability_zones_enabled.setter
    def availability_zones_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "availability_zones_enabled", value)

    @property
    @pulumi.getter(name="backupStorageCustomerKeyUri")
    def backup_storage_customer_key_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key URI of the customer key to use for the encryption of the backup Storage Account.
        """
        return pulumi.get(self, "backup_storage_customer_key_uri")

    @backup_storage_customer_key_uri.setter
    def backup_storage_customer_key_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "backup_storage_customer_key_uri", value)

    @property
    @pulumi.getter(name="base64EncodedYamlFragment")
    def base64_encoded_yaml_fragment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        """
        return pulumi.get(self, "base64_encoded_yaml_fragment")

    @base64_encoded_yaml_fragment.setter
    def base64_encoded_yaml_fragment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "base64_encoded_yaml_fragment", value)

    @property
    @pulumi.getter(name="cassandraClusterId")
    def cassandra_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "cassandra_cluster_id")

    @cassandra_cluster_id.setter
    def cassandra_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cassandra_cluster_id", value)

    @property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @delegated_management_subnet_id.setter
    def delegated_management_subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delegated_management_subnet_id", value)

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Determines the number of p30 disks that are attached to each node.
        """
        return pulumi.get(self, "disk_count")

    @disk_count.setter
    def disk_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_count", value)

    @property
    @pulumi.getter(name="diskSku")
    def disk_sku(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        """
        return pulumi.get(self, "disk_sku")

    @disk_sku.setter
    def disk_sku(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "disk_sku", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedDiskCustomerKeyUri")
    def managed_disk_customer_key_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key URI of the customer key to use for the encryption of the Managed Disk.
        """
        return pulumi.get(self, "managed_disk_customer_key_uri")

    @managed_disk_customer_key_uri.setter
    def managed_disk_customer_key_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_disk_customer_key_uri", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="seedNodeIpAddresses")
    def seed_node_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of IP Address for the seed nodes in this Cassandra Datacenter.
        """
        return pulumi.get(self, "seed_node_ip_addresses")

    @seed_node_ip_addresses.setter
    def seed_node_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "seed_node_ip_addresses", value)

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Determines the selected sku.

        > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sku_name", value)


@pulumi.type_token("azure:cosmosdb/cassandraDatacenter:CassandraDatacenter")
class CassandraDatacenter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_storage_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 base64_encoded_yaml_fragment: Optional[pulumi.Input[builtins.str]] = None,
                 cassandra_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_management_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 disk_count: Optional[pulumi.Input[builtins.int]] = None,
                 disk_sku: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_disk_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cassandra Datacenter.

        > **Note:** In order for the `Azure Managed Instances for Apache Cassandra` to work properly the product requires the `Azure Cosmos DB` Application ID to be present and working in your tenant. If the `Azure Cosmos DB` Application ID is missing in your environment you will need to have an administrator of your tenant run the following command to add the `Azure Cosmos DB` Application ID to your tenant:

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="accexample-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example = azuread.get_service_principal(display_name="Azure Cosmos DB")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=example.object_id)
        example_cassandra_cluster = azure.cosmosdb.CassandraCluster("example",
            name="example-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            delegated_management_subnet_id=example_subnet.id,
            default_admin_password="Password1234",
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        example_cassandra_datacenter = azure.cosmosdb.CassandraDatacenter("example",
            name="example-datacenter",
            location=example_cassandra_cluster.location,
            cassandra_cluster_id=example_cassandra_cluster.id,
            delegated_management_subnet_id=example_subnet.id,
            node_count=3,
            disk_count=4,
            sku_name="Standard_DS14_v2",
            availability_zones_enabled=False)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2023-04-15

        ## Import

        Cassandra Datacenters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/cassandraDatacenter:CassandraDatacenter example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DocumentDB/cassandraClusters/cluster1/dataCenters/dc1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] availability_zones_enabled: Determines whether availability zones are enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] backup_storage_customer_key_uri: The key URI of the customer key to use for the encryption of the backup Storage Account.
        :param pulumi.Input[builtins.str] base64_encoded_yaml_fragment: The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        :param pulumi.Input[builtins.str] cassandra_cluster_id: The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] disk_count: Determines the number of p30 disks that are attached to each node.
        :param pulumi.Input[builtins.str] disk_sku: The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] managed_disk_customer_key_uri: The key URI of the customer key to use for the encryption of the Managed Disk.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        :param pulumi.Input[builtins.str] sku_name: Determines the selected sku.
               
               > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CassandraDatacenterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cassandra Datacenter.

        > **Note:** In order for the `Azure Managed Instances for Apache Cassandra` to work properly the product requires the `Azure Cosmos DB` Application ID to be present and working in your tenant. If the `Azure Cosmos DB` Application ID is missing in your environment you will need to have an administrator of your tenant run the following command to add the `Azure Cosmos DB` Application ID to your tenant:

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="accexample-rg",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example_resource_group.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        example = azuread.get_service_principal(display_name="Azure Cosmos DB")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_virtual_network.id,
            role_definition_name="Network Contributor",
            principal_id=example.object_id)
        example_cassandra_cluster = azure.cosmosdb.CassandraCluster("example",
            name="example-cluster",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            delegated_management_subnet_id=example_subnet.id,
            default_admin_password="Password1234",
            opts = pulumi.ResourceOptions(depends_on=[example_assignment]))
        example_cassandra_datacenter = azure.cosmosdb.CassandraDatacenter("example",
            name="example-datacenter",
            location=example_cassandra_cluster.location,
            cassandra_cluster_id=example_cassandra_cluster.id,
            delegated_management_subnet_id=example_subnet.id,
            node_count=3,
            disk_count=4,
            sku_name="Standard_DS14_v2",
            availability_zones_enabled=False)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DocumentDB`: 2023-04-15

        ## Import

        Cassandra Datacenters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/cassandraDatacenter:CassandraDatacenter example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resGroup1/providers/Microsoft.DocumentDB/cassandraClusters/cluster1/dataCenters/dc1
        ```

        :param str resource_name: The name of the resource.
        :param CassandraDatacenterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CassandraDatacenterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 backup_storage_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 base64_encoded_yaml_fragment: Optional[pulumi.Input[builtins.str]] = None,
                 cassandra_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 delegated_management_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 disk_count: Optional[pulumi.Input[builtins.int]] = None,
                 disk_sku: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_disk_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 node_count: Optional[pulumi.Input[builtins.int]] = None,
                 sku_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CassandraDatacenterArgs.__new__(CassandraDatacenterArgs)

            __props__.__dict__["availability_zones_enabled"] = availability_zones_enabled
            __props__.__dict__["backup_storage_customer_key_uri"] = backup_storage_customer_key_uri
            __props__.__dict__["base64_encoded_yaml_fragment"] = base64_encoded_yaml_fragment
            if cassandra_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cassandra_cluster_id'")
            __props__.__dict__["cassandra_cluster_id"] = cassandra_cluster_id
            if delegated_management_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'delegated_management_subnet_id'")
            __props__.__dict__["delegated_management_subnet_id"] = delegated_management_subnet_id
            __props__.__dict__["disk_count"] = disk_count
            __props__.__dict__["disk_sku"] = disk_sku
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_disk_customer_key_uri"] = managed_disk_customer_key_uri
            __props__.__dict__["name"] = name
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["seed_node_ip_addresses"] = None
        super(CassandraDatacenter, __self__).__init__(
            'azure:cosmosdb/cassandraDatacenter:CassandraDatacenter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zones_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            backup_storage_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
            base64_encoded_yaml_fragment: Optional[pulumi.Input[builtins.str]] = None,
            cassandra_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            delegated_management_subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            disk_count: Optional[pulumi.Input[builtins.int]] = None,
            disk_sku: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed_disk_customer_key_uri: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            node_count: Optional[pulumi.Input[builtins.int]] = None,
            seed_node_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            sku_name: Optional[pulumi.Input[builtins.str]] = None) -> 'CassandraDatacenter':
        """
        Get an existing CassandraDatacenter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] availability_zones_enabled: Determines whether availability zones are enabled. Defaults to `true`.
        :param pulumi.Input[builtins.str] backup_storage_customer_key_uri: The key URI of the customer key to use for the encryption of the backup Storage Account.
        :param pulumi.Input[builtins.str] base64_encoded_yaml_fragment: The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        :param pulumi.Input[builtins.str] cassandra_cluster_id: The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] delegated_management_subnet_id: The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] disk_count: Determines the number of p30 disks that are attached to each node.
        :param pulumi.Input[builtins.str] disk_sku: The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        :param pulumi.Input[builtins.str] location: The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.str] managed_disk_customer_key_uri: The key URI of the customer key to use for the encryption of the Managed Disk.
        :param pulumi.Input[builtins.str] name: The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        :param pulumi.Input[builtins.int] node_count: The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] seed_node_ip_addresses: A list of IP Address for the seed nodes in this Cassandra Datacenter.
        :param pulumi.Input[builtins.str] sku_name: Determines the selected sku.
               
               > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CassandraDatacenterState.__new__(_CassandraDatacenterState)

        __props__.__dict__["availability_zones_enabled"] = availability_zones_enabled
        __props__.__dict__["backup_storage_customer_key_uri"] = backup_storage_customer_key_uri
        __props__.__dict__["base64_encoded_yaml_fragment"] = base64_encoded_yaml_fragment
        __props__.__dict__["cassandra_cluster_id"] = cassandra_cluster_id
        __props__.__dict__["delegated_management_subnet_id"] = delegated_management_subnet_id
        __props__.__dict__["disk_count"] = disk_count
        __props__.__dict__["disk_sku"] = disk_sku
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_disk_customer_key_uri"] = managed_disk_customer_key_uri
        __props__.__dict__["name"] = name
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["seed_node_ip_addresses"] = seed_node_ip_addresses
        __props__.__dict__["sku_name"] = sku_name
        return CassandraDatacenter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZonesEnabled")
    def availability_zones_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines whether availability zones are enabled. Defaults to `true`.
        """
        return pulumi.get(self, "availability_zones_enabled")

    @property
    @pulumi.getter(name="backupStorageCustomerKeyUri")
    def backup_storage_customer_key_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The key URI of the customer key to use for the encryption of the backup Storage Account.
        """
        return pulumi.get(self, "backup_storage_customer_key_uri")

    @property
    @pulumi.getter(name="base64EncodedYamlFragment")
    def base64_encoded_yaml_fragment(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The fragment of the cassandra.yaml configuration file to be included in the cassandra.yaml for all nodes in this Cassandra Datacenter. The fragment should be Base64 encoded and only a subset of keys is allowed.
        """
        return pulumi.get(self, "base64_encoded_yaml_fragment")

    @property
    @pulumi.getter(name="cassandraClusterId")
    def cassandra_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the Cassandra Cluster. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "cassandra_cluster_id")

    @property
    @pulumi.getter(name="delegatedManagementSubnetId")
    def delegated_management_subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the delegated management subnet for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "delegated_management_subnet_id")

    @property
    @pulumi.getter(name="diskCount")
    def disk_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Determines the number of p30 disks that are attached to each node.
        """
        return pulumi.get(self, "disk_count")

    @property
    @pulumi.getter(name="diskSku")
    def disk_sku(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Disk SKU that is used for this Cassandra Datacenter. Defaults to `P30`.
        """
        return pulumi.get(self, "disk_sku")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The Azure Region where the Cassandra Datacenter should exist. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedDiskCustomerKeyUri")
    def managed_disk_customer_key_uri(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The key URI of the customer key to use for the encryption of the Managed Disk.
        """
        return pulumi.get(self, "managed_disk_customer_key_uri")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name which should be used for this Cassandra Datacenter. Changing this forces a new Cassandra Datacenter to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of nodes the Cassandra Datacenter should have. The number should be equal or greater than `3`. Defaults to `3`.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="seedNodeIpAddresses")
    def seed_node_ip_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of IP Address for the seed nodes in this Cassandra Datacenter.
        """
        return pulumi.get(self, "seed_node_ip_addresses")

    @property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Determines the selected sku.

        > **Note:** In v4.0 of the provider the `sku_name` will have a default value of `Standard_E16s_v5`.
        """
        return pulumi.get(self, "sku_name")

