# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMongoDatabaseResult',
    'AwaitableGetMongoDatabaseResult',
    'get_mongo_database',
    'get_mongo_database_output',
]

@pulumi.output_type
class GetMongoDatabaseResult:
    """
    A collection of values returned by getMongoDatabase.
    """
    def __init__(__self__, account_name=None, id=None, name=None, resource_group_name=None, tags=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> builtins.str:
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> builtins.str:
        return pulumi.get(self, "resource_group_name")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, builtins.str]:
        """
        A mapping of tags assigned to the Cosmos DB Mongo Database.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMongoDatabaseResult(GetMongoDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMongoDatabaseResult(
            account_name=self.account_name,
            id=self.id,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_mongo_database(account_name: Optional[builtins.str] = None,
                       name: Optional[builtins.str] = None,
                       resource_group_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMongoDatabaseResult:
    """
    Use this data source to access information about an existing Cosmos DB Mongo Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_mongo_database(name="test-cosmosdb-mongo-db",
        resource_group_name="test-cosmosdb-account-rg",
        account_name="test-cosmosdb-account")
    pulumi.export("id", example.id)
    ```


    :param builtins.str account_name: The name of the Cosmos DB Account where the Mongo Database exists.
    :param builtins.str name: The name of this Cosmos DB Mongo Database.
    :param builtins.str resource_group_name: The name of the Resource Group where the Cosmos DB Mongo Database exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cosmosdb/getMongoDatabase:getMongoDatabase', __args__, opts=opts, typ=GetMongoDatabaseResult).value

    return AwaitableGetMongoDatabaseResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_mongo_database_output(account_name: Optional[pulumi.Input[builtins.str]] = None,
                              name: Optional[pulumi.Input[builtins.str]] = None,
                              resource_group_name: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMongoDatabaseResult]:
    """
    Use this data source to access information about an existing Cosmos DB Mongo Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_mongo_database(name="test-cosmosdb-mongo-db",
        resource_group_name="test-cosmosdb-account-rg",
        account_name="test-cosmosdb-account")
    pulumi.export("id", example.id)
    ```


    :param builtins.str account_name: The name of the Cosmos DB Account where the Mongo Database exists.
    :param builtins.str name: The name of this Cosmos DB Mongo Database.
    :param builtins.str resource_group_name: The name of the Resource Group where the Cosmos DB Mongo Database exists.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cosmosdb/getMongoDatabase:getMongoDatabase', __args__, opts=opts, typ=GetMongoDatabaseResult)
    return __ret__.apply(lambda __response__: GetMongoDatabaseResult(
        account_name=pulumi.get(__response__, 'account_name'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
